package com.ejianc.business.profinance.service;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.profinance.bean.SalaryPayApplyEntity;
import com.ejianc.business.profinance.vo.PaymentApplyVO;
import com.ejianc.business.profinance.vo.SalaryPayApplyVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 工人工资支付申请主实体
 *
 * @author generator
 */
public interface ISalaryPayApplyService extends IBaseService<SalaryPayApplyEntity> {

    List<PaymentApplyVO> queryPaymentByContractIdAndBillState(Long id, Long tenantId);

    SalaryPayApplyEntity selectById2(Serializable id);

    boolean queryAdjustByContractId(String billCode);

    Map<String, Object> queryIsCompleteApply(Long id);

    List<SalaryPayApplyEntity> queryApplyByContractId(Long contractId);

    void deleteData(List<SalaryPayApplyVO> vos);

    /**
     * 根据合同Id查询下累计应发、截止上期已申请、累计实付、本期可申请金额
     *
     * @param contractId
     * @return
     */
    Map<String, BigDecimal> getContractSalaryApplyInfo(Long contractId);

    void handMQMessage(String salaryPayApplyResultMsg);

    String isNewestApplyById(Long applyId);


    /**
     * 子表导入打分数据
     * @param request
     * @param response
     * @return
     */
    CommonResponse<JSONObject> excelImportInfo(HttpServletRequest request, HttpServletResponse response);


}
