/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.profinance.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.profinance.bean.GlodonProjectRelateEntity;
import com.ejianc.business.profinance.bean.SalaryEntity;
import com.ejianc.business.profinance.service.IGlodonProjectRelateDetailService;
import com.ejianc.business.profinance.service.IGlodonProjectRelateService;
import com.ejianc.business.profinance.service.ISalaryService;
import com.ejianc.business.profinance.vo.GlodonProjectRelateDetailVO;
import com.ejianc.business.profinance.vo.GlodonProjectRelateVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"glodonProjectRelate"})
public class GlodonProjectRelateController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "PROJECT_RELATE";
    @Autowired
    private IGlodonProjectRelateService service;
    @Autowired
    private IGlodonProjectRelateDetailService glodonProjectRelateDetailService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ISalaryService salaryService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<GlodonProjectRelateVO> saveOrUpdate(@RequestBody GlodonProjectRelateVO saveOrUpdateVO) {
        GlodonProjectRelateEntity entity = (GlodonProjectRelateEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, GlodonProjectRelateEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                this.logger.error("\u4fdd\u5b58\u9879\u76ee\u5bf9\u7167\u5931\u8d25\uff0c\u81ea\u52a8\u751f\u6210\u9879\u76ee\u5bf9\u7167\u7f16\u7801\u5931\u8d25: {}", (Object)billCode.getMsg());
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
        }
        this.service.saveOrUpdate((Object)entity, false);
        GlodonProjectRelateVO vo = (GlodonProjectRelateVO)BeanMapper.map((Object)((Object)entity), GlodonProjectRelateVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<GlodonProjectRelateVO> queryDetail(Long id) {
        GlodonProjectRelateEntity entity = (GlodonProjectRelateEntity)((Object)this.service.selectById(id));
        GlodonProjectRelateVO vo = (GlodonProjectRelateVO)BeanMapper.map((Object)((Object)entity), GlodonProjectRelateVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<GlodonProjectRelateVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            List ids = vos.stream().map(item -> item.getId()).collect(Collectors.toList());
            QueryParam param = new QueryParam();
            param.getParams().put("id", new Parameter("in", ids));
            List glodonProjectRelateEntityList = this.service.queryList(param);
            Map projectRelateEntityMap = glodonProjectRelateEntityList.stream().collect(Collectors.toMap(GlodonProjectRelateEntity::getProjectId, Function.identity(), (key1, key2) -> key2));
            List projectIds = glodonProjectRelateEntityList.stream().map(item -> item.getProjectId()).collect(Collectors.toList());
            QueryParam salaryQueryParam = new QueryParam();
            salaryQueryParam.getParams().put("project_id", new Parameter("in", projectIds));
            salaryQueryParam.getParams().put("salary_detail_source_type", new Parameter("eq", (Object)0));
            List salaryEntityList = this.salaryService.queryList(salaryQueryParam);
            if (CollectionUtils.isNotEmpty((Collection)salaryEntityList) && null != salaryEntityList.get(0) && projectRelateEntityMap.containsKey(((SalaryEntity)((Object)salaryEntityList.get(0))).getProjectId())) {
                String projectName = ((GlodonProjectRelateEntity)((Object)projectRelateEntityMap.get(((SalaryEntity)((Object)salaryEntityList.get(0))).getProjectId()))).getProjectName();
                return CommonResponse.error((String)("\u9879\u76ee<" + projectName + ">\u4e0b\u5df2\u6709\u5de5\u4eba\u5de5\u8d44\u5355\uff0c\u4e0d\u53ef\u5220\u9664\uff01"));
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<GlodonProjectRelateVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter("eq", (Object)orgId));
        } else {
            CommonResponse orgResp = this.iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            param.getParams().put("parentOrgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), GlodonProjectRelateVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/querySynchronizeFlagByProjectId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<GlodonProjectRelateVO>> querySynchronizeFlagByProjectId(@RequestParam String projectId) {
        List<GlodonProjectRelateEntity> glodonProjectRelateVOList = this.service.querySynchronizeFlagByProjectId(projectId);
        return CommonResponse.success((String)"\u67e5\u8be2\u5de5\u4eba\u5de5\u8d44\u8be6\u60c5\u6210\u529f\uff01", (Object)BeanMapper.mapList(glodonProjectRelateVOList, GlodonProjectRelateVO.class));
    }

    @RequestMapping(value={"/refGlodonProjectList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> refGlodonProjectList(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        if (null == condition || StringUtils.isBlank((CharSequence)condition)) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u5f53\u524d\u4f20\u5165condition\u4e3a\u7a7a\uff01");
        }
        Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
        String projectId = (String)conditionMap.get("projectId");
        if (StringUtils.isBlank((CharSequence)projectId)) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u7f3a\u5c11\u53c2\u6570\u9879\u76eeid-projectId\uff01");
        }
        JSONObject page = this.service.getGlodonProjectList(Long.valueOf(projectId), pageNumber, pageSize, searchText);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @GetMapping(value={"/glodonProjectTree"})
    @ResponseBody
    public List<Map<String, Object>> glodonProjectTree(@RequestParam(value="condition", required=false) String condition) {
        Long relateId;
        GlodonProjectRelateEntity glodonProjectRelateEntity;
        Map conditionMap;
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotBlank((CharSequence)condition) && null != (conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class)).get("projectId")) {
            Long projectId = Long.parseLong(conditionMap.get("projectId").toString());
            queryParam.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        }
        List glodonProjectRelateEntityList = this.service.queryList(queryParam, false);
        List relateDetailVOList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)glodonProjectRelateEntityList) && null != glodonProjectRelateEntityList.get(0) && CollectionUtils.isNotEmpty((glodonProjectRelateEntity = (GlodonProjectRelateEntity)((Object)this.service.selectById(relateId = ((GlodonProjectRelateEntity)((Object)glodonProjectRelateEntityList.get(0))).getId()))).getDetailList())) {
            relateDetailVOList = BeanMapper.mapList(glodonProjectRelateEntity.getDetailList(), GlodonProjectRelateDetailVO.class);
        }
        ArrayList resultMapList = new ArrayList();
        HashMap<String, Object> map = null;
        if (CollectionUtils.isNotEmpty(relateDetailVOList)) {
            for (GlodonProjectRelateDetailVO detailVO : relateDetailVOList) {
                map = new HashMap<String, Object>();
                map.put("id", detailVO.getGlodonProjectId());
                map.put("key", detailVO.getGlodonProjectId());
                map.put("name", detailVO.getGlodonProjectName());
                map.put("code", detailVO.getGlodonProjectCode());
                map.put("parentId", null);
                map.put("isTop", 1);
                map.put("glodonProjectId", detailVO.getGlodonProjectId());
                map.put("glodonProjectName", detailVO.getGlodonProjectName());
                map.put("glodonProjectCode", detailVO.getGlodonProjectCode());
                resultMapList.add(map);
            }
        }
        return ResultAsTree.createTreeData(resultMapList);
    }
}

