package com.ejianc.business.profinance.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.profinance.bean.SalaryDetailEntity;
import com.ejianc.business.profinance.bean.SalaryPayApplyDetailEntity;
import com.ejianc.business.profinance.bean.SalaryPayApplyDetailWorkerEntity;
import com.ejianc.business.profinance.service.ISalaryDetailService;
import com.ejianc.business.profinance.service.ISalaryPayApplyDetailService;
import com.ejianc.business.profinance.vo.PaymentApplyVO;
import com.ejianc.business.profinance.vo.SalaryPayApplyDetailVO;
import com.ejianc.business.profinance.vo.SalaryPayApplyDetailWorkerVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.profinance.bean.SalaryPayApplyEntity;
import com.ejianc.business.profinance.service.ISalaryPayApplyService;
import com.ejianc.business.profinance.vo.SalaryPayApplyVO;

/**
 * 工人工资支付申请主实体
 *
 * @author generator
 */
@Controller
@RequestMapping("salaryPayApply")
public class SalaryPayApplyController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "SALARY_PAY_APPLY_";//工人工资支付申请单
    private static final String BILL_CODE_ADJUST = "SALARY_PAY_APPLY_ADJUST_";//工人工资支付申请调整单

    @Autowired
    private ISalaryPayApplyService service;

    @Autowired
    private ISalaryPayApplyDetailService detailService;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private ISalaryDetailService salaryDetailService;

    // 新增或者修改
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SalaryPayApplyVO> saveOrUpdate(@RequestBody SalaryPayApplyVO saveOrUpdateVO) {

        /**
         * 2024-5-16 主表、子表、子表明细不一致bug，临时增加校验
         */
        //主表本期申请金额
        BigDecimal applyTaxMny = saveOrUpdateVO.getApplyTaxMny();
        //子表申请金额
        List<SalaryPayApplyDetailVO> applyList = saveOrUpdateVO.getSalaryList();
        BigDecimal totalApplyTaxMny = applyList.stream().map(SalaryPayApplyDetailVO::getWorkerApplyTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        //应发
        BigDecimal workerShouldPayTaxMny = applyList.stream().map(SalaryPayApplyDetailVO::getWorkerShouldPayTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        //剩余可发
        BigDecimal workerRemainderTaxMny = applyList.stream().map(SalaryPayApplyDetailVO::getWorkerRemainderTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        //子表申请金额明细
        List<SalaryPayApplyDetailWorkerVO> applyDetailList = saveOrUpdateVO.getSalaryDetailList();
        BigDecimal totalDetailApplyTaxMny = applyDetailList.stream().map(SalaryPayApplyDetailWorkerVO::getWorkerApplyTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        //不是重发单就要校验
        if(saveOrUpdateVO.getIsRepeatBill() != 1) {
            if (totalApplyTaxMny.compareTo(applyTaxMny) != 0 || totalApplyTaxMny.compareTo(totalDetailApplyTaxMny) != 0) {
                throw new BusinessException("保存失败，【子表】本期申请金额合计值与【主表】或者【明细】本期申请金额合计值不一致，请检查后重新保存!");
            }
            if(workerShouldPayTaxMny.compareTo(workerRemainderTaxMny) < 0){
                throw new BusinessException("保存失败，应发金额小于剩余可发金额!");
            }
        }

        if (saveOrUpdateVO.getId() == null) {
            // 新增
            saveOrUpdateVO.setCreateUserName(sessionManager.getUserContext().getUserName());
        } else {
            // 修改
            saveOrUpdateVO.setUpdateUserName(sessionManager.getUserContext().getUserName());
        }
        SalaryPayApplyEntity entity = BeanMapper.map(saveOrUpdateVO, SalaryPayApplyEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = new BillCodeParam();
            if (saveOrUpdateVO.getIsRepeatBill() == 1) {
                // 是重发的申请单
                billCodeParam = BillCodeParam.build(BILL_CODE_ADJUST, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            } else {
                // 是普通的申请单
                billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            }
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        //旧版使用
        List<SalaryPayApplyDetailEntity> salaryList = entity.getSalaryList();
        Map<String, SalaryDetailEntity> salaryDetailListMap = new HashMap();
        //新版使用明细表
        List<SalaryPayApplyDetailWorkerEntity> salaryDetailList = entity.getSalaryDetailList();
        Map<String, SalaryDetailEntity> salaryWorkerDetailListMap = new HashMap();


        if (CollectionUtils.isNotEmpty(salaryList)) {
            for (SalaryPayApplyDetailEntity item : salaryList) {
                // 累计申请
                BigDecimal workerTotalApplyTaxMny = item.getWorkerTotalApplyTaxMny();
                workerTotalApplyTaxMny = workerTotalApplyTaxMny == null ? BigDecimal.ZERO : workerTotalApplyTaxMny;
                // 本次申请
                BigDecimal workerApplyTaxMny = item.getWorkerApplyTaxMny();
                workerApplyTaxMny = workerApplyTaxMny == null ? BigDecimal.ZERO : workerApplyTaxMny;
                BigDecimal workerTotalApplyTaxMnyNew = BigDecimal.ZERO;
                if (item.getWorkerIsRepeatBill() == 1) {
                    // 是重发的：新的累计申请 = 原累计申请 + (本次申请 - 原本次申请)
                    BigDecimal workerApplyTaxMnyOld = item.getWorkerApplyTaxMnyOld();
                    workerApplyTaxMnyOld = workerApplyTaxMnyOld == null ? BigDecimal.ZERO : workerApplyTaxMnyOld;
                    workerTotalApplyTaxMnyNew = workerTotalApplyTaxMny.add(workerApplyTaxMny.subtract(workerApplyTaxMnyOld));
                } else {
                    // 不是重发的：新的累计申请 = 原累计申请 + 本次申请
                    workerTotalApplyTaxMnyNew = workerTotalApplyTaxMny.add(workerApplyTaxMny);
                }
                item.setWorkerTotalApplyTaxMny(workerTotalApplyTaxMnyNew);
            }

            if(CollectionUtils.isEmpty(salaryDetailList)) {
                if (saveOrUpdateVO.getIsRepeatBill() != 1) {
                    // 当前是非重发的申请单，此时需要占用工人工资资子表对应数据的剩可发，普通的申请单中已经占用过了，重发的申请单不需要再次占用剩可发的金额
                    List<Long> sourceIdList = salaryList.stream().map(SalaryPayApplyDetailEntity::getSourceId).collect(Collectors.toList());
                    QueryWrapper<SalaryDetailEntity> salaryDetailEntityQueryWrapper = new QueryWrapper<>();
                    salaryDetailEntityQueryWrapper.in("id", sourceIdList);
                    List<SalaryDetailEntity> salaryDetailEntityList = salaryDetailService.list(salaryDetailEntityQueryWrapper);
                    if (CollectionUtils.isNotEmpty(salaryDetailEntityList)) {
                        salaryDetailEntityList.forEach(item -> {
                            salaryDetailListMap.put(item.getId().toString(), item);
                        });
                    }
                    if (MapUtils.isNotEmpty(salaryDetailListMap)) {
                        /**
                         *  考虑行状态进行回写工资表
                         * 首次
                         *  只考虑新增
                         * 	申请金额直接更新
                         * 后来
                         * 	新增
                         * 		申请金额直接更新
                         * 	null
                         * 		不用管
                         * 	edit
                         * 		申请金额直接更新
                         * 	del
                         * 		把剩可发金额 更新到工资表里
                         */

                        if (null == saveOrUpdateVO.getId()) {
                            salaryList.forEach(item -> {
                                if (item.getRowState().equals("add")) {
                                    SalaryDetailEntity salaryDetailEntity = salaryDetailListMap.get(item.getSourceId().toString());
                                    if (salaryDetailEntity != null) {
                                        salaryDetailEntity.setWorkerRemainderTaxMny(item.getWorkerRemainderTaxMny().subtract(item.getWorkerApplyTaxMny()));
                                    }
                                }
                            });
                        } else {
                            salaryList.forEach(item -> {
                                SalaryDetailEntity salaryDetailEntity = salaryDetailListMap.get(item.getSourceId().toString());
                                if (salaryDetailEntity != null && item.getRowState() != null) {
                                    switch (item.getRowState()) {
                                        case "add":
                                        case "edit":
                                            salaryDetailEntity.setWorkerRemainderTaxMny(item.getWorkerRemainderTaxMny().subtract(item.getWorkerApplyTaxMny()));
                                            break;
                                        case "del":
                                            salaryDetailEntity.setWorkerRemainderTaxMny(item.getWorkerRemainderTaxMny());
                                            break;
                                    }
                                }
                            });
                        }
                        salaryDetailService.saveOrUpdateBatch(salaryDetailListMap.values());
                    }
                }
            }
        }


        if (CollectionUtils.isNotEmpty(salaryDetailList)) {
            for (SalaryPayApplyDetailWorkerEntity item : salaryDetailList) {
                // 累计申请
                BigDecimal workerTotalApplyTaxMny = item.getWorkerTotalApplyTaxMny();
                workerTotalApplyTaxMny = workerTotalApplyTaxMny == null ? BigDecimal.ZERO : workerTotalApplyTaxMny;
                // 本次申请
                BigDecimal workerApplyTaxMny = item.getWorkerApplyTaxMny();
                workerApplyTaxMny = workerApplyTaxMny == null ? BigDecimal.ZERO : workerApplyTaxMny;
                BigDecimal workerTotalApplyTaxMnyNew = BigDecimal.ZERO;
                if (item.getWorkerIsRepeatBill() == 1) {
                    // 是重发的：新的累计申请 = 原累计申请 + (本次申请 - 原本次申请)
                    BigDecimal workerApplyTaxMnyOld = item.getWorkerApplyTaxMnyOld();
                    workerApplyTaxMnyOld = workerApplyTaxMnyOld == null ? BigDecimal.ZERO : workerApplyTaxMnyOld;
                    workerTotalApplyTaxMnyNew = workerTotalApplyTaxMny.add(workerApplyTaxMny.subtract(workerApplyTaxMnyOld));
                } else {
                    // 不是重发的：新的累计申请 = 原累计申请 + 本次申请
                    workerTotalApplyTaxMnyNew = workerTotalApplyTaxMny.add(workerApplyTaxMny);
                }
                item.setWorkerTotalApplyTaxMny(workerTotalApplyTaxMnyNew);
            }
            if (saveOrUpdateVO.getIsRepeatBill() != 1) {
                // 当前是非重发的申请单，此时需要占用工人工资资子表对应数据的剩可发，普通的申请单中已经占用过了，重发的申请单不需要再次占用剩可发的金额
                List<Long> sourceIdList = salaryDetailList.stream().map(SalaryPayApplyDetailWorkerEntity::getSourceId).collect(Collectors.toList());
                QueryWrapper<SalaryDetailEntity> salaryDetailEntityQueryWrapper = new QueryWrapper<>();
                salaryDetailEntityQueryWrapper.in("id", sourceIdList);
                List<SalaryDetailEntity> salaryDetailEntityList = salaryDetailService.list(salaryDetailEntityQueryWrapper);
                if (CollectionUtils.isNotEmpty(salaryDetailEntityList)) {
                    salaryDetailEntityList.forEach(item -> {
                        salaryWorkerDetailListMap.put(item.getId().toString(), item);
                    });
                }
                if (MapUtils.isNotEmpty(salaryWorkerDetailListMap)) {
                    /**
                     *  考虑行状态进行回写工资表
                     * 首次
                     *  只考虑新增
                     * 	申请金额直接更新
                     * 后来
                     * 	新增
                     * 		申请金额直接更新
                     * 	null
                     * 		不用管
                     * 	edit
                     * 		申请金额直接更新
                     * 	del
                     * 		把剩可发金额 更新到工资表里
                     */

                    if (null == saveOrUpdateVO.getId()){
                        salaryDetailList.forEach(item ->{
                            if (item.getRowState().equals("add")){
                                SalaryDetailEntity salaryDetailEntity = salaryWorkerDetailListMap.get(item.getSourceId().toString());
                                if (salaryDetailEntity != null) {
                                    salaryDetailEntity.setWorkerRemainderTaxMny(item.getWorkerRemainderTaxMny().subtract(item.getWorkerApplyTaxMny()));
                                }
                            }
                        });
                    }else {
                        salaryDetailList.forEach(item ->{
                            SalaryDetailEntity salaryDetailEntity = salaryWorkerDetailListMap.get(item.getSourceId().toString());
                            if (salaryDetailEntity != null && item.getRowState() != null) {
                                switch (item.getRowState()) {
                                    case "add":
                                    case "edit":
                                        salaryDetailEntity.setWorkerRemainderTaxMny(item.getWorkerRemainderTaxMny().subtract(item.getWorkerApplyTaxMny()));
                                        break;
                                    case "del":
                                        salaryDetailEntity.setWorkerRemainderTaxMny(item.getWorkerRemainderTaxMny());
                                        break;
                                }
                            }
                        });
                    }
                    salaryDetailService.saveOrUpdateBatch(salaryWorkerDetailListMap.values());
                }
            }
        }
        //是否关闭 默认未关闭
        entity.setIsClose(0);
        //默认原始申请金额 = 本次申请金额
        entity.setApplyTaxMnyOld(entity.getApplyTaxMny());

        service.saveOrUpdate(entity, false);
        // 新增成功后，entity中会封装新增的数据的ID，可以直接使用
        SalaryPayApplyVO vo = BeanMapper.map(service.selectById(entity.getId()), SalaryPayApplyVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    // 查询详情
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SalaryPayApplyVO> queryDetail(Long id) {
        // 调用手动写的查询方法，此方法中除了查询当前记录外，添加了查询子表中对应数据的最新的支付成功的日期并进行了封装
        // 设置重发状态
        SalaryPayApplyEntity entity = service.selectById2(id);
        if (entity == null) {
            return CommonResponse.error("查询详情数据失败");
        }
        SalaryPayApplyVO vo = BeanMapper.map(entity, SalaryPayApplyVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }


    /**
     * 新增重发单
     * 点击重发支付申请按钮后跳转到新增一条调整单数据的页面中时，调用此接口，查询跳转时所在记录的数据，并将查询到的结果重新封装和返回用于页面展示
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryDetailAdjust", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SalaryPayApplyVO> queryDetailAdjust(Long id) {
        SalaryPayApplyEntity entity = service.selectById(id);
        SalaryPayApplyVO vo = new SalaryPayApplyVO();
        // 原单据编码
        vo.setBillCodeOld(entity.getBillCodeOld() != null ? entity.getBillCodeOld() : entity.getBillCode());
        // 合同
        vo.setContractId(entity.getContractId());
        vo.setContractCode(entity.getContractCode());
        vo.setContractName(entity.getContractName());
        vo.setContractCategoryId(entity.getContractCategoryId());
        vo.setContractCategoryName(entity.getContractCategoryName());
        vo.setContractTaxMny(entity.getContractTaxMny());
        vo.setContractLinkUrl(entity.getContractLinkUrl());// 合同穿透URL
        // 项目
        vo.setProjectId(entity.getProjectId());
        vo.setProjectCode(entity.getProjectCode());
        vo.setProjectName(entity.getProjectName());
        // 收款单位
        vo.setPaySupplierId(entity.getPaySupplierId());
        vo.setPaySupplierName(entity.getPaySupplierName());
        // 组织
        vo.setOrgId(entity.getOrgId());
        vo.setOrgCode(entity.getOrgCode());
        vo.setOrgName(entity.getOrgName());
        vo.setParentOrgId(entity.getParentOrgId());
        vo.setParentOrgCode(entity.getParentOrgCode());
        vo.setParentOrgName(entity.getParentOrgName());
        // 申请日期
        vo.setApplyDate(new Date());
        // 申请人
        vo.setApplyId(entity.getApplyId());
        vo.setApplyName(entity.getApplyName());
        // 事由
        vo.setPayReason(entity.getPayReason());
        // 备注
        vo.setMemo(entity.getMemo());
        // 银行
        vo.setAccountId(entity.getAccountId());
        vo.setAccountName(entity.getAccountName());
        vo.setAccountNum(entity.getAccountNum());
        vo.setBankName(entity.getBankName());
        // 支付状态默认为待支付
        vo.setPayState(0);
        // 工资清单，只要待支付和支付失败的子表数据
        List<SalaryPayApplyDetailVO> salaryList = BeanMapper.mapList(entity.getSalaryList(), SalaryPayApplyDetailVO.class);
        List<SalaryPayApplyDetailVO> rePayList = new ArrayList<>();
        BigDecimal applyTaxMny = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(salaryList)) {
            for (SalaryPayApplyDetailVO item : salaryList) {
                //支付失败的需要重发
                if(item.getWorkerPayState() == 3) {
                    SalaryPayApplyDetailVO detailVO = BeanMapper.map(item, SalaryPayApplyDetailVO.class);

                    // 支付状态：0-待支付
                    detailVO.setWorkerPayState(0);
                    // 支付日期
                    detailVO.setWorkerPayDate(null);
                    // 原申请单子表ID
                    detailVO.setIdOld(item.getId());
                    // 原申请子表金额
                    detailVO.setWorkerApplyTaxMnyOld(item.getWorkerApplyTaxMny());
                    // 是否重发：1-是
                    detailVO.setWorkerIsRepeatBill(1);

                    //新建数据就该设置为null值了
                    detailVO.setId(IdWorker.getId());
                    applyTaxMny = applyTaxMny.add(item.getWorkerApplyTaxMny());
                    rePayList.add(detailVO);
                }
            }
            vo.setApplyTaxMny(applyTaxMny);
            vo.setSalaryList(BeanMapper.mapList(rePayList, SalaryPayApplyDetailVO.class));
        }

        List<SalaryPayApplyDetailWorkerVO> salaryDetailList = BeanMapper.mapList(entity.getSalaryDetailList(), SalaryPayApplyDetailWorkerVO.class);
        List<SalaryPayApplyDetailWorkerVO> rePayDetailList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(salaryDetailList)) {
            for (SalaryPayApplyDetailWorkerVO item : salaryDetailList) {
                //支付失败的需要重发
                if(item.getWorkerPayState() == 3) {
                    SalaryPayApplyDetailWorkerVO detailVO = BeanMapper.map(item, SalaryPayApplyDetailWorkerVO.class);

                    // 支付状态：0-待支付
                    detailVO.setWorkerPayState(0);
                    // 支付日期
                    detailVO.setWorkerPayDate(null);
                    // 原申请单子表ID
                    detailVO.setIdOld(item.getId());
                    // 原申请子表金额
                    detailVO.setWorkerApplyTaxMnyOld(item.getWorkerApplyTaxMny());
                    // 是否重发：1-是
                    detailVO.setWorkerIsRepeatBill(1);

                    //新建数据就该设置为null值了
                    detailVO.setId(IdWorker.getId());
                    applyTaxMny = applyTaxMny.add(item.getWorkerApplyTaxMny());
                    rePayDetailList.add(detailVO);
                }
            }
            vo.setSalaryDetailList(BeanMapper.mapList(rePayDetailList, SalaryPayApplyDetailWorkerVO.class));
        }

        return CommonResponse.success("查询详情数据成功！", vo);
    }

    // 批量删除单据
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SalaryPayApplyVO> vos) {
        service.deleteData(vos);
        return CommonResponse.success("删除成功！");
    }

    // 查询列表
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SalaryPayApplyVO>> queryList(@RequestBody QueryParam param) {

        // 模糊查询：根据 项目名称、合同编码、合同名称、收款单位、申请人
        param.setFuzzyFields(Arrays.asList("billCode","projectName", "contractCode", "contractName", "paySupplierName", "applyName"));

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();
        orderMap.put("create_time", QueryParam.DESC);
        param.setOrderMap(orderMap);

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有parentOrgId字段，保存单据所属组织 */
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有orgId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        Parameter isRepeatBillParam = param.getParams().get("isRepeatBill");
        if (isRepeatBillParam != null && isRepeatBillParam.getValue() != null) {
            param.getParams().put("is_repeat_bill", new Parameter(QueryParam.EQ, Integer.parseInt(isRepeatBillParam.getValue().toString())));
        } else {
            // 默认查询普通申请单
            param.getParams().put("is_repeat_bill", new Parameter(QueryParam.EQ, 0));
        }

        param.getOrderMap().put("bill_code", QueryParam.DESC);
        IPage<SalaryPayApplyEntity> page = service.queryPage(param, false);
        IPage<SalaryPayApplyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<SalaryPayApplyVO> records = BeanMapper.mapList(page.getRecords(), SalaryPayApplyVO.class);
        setPayStateName(records);
        pageData.setRecords(records);

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    // 导出
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<SalaryPayApplyEntity> list = service.queryList(param);
        List<SalaryPayApplyVO> salaryPayApplyVOList = BeanMapper.mapList(list, SalaryPayApplyVO.class);
        // 封装单据状态名称
        setBillStateName(salaryPayApplyVOList);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", salaryPayApplyVOList);
        ExcelExport.getInstance().export("SalaryPayApply-export.xlsx", beans, response);
    }

    // 参照
    @RequestMapping(value = "/refSalaryPayApplyData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SalaryPayApplyVO>> refSalaryPayApplyData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                         String condition,
                                                                         String searchObject,
                                                                         String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<SalaryPayApplyEntity> page = service.queryPage(param, false);
        IPage<SalaryPayApplyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SalaryPayApplyVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    @GetMapping(value = "/queryPaymentByContractIdAndBillState")
    @ResponseBody
    public CommonResponse<List<PaymentApplyVO>> queryPaymentByContractIdAndBillState(@RequestParam Long id) {
        List<PaymentApplyVO> paymentApplyVOS = service.queryPaymentByContractIdAndBillState(id, InvocationInfoProxy.getTenantid());
        return CommonResponse.success("查询当前合同下自由状态的付款申请单成功", paymentApplyVOS);
    }

    // 查询当前申请单下是否有自由态或者审批中或者驳回的调整单
    @PostMapping("/queryAdjustByContractId")
    @ResponseBody
    public boolean queryAdjustByContractId(@RequestBody Map<String, Object> param) {
        return service.queryAdjustByContractId(param.get("billCode").toString());
    }

    // 查询当前合同下是否有自由态的申请单
    @GetMapping("/queryApplyByContractId")
    @ResponseBody
    public CommonResponse<List<SalaryPayApplyVO>> queryApplyByContractId(@RequestParam Long contractId) {
        List<SalaryPayApplyEntity> salaryPayApplyEntityList = service.queryApplyByContractId(contractId);
        return CommonResponse.success("查询成功", BeanMapper.mapList(salaryPayApplyEntityList, SalaryPayApplyVO.class));
    }

    @GetMapping(value = "/getContractSalaryApplyInfo")
    @ResponseBody
    public CommonResponse<Map<String, BigDecimal>> getContractSalaryApplyInfo(@RequestParam Long contractId) {
        Map<String, BigDecimal> applyInfo = service.getContractSalaryApplyInfo(contractId);
        return CommonResponse.success(applyInfo);
    }

    @PostMapping(value = "/handMQMessage")
    @ResponseBody
    public CommonResponse<Map<String, BigDecimal>> handMQMessage(@RequestParam String salaryPayApplyResultMsg) {
        //改数据用于测试消息队列接收数据进行回写操作
        salaryPayApplyResultMsg = "[{\"workerBankName\":\"工商银行\",\"workerAccountNum\":\"622021703057237983\",\"workerIdCard\":\"411318198701063020\",\"workerApplyTaxMny\":10058.82,\"updateTime\":\"2022/6/17 14:12:06\",\"id\":\"1537272108839604225\",\"payState\":\"1\",\"workerName\":\"任七\",\"salaryPayApplyId\":\"592289262041333852\"},{\"workerBankName\":\"工商银行\",\"workerAccountNum\":\"622021703057237982\",\"workerIdCard\":\"411318198701053020\",\"workerApplyTaxMny\":9529.41,\"updateTime\":\"2022/6/17 14:12:06\",\"id\":\"1537272108839604226\",\"payState\":\"1\",\"workerName\":\"赵六\",\"salaryPayApplyId\":\"592289262041333852\"},{\"workerBankName\":\"工商银行\",\"workerAccountNum\":\"622021703057237981\",\"workerIdCard\":\"411318198701043020\",\"workerApplyTaxMny\":9000.00,\"updateTime\":\"2022/6/17 14:12:06\",\"id\":\"1537272108839604227\",\"payState\":\"1\",\"workerName\":\"王五\",\"salaryPayApplyId\":\"592289262041333852\"},{\"workerBankName\":\"工商银行\",\"workerAccountNum\":\"622021703057237980\",\"workerIdCard\":\"411318198701033020\",\"workerApplyTaxMny\":8470.59,\"updateTime\":\"2022/6/17 14:12:06\",\"id\":\"1537272108839604228\",\"payState\":\"1\",\"workerName\":\"李四\",\"salaryPayApplyId\":\"592289262041333852\"},{\"workerBankName\":\"工商银行\",\"workerAccountNum\":\"622021703057237979\",\"workerIdCard\":\"411318198701023020\",\"workerApplyTaxMny\":7941.18,\"updateTime\":\"2022/6/17 14:12:06\",\"id\":\"1537272108839604229\",\"payState\":\"2\",\"workerName\":\"张三\",\"salaryPayApplyId\":\"592289262041333852\"},{\"workerBankName\":\"123\",\"workerAccountNum\":\"4123331231231233\",\"workerIdCard\":\"123123123123123333\",\"workerApplyTaxMny\":50.00,\"updateTime\":\"2022/6/17 14:18:50\",\"id\":\"1537333865401610242\",\"payState\":\"3\",\"workerName\":\"11\",\"salaryPayApplyId\":\"592084267778588756\"},{\"workerBankName\":\"123\",\"workerAccountNum\":\"4123331231231234\",\"workerIdCard\":\"123123123123123334\",\"workerApplyTaxMny\":40.00,\"updateTime\":\"2022/6/17 14:18:50\",\"id\":\"1537333865401610243\",\"payState\":\"2\",\"workerName\":\"22\",\"salaryPayApplyId\":\"592084267778588756\"},{\"workerBankName\":\"123\",\"workerAccountNum\":\"4123331231231233\",\"workerIdCard\":\"123123123123123333\",\"workerApplyTaxMny\":50.00,\"updateTime\":\"2022/6/17 16:40:06\",\"id\":\"1537716828910579713\",\"payState\":\"3\",\"workerName\":\"11\",\"salaryPayApplyId\":\"592755873010040844\"},{\"workerBankName\":\"人民银行\",\"workerAccountNum\":\"1234567801112345\",\"workerIdCard\":\"410222199909091010\",\"workerApplyTaxMny\":500.00,\"updateTime\":\"2022/6/17 18:35:06\",\"id\":\"1537745416001425409\",\"payState\":\"2\",\"workerName\":\"亚瑟\",\"salaryPayApplyId\":\"592784546114601044\"},{\"workerBankName\":\"12\",\"workerAccountNum\":\"2120131231831821\",\"workerIdCard\":\"410221210103102940\",\"workerApplyTaxMny\":600.00,\"updateTime\":\"2022/6/17 18:50:06\",\"id\":\"1537749338833293314\",\"payState\":\"1\",\"workerName\":\"妲己\",\"salaryPayApplyId\":\"592788469684666466\"},{\"workerBankName\":\"1\",\"workerAccountNum\":\"2120131231831813\",\"workerIdCard\":\"410221210103102941\",\"workerApplyTaxMny\":600.00,\"updateTime\":\"2022/6/17 18:50:06\",\"id\":\"1537749338833293315\",\"payState\":\"2\",\"workerName\":\"王昭君\",\"salaryPayApplyId\":\"592788469684666466\"},{\"workerBankName\":\"12\",\"workerAccountNum\":\"2120131231831811\",\"workerIdCard\":\"410221210103102942\",\"workerApplyTaxMny\":600.00,\"updateTime\":\"2022/6/17 18:50:06\",\"id\":\"1537749338833293316\",\"payState\":\"3\",\"workerName\":\"嫦娥\",\"salaryPayApplyId\":\"592788469684666466\"},{\"workerBankName\":\"123\",\"workerAccountNum\":\"4123331231231233\",\"workerIdCard\":\"123123123123123333\",\"workerApplyTaxMny\":50.00,\"updateTime\":\"2022/6/18 10:50:06\",\"id\":\"1537998180805185538\",\"payState\":\"2\",\"workerName\":\"11\",\"salaryPayApplyId\":\"593027102631673886\"}]";
        service.handMQMessage(salaryPayApplyResultMsg);

        return CommonResponse.success();
    }
    @GetMapping(value = "/handSalaryData")
    @ResponseBody
    public CommonResponse<Map<String, BigDecimal>> handSalaryData(Long id) {
        SalaryPayApplyEntity salaryPayApplyEntity = service.selectById(id);
        service.handSalaryData(salaryPayApplyEntity);

        return CommonResponse.success();
    }

    // 查询当前申请单是不是最新的付款申请单
    @GetMapping("/queryIsNewestApplyById")
    @ResponseBody
    public CommonResponse<String> queryIsNewestApplyById(@RequestParam Long applyId) {
        return CommonResponse.success("查询成功", service.isNewestApplyById(applyId));
    }

    // 封装单据状态名称
    private void setBillStateName(List<SalaryPayApplyVO> voList) {
        if (CollectionUtils.isEmpty(voList)) {
            return;
        }
        for (SalaryPayApplyVO vo : voList) {
            Integer billState = vo.getBillState();
            if (billState == null) {
                continue;
            }
            switch (billState) {
                case 0:
                    vo.setBillStateName("自由态");
                    break;
                case 1:
                    vo.setBillStateName("已提交");
                    break;
                case 2:
                    vo.setBillStateName("审批中");
                    break;
                case 3:
                    vo.setBillStateName("审批通过");
                    break;
                case 4:
                    vo.setBillStateName("驳回");
                    break;
                case 5:
                    vo.setBillStateName("提交后有人审批中");
                    break;
                default:
                    break;
            }
        }
    }

    // 封装支付状态名称 支付状态：0-待支付，1-支付成功，2-部分支付，3-支付失败
    private void setPayStateName(List<SalaryPayApplyVO> voList) {
        if (CollectionUtils.isEmpty(voList)) {
            return;
        }
        for (SalaryPayApplyVO vo : voList) {
            Integer payState = vo.getPayState();
            if (payState == null) {
                continue;
            }
            switch (payState) {
                case 0:
                    vo.setPayStateName("待支付");
                    break;
                case 1:
                    vo.setPayStateName("支付成功");
                    break;
                case 2:
                    vo.setPayStateName("部分支付");
                    break;
                case 3:
                    vo.setPayStateName("支付失败");
                    break;
                default:
                    break;
            }
        }
    }



    /**
     * @Description 导出子表
     * @param
     * @Return void
     */
    @RequestMapping(value = "/excelExportZi", method = RequestMethod.GET)
    @ResponseBody
    public void excelExportZi(Long id, HttpServletResponse response) {
        SalaryPayApplyEntity entity = service.selectById(id);
        //KhzzEntity khzzEntity = new KhzzEntity();
        if (entity.getSalaryList() != null){
            for (SalaryPayApplyDetailEntity khjgDetailEntity : entity.getSalaryList()) {
                khjgDetailEntity.setTeamCode(khjgDetailEntity.getId()+"");
            }
//            entity.getSalaryList(entity.getSalaryList().stream().sorted(Comparator.comparing(SalaryPayApplyDetailEntity::getCode))
//                    .collect(Collectors.toList())) ;
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records",entity.getSalaryList());

        ExcelExport.getInstance().export("KhzbdyZiDf-export.xlsx", beans, response);
    }


    /**
     * excel导入打分
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/uploadTemplate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> uploadTemplate(HttpServletRequest request, HttpServletResponse response) {
        return service.excelImportInfo(request,response);
        //return CommonResponse.success("上传成功！");
    }


    /**
     * 银行代发模板数据导出
     */
    /**
     * @Description 导出子表
     * @param
     * @Return void
     */
    @RequestMapping(value = "/excelExportZGYH", method = RequestMethod.GET)
    @ResponseBody
    public void excelExportZGYH(Long id, HttpServletResponse response) {
        SalaryPayApplyEntity entity = service.selectById(id);
        Map<String, Object> beans = new HashMap<>();

        beans.put("records",entity.getSalaryList());

        ExcelExport.getInstance().export("zgyh.xlsx", beans, response);
    }
    @RequestMapping(value = "/excelExportJSYH", method = RequestMethod.GET)
    @ResponseBody
    public void excelExportJSYH(Long id, HttpServletResponse response) {
        SalaryPayApplyEntity entity = service.selectById(id);
        Map<String, Object> beans = new HashMap<>();
        for (int i = 0; i < entity.getSalaryList().size(); i++) {
            entity.getSalaryList().get(i).setWorkerPayState(i+1);//当作序号
        }
        beans.put("records",entity.getSalaryList());
        ExcelExport.getInstance().export("jsyh.xlsx", beans, response);
    }

    @RequestMapping(value = "/excelExportNYYH", method = RequestMethod.GET)
    @ResponseBody
    public void excelExportNYYH(Long id, HttpServletResponse response) {
        SalaryPayApplyEntity entity = service.selectById(id);
        Map<String, Object> beans = new HashMap<>();
        for (int i = 0; i < entity.getSalaryList().size(); i++) {
            entity.getSalaryList().get(i).setWorkerPayState(i+1);//当作序号
        }
        beans.put("records",entity.getSalaryList());
        ExcelExport.getInstance().export("nyyh.xlsx", beans, response);
    }

    @RequestMapping(value = "/excelExportZZYH", method = RequestMethod.GET)
    @ResponseBody
    public void excelExportZZYH(Long id, HttpServletResponse response) {
        SalaryPayApplyEntity entity = service.selectById(id);
        Map<String, Object> beans = new HashMap<>();
        BigDecimal bigDecimal = new BigDecimal(0);
        for (int i = 0; i < entity.getSalaryList().size(); i++) {
            entity.getSalaryList().get(i).setWorkerPayState(i+1);//当作序号
            bigDecimal = bigDecimal.add(entity.getSalaryList().get(i).getWorkerApplyTaxMny());
        }

        beans.put("records",entity.getSalaryList());
        beans.put("mny",bigDecimal);
        beans.put("num",entity.getSalaryList().size());
        ExcelExport.getInstance().export("zzyh.xlsx", beans, response);
    }
}
