package com.ejianc.business.profinance.plan.service;

import com.ejianc.business.profinance.plan.bean.PlanMaterialEntity;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.Collection;
import java.util.Map;

/**
 * 项目资金计划-零星材料采购
 *
 * @author generator
 */
public interface IPlanMaterialService extends IBaseService<PlanMaterialEntity> {


	/**
	 * 根据项目资金计划id，修改项目资金计划-零星材料的单据状态
	 *
	 * @param planId        项目资金计划id
	 * @param billStateCode 单据状态
	 */
	void updateBillState(Long planId, Integer billStateCode);

	/**
	 * 已申请金额(不含本次)=查询所有审批通过或已提交的【项目资金计划】-【零星材料】页签数据，统计该结算单的“本次计划付款金额”
	 *
	 * @param settleIds 结算单ids
	 *
	 * @return 已申请金额(不含本次)
	 */
	Map<String, Object> fetchMaterialValue(Collection<Long> settleIds);
}
