package com.ejianc.business.warn;


import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.center.vo.EarlyWarnTransVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("/profinanceWarn/")
public class ProfinanceWarnController {


    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String PC_URL = "/ejc-promaterial-frontend/#/check/card?id=";
    private static final String PC_A_URL = "/ejc-profinance-frontend/#/receiptList/receiptCard?id=";
    private static final String PC_B_URL = "/ejc-promaterial-frontend/#/concreteCheck";

    @Autowired
    private IWarnCenterApi warnCenterApi;

    @Autowired
    private IOrgApi iOrgApi;


    @Autowired
    private WarnMapper warnMapper;







    private CommonResponse<String> sendWarnToTask(List<EarlyWarnTransVO> warnList, Long warnId) {
        CommonResponse<String> warnResp = warnCenterApi.sendToWarnCenter(warnList, warnId);
        if(!warnResp.isSuccess()) {
            logger.error("回调预警任务服务失败，{}", warnResp.getMsg());
            return CommonResponse.error("回调预警任务服务失败" + warnResp.getMsg());
        }

        return CommonResponse.success("任务接受处理成功！");
    }

    private List<EarlyWarnTransVO> transToWarnVO(List<Map<String, Object>> result, JSONObject defaultWarnInfo) {
        List<EarlyWarnTransVO> resp = new ArrayList<>();
        String tmpContent = null;
        DecimalFormat df = new DecimalFormat("###,##0.00");
        for(Map<String, Object> m : result) {
            EarlyWarnTransVO vo = new EarlyWarnTransVO();
            vo.setBillName((null != defaultWarnInfo.get("categoryName") ? defaultWarnInfo.get("categoryName").toString() + " - " : "")  + m.get("contractCode").toString());
            vo.setPcTitle("施工合同");
            vo.setPcUrl(PC_URL + m.get("contractId").toString());
            vo.setOrgId(Long.valueOf(m.get("orgId").toString()));
            vo.setOrgName(m.get("orgName").toString());
            vo.setSourceId(m.get("contractId").toString());
            vo.setTenantId(Long.valueOf(m.get("tenantId").toString()));
            vo.setWarnLevel(m.get("warnLevel").toString());
            vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
            vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));


            tmpContent = defaultWarnInfo.getString("earlywarnContent");
            vo.setEarlywarnContent(
                    tmpContent.replaceAll("#contractName#", m.get("contractName").toString())
                            .replaceAll("#signDate#", m.get("signDate").toString())
            );

            resp.add(vo);
        }

        logger.info("发送预警参数：{}", JSON.toJSONString(resp));
        return resp;
    }


    /**
     * 回款金额低于产值统计进度50% 以项目纬度
     * @param jsonParam
     * @return
     */
    @PostMapping(value = "outputValueWarnExecute")
    public CommonResponse<String> outputValueWarnExecute(@RequestBody JSONArray jsonParam) {
        logger.info("接收到 Task 参数：{}", jsonParam);
        List<EarlyWarnTransVO> warnList = new ArrayList<>();
        String warnCode = null;



        for (int i = 0; i < jsonParam.size(); i++) {
            JSONObject o = jsonParam.getJSONObject(i);
            Long tenantId = o.getLong("tenantId");
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");
            // 1、根据租户合同纬度，查询合同
            // 2、根据合同的单据所属组织，找到对应的预警设置，也就是这条合同适用于那个设置
            // 3、根据预警设置判断该合同数据属于哪个等级
            // 4、符合等级，则拼接预警数据，并保存到 list
            // 5、发送数据


            List<WarnEntity> warnEntities = warnMapper.selectOutputValueList();

            logger.info("本次共获取单据数量{}条",warnEntities.size());


            List<WarnEntity> resultList = new ArrayList<>();
            for (WarnEntity warnEntity : warnEntities){
                if(warnEntity.getSumReceivedMny() != null && warnEntity.getReplyMny() != null) {
                    if (warnEntity.getSumReceivedMny().compareTo(warnEntity.getReplyMny().multiply(new BigDecimal("0.5"))) < 0) {
                        resultList.add(warnEntity);
                    }
                }
            }

            logger.info("本次共获取 （收款金额小于产值统计金额的70%）的项目{}个",resultList.size());

            if (ListUtil.isNotEmpty(resultList)) {
                for (WarnEntity pvo : resultList) {
                    JSONObject orgSet = null;
                    JSONObject defaultSet = null;
                    Long orgId = pvo.getOrgId();
                    OrgVO orgVO = iOrgApi.getOneById(orgId).getData();
                    if (orgVO == null) {
                        continue;
                    }
                    String innerCode = orgVO.getInnerCode();
                    String[] parentIds = innerCode.split("\\|");
                    /**
                     * 如果当前组织没查到配置，则找其直接上级的配置，
                     * 再找不到，再找其上级，以此类推，
                     * 直至上级为空，还没找到则用默认配置，
                     * 默认配置为空，则不预警
                     * 使用当前组织的 innerCode 进行父级查找
                     * */
                    logger.info("parentIds______" + innerCode);
                    for (int i1 = parentIds.length - 1; i1 >= 0; i1--) {
                        /** 反向查找 */
                        Long pOrgId = Long.parseLong(parentIds[i1]);
                        for (int j = 0; j < orgSettings.size(); j++) {
                            JSONObject set = orgSettings.getJSONObject(j);
                            if (pOrgId.equals(set.getLong("orgId"))) {
                                orgSet = set;
                                break;
                            }
                        }
                        if (orgSet != null) {
                            break;
                        }
                    }
                    /** 查找默认的 */
                    for (int i1 = 0; i1 < orgSettings.size(); i1++) {
                        JSONObject set = orgSettings.getJSONObject(i1);
                        if (set.getBoolean("default")) {
                            defaultSet = set;
                            break;
                        }
                    }
                    if (orgSet == null) {
                        /** 使用默认配置 */
                        orgSet = defaultSet;
                    }
                    if (orgSet != null && ListUtil.isNotEmpty(orgSet.getJSONArray("warningSetings"))) {
                        JSONArray warningSettings = orgSet.getJSONArray("warningSetings");
                        boolean high = false;
                        boolean meddle = false;
                        boolean low = false;
                        JSONObject useSetHigh = null;
                        JSONObject useSetMeddle = null;
                        JSONObject useSetLow = null;
                        for (int i1 = 0; i1 < warningSettings.size(); i1++) {
                            JSONObject set = warningSettings.getJSONObject(i1);
                            if ("高".equals(set.getString("warningLevel"))) {
                                if (set.getString("parameterValue") != null) {
                                    high = true;
                                    useSetHigh = set;
                                }
                            }
                            if ("中".equals(set.getString("warningLevel"))) {
                                if (set.getString("parameterValue") != null) {
                                    meddle = true;
                                    useSetMeddle = set;
                                }
                            }
                            if ("低".equals(set.getString("warningLevel"))) {
                                if (set.getString("parameterValue") != null) {
                                    low = true;
                                    useSetLow = set;
                                }
                            }
                        }
                        //DecimalFormat df = new DecimalFormat("###,##0.00");
                        if (high || meddle || low) {
                            EarlyWarnTransVO vo = new EarlyWarnTransVO();
                            vo.setBillName("-合同-"+pvo.getContractName());
                            vo.setPcTitle("收款登记");
                            vo.setPcUrl(PC_A_URL+pvo.getId() );
                            vo.setOrgId(pvo.getOrgId());
                            //发送消息，根据角色和组织找人，指定找人组织，多个以半角逗号分割
                            vo.setSendOrgId(pvo.getOrgId() + "");
                            vo.setOrgName(orgVO.getName());
                            vo.setSourceId(pvo.getId().toString());
                            vo.setTenantId(tenantId);
                            vo.setWarnSetId(orgSet.getLong("warnId"));
                            vo.setEarlywarnName(orgSet.getString("warnName"));
                            vo.setWarnType(orgSet.getString("warnType"));
                            String tmpContent = orgSet.getString("warningContentTemplate");
                            if (high) {
                                vo.setWarnLevel("高");
                                vo.setWarnSetParamId(useSetHigh.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#projectName#", pvo.getContractName())
                                );
                            } else if (meddle) {
                                vo.setWarnLevel("中");
                                vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#projectName#", pvo.getContractName())
                                );
                            } else {
                                vo.setWarnLevel("低");
                                vo.setWarnSetParamId(useSetLow.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#projectName#", pvo.getContractName())
                                );
                            }
                            warnList.add(vo);
                        }
                    }
                }
            }
        }
        return sendWarnToTask(warnList,warnCode);
    }


    /**
     * 回款金额低于甲方报量70% 以合同纬度
     * @param jsonParam
     * @return
     */
    @PostMapping(value = "quoteWarnExecute")
    public CommonResponse<String> quoteWarnExecute(@RequestBody JSONArray jsonParam) {
        logger.info("接收到 Task 参数：{}", jsonParam);
        List<EarlyWarnTransVO> warnList = new ArrayList<>();
        String warnCode = null;



        for (int i = 0; i < jsonParam.size(); i++) {
            JSONObject o = jsonParam.getJSONObject(i);
            Long tenantId = o.getLong("tenantId");
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");
            // 1、根据租户合同纬度，查询合同
            // 2、根据合同的单据所属组织，找到对应的预警设置，也就是这条合同适用于那个设置
            // 3、根据预警设置判断该合同数据属于哪个等级
            // 4、符合等级，则拼接预警数据，并保存到 list
            // 5、发送数据


            List<WarnEntity> warnEntities = warnMapper.selectCheckList();

            logger.info("本次共获取单据数量{}条",warnEntities.size());


            List<WarnEntity> resultList = new ArrayList<>();
            for (WarnEntity warnEntity : warnEntities){
                if(warnEntity.getSumReceivedMny() != null && warnEntity.getReplyMny() != null) {
                    if (warnEntity.getSumReceivedMny().compareTo(warnEntity.getReplyMny().multiply(new BigDecimal("0.7"))) < 0) {
                        resultList.add(warnEntity);
                    }
                }
            }

            logger.info("本次共获取 （收款金额小于对甲报量金额的70%）的合同{}个",resultList.size());

            if (ListUtil.isNotEmpty(resultList)) {
                for (WarnEntity pvo : resultList) {
                    JSONObject orgSet = null;
                    JSONObject defaultSet = null;
                    Long orgId = pvo.getOrgId();
                    OrgVO orgVO = iOrgApi.getOneById(orgId).getData();
                    if (orgVO == null) {
                        continue;
                    }
                    String innerCode = orgVO.getInnerCode();
                    String[] parentIds = innerCode.split("\\|");
                    /**
                     * 如果当前组织没查到配置，则找其直接上级的配置，
                     * 再找不到，再找其上级，以此类推，
                     * 直至上级为空，还没找到则用默认配置，
                     * 默认配置为空，则不预警
                     * 使用当前组织的 innerCode 进行父级查找
                     * */
                    logger.info("parentIds______" + innerCode);
                    for (int i1 = parentIds.length - 1; i1 >= 0; i1--) {
                        /** 反向查找 */
                        Long pOrgId = Long.parseLong(parentIds[i1]);
                        for (int j = 0; j < orgSettings.size(); j++) {
                            JSONObject set = orgSettings.getJSONObject(j);
                            if (pOrgId.equals(set.getLong("orgId"))) {
                                orgSet = set;
                                break;
                            }
                        }
                        if (orgSet != null) {
                            break;
                        }
                    }
                    /** 查找默认的 */
                    for (int i1 = 0; i1 < orgSettings.size(); i1++) {
                        JSONObject set = orgSettings.getJSONObject(i1);
                        if (set.getBoolean("default")) {
                            defaultSet = set;
                            break;
                        }
                    }
                    if (orgSet == null) {
                        /** 使用默认配置 */
                        orgSet = defaultSet;
                    }
                    if (orgSet != null && ListUtil.isNotEmpty(orgSet.getJSONArray("warningSetings"))) {
                        JSONArray warningSettings = orgSet.getJSONArray("warningSetings");
                        boolean high = false;
                        boolean meddle = false;
                        boolean low = false;
                        JSONObject useSetHigh = null;
                        JSONObject useSetMeddle = null;
                        JSONObject useSetLow = null;
                        for (int i1 = 0; i1 < warningSettings.size(); i1++) {
                            JSONObject set = warningSettings.getJSONObject(i1);
                            if ("高".equals(set.getString("warningLevel"))) {
                                if (set.getString("parameterValue") != null) {
                                    high = true;
                                    useSetHigh = set;
                                }
                            }
                            if ("中".equals(set.getString("warningLevel"))) {
                                if (set.getString("parameterValue") != null) {
                                    meddle = true;
                                    useSetMeddle = set;
                                }
                            }
                            if ("低".equals(set.getString("warningLevel"))) {
                                if (set.getString("parameterValue") != null) {
                                    low = true;
                                    useSetLow = set;
                                }
                            }
                        }
                        //DecimalFormat df = new DecimalFormat("###,##0.00");
                        if (high || meddle || low) {
                            EarlyWarnTransVO vo = new EarlyWarnTransVO();
                            vo.setBillName("-合同-"+pvo.getContractName());
                            vo.setPcTitle("收款登记");
                            vo.setPcUrl(PC_A_URL+pvo.getId() );
                            vo.setOrgId(pvo.getOrgId());
                            //发送消息，根据角色和组织找人，指定找人组织，多个以半角逗号分割
                            vo.setSendOrgId(pvo.getOrgId() + "");
                            vo.setOrgName(orgVO.getName());
                            vo.setSourceId(pvo.getId().toString());
                            vo.setTenantId(tenantId);
                            vo.setWarnSetId(orgSet.getLong("warnId"));
                            vo.setEarlywarnName(orgSet.getString("warnName"));
                            vo.setWarnType(orgSet.getString("warnType"));
                            String tmpContent = orgSet.getString("warningContentTemplate");
                            if (high) {
                                vo.setWarnLevel("高");
                                vo.setWarnSetParamId(useSetHigh.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#projectName#", pvo.getContractName())
                                );
                            } else if (meddle) {
                                vo.setWarnLevel("中");
                                vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#projectName#", pvo.getContractName())
                                );
                            } else {
                                vo.setWarnLevel("低");
                                vo.setWarnSetParamId(useSetLow.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#projectName#", pvo.getContractName())
                                );
                            }
                            warnList.add(vo);
                        }
                    }
                }
            }
        }
        return sendWarnToTask(warnList,warnCode);
    }

    private CommonResponse<String> sendWarnToTask(List<EarlyWarnTransVO> warnList, String warnCode) {
        CommonResponse<String> warnResp = warnCenterApi.sendToWarnCenterByCode(warnList, warnCode);
        if (!warnResp.isSuccess()) {
            logger.error("回调预警任务服务失败，{}", warnResp.getMsg());
            return CommonResponse.error("回调预警任务服务失败" + warnResp.getMsg());
        }
        return CommonResponse.success("任务接受处理成功！");
    }



}
