/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.profinance.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contractbase.api.ITemplateCategoryApi;
import com.ejianc.business.contractbase.pool.enums.ContractFlagEnum;
import com.ejianc.business.contractbase.pool.enums.SettleSourceTypeEnum;
import com.ejianc.business.contractbase.pool.enums.SettleUltimateFlagEnum;
import com.ejianc.business.contractbase.pool.settlepool.api.ISettlePoolApi;
import com.ejianc.business.contractbase.pool.settlepool.vo.SettlePoolVO;
import com.ejianc.business.contractbase.vo.TemplateCategoryVO;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.process.enums.BillPushStatusEnum;
import com.ejianc.business.profinance.bean.ContractLawsuitEntity;
import com.ejianc.business.profinance.service.IContractLawsuitService;
import com.ejianc.business.profinance.vo.ContractLawsuitVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springside.modules.nosql.redis.JedisTemplate;

@Controller
@RequestMapping(value={"contractLawsuit"})
public class ContractLawsuitController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private CacheManager cacheManager;
    private final String PUSH_POOL_PREFIX = "pushContractLawsuit::";
    @Autowired
    private IContractLawsuitService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ISettlePoolApi settlePoolApi;
    @Autowired
    private ITemplateCategoryApi templateCategoryApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ContractLawsuitVO> saveOrUpdate(@RequestBody ContractLawsuitVO saveOrUpdateVO) {
        List list;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"contract_id", (Object)saveOrUpdateVO.getContractId());
        query.notIn((Object)"bill_state", (Object[])new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
        if (null != saveOrUpdateVO.getId()) {
            query.ne((Object)"id", (Object)saveOrUpdateVO.getId());
        }
        if (CollectionUtils.isNotEmpty((Collection)(list = this.service.list((Wrapper)query)))) {
            return CommonResponse.error((String)"\u5f53\u524d\u5408\u540c\u5b58\u5728\u672a\u751f\u6548\u7684\u5355\u636e\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u5408\u540c\u6216\u5904\u7406\u672a\u751f\u6548\u7684\u8bc9\u8bbc\u8d39\u7ed3\u7b97\u5355\uff01");
        }
        ContractLawsuitVO vo = this.service.saveContractLawsuitVO(saveOrUpdateVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ContractLawsuitVO> queryDetail(Long id) {
        ContractLawsuitEntity entity = (ContractLawsuitEntity)((Object)this.service.selectById(id));
        ContractLawsuitVO vo = (ContractLawsuitVO)BeanMapper.map((Object)((Object)entity), ContractLawsuitVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @GetMapping(value={"/checkExistsUnValidData"})
    @ResponseBody
    public CommonResponse<JSONObject> checkExistsUnValidData(@RequestParam Long contractId) {
        JSONObject resp = new JSONObject();
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"contract_id", (Object)contractId);
        List list = this.service.list((Wrapper)query);
        List unValidList = list.stream().filter(item -> !BillStateEnum.PASSED_STATE.getBillStateCode().equals(item.getBillState()) && !BillStateEnum.COMMITED_STATE.getBillStateCode().equals(item.getBillState())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(unValidList)) {
            return CommonResponse.error((String)"\u5f53\u524d\u5408\u540c\u5b58\u5728\u672a\u751f\u6548\u7684\u5355\u636e\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u5408\u540c\u6216\u5904\u7406\u672a\u751f\u6548\u7684\u8bc9\u8bbc\u8d39\u7ed3\u7b97\u5355");
        }
        resp.put("lastLawsuitWorkMny", (Object)list.stream().map(ContractLawsuitEntity::getLawsuitWorkMny).reduce(BigDecimal.ZERO, BigDecimal::add));
        return CommonResponse.success((Object)resp);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ContractLawsuitVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ContractLawsuitVO contractLawsuitVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(ContractLawsuitVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ContractLawsuitVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("contractCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter("eq", (Object)orgId));
        } else {
            CommonResponse orgResp = this.iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            param.getParams().put("parentOrgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ContractLawsuitVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(org.apache.commons.lang3.StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageSize(-1);
        CommonResponse<IPage<ContractLawsuitVO>> commonResponse = this.queryList(param);
        List lawsuitVOS = new ArrayList();
        if (null != commonResponse.getData() && null != (lawsuitVOS = ((IPage)commonResponse.getData()).getRecords()) && lawsuitVOS.size() > 0) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            lawsuitVOS.forEach(c -> {
                c.setSettleDateStr(sdf.format(c.getSettleDate()));
                c.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)c.getBillState()).getDescription());
            });
        }
        HashMap beans = new HashMap();
        beans.put("records", lawsuitVOS);
        ExcelExport.getInstance().export("ContractLawsuit-export .xlsx", beans, response);
    }

    @RequestMapping(value={"/refContractLawsuitData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> refContractLawsuitData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        if (null == condition || StringUtils.isBlank((String)condition)) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u5f53\u524d\u4f20\u5165condition\u4e3a\u7a7a\uff01");
        }
        Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
        if (null != conditionMap.get("contractId")) {
            param.getParams().put("contractId", new Parameter("eq", conditionMap.get("contractId")));
        }
        if (null != conditionMap.get("projectId")) {
            Long projectId = Long.parseLong(conditionMap.get("projectId").toString());
            param.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        } else {
            Long orgId = Long.parseLong(conditionMap.get("orgId").toString());
            if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(conditionMap.get("orgType").toString()))) {
                param.getParams().put("orgId", new Parameter("eq", (Object)orgId));
            } else {
                CommonResponse orgResp = this.iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
                if (!orgResp.isSuccess()) {
                    this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
                    return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
                }
                param.getParams().put("parentOrgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            }
        }
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("bill_state", new Parameter("in", (Object)"1,3"));
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>();
        orderMap.put("create_time", "desc");
        param.setOrderMap(orderMap);
        IPage pageData = this.service.queryPage(param, false);
        JSONObject page = new JSONObject();
        page.put("records", (Object)BeanMapper.mapList((Iterable)pageData.getRecords(), ContractLawsuitVO.class));
        page.put("total", (Object)pageData.getTotal());
        page.put("current", (Object)pageData.getCurrent());
        page.put("size", (Object)pageData.getSize());
        page.put("pages", (Object)pageData.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/pushLawsuitToPool"})
    @ResponseBody
    public CommonResponse<ContractLawsuitVO> pushLawsuitToPool(@RequestBody Long settleId) {
        ContractLawsuitVO s;
        JedisTemplate jedisTemplate;
        block9: {
            CommonResponse commonResponse;
            CommonResponse categoryResp;
            SettlePoolVO spv;
            ContractLawsuitEntity entity;
            block8: {
                jedisTemplate = this.cacheManager.getJedisTemplate();
                String contractIdStr = jedisTemplate.get("pushContractLawsuit::" + settleId.toString());
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)contractIdStr)) {
                    return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u6570\u636e\u5df2\u5904\u4e8e\u540c\u6b65\u64cd\u4f5c\u4e2d\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\uff01");
                }
                jedisTemplate.set("pushContractLawsuit::" + settleId.toString(), settleId.toString());
                entity = (ContractLawsuitEntity)((Object)this.service.selectById(settleId));
                if (null == entity) {
                    jedisTemplate.del(new String[]{"pushContractLawsuit::" + settleId.toString()});
                    return CommonResponse.error((String)("\u7ed3\u7b97\u5355\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25\uff0c\u672a\u627e\u5230Id-" + settleId + "\u5339\u914d\u7684\u7ed3\u7b97\u5355\uff01"));
                }
                s = (ContractLawsuitVO)BeanMapper.map((Object)((Object)entity), ContractLawsuitVO.class);
                spv = new SettlePoolVO();
                this.logger.info("\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u81ea\u52a8\u8f6c\u6362\u5f00\u59cb");
                BeanConvertorUtil.convert((Object)s, (Object)spv);
                this.logger.info("\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u81ea\u52a8\u8f6c\u6362\u7ed3\u675f\uff0c\u4e0b\u9762\u5f00\u59cb\u624b\u52a8\u8f6c\u6362");
                spv.setSourceType(SettleSourceTypeEnum.\u8bc9\u8bbc\u8d39\u7ed3\u7b97.getCode());
                spv.setSettleProperty(Integer.valueOf(0));
                spv.setUltimateFlag(Integer.valueOf(0));
                spv.setCurMny(s.getSettleMny());
                spv.setCurTax(BigDecimal.ZERO);
                spv.setCreateTime(s.getCreateTime());
                spv.setCreateUserCode(s.getCreateUserCode());
                spv.setBillCodeUrl("/ejc-profinance-frontend/#/lawsuitList/card?id=" + s.getId());
                spv.setHandleType(Integer.valueOf(0));
                spv.setContractFlag(ContractFlagEnum.\u6709\u5408\u540c\u7ed3\u7b97.getContractFlagCode());
                spv.setContractFlagName(ContractFlagEnum.\u6709\u5408\u540c\u7ed3\u7b97.getContractFlagCodeName());
                spv.setUltimateFlag(SettleUltimateFlagEnum.\u975e\u6700\u7ec8\u7ed3\u7b97.getCode());
                categoryResp = this.templateCategoryApi.queryTmplCategoryById(entity.getContractCategoryId());
                if (categoryResp.isSuccess()) break block8;
                CommonResponse commonResponse2 = CommonResponse.error((String)"\u63a8\u9001\u5931\u8d25\uff0c\u83b7\u53d6\u5408\u540c\u5206\u7c7b\u4fe1\u606f\u5931\u8d25\uff01");
                jedisTemplate.del(new String[]{"pushContractLawsuit::" + settleId.toString()});
                return commonResponse2;
            }
            try {
                spv.setContractType(((TemplateCategoryVO)categoryResp.getData()).getCategoryProperty());
                spv.setContractTypeName(((TemplateCategoryVO)categoryResp.getData()).getpName());
                this.logger.info("\u7ed3\u7b97\u5355\u5bf9\u8c61:[{}] -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u624b\u52a8\u8f6c\u6362\u5b8c\u6210\uff0c\u4e0b\u9762\u5f00\u59cb:[{}]\u63a8\u9001\u81f3\u7ed3\u7b97\u6c60", (Object)JSONObject.toJSONString((Object)s), (Object)JSONObject.toJSONString((Object)spv));
                CommonResponse res = this.settlePoolApi.saveOrUpdateSettle(spv);
                if (!res.isSuccess()) break block9;
                this.logger.info("\u7ed3\u7b97\u5355\u63a8\u9001\u81f3\u7ed3\u7b97\u6c60\u6210\u529f\uff01\u7ed3\u7b97\u5355id-{}", (Object)s.getId());
                if (BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus().equals(entity.getPushPoolFlag())) {
                    entity.setPushPoolFlag(BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus());
                    this.service.saveOrUpdate((Object)entity);
                }
                commonResponse = CommonResponse.success((String)"\u7ed3\u7b97\u5355\u63a8\u9001\u7ed3\u7b97\u6c60\u6210\u529f\uff01");
            }
            catch (Exception e) {
                try {
                    this.logger.error("\u7ed3\u7b97\u5355\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25\uff01\u7ed3\u7b97\u5355id-{}", (Object)s.getId(), (Object)e);
                }
                catch (Throwable throwable) {
                    jedisTemplate.del(new String[]{"pushContractLawsuit::" + settleId.toString()});
                    throw throwable;
                }
                jedisTemplate.del(new String[]{"pushContractLawsuit::" + settleId.toString()});
            }
            jedisTemplate.del(new String[]{"pushContractLawsuit::" + settleId.toString()});
            return commonResponse;
        }
        jedisTemplate.del(new String[]{"pushContractLawsuit::" + settleId.toString()});
        return CommonResponse.error((String)"\u7ed3\u7b97\u5355\u63a8\u9001\u5931\u8d25", (Object)s);
    }

    @RequestMapping(value={"/pushCost"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ContractLawsuitVO> pushCost(@RequestBody ContractLawsuitVO saveOrUpdateVO) {
        return this.service.pushCost(saveOrUpdateVO);
    }
}

