/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.profinance.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.profinance.bean.PaymentApplyEntity;
import com.ejianc.business.profinance.service.IPaymentApplyDetailService;
import com.ejianc.business.profinance.service.IPaymentApplyService;
import com.ejianc.business.profinance.service.IPaymentRegisterService;
import com.ejianc.business.profinance.vo.ContractPaymentResultVO;
import com.ejianc.business.profinance.vo.PaymentApplyVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/paymentApplyApi/"})
public class PaymentApplyApi
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPaymentApplyService service;
    @Autowired
    private IPaymentRegisterService paymentRegisterService;
    @Autowired
    private IPaymentApplyDetailService detailService;
    @Value(value="${common.env.base-host}")
    private String BASE_HOST;
    private final String DETAIL_PC_URL_CONTRACT = "ejc-profinance-frontend/#/paymentList/contractCard?id=";
    private final String DETAIL_PC_URL_NO_CONTRACT = "ejc-profinance-frontend/#/noContractCard?id=";

    @GetMapping(value={"queryListByContractId"})
    CommonResponse<List<PaymentApplyVO>> queryListByContractId(@RequestParam(value="contractId") Long contractId) {
        this.logger.info("\u67e5\u8be2\u4ed8\u6b3e\u7533\u8bf7\u5355\u6761\u4ef6\uff1acontractId - ", (Object)contractId);
        List<PaymentApplyVO> vos = this.service.queryListByContractId(contractId);
        this.logger.info("\u67e5\u8be2\u4ed8\u6b3e\u7533\u8bf7\u5355\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString(vos, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        return CommonResponse.success((String)"\u67e5\u8be2\u4ed8\u6b3e\u7533\u8bf7\u5355\u6210\u529f\uff01", vos);
    }

    @GetMapping(value={"queryListBySettleId"})
    CommonResponse<List<PaymentApplyVO>> queryListBySettleId(@RequestParam(value="settleId") Long settleId) {
        ArrayList<PaymentApplyVO> resp = new ArrayList<PaymentApplyVO>();
        QueryWrapper query = new QueryWrapper();
        query.select(new String[]{"distinct(pay_id) as payIds"});
        query.eq((Object)"source_id", (Object)settleId);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        List payApplyIds = this.detailService.listObjs((Wrapper)query, item -> Long.valueOf(item.toString()));
        if (CollectionUtils.isNotEmpty((Collection)payApplyIds)) {
            QueryWrapper listQuery = new QueryWrapper();
            listQuery.in((Object)"id", (Collection)payApplyIds);
            listQuery.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
            List entities = this.service.list((Wrapper)listQuery);
            PaymentApplyVO tmp = null;
            for (PaymentApplyEntity pay : entities) {
                tmp = (PaymentApplyVO)BeanMapper.map((Object)((Object)pay), PaymentApplyVO.class);
                if (Integer.valueOf(0).equals(tmp.getPaymentContractFlag())) {
                    tmp.setDetailPcUrl(this.BASE_HOST + "ejc-profinance-frontend/#/paymentList/contractCard?id=" + tmp.getId().toString());
                } else {
                    tmp.setDetailPcUrl(this.BASE_HOST + "ejc-profinance-frontend/#/noContractCard?id=" + tmp.getId().toString());
                }
                resp.add(tmp);
            }
        }
        return CommonResponse.success(resp);
    }

    @GetMapping(value={"queryJsonByContractId"})
    CommonResponse<ContractPaymentResultVO> queryJsonByContractId(@RequestParam(value="id") Long contractId) {
        this.logger.info("\u67e5\u8be2\u4ed8\u6b3e\u7533\u8bf7\u5355\u6761\u4ef6\uff1acontractId - ", (Object)contractId);
        return this.service.queryJsonByContractId(contractId);
    }

    @PostMapping(value={"queryActualPayGroupByMonth"})
    public CommonResponse<List<Map<String, BigDecimal>>> queryActualPayGroupByMonth(@RequestBody QueryParam queryParam) {
        ArrayList<Map<String, BigDecimal>> resp = new ArrayList<Map<String, BigDecimal>>();
        this.logger.info("\u6309\u6708\u4efd\u67e5\u8be2\u5b9e\u4ed8\u91d1\u989d\u6761\u4ef6\uff1a{}", (Object)JSONObject.toJSONString((Object)queryParam));
        Map<String, BigDecimal> rs = this.paymentRegisterService.queryActualPayGroupByMonth(queryParam);
        this.logger.info("\u6309\u6708\u4efd\u67e5\u8be2\u5b9e\u4ed8\u91d1\u989d\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString(rs));
        resp.add(rs);
        return CommonResponse.success(resp);
    }

    @PostMapping(value={"queryActualPayGroupByContractCategoryType"})
    public CommonResponse<List<Map<String, BigDecimal>>> queryActualPayGroupByContractCategoryType(@RequestBody QueryParam queryParam) {
        ArrayList<Map<String, BigDecimal>> resp = new ArrayList<Map<String, BigDecimal>>();
        this.logger.info("\u6309\u5408\u540c\u7c7b\u578b\u67e5\u8be2\u5b9e\u4ed8\u91d1\u989d\u6761\u4ef6\uff1a{}", (Object)JSONObject.toJSONString((Object)queryParam));
        Map<String, BigDecimal> rs = this.paymentRegisterService.queryActualPayGroupByContractCategoryType(queryParam);
        this.logger.info("\u6309\u5408\u540c\u7c7b\u578b\u67e5\u8be2\u5b9e\u4ed8\u91d1\u989d\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString(rs));
        resp.add(rs);
        return CommonResponse.success(resp);
    }

    @GetMapping(value={"queryAddFlagContractId"})
    CommonResponse<String> queryAddFlagContractId(@RequestParam(value="contractId") Long contractId) {
        QueryWrapper listQuery = new QueryWrapper();
        listQuery.eq((Object)"contract_id", (Object)contractId);
        listQuery.eq((Object)"bill_state", (Object)BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        int resultCount = this.service.count((Wrapper)listQuery);
        if (resultCount > 0) {
            return CommonResponse.success((String)"\u67e5\u8be2\u80fd\u5426\u65b0\u589e\u4ed8\u6b3e\u7533\u8bf7\u5355\u6210\u529f\uff0c\u5f53\u524d\u5408\u540c\u5df2\u5b58\u5728\u672a\u751f\u6548\u7684\u4ed8\u6b3e\u7533\u8bf7\u5355\uff0c\u4e0d\u80fd\u65b0\u589e\uff01", (Object)"0");
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u80fd\u5426\u65b0\u589e\u4ed8\u6b3e\u7533\u8bf7\u5355\u6210\u529f\uff0c\u53ef\u4ee5\u65b0\u589e\uff01", (Object)"1");
    }

    @GetMapping(value={"querySumApplyMny"})
    CommonResponse<JSONObject> querySumApplyMny(@RequestParam(value="supplierId") Long supplierId, @RequestParam(value="contractId") Long contractId) {
        JSONObject data = new JSONObject();
        QueryWrapper listQuery = new QueryWrapper();
        listQuery.eq((Object)"contract_id", (Object)contractId);
        listQuery.eq((Object)"supplier_id", (Object)supplierId);
        listQuery.eq((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        List list = this.service.list((Wrapper)listQuery);
        BigDecimal sumApplyMny = list.stream().map(PaymentApplyEntity::getApplyMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        data.put("sumApplyMny", (Object)sumApplyMny);
        return CommonResponse.success((String)"\u67e5\u8be2\u7d2f\u8ba1\u4ed8\u6b3e\u7533\u8bf7\u6210\u529f\uff01", (Object)data);
    }

    @RequestMapping(value={"querySumMny"}, method={RequestMethod.POST})
    public CommonResponse<Map<Long, BigDecimal>> querySumMny(@RequestBody Map<String, List<Long>> param) {
        Map<Long, BigDecimal> longBigDecimalMap = this.service.querySumMny(param);
        if (null == longBigDecimalMap) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff01");
        }
        return CommonResponse.success(longBigDecimalMap);
    }
}

