/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.report.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractPerformanceStateEnum;
import com.ejianc.business.contractbase.pool.enums.ContractPropertyEnum;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.pool.enums.SettleSourceTypeEnum;
import com.ejianc.business.contractbase.pool.settlepool.vo.SettlePoolVO;
import com.ejianc.business.procost.vo.HandshareDetailVO;
import com.ejianc.business.profinance.bean.PaymentApplyEntity;
import com.ejianc.business.profinance.bean.PaymentRegisterEntity;
import com.ejianc.business.profinance.service.IPaymentApplyService;
import com.ejianc.business.profinance.service.IPaymentRegisterService;
import com.ejianc.business.profinance.service.ISalaryPayApplyService;
import com.ejianc.business.report.mapper.ProjectReportMapper;
import com.ejianc.business.report.service.IProjectReportService;
import com.ejianc.business.report.vo.CostAndActualOutVO;
import com.ejianc.business.report.vo.IncomeContractVO;
import com.ejianc.business.report.vo.ProjectReportVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.api.IShareSubjectOrgApi;
import com.ejianc.foundation.share.vo.SubjectOrgVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class ProjectReportServiceImpl
implements IProjectReportService {
    @Autowired
    private IProjectPoolApi projectPoolApi;
    @Autowired
    private IPaymentApplyService paymentApplyService;
    @Autowired
    private IPaymentRegisterService paymentRegisterService;
    @Autowired
    private IShareSubjectOrgApi subjectOrgApi;
    private String PROJECT_SETTLE_RANGE_PARAM = "P-zF77230174";
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private ISalaryPayApplyService salaryPayApplyService;
    @Autowired
    private ProjectReportMapper mapper;

    @Override
    public IPage<ProjectReportVO> queryProjectCount(QueryParam param) {
        IPage resp = (IPage)this.projectPoolApi.queryProjectIPage(param).getData();
        Page page = new Page(resp.getCurrent(), resp.getSize(), resp.getTotal());
        List projectReportVOS = BeanMapper.mapList((Iterable)resp.getRecords(), ProjectReportVO.class);
        List<Long> projectIds = projectReportVOS.stream().map(ProjectReportVO::getId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty((Collection)projectReportVOS)) {
            return page;
        }
        List<IncomeContractVO> incomeContractVOS = this.mapper.queryIncomeContractMny(projectIds);
        projectReportVOS = projectReportVOS.stream().map(e1 -> {
            incomeContractVOS.stream().filter(e2 -> e1.getId().equals(e2.getProjectId())).forEach(e2 -> {
                e1.setApplyChangeTaxMny(e2.getSumContractTaxMny());
                e1.setNoZlMny(ComputeUtil.safeAdd((BigDecimal)e2.getSumNotIncludeProvisionalMny(), (BigDecimal)e2.getSumSupplementTaxMny()));
            });
            return e1;
        }).collect(Collectors.toList());
        List<Map<String, Object>> costAdjustList = this.mapper.queryCostAdjustTaxMny(projectIds);
        projectReportVOS = projectReportVOS.stream().map(e1 -> {
            costAdjustList.stream().filter(e2 -> e1.getId().equals(e2.get("projectId"))).forEach(e2 -> e1.setIncomeContractTaxMny((BigDecimal)e2.get("sumApplyChangeTaxMny")));
            return e1;
        }).collect(Collectors.toList());
        List<Map<String, Object>> costAdjustMoneyList = this.mapper.queryCostAdjustMoney(projectIds);
        projectReportVOS = projectReportVOS.stream().map(e1 -> {
            costAdjustMoneyList.stream().filter(e2 -> e1.getId().equals(e2.get("projectId"))).forEach(e2 -> e1.setTotalCostAdjustTaxMny(ComputeUtil.safeAdd((BigDecimal)e1.getIncomeContractTaxMny(), (BigDecimal)((BigDecimal)e2.get("sumTotalCostAdjustTaxMny")))));
            return e1;
        }).collect(Collectors.toList());
        List<Map<String, Object>> finalizedList = this.mapper.queryCheckTaxMny(projectIds);
        projectReportVOS = projectReportVOS.stream().map(e1 -> {
            finalizedList.stream().filter(e2 -> e1.getId().equals(e2.get("projectId"))).forEach(e2 -> e1.setCheckTaxMny((BigDecimal)e2.get("sumCheckTaxMny")));
            return e1;
        }).collect(Collectors.toList());
        List<Map<String, Object>> BudgetList = this.mapper.queryBudgetTaxMny(projectIds);
        projectReportVOS = projectReportVOS.stream().map(e1 -> {
            BudgetList.stream().filter(e2 -> e1.getId().equals(e2.get("projectId"))).forEach(e2 -> e1.setBudgetTaxMny((BigDecimal)e2.get("sumBudgetTaxMny")));
            return e1;
        }).collect(Collectors.toList());
        for (ProjectReportVO reportVO : projectReportVOS) {
            reportVO.setNoZlMnyAndApplyChangeTaxMny(reportVO.getApplyChangeTaxMny());
        }
        page.setRecords(projectReportVOS);
        return page;
    }

    @Override
    public List<CostAndActualOutVO> queryProjectCostAndActualOut(Long projectId, BigDecimal changeAndcostTaxMny) {
        CostAndActualOutVO targetCost = this.queryTargetCost(projectId, changeAndcostTaxMny);
        CostAndActualOutVO payContract = this.queryPayContract(projectId, changeAndcostTaxMny);
        CostAndActualOutVO settle = this.querySettle(projectId, changeAndcostTaxMny);
        CostAndActualOutVO paymentApply = this.queryPaymentApply(projectId, changeAndcostTaxMny);
        CostAndActualOutVO paymentRegister = this.queryPaymentRegister(projectId, changeAndcostTaxMny);
        ArrayList<CostAndActualOutVO> list = new ArrayList<CostAndActualOutVO>();
        list.add(targetCost);
        list.add(payContract);
        list.add(settle);
        list.add(paymentApply);
        list.add(paymentRegister);
        return list;
    }

    public CostAndActualOutVO queryTargetCost(Long projectId, BigDecimal changeAndcostTaxMny) {
        BigDecimal totalTaxMny = BigDecimal.ZERO;
        BigDecimal lwfTaxMny = BigDecimal.ZERO;
        BigDecimal clfTaxMny = BigDecimal.ZERO;
        BigDecimal jxsbfTaxMny = BigDecimal.ZERO;
        BigDecimal zyfbfTaxMny = BigDecimal.ZERO;
        BigDecimal qtzjfTaxMny = BigDecimal.ZERO;
        BigDecimal jjfTaxMny = BigDecimal.ZERO;
        BigDecimal taxMny = BigDecimal.ZERO;
        List<Map<String, Object>> targetCost = this.mapper.queryTargetCostByProjectId(projectId);
        List<Long> targetCostIds = new ArrayList<Long>();
        if (CollectionUtils.isNotEmpty(targetCost)) {
            totalTaxMny = targetCost.stream().map(e -> null != e.get("taxMny") ? (BigDecimal)e.get("taxMny") : BigDecimal.ZERO).reduce(ComputeUtil::safeAdd).get();
            targetCostIds = targetCost.stream().map(e -> (Long)e.get("id")).collect(Collectors.toList());
        }
        if (CollectionUtils.isNotEmpty(targetCostIds)) {
            List<Map<String, Object>> targetCostDetailList = this.mapper.queryTargetCostDetailByIds(targetCostIds);
            for (Map<String, Object> map : targetCostDetailList) {
                if ("01".equals(map.get("code").toString())) {
                    lwfTaxMny = (BigDecimal)map.get("taxMny");
                }
                if ("02".equals(map.get("code").toString())) {
                    clfTaxMny = (BigDecimal)map.get("taxMny");
                }
                if ("03".equals(map.get("code").toString())) {
                    jxsbfTaxMny = (BigDecimal)map.get("taxMny");
                }
                if ("04".equals(map.get("code").toString())) {
                    zyfbfTaxMny = (BigDecimal)map.get("taxMny");
                }
                if ("05".equals(map.get("code").toString())) {
                    qtzjfTaxMny = (BigDecimal)map.get("taxMny");
                }
                if ("06".equals(map.get("code").toString())) {
                    jjfTaxMny = (BigDecimal)map.get("taxMny");
                }
                if (!"07".equals(map.get("code").toString())) continue;
                taxMny = (BigDecimal)map.get("taxMny");
            }
        }
        CostAndActualOutVO vo = new CostAndActualOutVO();
        vo.setItem(Integer.valueOf(1));
        vo.setItemName("\u76ee\u6807\u6210\u672c");
        vo.setTotalTaxMny(totalTaxMny);
        vo.setLwfTaxMny(lwfTaxMny);
        vo.setClfTaxMny(clfTaxMny);
        vo.setJxfTaxMny(jxsbfTaxMny);
        vo.setZyfbfTaxMny(zyfbfTaxMny);
        vo.setQtzjfTaxMny(qtzjfTaxMny);
        vo.setJjfTaxMny(jjfTaxMny);
        vo.setTaxMny(taxMny);
        if (BigDecimal.ZERO.compareTo(changeAndcostTaxMny) == 0) {
            vo.setTotalTaxMnyScale(BigDecimal.ZERO);
            vo.setLwfTaxMnyScale(BigDecimal.ZERO);
            vo.setClfTaxMnyScale(BigDecimal.ZERO);
            vo.setJxfTaxMnyScale(BigDecimal.ZERO);
            vo.setZyfbTaxMnyScale(BigDecimal.ZERO);
            vo.setQtzjfTaxMnyScale(BigDecimal.ZERO);
            vo.setJjfTaxMnyScale(BigDecimal.ZERO);
            vo.setTaxMnyScale(BigDecimal.ZERO);
        } else {
            vo.setTotalTaxMnyScale(ComputeUtil.safeDiv((BigDecimal)totalTaxMny, (BigDecimal)changeAndcostTaxMny));
            vo.setLwfTaxMnyScale(ComputeUtil.safeDiv((BigDecimal)lwfTaxMny, (BigDecimal)changeAndcostTaxMny));
            vo.setClfTaxMnyScale(ComputeUtil.safeDiv((BigDecimal)clfTaxMny, (BigDecimal)changeAndcostTaxMny));
            vo.setJxfTaxMnyScale(ComputeUtil.safeDiv((BigDecimal)jxsbfTaxMny, (BigDecimal)changeAndcostTaxMny));
            vo.setZyfbTaxMnyScale(ComputeUtil.safeDiv((BigDecimal)zyfbfTaxMny, (BigDecimal)changeAndcostTaxMny));
            vo.setQtzjfTaxMnyScale(ComputeUtil.safeDiv((BigDecimal)qtzjfTaxMny, (BigDecimal)changeAndcostTaxMny));
            vo.setJjfTaxMnyScale(ComputeUtil.safeDiv((BigDecimal)jjfTaxMny, (BigDecimal)changeAndcostTaxMny));
            vo.setTaxMnyScale(ComputeUtil.safeDiv((BigDecimal)taxMny, (BigDecimal)changeAndcostTaxMny));
        }
        return vo;
    }

    public CostAndActualOutVO queryPayContract(Long projectId, BigDecimal changeAndcostTaxMny) {
        BigDecimal totalTaxMny = BigDecimal.ZERO;
        BigDecimal lwfTaxMny = BigDecimal.ZERO;
        BigDecimal clfTaxMny = BigDecimal.ZERO;
        BigDecimal jxsbfTaxMny = BigDecimal.ZERO;
        BigDecimal zyfbfTaxMny = BigDecimal.ZERO;
        BigDecimal qtzjfTaxMny = BigDecimal.ZERO;
        BigDecimal jjfTaxMny = BigDecimal.ZERO;
        BigDecimal taxMny = BigDecimal.ZERO;
        List<Object> contractPoolList = this.mapper.queryContractPoolByProjectId(projectId);
        if (CollectionUtils.isNotEmpty(contractPoolList = contractPoolList.stream().filter(e -> !ContractPerformanceStateEnum.\u5df2\u4f5c\u5e9f.getStateCode().equals(e.getPerformanceStatus())).collect(Collectors.toList()))) {
            List qtzjfContractList;
            List zyfbfContractList;
            List jxfContractList;
            List clfContractList;
            List lwfContractList;
            List payContractList = contractPoolList.stream().filter(e -> ContractPropertyEnum.\u652f\u51fa\u5408\u540c.getPropertyCode() == e.getContractProperty()).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(payContractList)) {
                totalTaxMny = payContractList.stream().map(ContractPoolVO::getContractTaxMny).reduce(ComputeUtil::safeAdd).get();
            }
            if (CollectionUtils.isNotEmpty(lwfContractList = contractPoolList.stream().filter(e -> ContractTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c.getTypeCode().equals(e.getSourceType())).collect(Collectors.toList()))) {
                lwfTaxMny = lwfContractList.stream().map(ContractPoolVO::getContractTaxMny).reduce(ComputeUtil::safeAdd).get();
            }
            if (CollectionUtils.isNotEmpty(clfContractList = contractPoolList.stream().filter(e -> ContractTypeEnum.\u7269\u8d44\u91c7\u8d2d\u5408\u540c.getTypeCode().equals(e.getSourceType()) || ContractTypeEnum.\u6df7\u51dd\u571f\u5408\u540c.getTypeCode().equals(e.getSourceType()) || ContractTypeEnum.\u5468\u8f6c\u6750\u5408\u540c.getTypeCode().equals(e.getSourceType())).collect(Collectors.toList()))) {
                clfTaxMny = clfContractList.stream().map(ContractPoolVO::getContractTaxMny).reduce(ComputeUtil::safeAdd).get();
            }
            if (CollectionUtils.isNotEmpty(jxfContractList = contractPoolList.stream().filter(e -> ContractTypeEnum.\u8bbe\u5907\u91c7\u8d2d.getTypeCode().equals(e.getSourceType()) || ContractTypeEnum.\u8bbe\u5907\u79df\u8d41.getTypeCode().equals(e.getSourceType()) || ContractTypeEnum.\u5b89\u62c6\u5408\u540c.getTypeCode().equals(e.getSourceType()) || ContractTypeEnum.\u4e34\u65f6\u8bbe\u5907.getTypeCode().equals(e.getSourceType())).collect(Collectors.toList()))) {
                jxsbfTaxMny = jxfContractList.stream().map(ContractPoolVO::getContractTaxMny).reduce(ComputeUtil::safeAdd).get();
            }
            if (CollectionUtils.isNotEmpty(zyfbfContractList = contractPoolList.stream().filter(e -> ContractTypeEnum.\u4e13\u4e1a\u5206\u5305\u5408\u540c.getTypeCode().equals(e.getSourceType())).collect(Collectors.toList()))) {
                zyfbfTaxMny = zyfbfContractList.stream().map(ContractPoolVO::getContractTaxMny).reduce(ComputeUtil::safeAdd).get();
            }
            if (CollectionUtils.isNotEmpty(qtzjfContractList = contractPoolList.stream().filter(e -> ContractTypeEnum.\u5176\u4ed6\u652f\u51fa.getTypeCode().equals(e.getSourceType())).collect(Collectors.toList()))) {
                qtzjfTaxMny = qtzjfContractList.stream().map(ContractPoolVO::getContractTaxMny).reduce(ComputeUtil::safeAdd).get();
            }
        }
        CostAndActualOutVO vo = new CostAndActualOutVO();
        vo.setItem(Integer.valueOf(2));
        vo.setItemName("\u652f\u51fa\u5408\u540c");
        vo.setTotalTaxMny(totalTaxMny);
        vo.setLwfTaxMny(lwfTaxMny);
        vo.setClfTaxMny(clfTaxMny);
        vo.setJxfTaxMny(jxsbfTaxMny);
        vo.setZyfbfTaxMny(zyfbfTaxMny);
        vo.setQtzjfTaxMny(qtzjfTaxMny);
        vo.setJjfTaxMny(jjfTaxMny);
        vo.setTaxMny(taxMny);
        if (BigDecimal.ZERO.compareTo(changeAndcostTaxMny) == 0) {
            vo.setTotalTaxMnyScale(BigDecimal.ZERO);
            vo.setLwfTaxMnyScale(BigDecimal.ZERO);
            vo.setClfTaxMnyScale(BigDecimal.ZERO);
            vo.setJxfTaxMnyScale(BigDecimal.ZERO);
            vo.setZyfbTaxMnyScale(BigDecimal.ZERO);
            vo.setQtzjfTaxMnyScale(BigDecimal.ZERO);
            vo.setJjfTaxMnyScale(BigDecimal.ZERO);
            vo.setTaxMnyScale(BigDecimal.ZERO);
        } else {
            vo.setTotalTaxMnyScale(ComputeUtil.safeDiv((BigDecimal)totalTaxMny, (BigDecimal)changeAndcostTaxMny));
            vo.setLwfTaxMnyScale(ComputeUtil.safeDiv((BigDecimal)lwfTaxMny, (BigDecimal)changeAndcostTaxMny));
            vo.setClfTaxMnyScale(ComputeUtil.safeDiv((BigDecimal)clfTaxMny, (BigDecimal)changeAndcostTaxMny));
            vo.setJxfTaxMnyScale(ComputeUtil.safeDiv((BigDecimal)jxsbfTaxMny, (BigDecimal)changeAndcostTaxMny));
            vo.setZyfbTaxMnyScale(ComputeUtil.safeDiv((BigDecimal)zyfbfTaxMny, (BigDecimal)changeAndcostTaxMny));
            vo.setQtzjfTaxMnyScale(ComputeUtil.safeDiv((BigDecimal)qtzjfTaxMny, (BigDecimal)changeAndcostTaxMny));
            vo.setJjfTaxMnyScale(ComputeUtil.safeDiv((BigDecimal)jjfTaxMny, (BigDecimal)changeAndcostTaxMny));
            vo.setTaxMnyScale(ComputeUtil.safeDiv((BigDecimal)taxMny, (BigDecimal)changeAndcostTaxMny));
        }
        return vo;
    }

    public CostAndActualOutVO querySettle(Long projectId, BigDecimal changeAndcostTaxMny) {
        BigDecimal totalTaxMny = BigDecimal.ZERO;
        BigDecimal lwfTaxMny = BigDecimal.ZERO;
        BigDecimal clfTaxMny = BigDecimal.ZERO;
        BigDecimal jxsbfTaxMny = BigDecimal.ZERO;
        BigDecimal zyfbfTaxMny = BigDecimal.ZERO;
        BigDecimal qtzjfTaxMny = BigDecimal.ZERO;
        BigDecimal jjfTaxMny = BigDecimal.ZERO;
        BigDecimal taxMny = BigDecimal.ZERO;
        CommonResponse paramResponse = this.paramConfigApi.getByCode(this.PROJECT_SETTLE_RANGE_PARAM);
        if (!paramResponse.isSuccess() || paramResponse.getData() == null) {
            throw new BusinessException("\u83b7\u53d6\u9879\u76ee\u7ed3\u7b97\u67e5\u8be2\u7ed3\u7b97\u5355\u8303\u56f4\u7cfb\u7edf\u53c2\u6570\u8bf7\u6c42\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + paramResponse.getMsg());
        }
        String valueData = ((ParamRegisterSetVO)paramResponse.getData()).getValueData();
        Assert.hasText((String)valueData, (String)"\u83b7\u53d6\u7684\u9879\u76ee\u7ed3\u7b97\u67e5\u8be2\u7ed3\u7b97\u5355\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a!");
        List<SettlePoolVO> settlePoolList = this.mapper.querySettlePoolByProjectId(projectId, Arrays.asList(valueData.split(",")));
        if (CollectionUtils.isNotEmpty(settlePoolList)) {
            BigDecimal settleTaxMny = null;
            for (SettlePoolVO settle : settlePoolList) {
                settleTaxMny = settle.getCurTaxMny();
                if (SettleSourceTypeEnum.\u52b3\u52a1\u5206\u5305\u6700\u7ec8\u7ed3\u7b97.getCode().equals(settle.getSourceType()) || SettleSourceTypeEnum.\u4e13\u4e1a\u5206\u5305\u6700\u7ec8\u7ed3\u7b97.getCode().equals(settle.getSourceType())) {
                    settleTaxMny = settle.getTotalNodeTaxDifference();
                }
                if (ContractPropertyEnum.\u652f\u51fa\u5408\u540c.getPropertyCode().equals(settle.getSettleProperty())) {
                    totalTaxMny = ComputeUtil.safeAdd((BigDecimal)totalTaxMny, (BigDecimal)settleTaxMny);
                }
                switch (settle.getSourceType()) {
                    case "labor_node": 
                    case "labor_final": {
                        lwfTaxMny = ComputeUtil.safeAdd((BigDecimal)lwfTaxMny, (BigDecimal)settleTaxMny);
                        break;
                    }
                    case "material_buy_in": 
                    case "beton_buy_in": 
                    case "material_week_rent_in": 
                    case "sporadic_material": {
                        clfTaxMny = ComputeUtil.safeAdd((BigDecimal)clfTaxMny, (BigDecimal)settleTaxMny);
                        break;
                    }
                    case "equip_buy_in": 
                    case "equip_rent_in": 
                    case "temp_equip": 
                    case "ac_other_out_contract_month": 
                    case "ac_other_out_contract_final": {
                        jxsbfTaxMny = ComputeUtil.safeAdd((BigDecimal)jxsbfTaxMny, (BigDecimal)settleTaxMny);
                        break;
                    }
                    case "pro_node": 
                    case "pro_final": {
                        zyfbfTaxMny = ComputeUtil.safeAdd((BigDecimal)zyfbfTaxMny, (BigDecimal)settleTaxMny);
                        break;
                    }
                    case "other_out": 
                    case "other_out_contract_month": 
                    case "other_out_contract_final": {
                        qtzjfTaxMny = ComputeUtil.safeAdd((BigDecimal)qtzjfTaxMny, (BigDecimal)settleTaxMny);
                    }
                }
            }
        }
        CostAndActualOutVO vo = new CostAndActualOutVO();
        vo.setItem(Integer.valueOf(3));
        vo.setItemName("\u7ed3\u7b97\u91d1\u989d");
        vo.setTotalTaxMny(totalTaxMny);
        vo.setLwfTaxMny(lwfTaxMny);
        vo.setClfTaxMny(clfTaxMny);
        vo.setJxfTaxMny(jxsbfTaxMny);
        vo.setZyfbfTaxMny(zyfbfTaxMny);
        vo.setQtzjfTaxMny(qtzjfTaxMny);
        vo.setJjfTaxMny(jjfTaxMny);
        vo.setTaxMny(taxMny);
        if (BigDecimal.ZERO.compareTo(changeAndcostTaxMny) == 0) {
            vo.setTotalTaxMnyScale(BigDecimal.ZERO);
            vo.setLwfTaxMnyScale(BigDecimal.ZERO);
            vo.setClfTaxMnyScale(BigDecimal.ZERO);
            vo.setJxfTaxMnyScale(BigDecimal.ZERO);
            vo.setZyfbTaxMnyScale(BigDecimal.ZERO);
            vo.setQtzjfTaxMnyScale(BigDecimal.ZERO);
            vo.setJjfTaxMnyScale(BigDecimal.ZERO);
            vo.setTaxMnyScale(BigDecimal.ZERO);
        } else {
            vo.setTotalTaxMnyScale(ComputeUtil.safeDiv((BigDecimal)totalTaxMny, (BigDecimal)changeAndcostTaxMny));
            vo.setLwfTaxMnyScale(ComputeUtil.safeDiv((BigDecimal)lwfTaxMny, (BigDecimal)changeAndcostTaxMny));
            vo.setClfTaxMnyScale(ComputeUtil.safeDiv((BigDecimal)clfTaxMny, (BigDecimal)changeAndcostTaxMny));
            vo.setJxfTaxMnyScale(ComputeUtil.safeDiv((BigDecimal)jxsbfTaxMny, (BigDecimal)changeAndcostTaxMny));
            vo.setZyfbTaxMnyScale(ComputeUtil.safeDiv((BigDecimal)zyfbfTaxMny, (BigDecimal)changeAndcostTaxMny));
            vo.setQtzjfTaxMnyScale(ComputeUtil.safeDiv((BigDecimal)qtzjfTaxMny, (BigDecimal)changeAndcostTaxMny));
            vo.setJjfTaxMnyScale(ComputeUtil.safeDiv((BigDecimal)jjfTaxMny, (BigDecimal)changeAndcostTaxMny));
            vo.setTaxMnyScale(ComputeUtil.safeDiv((BigDecimal)taxMny, (BigDecimal)changeAndcostTaxMny));
        }
        return vo;
    }

    public CostAndActualOutVO queryPaymentApply(Long projectId, BigDecimal changeAndcostTaxMny) {
        BigDecimal totalTaxMny = BigDecimal.ZERO;
        BigDecimal lwfTaxMny = BigDecimal.ZERO;
        BigDecimal clfTaxMny = BigDecimal.ZERO;
        BigDecimal jxsbfTaxMny = BigDecimal.ZERO;
        BigDecimal zyfbfTaxMny = BigDecimal.ZERO;
        BigDecimal qtzjfTaxMny = BigDecimal.ZERO;
        BigDecimal jjfTaxMny = BigDecimal.ZERO;
        BigDecimal taxMny = BigDecimal.ZERO;
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(PaymentApplyEntity::getProjectId, (Object)projectId);
        queryWrapper.in(PaymentApplyEntity::getBillState, new Object[]{1, 3});
        queryWrapper.in(BaseEntity::getDr, new Object[]{0});
        List list = this.paymentApplyService.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            List collect;
            List qtzjfPaymentApplyList;
            List collect2;
            List zyfbfPaymentApplyList;
            List collect3;
            List jxfPaymentApplyList;
            List collect4;
            List clfPaymentApplyList;
            List collect5;
            totalTaxMny = list.stream().map(PaymentApplyEntity::getApprovalMny).reduce(ComputeUtil::safeAdd).get();
            List lwfPaymentApplyList = list.stream().filter(e -> 0 == e.getPaymentContractFlag() && ContractTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c.getTypeCode().equals(e.getSourceCategoryType())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(lwfPaymentApplyList) && CollectionUtils.isNotEmpty(collect5 = lwfPaymentApplyList.stream().filter(e -> null != e.getApprovalMny()).collect(Collectors.toList()))) {
                lwfTaxMny = lwfPaymentApplyList.stream().map(PaymentApplyEntity::getApprovalMny).reduce(ComputeUtil::safeAdd).get();
            }
            if (CollectionUtils.isNotEmpty(clfPaymentApplyList = list.stream().filter(e -> ContractTypeEnum.\u7269\u8d44\u91c7\u8d2d\u5408\u540c.getTypeCode().equals(e.getSourceCategoryType()) || ContractTypeEnum.\u6df7\u51dd\u571f\u5408\u540c.getTypeCode().equals(e.getSourceCategoryType()) || ContractTypeEnum.\u5468\u8f6c\u6750\u5408\u540c.getTypeCode().equals(e.getSourceCategoryType()) || 3 == e.getPaymentType()).collect(Collectors.toList())) && CollectionUtils.isNotEmpty(collect4 = clfPaymentApplyList.stream().filter(e -> null != e.getApprovalMny()).collect(Collectors.toList()))) {
                clfTaxMny = clfPaymentApplyList.stream().map(PaymentApplyEntity::getApprovalMny).reduce(ComputeUtil::safeAdd).get();
            }
            if (CollectionUtils.isNotEmpty(jxfPaymentApplyList = list.stream().filter(e -> ContractTypeEnum.\u8bbe\u5907\u91c7\u8d2d.getTypeCode().equals(e.getSourceCategoryType()) || ContractTypeEnum.\u8bbe\u5907\u79df\u8d41.getTypeCode().equals(e.getSourceCategoryType()) || ContractTypeEnum.\u5b89\u62c6\u5408\u540c.getTypeCode().equals(e.getSourceCategoryType()) || ContractTypeEnum.\u4e34\u65f6\u8bbe\u5907.getTypeCode().equals(e.getSourceCategoryType()) || 4 == e.getPaymentType()).collect(Collectors.toList())) && CollectionUtils.isNotEmpty(collect3 = jxfPaymentApplyList.stream().filter(e -> null != e.getApprovalMny()).collect(Collectors.toList()))) {
                jxsbfTaxMny = jxfPaymentApplyList.stream().map(PaymentApplyEntity::getApprovalMny).reduce(ComputeUtil::safeAdd).get();
            }
            if (CollectionUtils.isNotEmpty(zyfbfPaymentApplyList = list.stream().filter(e -> 0 == e.getPaymentContractFlag() && ContractTypeEnum.\u4e13\u4e1a\u5206\u5305\u5408\u540c.getTypeCode().equals(e.getSourceCategoryType())).collect(Collectors.toList())) && CollectionUtils.isNotEmpty(collect2 = zyfbfPaymentApplyList.stream().filter(e -> null != e.getApprovalMny()).collect(Collectors.toList()))) {
                zyfbfTaxMny = zyfbfPaymentApplyList.stream().map(PaymentApplyEntity::getApprovalMny).reduce(ComputeUtil::safeAdd).get();
            }
            if (CollectionUtils.isNotEmpty(qtzjfPaymentApplyList = list.stream().filter(e -> 0 == e.getPaymentContractFlag() && ContractTypeEnum.\u5176\u4ed6\u652f\u51fa.getTypeCode().equals(e.getSourceCategoryType())).collect(Collectors.toList())) && CollectionUtils.isNotEmpty(collect = qtzjfPaymentApplyList.stream().filter(e -> null != e.getApprovalMny()).collect(Collectors.toList()))) {
                qtzjfTaxMny = qtzjfPaymentApplyList.stream().map(PaymentApplyEntity::getApprovalMny).reduce(ComputeUtil::safeAdd).get();
            }
        }
        QueryWrapper salaryCount = new QueryWrapper();
        salaryCount.select(new String[]{"sum(apply_tax_mny) as totalSalaryApplyTaxMny"});
        salaryCount.eq((Object)"project_id", (Object)projectId);
        salaryCount.in((Object)"bill_state", new Object[]{1, 3});
        salaryCount.eq((Object)"dr", (Object)0);
        salaryCount.eq((Object)"is_repeat_bill", (Object)0);
        Map salaryMnyMap = this.salaryPayApplyService.getMap((Wrapper)salaryCount);
        BigDecimal totalSalaryApplyTaxMny = BigDecimal.ZERO;
        if (null != salaryMnyMap && null != salaryMnyMap.get("totalSalaryApplyTaxMny")) {
            totalSalaryApplyTaxMny = new BigDecimal(salaryMnyMap.get("totalSalaryApplyTaxMny").toString());
        }
        totalTaxMny = totalTaxMny.add(totalSalaryApplyTaxMny);
        lwfTaxMny = lwfTaxMny.add(totalSalaryApplyTaxMny);
        CostAndActualOutVO vo = new CostAndActualOutVO();
        vo.setItem(Integer.valueOf(4));
        vo.setItemName("\u6279\u590d\u91d1\u989d");
        vo.setTotalTaxMny(totalTaxMny);
        vo.setLwfTaxMny(lwfTaxMny);
        vo.setClfTaxMny(clfTaxMny);
        vo.setJxfTaxMny(jxsbfTaxMny);
        vo.setZyfbfTaxMny(zyfbfTaxMny);
        vo.setQtzjfTaxMny(qtzjfTaxMny);
        vo.setJjfTaxMny(jjfTaxMny);
        vo.setTaxMny(taxMny);
        if (BigDecimal.ZERO.compareTo(changeAndcostTaxMny) == 0) {
            vo.setTotalTaxMnyScale(BigDecimal.ZERO);
            vo.setLwfTaxMnyScale(BigDecimal.ZERO);
            vo.setClfTaxMnyScale(BigDecimal.ZERO);
            vo.setJxfTaxMnyScale(BigDecimal.ZERO);
            vo.setZyfbTaxMnyScale(BigDecimal.ZERO);
            vo.setQtzjfTaxMnyScale(BigDecimal.ZERO);
            vo.setJjfTaxMnyScale(BigDecimal.ZERO);
            vo.setTaxMnyScale(BigDecimal.ZERO);
        } else {
            vo.setTotalTaxMnyScale(ComputeUtil.safeDiv((BigDecimal)totalTaxMny, (BigDecimal)changeAndcostTaxMny));
            vo.setLwfTaxMnyScale(ComputeUtil.safeDiv((BigDecimal)lwfTaxMny, (BigDecimal)changeAndcostTaxMny));
            vo.setClfTaxMnyScale(ComputeUtil.safeDiv((BigDecimal)clfTaxMny, (BigDecimal)changeAndcostTaxMny));
            vo.setJxfTaxMnyScale(ComputeUtil.safeDiv((BigDecimal)jxsbfTaxMny, (BigDecimal)changeAndcostTaxMny));
            vo.setZyfbTaxMnyScale(ComputeUtil.safeDiv((BigDecimal)zyfbfTaxMny, (BigDecimal)changeAndcostTaxMny));
            vo.setQtzjfTaxMnyScale(ComputeUtil.safeDiv((BigDecimal)qtzjfTaxMny, (BigDecimal)changeAndcostTaxMny));
            vo.setJjfTaxMnyScale(ComputeUtil.safeDiv((BigDecimal)jjfTaxMny, (BigDecimal)changeAndcostTaxMny));
            vo.setTaxMnyScale(ComputeUtil.safeDiv((BigDecimal)taxMny, (BigDecimal)changeAndcostTaxMny));
        }
        return vo;
    }

    public CostAndActualOutVO queryPaymentRegister(Long projectId, BigDecimal changeAndcostTaxMny) {
        BigDecimal totalTaxMny = BigDecimal.ZERO;
        BigDecimal lwfTaxMny = BigDecimal.ZERO;
        BigDecimal clfTaxMny = BigDecimal.ZERO;
        BigDecimal jxsbfTaxMny = BigDecimal.ZERO;
        BigDecimal zyfbfTaxMny = BigDecimal.ZERO;
        BigDecimal qtzjfTaxMny = BigDecimal.ZERO;
        BigDecimal jjfTaxMny = BigDecimal.ZERO;
        BigDecimal taxMny = BigDecimal.ZERO;
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(PaymentRegisterEntity::getProjectId, (Object)projectId);
        queryWrapper.in(PaymentRegisterEntity::getBillState, new Object[]{1, 3});
        queryWrapper.eq(BaseEntity::getDr, (Object)0);
        List list = this.paymentRegisterService.list((Wrapper)queryWrapper);
        List<BigDecimal> costMny = this.mapper.queryCostByProjectId(projectId);
        if (CollectionUtils.isNotEmpty(costMny)) {
            totalTaxMny = (BigDecimal)costMny.stream().reduce(ComputeUtil::safeAdd).get();
        }
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            List qtzjfPayList;
            List zyfbfPayList;
            List jxfPayList;
            List clfPayList;
            BigDecimal payMny = list.stream().map(PaymentRegisterEntity::getPayMny).reduce(ComputeUtil::safeAdd).get();
            totalTaxMny = ComputeUtil.safeAdd((BigDecimal)totalTaxMny, (BigDecimal)payMny);
            List lwfPayList = list.stream().filter(e -> ContractTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c.getTypeCode().equals(e.getSourceCategoryType())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(lwfPayList)) {
                lwfTaxMny = lwfPayList.stream().map(PaymentRegisterEntity::getPayMny).reduce(ComputeUtil::safeAdd).get();
            }
            if (CollectionUtils.isNotEmpty(clfPayList = list.stream().filter(e -> ContractTypeEnum.\u7269\u8d44\u91c7\u8d2d\u5408\u540c.getTypeCode().equals(e.getSourceCategoryType()) || ContractTypeEnum.\u6df7\u51dd\u571f\u5408\u540c.getTypeCode().equals(e.getSourceCategoryType()) || ContractTypeEnum.\u5468\u8f6c\u6750\u5408\u540c.getTypeCode().equals(e.getSourceCategoryType()) || "\u96f6\u661f\u6750\u6599".equals(e.getFeeTypeName()) || "\u96f6\u661f\u6750\u6599\u8d39\u7528".equals(e.getFeeTypeName())).collect(Collectors.toList()))) {
                clfTaxMny = clfPayList.stream().map(PaymentRegisterEntity::getPayMny).reduce(ComputeUtil::safeAdd).get();
            }
            if (CollectionUtils.isNotEmpty(jxfPayList = list.stream().filter(e -> ContractTypeEnum.\u8bbe\u5907\u91c7\u8d2d.getTypeCode().equals(e.getSourceCategoryType()) || ContractTypeEnum.\u8bbe\u5907\u79df\u8d41.getTypeCode().equals(e.getSourceCategoryType()) || ContractTypeEnum.\u5b89\u62c6\u5408\u540c.getTypeCode().equals(e.getSourceCategoryType()) || ContractTypeEnum.\u4e34\u65f6\u8bbe\u5907.getTypeCode().equals(e.getSourceCategoryType()) || "\u4e34\u65f6\u673a\u68b0".equals(e.getFeeTypeName()) || "\u4e34\u65f6\u8bbe\u5907\u8d39\u7528".equals(e.getFeeTypeName())).collect(Collectors.toList()))) {
                jxsbfTaxMny = jxfPayList.stream().map(PaymentRegisterEntity::getPayMny).reduce(ComputeUtil::safeAdd).get();
            }
            if (CollectionUtils.isNotEmpty(zyfbfPayList = list.stream().filter(e -> ContractTypeEnum.\u4e13\u4e1a\u5206\u5305\u5408\u540c.getTypeCode().equals(e.getSourceCategoryType())).collect(Collectors.toList()))) {
                zyfbfTaxMny = zyfbfPayList.stream().map(PaymentRegisterEntity::getPayMny).reduce(ComputeUtil::safeAdd).get();
            }
            if (CollectionUtils.isNotEmpty(qtzjfPayList = list.stream().filter(e -> ContractTypeEnum.\u5176\u4ed6\u652f\u51fa.getTypeCode().equals(e.getSourceCategoryType())).collect(Collectors.toList()))) {
                qtzjfTaxMny = qtzjfPayList.stream().map(PaymentRegisterEntity::getPayMny).reduce(ComputeUtil::safeAdd).get();
            }
        }
        QueryParam jjfParam = new QueryParam();
        jjfParam.getParams().put("subject_code", new Parameter("eq", (Object)"06"));
        CommonResponse jjfResp = this.subjectOrgApi.querySubjectOrg(jjfParam);
        if (!jjfResp.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u95f4\u63a5\u8d39\u5931\u8d25!");
        }
        if (CollectionUtils.isNotEmpty((Collection)((Collection)jjfResp.getData()))) {
            SubjectOrgVO subjectOrgVO = (SubjectOrgVO)((List)jjfResp.getData()).get(0);
            QueryParam Param2 = new QueryParam();
            Param2.getParams().put("inner_code", new Parameter("like", (Object)subjectOrgVO.getId()));
            CommonResponse res = this.subjectOrgApi.querySubjectOrg(Param2);
            List<Long> ids = ((List)res.getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
            List<HandshareDetailVO> handshareDetailVOS = this.mapper.queryCostDetailByProjectId(projectId, ids);
            if (CollectionUtils.isNotEmpty(handshareDetailVOS)) {
                jjfTaxMny = handshareDetailVOS.stream().map(HandshareDetailVO::getHappenMny).reduce(ComputeUtil::safeAdd).get();
            }
        }
        QueryParam taxParam = new QueryParam();
        taxParam.getParams().put("subject_code", new Parameter("eq", (Object)"07"));
        CommonResponse taxResp = this.subjectOrgApi.querySubjectOrg(taxParam);
        if (!taxResp.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u95f4\u63a5\u8d39\u5931\u8d25!");
        }
        if (CollectionUtils.isNotEmpty((Collection)((Collection)taxResp.getData()))) {
            SubjectOrgVO subjectOrgVO = (SubjectOrgVO)((List)taxResp.getData()).get(0);
            QueryParam Param3 = new QueryParam();
            Param3.getParams().put("inner_code", new Parameter("like", (Object)subjectOrgVO.getId()));
            CommonResponse res = this.subjectOrgApi.querySubjectOrg(Param3);
            List<Long> ids = ((List)res.getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
            List<HandshareDetailVO> handshareDetailVOS = this.mapper.queryCostDetailByProjectId(projectId, ids);
            if (CollectionUtils.isNotEmpty(handshareDetailVOS)) {
                taxMny = handshareDetailVOS.stream().map(HandshareDetailVO::getHappenMny).reduce(ComputeUtil::safeAdd).get();
            }
        }
        CostAndActualOutVO vo = new CostAndActualOutVO();
        vo.setItem(Integer.valueOf(5));
        vo.setItemName("\u5b9e\u9645\u4ed8\u6b3e");
        vo.setTotalTaxMny(totalTaxMny);
        vo.setLwfTaxMny(lwfTaxMny);
        vo.setClfTaxMny(clfTaxMny);
        vo.setJxfTaxMny(jxsbfTaxMny);
        vo.setZyfbfTaxMny(zyfbfTaxMny);
        vo.setQtzjfTaxMny(qtzjfTaxMny);
        vo.setJjfTaxMny(jjfTaxMny);
        vo.setTaxMny(taxMny);
        if (BigDecimal.ZERO.compareTo(changeAndcostTaxMny) == 0) {
            vo.setTotalTaxMnyScale(BigDecimal.ZERO);
            vo.setLwfTaxMnyScale(BigDecimal.ZERO);
            vo.setClfTaxMnyScale(BigDecimal.ZERO);
            vo.setJxfTaxMnyScale(BigDecimal.ZERO);
            vo.setZyfbTaxMnyScale(BigDecimal.ZERO);
            vo.setQtzjfTaxMnyScale(BigDecimal.ZERO);
            vo.setJjfTaxMnyScale(BigDecimal.ZERO);
            vo.setTaxMnyScale(BigDecimal.ZERO);
        } else {
            vo.setTotalTaxMnyScale(ComputeUtil.safeDiv((BigDecimal)totalTaxMny, (BigDecimal)changeAndcostTaxMny));
            vo.setLwfTaxMnyScale(ComputeUtil.safeDiv((BigDecimal)lwfTaxMny, (BigDecimal)changeAndcostTaxMny));
            vo.setClfTaxMnyScale(ComputeUtil.safeDiv((BigDecimal)clfTaxMny, (BigDecimal)changeAndcostTaxMny));
            vo.setJxfTaxMnyScale(ComputeUtil.safeDiv((BigDecimal)jxsbfTaxMny, (BigDecimal)changeAndcostTaxMny));
            vo.setZyfbTaxMnyScale(ComputeUtil.safeDiv((BigDecimal)zyfbfTaxMny, (BigDecimal)changeAndcostTaxMny));
            vo.setQtzjfTaxMnyScale(ComputeUtil.safeDiv((BigDecimal)qtzjfTaxMny, (BigDecimal)changeAndcostTaxMny));
            vo.setJjfTaxMnyScale(ComputeUtil.safeDiv((BigDecimal)jjfTaxMny, (BigDecimal)changeAndcostTaxMny));
            vo.setTaxMnyScale(ComputeUtil.safeDiv((BigDecimal)taxMny, (BigDecimal)changeAndcostTaxMny));
        }
        return vo;
    }
}

