/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.profinance.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.profinance.bean.SalaryDetailEntity;
import com.ejianc.business.profinance.bean.SalaryPayApplyDetailEntity;
import com.ejianc.business.profinance.bean.SalaryPayApplyDetailWorkerEntity;
import com.ejianc.business.profinance.bean.SalaryPayApplyEntity;
import com.ejianc.business.profinance.service.ISalaryDetailService;
import com.ejianc.business.profinance.service.ISalaryPayApplyDetailService;
import com.ejianc.business.profinance.service.ISalaryPayApplyService;
import com.ejianc.business.profinance.utils.DateUtil;
import com.ejianc.business.profinance.vo.PaymentApplyVO;
import com.ejianc.business.profinance.vo.SalaryPayApplyDetailVO;
import com.ejianc.business.profinance.vo.SalaryPayApplyDetailWorkerVO;
import com.ejianc.business.profinance.vo.SalaryPayApplyVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"salaryPayApply"})
public class SalaryPayApplyController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "SALARY_PAY_APPLY_";
    private static final String BILL_CODE_ADJUST = "SALARY_PAY_APPLY_ADJUST_";
    @Autowired
    private ISalaryPayApplyService service;
    @Autowired
    private ISalaryPayApplyDetailService detailService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ISalaryDetailService salaryDetailService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SalaryPayApplyVO> saveOrUpdate(@RequestBody SalaryPayApplyVO saveOrUpdateVO) {
        List salaryDetailEntityList;
        List sourceIdList;
        BigDecimal workerApplyTaxMnyOld;
        BigDecimal workerTotalApplyTaxMnyNew;
        BigDecimal workerApplyTaxMny;
        BigDecimal workerTotalApplyTaxMny;
        BigDecimal applyTaxMny = saveOrUpdateVO.getApplyTaxMny();
        List applyListOld = saveOrUpdateVO.getSalaryList();
        List applyList = applyListOld.stream().filter(entity -> entity.getRowState() != "del").collect(Collectors.toList());
        BigDecimal totalApplyTaxMny = applyList.stream().map(SalaryPayApplyDetailVO::getWorkerApplyTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal workerShouldPayTaxMny = applyList.stream().map(SalaryPayApplyDetailVO::getWorkerShouldPayTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal workerRemainderTaxMny = applyList.stream().map(SalaryPayApplyDetailVO::getWorkerRemainderTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        List applyDetailList = saveOrUpdateVO.getSalaryDetailList();
        BigDecimal totalDetailApplyTaxMny = applyDetailList.stream().map(SalaryPayApplyDetailWorkerVO::getWorkerApplyTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (saveOrUpdateVO.getIsRepeatBill() != 1) {
            if (totalApplyTaxMny.compareTo(applyTaxMny) != 0 || totalApplyTaxMny.compareTo(totalDetailApplyTaxMny) != 0) {
                this.logger.info("totalApplyTaxMny{},applyTaxMny{},totalDetailApplyTaxMny{}", new Object[]{totalApplyTaxMny, applyTaxMny, totalDetailApplyTaxMny});
                throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff0c\u3010\u5b50\u8868\u3011\u672c\u671f\u7533\u8bf7\u91d1\u989d\u5408\u8ba1\u503c\u4e0e\u3010\u4e3b\u8868\u3011\u6216\u8005\u3010\u660e\u7ec6\u3011\u672c\u671f\u7533\u8bf7\u91d1\u989d\u5408\u8ba1\u503c\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u4fdd\u5b58!");
            }
            if (workerShouldPayTaxMny.compareTo(workerRemainderTaxMny) < 0) {
                throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff0c\u5e94\u53d1\u91d1\u989d\u5c0f\u4e8e\u5269\u4f59\u53ef\u53d1\u91d1\u989d!");
            }
        }
        if (saveOrUpdateVO.getId() == null) {
            saveOrUpdateVO.setCreateUserName(this.sessionManager.getUserContext().getUserName());
        } else {
            saveOrUpdateVO.setUpdateUserName(this.sessionManager.getUserContext().getUserName());
        }
        SalaryPayApplyEntity entity2 = (SalaryPayApplyEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, SalaryPayApplyEntity.class));
        if (entity2.getId() == null || entity2.getId() == 0L) {
            BillCodeParam billCodeParam = new BillCodeParam();
            billCodeParam = saveOrUpdateVO.getIsRepeatBill() == 1 ? BillCodeParam.build((String)BILL_CODE_ADJUST, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO) : BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity2.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        List<SalaryPayApplyDetailEntity> salaryList = entity2.getSalaryList();
        HashMap salaryDetailListMap = new HashMap();
        List<SalaryPayApplyDetailWorkerEntity> salaryDetailList = entity2.getSalaryDetailList();
        HashMap salaryWorkerDetailListMap = new HashMap();
        if (CollectionUtils.isNotEmpty(salaryList)) {
            for (SalaryPayApplyDetailEntity salaryPayApplyDetailEntity : salaryList) {
                workerTotalApplyTaxMny = salaryPayApplyDetailEntity.getWorkerTotalApplyTaxMny();
                workerTotalApplyTaxMny = workerTotalApplyTaxMny == null ? BigDecimal.ZERO : workerTotalApplyTaxMny;
                workerApplyTaxMny = salaryPayApplyDetailEntity.getWorkerApplyTaxMny();
                workerApplyTaxMny = workerApplyTaxMny == null ? BigDecimal.ZERO : workerApplyTaxMny;
                workerTotalApplyTaxMnyNew = BigDecimal.ZERO;
                if (salaryPayApplyDetailEntity.getWorkerIsRepeatBill() == 1) {
                    workerApplyTaxMnyOld = salaryPayApplyDetailEntity.getWorkerApplyTaxMnyOld();
                    workerApplyTaxMnyOld = workerApplyTaxMnyOld == null ? BigDecimal.ZERO : workerApplyTaxMnyOld;
                    workerTotalApplyTaxMnyNew = workerTotalApplyTaxMny.add(workerApplyTaxMny.subtract(workerApplyTaxMnyOld));
                } else {
                    workerTotalApplyTaxMnyNew = workerTotalApplyTaxMny.add(workerApplyTaxMny);
                }
                salaryPayApplyDetailEntity.setWorkerTotalApplyTaxMny(workerTotalApplyTaxMnyNew);
            }
            if (CollectionUtils.isEmpty(salaryDetailList) && saveOrUpdateVO.getIsRepeatBill() != 1) {
                sourceIdList = salaryList.stream().map(SalaryPayApplyDetailEntity::getSourceId).collect(Collectors.toList());
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.in((Object)"id", sourceIdList);
                salaryDetailEntityList = this.salaryDetailService.list((Wrapper)queryWrapper);
                if (CollectionUtils.isNotEmpty((Collection)salaryDetailEntityList)) {
                    salaryDetailEntityList.forEach(item -> salaryDetailListMap.put(item.getId().toString(), item));
                }
                if (MapUtils.isNotEmpty(salaryDetailListMap)) {
                    if (null == saveOrUpdateVO.getId()) {
                        salaryList.forEach(item -> {
                            SalaryDetailEntity salaryDetailEntity;
                            if (item.getRowState().equals("add") && (salaryDetailEntity = (SalaryDetailEntity)((Object)((Object)((Object)salaryDetailListMap.get(item.getSourceId().toString()))))) != null) {
                                salaryDetailEntity.setWorkerRemainderTaxMny(item.getWorkerRemainderTaxMny().subtract(item.getWorkerApplyTaxMny()));
                            }
                        });
                    } else {
                        salaryList.forEach(item -> {
                            SalaryDetailEntity salaryDetailEntity = (SalaryDetailEntity)((Object)((Object)((Object)salaryDetailListMap.get(item.getSourceId().toString()))));
                            if (salaryDetailEntity != null && item.getRowState() != null) {
                                switch (item.getRowState()) {
                                    case "add": 
                                    case "edit": {
                                        salaryDetailEntity.setWorkerRemainderTaxMny(item.getWorkerRemainderTaxMny().subtract(item.getWorkerApplyTaxMny()));
                                        break;
                                    }
                                    case "del": {
                                        salaryDetailEntity.setWorkerRemainderTaxMny(item.getWorkerRemainderTaxMny());
                                    }
                                }
                            }
                        });
                    }
                    this.salaryDetailService.saveOrUpdateBatch(salaryDetailListMap.values());
                }
            }
        }
        if (CollectionUtils.isNotEmpty(salaryDetailList)) {
            for (SalaryPayApplyDetailWorkerEntity salaryPayApplyDetailWorkerEntity : salaryDetailList) {
                workerTotalApplyTaxMny = salaryPayApplyDetailWorkerEntity.getWorkerTotalApplyTaxMny();
                workerTotalApplyTaxMny = workerTotalApplyTaxMny == null ? BigDecimal.ZERO : workerTotalApplyTaxMny;
                workerApplyTaxMny = salaryPayApplyDetailWorkerEntity.getWorkerApplyTaxMny();
                workerApplyTaxMny = workerApplyTaxMny == null ? BigDecimal.ZERO : workerApplyTaxMny;
                workerTotalApplyTaxMnyNew = BigDecimal.ZERO;
                if (salaryPayApplyDetailWorkerEntity.getWorkerIsRepeatBill() == 1) {
                    workerApplyTaxMnyOld = salaryPayApplyDetailWorkerEntity.getWorkerApplyTaxMnyOld();
                    workerApplyTaxMnyOld = workerApplyTaxMnyOld == null ? BigDecimal.ZERO : workerApplyTaxMnyOld;
                    workerTotalApplyTaxMnyNew = workerTotalApplyTaxMny.add(workerApplyTaxMny.subtract(workerApplyTaxMnyOld));
                } else {
                    workerTotalApplyTaxMnyNew = workerTotalApplyTaxMny.add(workerApplyTaxMny);
                }
                salaryPayApplyDetailWorkerEntity.setWorkerTotalApplyTaxMny(workerTotalApplyTaxMnyNew);
            }
            if (saveOrUpdateVO.getIsRepeatBill() != 1) {
                sourceIdList = salaryDetailList.stream().map(SalaryPayApplyDetailWorkerEntity::getSourceId).collect(Collectors.toList());
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.in((Object)"id", sourceIdList);
                salaryDetailEntityList = this.salaryDetailService.list((Wrapper)queryWrapper);
                if (CollectionUtils.isNotEmpty((Collection)salaryDetailEntityList)) {
                    salaryDetailEntityList.forEach(item -> salaryWorkerDetailListMap.put(item.getId().toString(), item));
                }
                if (MapUtils.isNotEmpty(salaryWorkerDetailListMap)) {
                    if (null == saveOrUpdateVO.getId()) {
                        salaryDetailList.forEach(item -> {
                            SalaryDetailEntity salaryDetailEntity;
                            if (item.getRowState().equals("add") && (salaryDetailEntity = (SalaryDetailEntity)((Object)((Object)((Object)salaryWorkerDetailListMap.get(item.getSourceId().toString()))))) != null) {
                                salaryDetailEntity.setWorkerRemainderTaxMny(item.getWorkerRemainderTaxMny().subtract(item.getWorkerApplyTaxMny()));
                            }
                        });
                    } else {
                        salaryDetailList.forEach(item -> {
                            SalaryDetailEntity salaryDetailEntity = (SalaryDetailEntity)((Object)((Object)((Object)salaryWorkerDetailListMap.get(item.getSourceId().toString()))));
                            if (salaryDetailEntity != null && item.getRowState() != null) {
                                switch (item.getRowState()) {
                                    case "add": 
                                    case "edit": {
                                        salaryDetailEntity.setWorkerRemainderTaxMny(item.getWorkerRemainderTaxMny().subtract(item.getWorkerApplyTaxMny()));
                                        break;
                                    }
                                    case "del": {
                                        salaryDetailEntity.setWorkerRemainderTaxMny(item.getWorkerRemainderTaxMny());
                                    }
                                }
                            }
                        });
                    }
                    this.salaryDetailService.saveOrUpdateBatch(salaryWorkerDetailListMap.values());
                }
            }
        }
        entity2.setIsClose(0);
        entity2.setApplyTaxMnyOld(entity2.getApplyTaxMny());
        this.service.saveOrUpdate((Object)entity2, false);
        SalaryPayApplyVO vo = (SalaryPayApplyVO)BeanMapper.map((Object)this.service.selectById(entity2.getId()), SalaryPayApplyVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SalaryPayApplyVO> queryDetail(Long id) {
        SalaryPayApplyEntity entity = this.service.selectById2(id);
        if (entity == null) {
            return CommonResponse.error((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u5931\u8d25");
        }
        SalaryPayApplyVO vo = (SalaryPayApplyVO)BeanMapper.map((Object)((Object)entity), SalaryPayApplyVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetailAdjust"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SalaryPayApplyVO> queryDetailAdjust(Long id) {
        SalaryPayApplyEntity entity = (SalaryPayApplyEntity)((Object)this.service.selectById(id));
        SalaryPayApplyVO vo = new SalaryPayApplyVO();
        vo.setBillCodeOld(entity.getBillCodeOld() != null ? entity.getBillCodeOld() : entity.getBillCode());
        vo.setContractId(entity.getContractId());
        vo.setContractCode(entity.getContractCode());
        vo.setContractName(entity.getContractName());
        vo.setContractCategoryId(entity.getContractCategoryId());
        vo.setContractCategoryName(entity.getContractCategoryName());
        vo.setContractTaxMny(entity.getContractTaxMny());
        vo.setContractLinkUrl(entity.getContractLinkUrl());
        vo.setProjectId(entity.getProjectId());
        vo.setProjectCode(entity.getProjectCode());
        vo.setProjectName(entity.getProjectName());
        vo.setPaySupplierId(entity.getPaySupplierId());
        vo.setPaySupplierName(entity.getPaySupplierName());
        vo.setOrgId(entity.getOrgId());
        vo.setOrgCode(entity.getOrgCode());
        vo.setOrgName(entity.getOrgName());
        vo.setParentOrgId(entity.getParentOrgId());
        vo.setParentOrgCode(entity.getParentOrgCode());
        vo.setParentOrgName(entity.getParentOrgName());
        vo.setApplyDate(new Date());
        vo.setApplyId(entity.getApplyId());
        vo.setApplyName(entity.getApplyName());
        vo.setPayReason(entity.getPayReason());
        vo.setMemo(entity.getMemo());
        vo.setAccountId(entity.getAccountId());
        vo.setAccountName(entity.getAccountName());
        vo.setAccountNum(entity.getAccountNum());
        vo.setBankName(entity.getBankName());
        vo.setPayState(Integer.valueOf(0));
        List salaryList = BeanMapper.mapList(entity.getSalaryList(), SalaryPayApplyDetailVO.class);
        ArrayList<SalaryPayApplyDetailVO> rePayList = new ArrayList<SalaryPayApplyDetailVO>();
        BigDecimal applyTaxMny = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty((Collection)salaryList)) {
            for (SalaryPayApplyDetailVO item : salaryList) {
                if (item.getWorkerPayState() != 3) continue;
                SalaryPayApplyDetailVO detailVO = (SalaryPayApplyDetailVO)BeanMapper.map((Object)item, SalaryPayApplyDetailVO.class);
                detailVO.setWorkerPayState(Integer.valueOf(0));
                detailVO.setWorkerPayDate(null);
                detailVO.setIdOld(item.getId());
                detailVO.setWorkerApplyTaxMnyOld(item.getWorkerApplyTaxMny());
                detailVO.setWorkerIsRepeatBill(Integer.valueOf(1));
                detailVO.setId(Long.valueOf(IdWorker.getId()));
                applyTaxMny = applyTaxMny.add(item.getWorkerApplyTaxMny());
                rePayList.add(detailVO);
            }
            vo.setApplyTaxMny(applyTaxMny);
            vo.setSalaryList(BeanMapper.mapList(rePayList, SalaryPayApplyDetailVO.class));
        }
        List salaryDetailList = BeanMapper.mapList(entity.getSalaryDetailList(), SalaryPayApplyDetailWorkerVO.class);
        ArrayList<SalaryPayApplyDetailWorkerVO> rePayDetailList = new ArrayList<SalaryPayApplyDetailWorkerVO>();
        if (CollectionUtils.isNotEmpty((Collection)salaryDetailList)) {
            for (SalaryPayApplyDetailWorkerVO item : salaryDetailList) {
                if (item.getWorkerPayState() != 3) continue;
                SalaryPayApplyDetailWorkerVO detailVO = (SalaryPayApplyDetailWorkerVO)BeanMapper.map((Object)item, SalaryPayApplyDetailWorkerVO.class);
                detailVO.setWorkerPayState(Integer.valueOf(0));
                detailVO.setWorkerPayDate(null);
                detailVO.setIdOld(item.getId());
                detailVO.setWorkerApplyTaxMnyOld(item.getWorkerApplyTaxMny());
                detailVO.setWorkerIsRepeatBill(Integer.valueOf(1));
                detailVO.setId(Long.valueOf(IdWorker.getId()));
                applyTaxMny = applyTaxMny.add(item.getWorkerApplyTaxMny());
                rePayDetailList.add(detailVO);
            }
            vo.setSalaryDetailList(BeanMapper.mapList(rePayDetailList, SalaryPayApplyDetailWorkerVO.class));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SalaryPayApplyVO> vos) {
        this.service.deleteData(vos);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SalaryPayApplyVO>> queryList(@RequestBody QueryParam param) {
        param.setFuzzyFields(Arrays.asList("billCode", "projectName", "contractCode", "contractName", "paySupplierName", "applyName"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>();
        orderMap.put("create_time", "desc");
        param.setOrderMap(orderMap);
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        Parameter isRepeatBillParam = (Parameter)param.getParams().get("isRepeatBill");
        if (isRepeatBillParam != null && isRepeatBillParam.getValue() != null) {
            param.getParams().put("is_repeat_bill", new Parameter("eq", (Object)Integer.parseInt(isRepeatBillParam.getValue().toString())));
        } else {
            param.getParams().put("is_repeat_bill", new Parameter("eq", (Object)0));
        }
        param.getOrderMap().put("bill_code", "desc");
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List records = BeanMapper.mapList((Iterable)page.getRecords(), SalaryPayApplyVO.class);
        this.setPayStateName(records);
        pageData.setRecords(records);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        List salaryPayApplyVOList = BeanMapper.mapList((Iterable)list, SalaryPayApplyVO.class);
        this.setBillStateName(salaryPayApplyVOList);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", salaryPayApplyVOList);
        ExcelExport.getInstance().export("SalaryPayApply-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refSalaryPayApplyData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SalaryPayApplyVO>> refSalaryPayApplyData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SalaryPayApplyVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @GetMapping(value={"/queryPaymentByContractIdAndBillState"})
    @ResponseBody
    public CommonResponse<List<PaymentApplyVO>> queryPaymentByContractIdAndBillState(@RequestParam Long id) {
        List<PaymentApplyVO> paymentApplyVOS = this.service.queryPaymentByContractIdAndBillState(id, InvocationInfoProxy.getTenantid());
        return CommonResponse.success((String)"\u67e5\u8be2\u5f53\u524d\u5408\u540c\u4e0b\u81ea\u7531\u72b6\u6001\u7684\u4ed8\u6b3e\u7533\u8bf7\u5355\u6210\u529f", paymentApplyVOS);
    }

    @PostMapping(value={"/queryAdjustByContractId"})
    @ResponseBody
    public boolean queryAdjustByContractId(@RequestBody Map<String, Object> param) {
        return this.service.queryAdjustByContractId(param.get("billCode").toString());
    }

    @GetMapping(value={"/queryApplyByContractId"})
    @ResponseBody
    public CommonResponse<List<SalaryPayApplyVO>> queryApplyByContractId(@RequestParam Long contractId) {
        List<SalaryPayApplyEntity> salaryPayApplyEntityList = this.service.queryApplyByContractId(contractId);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", (Object)BeanMapper.mapList(salaryPayApplyEntityList, SalaryPayApplyVO.class));
    }

    @GetMapping(value={"/getContractSalaryApplyInfo"})
    @ResponseBody
    public CommonResponse<Map<String, BigDecimal>> getContractSalaryApplyInfo(@RequestParam Long contractId) {
        Map<String, BigDecimal> applyInfo = this.service.getContractSalaryApplyInfo(contractId);
        return CommonResponse.success(applyInfo);
    }

    @PostMapping(value={"/handMQMessage"})
    @ResponseBody
    public CommonResponse<Map<String, BigDecimal>> handMQMessage(@RequestParam String salaryPayApplyResultMsg) {
        salaryPayApplyResultMsg = "[{\"workerBankName\":\"\u5de5\u5546\u94f6\u884c\",\"workerAccountNum\":\"622021703057237983\",\"workerIdCard\":\"411318198701063020\",\"workerApplyTaxMny\":10058.82,\"updateTime\":\"2022/6/17 14:12:06\",\"id\":\"1537272108839604225\",\"payState\":\"1\",\"workerName\":\"\u4efb\u4e03\",\"salaryPayApplyId\":\"592289262041333852\"},{\"workerBankName\":\"\u5de5\u5546\u94f6\u884c\",\"workerAccountNum\":\"622021703057237982\",\"workerIdCard\":\"411318198701053020\",\"workerApplyTaxMny\":9529.41,\"updateTime\":\"2022/6/17 14:12:06\",\"id\":\"1537272108839604226\",\"payState\":\"1\",\"workerName\":\"\u8d75\u516d\",\"salaryPayApplyId\":\"592289262041333852\"},{\"workerBankName\":\"\u5de5\u5546\u94f6\u884c\",\"workerAccountNum\":\"622021703057237981\",\"workerIdCard\":\"411318198701043020\",\"workerApplyTaxMny\":9000.00,\"updateTime\":\"2022/6/17 14:12:06\",\"id\":\"1537272108839604227\",\"payState\":\"1\",\"workerName\":\"\u738b\u4e94\",\"salaryPayApplyId\":\"592289262041333852\"},{\"workerBankName\":\"\u5de5\u5546\u94f6\u884c\",\"workerAccountNum\":\"622021703057237980\",\"workerIdCard\":\"411318198701033020\",\"workerApplyTaxMny\":8470.59,\"updateTime\":\"2022/6/17 14:12:06\",\"id\":\"1537272108839604228\",\"payState\":\"1\",\"workerName\":\"\u674e\u56db\",\"salaryPayApplyId\":\"592289262041333852\"},{\"workerBankName\":\"\u5de5\u5546\u94f6\u884c\",\"workerAccountNum\":\"622021703057237979\",\"workerIdCard\":\"411318198701023020\",\"workerApplyTaxMny\":7941.18,\"updateTime\":\"2022/6/17 14:12:06\",\"id\":\"1537272108839604229\",\"payState\":\"2\",\"workerName\":\"\u5f20\u4e09\",\"salaryPayApplyId\":\"592289262041333852\"},{\"workerBankName\":\"123\",\"workerAccountNum\":\"4123331231231233\",\"workerIdCard\":\"123123123123123333\",\"workerApplyTaxMny\":50.00,\"updateTime\":\"2022/6/17 14:18:50\",\"id\":\"1537333865401610242\",\"payState\":\"3\",\"workerName\":\"11\",\"salaryPayApplyId\":\"592084267778588756\"},{\"workerBankName\":\"123\",\"workerAccountNum\":\"4123331231231234\",\"workerIdCard\":\"123123123123123334\",\"workerApplyTaxMny\":40.00,\"updateTime\":\"2022/6/17 14:18:50\",\"id\":\"1537333865401610243\",\"payState\":\"2\",\"workerName\":\"22\",\"salaryPayApplyId\":\"592084267778588756\"},{\"workerBankName\":\"123\",\"workerAccountNum\":\"4123331231231233\",\"workerIdCard\":\"123123123123123333\",\"workerApplyTaxMny\":50.00,\"updateTime\":\"2022/6/17 16:40:06\",\"id\":\"1537716828910579713\",\"payState\":\"3\",\"workerName\":\"11\",\"salaryPayApplyId\":\"592755873010040844\"},{\"workerBankName\":\"\u4eba\u6c11\u94f6\u884c\",\"workerAccountNum\":\"1234567801112345\",\"workerIdCard\":\"410222199909091010\",\"workerApplyTaxMny\":500.00,\"updateTime\":\"2022/6/17 18:35:06\",\"id\":\"1537745416001425409\",\"payState\":\"2\",\"workerName\":\"\u4e9a\u745f\",\"salaryPayApplyId\":\"592784546114601044\"},{\"workerBankName\":\"12\",\"workerAccountNum\":\"2120131231831821\",\"workerIdCard\":\"410221210103102940\",\"workerApplyTaxMny\":600.00,\"updateTime\":\"2022/6/17 18:50:06\",\"id\":\"1537749338833293314\",\"payState\":\"1\",\"workerName\":\"\u59b2\u5df1\",\"salaryPayApplyId\":\"592788469684666466\"},{\"workerBankName\":\"1\",\"workerAccountNum\":\"2120131231831813\",\"workerIdCard\":\"410221210103102941\",\"workerApplyTaxMny\":600.00,\"updateTime\":\"2022/6/17 18:50:06\",\"id\":\"1537749338833293315\",\"payState\":\"2\",\"workerName\":\"\u738b\u662d\u541b\",\"salaryPayApplyId\":\"592788469684666466\"},{\"workerBankName\":\"12\",\"workerAccountNum\":\"2120131231831811\",\"workerIdCard\":\"410221210103102942\",\"workerApplyTaxMny\":600.00,\"updateTime\":\"2022/6/17 18:50:06\",\"id\":\"1537749338833293316\",\"payState\":\"3\",\"workerName\":\"\u5ae6\u5a25\",\"salaryPayApplyId\":\"592788469684666466\"},{\"workerBankName\":\"123\",\"workerAccountNum\":\"4123331231231233\",\"workerIdCard\":\"123123123123123333\",\"workerApplyTaxMny\":50.00,\"updateTime\":\"2022/6/18 10:50:06\",\"id\":\"1537998180805185538\",\"payState\":\"2\",\"workerName\":\"11\",\"salaryPayApplyId\":\"593027102631673886\"}]";
        this.service.handMQMessage(salaryPayApplyResultMsg);
        return CommonResponse.success();
    }

    @GetMapping(value={"/handSalaryData"})
    @ResponseBody
    public CommonResponse<Map<String, BigDecimal>> handSalaryData(Long id) {
        SalaryPayApplyEntity salaryPayApplyEntity = (SalaryPayApplyEntity)((Object)this.service.selectById(id));
        this.service.handSalaryData(salaryPayApplyEntity);
        return CommonResponse.success();
    }

    @GetMapping(value={"/queryIsNewestApplyById"})
    @ResponseBody
    public CommonResponse<String> queryIsNewestApplyById(@RequestParam Long applyId) {
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", (Object)this.service.isNewestApplyById(applyId));
    }

    private void setBillStateName(List<SalaryPayApplyVO> voList) {
        if (CollectionUtils.isEmpty(voList)) {
            return;
        }
        for (SalaryPayApplyVO vo : voList) {
            Integer billState = vo.getBillState();
            if (billState == null) continue;
            switch (billState) {
                case 0: {
                    vo.setBillStateName("\u81ea\u7531\u6001");
                    break;
                }
                case 1: {
                    vo.setBillStateName("\u5df2\u63d0\u4ea4");
                    break;
                }
                case 2: {
                    vo.setBillStateName("\u5ba1\u6279\u4e2d");
                    break;
                }
                case 3: {
                    vo.setBillStateName("\u5ba1\u6279\u901a\u8fc7");
                    break;
                }
                case 4: {
                    vo.setBillStateName("\u9a73\u56de");
                    break;
                }
                case 5: {
                    vo.setBillStateName("\u63d0\u4ea4\u540e\u6709\u4eba\u5ba1\u6279\u4e2d");
                    break;
                }
            }
        }
    }

    private void setPayStateName(List<SalaryPayApplyVO> voList) {
        if (CollectionUtils.isEmpty(voList)) {
            return;
        }
        for (SalaryPayApplyVO vo : voList) {
            Integer payState = vo.getPayState();
            if (payState == null) continue;
            switch (payState) {
                case 0: {
                    vo.setPayStateName("\u5f85\u652f\u4ed8");
                    break;
                }
                case 1: {
                    vo.setPayStateName("\u652f\u4ed8\u6210\u529f");
                    break;
                }
                case 2: {
                    vo.setPayStateName("\u90e8\u5206\u652f\u4ed8");
                    break;
                }
                case 3: {
                    vo.setPayStateName("\u652f\u4ed8\u5931\u8d25");
                    break;
                }
            }
        }
    }

    @RequestMapping(value={"/excelExportZi"}, method={RequestMethod.GET})
    @ResponseBody
    public void excelExportZi(Long id, HttpServletResponse response) {
        SalaryPayApplyEntity entity = (SalaryPayApplyEntity)((Object)this.service.selectById(id));
        if (entity.getSalaryList() != null) {
            for (SalaryPayApplyDetailEntity khjgDetailEntity : entity.getSalaryList()) {
                khjgDetailEntity.setTeamCode(khjgDetailEntity.getId() + "");
            }
        }
        HashMap<String, List<SalaryPayApplyDetailEntity>> beans = new HashMap<String, List<SalaryPayApplyDetailEntity>>();
        beans.put("records", entity.getSalaryList());
        ExcelExport.getInstance().export("KhzbdyZiDf-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/uploadTemplate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> uploadTemplate(HttpServletRequest request, HttpServletResponse response) {
        return this.service.excelImportInfo(request, response);
    }

    @RequestMapping(value={"/excelExportZGYH"}, method={RequestMethod.GET})
    @ResponseBody
    public void excelExportZGYH(Long id, HttpServletResponse response) {
        SalaryPayApplyEntity entity = (SalaryPayApplyEntity)((Object)this.service.selectById(id));
        HashMap<String, List<SalaryPayApplyDetailEntity>> beans = new HashMap<String, List<SalaryPayApplyDetailEntity>>();
        beans.put("records", entity.getSalaryList());
        ExcelExport.getInstance().export("zgyh.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelExportJSYH"}, method={RequestMethod.GET})
    @ResponseBody
    public void excelExportJSYH(Long id, HttpServletResponse response) {
        SalaryPayApplyEntity entity = (SalaryPayApplyEntity)((Object)this.service.selectById(id));
        HashMap<String, List<SalaryPayApplyDetailEntity>> beans = new HashMap<String, List<SalaryPayApplyDetailEntity>>();
        for (int i = 0; i < entity.getSalaryList().size(); ++i) {
            entity.getSalaryList().get(i).setWorkerPayState(i + 1);
        }
        beans.put("records", entity.getSalaryList());
        ExcelExport.getInstance().export("jsyh.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelExportNYYH"}, method={RequestMethod.GET})
    @ResponseBody
    public void excelExportNYYH(Long id, HttpServletResponse response) {
        SalaryPayApplyEntity entity = (SalaryPayApplyEntity)((Object)this.service.selectById(id));
        HashMap<String, List<SalaryPayApplyDetailEntity>> beans = new HashMap<String, List<SalaryPayApplyDetailEntity>>();
        for (int i = 0; i < entity.getSalaryList().size(); ++i) {
            entity.getSalaryList().get(i).setWorkerPayState(i + 1);
        }
        beans.put("records", entity.getSalaryList());
        ExcelExport.getInstance().export("nyyh.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelExportZZYH"}, method={RequestMethod.GET})
    @ResponseBody
    public void excelExportZZYH(Long id, HttpServletResponse response) {
        SalaryPayApplyEntity entity = (SalaryPayApplyEntity)((Object)this.service.selectById(id));
        HashMap<String, Object> beans = new HashMap<String, Object>();
        BigDecimal bigDecimal = new BigDecimal(0);
        for (int i = 0; i < entity.getSalaryList().size(); ++i) {
            entity.getSalaryList().get(i).setWorkerPayState(i + 1);
            bigDecimal = bigDecimal.add(entity.getSalaryList().get(i).getWorkerApplyTaxMny());
        }
        beans.put("records", entity.getSalaryList());
        beans.put("mny", bigDecimal);
        beans.put("num", entity.getSalaryList().size());
        ExcelExport.getInstance().export("zzyh.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelExportYQZL"}, method={RequestMethod.GET})
    @ResponseBody
    public void excelExportYQZL(Long id, HttpServletResponse response) {
        SalaryPayApplyEntity entity = (SalaryPayApplyEntity)((Object)this.service.selectById(id));
        String currentDay = DateUtil.getCurrentDay("yyyyMMdd");
        HashMap<String, List<SalaryPayApplyDetailEntity>> beans = new HashMap<String, List<SalaryPayApplyDetailEntity>>();
        for (int i = 0; i < entity.getSalaryList().size(); ++i) {
            entity.getSalaryList().get(i).setWorkerPayState(i + 1);
            entity.getSalaryList().get(i).setWorkerMemo(currentDay);
        }
        beans.put("records", entity.getSalaryList());
        ExcelExport.getInstance().export("yqzl.xlsx", beans, response);
    }
}

