package com.ejianc.business.profinance.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.financeintegration.PMPayApply.api.IPMPayApplyApi;
import com.ejianc.business.financeintegration.PMPayApply.vo.PMPayApplyVO;
import com.ejianc.business.profinance.bean.ContractLawsuitEntity;
import com.ejianc.business.profinance.bean.PaymentApplyEntity;
import com.ejianc.business.profinance.service.IPaymentApplyService;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

@Service("paymentApply")
public class PaymentApplyBpmServiceImpl implements ICommonBusinessService {

    @Autowired
	private IPaymentApplyService service;

	@Autowired
	private IPMPayApplyApi pmPayApplyApi;

	@Autowired
	private IProjectPoolApi projectPoolApi;

	private final Logger logger = LoggerFactory.getLogger(this.getClass());
	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		// 付款申请日期校验
//        PaymentApplyEntity paymentApplyEntity = service.selectById(billId);
//        if (paymentApplyEntity == null) {
//            return CommonResponse.error("查询不到该单据信息！");
//        }
//        // 打印结算单日志
//        logger.info("付款申请提交前回调，付款申请信息：{}", JSON.toJSONString(paymentApplyEntity));
//
//        CommonResponse<PaymentApplyVO> result = service.queryUnusedPaymentApply(paymentApplyEntity.getPaymentType(), paymentApplyEntity.getProjectId(), paymentApplyEntity.getSupplierId(), paymentApplyEntity.getApplyDate());
//        if (result.isSuccess()){
//			return CommonResponse.success("付款申请-提交前回调成功！");
//		}else {
//			return CommonResponse.error(result.getMsg());
//		}
		return CommonResponse.success("付款申请-提交前回调成功！");
	}

	/**
	 * 终审审核完回调
	 *
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		PaymentApplyEntity entity = service.selectById(billId);
		if (entity==null){

		}
		entity.setActualApplyMny(entity.getApprovalMny());
		//TODO 这里判断当前是否是最后一次付款 如果是 就回写当前合同设置为已关闭
		// 调用PM付款申请生效接口
		CommonResponse<PMPayApplyVO> res = takeEffectApply(billId);
		if (!res.isSuccess()) {
			logger.error("调用PM付款申请生效接口失败！message-{}", res.getMsg());
			return CommonResponse.error("调用PM付款申请生效接口失败");
		}
		service.saveOrUpdate(entity,false);
		return CommonResponse.success("付款申请终审回调成功！");
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return bpmBackCheck(billId, state, billTypeCode);
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		return bpmBackCheck(billId, state, billTypeCode);
	}

	/**
	 * 调用PM付款申请生效接口
	 * 接口参数VO中必须封装的字段：
	 * 付款申请ID、项目ID、供应商ID、合同登记ID、收款单位ID、本次申请金额、是否有合同标识：1-是，0-否
	 *
	 * @param id 当前付款申请的主键ID
	 * @return 调用结果
	 */
	private CommonResponse<PMPayApplyVO> takeEffectApply(Long id) {
		logger.info("调用PM付款申请的生效接口---ejc-profinance项目---PaymentApplyBpmServiceImpl类---takeEffectApply方法---begin，本付款申请ID-{}", id);
		PaymentApplyEntity sourceEntity = service.selectById(id);
		if (sourceEntity == null) {
			logger.error("根据本付款申请ID-{}，查询不到本付款申请数据，无法调用PM付款申请生效接口", id);
			return CommonResponse.error("根据本付款申请ID-【" + id + "】查询不到本付款申请数据，无法调用PM付款申请生效接口");
		}
		logger.info("根据本付款申请ID-{}，查询到的本付款申请数据-{}", id, JSONObject.toJSONString(sourceEntity, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
		PMPayApplyVO paramVO = new PMPayApplyVO();
		// 项目ID
		Long projectId = sourceEntity.getProjectId();
		paramVO.setProjectId(null);
		if (projectId != null) {
			paramVO.setProjectId(projectId.toString());
		}
		// 供应商ID
		Long supplierId = sourceEntity.getSupplierId();
		paramVO.setSupplierId(null);
		if (supplierId != null) {
			paramVO.setSupplierId(supplierId.toString());
		}
		// 收款单位ID
		Long payeeId = sourceEntity.getPayeeId();
		paramVO.setPayeeId(null);
		if (payeeId != null) {
			paramVO.setPayeeId(payeeId.toString());
		}
		// 是否有合同    sourceEntity中：0-有合同，1无合同，targetVO中：1-有合同，0-无合同
		Integer paymentContractFlag = sourceEntity.getPaymentContractFlag();
		// 合同登记ID
		Long contractId = sourceEntity.getContractId();
		paramVO.setIsContract(null);
		paramVO.setContractRegisterId(null);
		if (paymentContractFlag != null) {
			if (paymentContractFlag == 0) {// 有合同
				paramVO.setIsContract(1);
				if (contractId != null) {
					paramVO.setContractRegisterId(contractId.toString());
				}
			} else {// 无合同
				paramVO.setIsContract(0);
				paramVO.setContractRegisterId("-1");
			}
		}
		// 本次申请金额
		paramVO.setCurApplyMny(sourceEntity.getApprovalMny());

		//BS ： 以物抵债推送3
		if(sourceEntity.getIsDelegatioNominis() == 2){
			//paramVO.setBs("3");
		}
		logger.info("开始调用PM付款申请生效接口，接口参数VO-{}", paramVO.toString());
		CommonResponse<PMPayApplyVO> res = pmPayApplyApi.takeEffect(paramVO);
		logger.info("调用PM付款申请的生效接口---ejc-profinance项目---PaymentApplyBpmServiceImpl类---takeEffectApply方法---end，接口返回结果-{}", JSONObject.toJSONString(res, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
		if (!res.isSuccess()){
			return  CommonResponse.error("付款申请推送中间表失败");
		}
		return res;
	}

	/**
	 * 调用PM付款申请弃审/关闭接口
	 * 接口参数VO中必须封装的字段：
	 * 项目ID、供应商ID、合同登记ID、收款单位ID、本次申请金额（弃审时为必填）、本次释放申请金额（关闭时必填）、是否有合同标识：1-是，0-否，弃审还是关闭标识：1-弃审，2关闭
	 *
	 * @param id 当前付款申请的主键ID
	 * @param type 弃审还是关闭标识：1-弃审，2-关闭
	 * @return 调用结果
	 */
	private CommonResponse<PMPayApplyVO> abandonOrCloseApply(Long id, Integer type) {
		logger.info("调用PM付款申请的生效接口---ejc-profinance项目---PaymentApplyBpmServiceImpl类---abandonOrCloseApply方法---begin，本付款申请ID-{}", id);
		PaymentApplyEntity sourceEntity = service.selectById(id);
		if (sourceEntity == null) {
			logger.error("根据本付款申请ID-{}，查询不到本付款申请数据，无法调用PM付款申请生效接口", id);
			return CommonResponse.error("根据本付款申请ID-【" + id + "】查询不到本付款申请数据，无法调用PM付款申请生效接口");
		}
		logger.info("根据本付款申请ID-{}，查询到的本付款申请数据-{}", id, JSONObject.toJSONString(sourceEntity, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
		if (sourceEntity.getActualMny()!=null){
			if (sourceEntity.getActualMny().compareTo(BigDecimal.ZERO)==1){
				return CommonResponse.error("当前付款单已存在实际支付金额无法弃审");
			}

		}
		service.abandonOrClose(sourceEntity,"弃审");
		PMPayApplyVO paramVO = new PMPayApplyVO();
		// 项目ID
		paramVO.setProjectId(sourceEntity.getProjectId().toString());

		// 供应商ID
		paramVO.setSupplierId(sourceEntity.getSupplierId().toString());

		// 收款单位ID
		paramVO.setPayeeId(sourceEntity.getPayeeId().toString());

		// 是否有合同    sourceEntity中：0-有合同，1无合同，targetVO中：1-有合同，0-无合同
		Integer paymentContractFlag = sourceEntity.getPaymentContractFlag();
		// 合同登记ID
		Long contractId = sourceEntity.getContractId();
		paramVO.setIsContract(null);
		paramVO.setContractRegisterId(null);
		if (paymentContractFlag != null) {
			if (paymentContractFlag == 0) {// 有合同
				paramVO.setIsContract(1);
				if (contractId != null) {
					paramVO.setContractRegisterId(contractId.toString());
				}
			} else {// 无合同
				paramVO.setIsContract(0);
				paramVO.setContractRegisterId("-1");
			}
		}
		// 弃审还是关闭标识：1-弃审，2-关闭
		paramVO.setType(type);
		// 本次申请金额
		if (type == 1) {
			paramVO.setCurApplyMny(sourceEntity.getApprovalMny());
		}
		//弃审 本次释放金额 = 批复金额
		paramVO.setCurReleaseMny(sourceEntity.getApprovalMny());

		logger.info("开始调用PM付款申请生效接口，接口参数VO-{}", paramVO.toString());
		CommonResponse<PMPayApplyVO> res = pmPayApplyApi.abandonOrClose(paramVO);
		logger.info("调用PM付款申请的生效接口---ejc-profinance项目---PaymentApplyBpmServiceImpl类---abandonOrCloseApply方法---end，接口返回结果-{}", JSONObject.toJSONString(res, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
		return res;
	}

	//撤回、弃审回调方法
	private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
		logger.info("付款申请单据billId-{}, state-{}, billTypeCode-{}撤回前校验", billId, state, billTypeCode);
		//已关闭的申请不能撤回
		PaymentApplyEntity paymentApplyEntity = service.selectById(billId);
		if (paymentApplyEntity == null) {
			return CommonResponse.error("查询不到该单据信息！");
		}
		logger.info("撤回前付款申请实体信息为：{}", JSONObject.toJSONString(paymentApplyEntity, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
		//有合同付款申请 撤回校验
		if (paymentApplyEntity.getPaymentContractFlag()==0){
			//查询当前合同是否存在自由态的单据
			QueryWrapper<PaymentApplyEntity> listQuery = new QueryWrapper<>();
			listQuery.eq("contract_id", paymentApplyEntity.getContractId());
			listQuery.eq("bill_state",BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
			int resultCount = service.count(listQuery);
			if (resultCount > 0) {
				return CommonResponse.error("当前合同已存在自由态的付款申请 不能弃审/撤回！");
			}
		}
		//已关闭的不能弃审
		if (null != paymentApplyEntity.getCloseState() && paymentApplyEntity.getCloseState().equals(1)) {
			return CommonResponse.error("当前单据已关闭，不能弃审/撤回！");
		}
		//已付款的不能弃审
		if (null != paymentApplyEntity.getPaymentStatus() && paymentApplyEntity.getPaymentStatus().equals(2)){
			return CommonResponse.error("当前单据已付款，不能弃审！");
		}
		// 调用PM付款申请弃审/关闭接口
		if (paymentApplyEntity.getActualMny()!=null){
			if (paymentApplyEntity.getActualMny().compareTo(BigDecimal.ZERO)==1){
				return CommonResponse.error("当前付款单已存在实际支付金额无法弃审");
			}
		}

		//审批通过的单据走财务金额扣减逻辑
		if(BillStateEnum.COMMITED_STATE.getBillStateCode().equals(paymentApplyEntity.getBillState())
				|| BillStateEnum.PASSED_STATE.getBillStateCode().equals(paymentApplyEntity.getBillState())) {
			logger.error("付款申请-【{}】执行弃审，更新中间表逻辑！", JSONObject.toJSONString(paymentApplyEntity));
			String abaMsg = service.abandonOrClose(paymentApplyEntity, "弃审");
			if (StringUtils.isNotBlank(abaMsg)) {
				return CommonResponse.error(abaMsg);
			}
		}

		return CommonResponse.success("弃审/撤回前校验回调成功！");
	}
	/**
	 * 审批--获取当前节点的审批人---从服务中选择
	 *
	 * @param billId 单据id
	 * @param billTypeCode 单据类型编码
	 * @param sign 节点标志
	 * @return
	 */
	@Override
	public CommonResponse<JSONArray> queryApproveUser(Long billId, String billTypeCode, String sign, Map<String, Object> other){
		JSONArray arr = new JSONArray();
		logger.info("sign:{}",sign);

		//根据标识判断是否（成本相关人员审批的）节点
		if ("choseCostUser".equals(sign)){
			//获取表单详情数据

			//根据项目id获取项目基本信息中的成本对接人信息
			PaymentApplyEntity entity = service.selectById(billId);
			Long projectId = entity.getProjectId();

			JSONObject jsonObject = new JSONObject();
			CommonResponse<JSONArray> commonResponse = projectPoolApi.queryProjectPoolById(projectId);


			if(!commonResponse.isSuccess()){
				throw new BusinessException("查询项目失败!");
			}
			JSONArray array = commonResponse.getData();
			List<ProjectPoolSetVO> vos = JSONObject.parseArray(array.toJSONString(), ProjectPoolSetVO.class);

			logger.info("vos:{}",JSONObject.toJSONString(vos));

			ProjectPoolSetVO vo = vos.get(0);
			Long costAdapter = vo.getCostAdapter();
			String costAdapterName = vo.getCostAdapterName();

			logger.info("userId:{}",costAdapter);
			logger.info("userName:{}",costAdapterName);


			jsonObject.put("userId",costAdapter);
			jsonObject.put("userName",costAdapterName);

			arr.add(jsonObject);

		}
		return CommonResponse.success(arr);
	}

}
