package com.ejianc.business.receipt.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.receipt.bean.ReceiptRegisterEntity;
import com.ejianc.business.receipt.service.IReceiptRegisterService;
import com.ejianc.business.receipt.vo.ReceiptRegisterVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * 收款登记api
 *
 * @author generator
 */
@RestController
@RequestMapping("/api/receiptRegisterApi/")
public class ReceiptRegisterApi implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IReceiptRegisterService service;


    /**
     * 通过项目id查询相应的累计收款金额
     * @param projectId
     * @return
     */
    @GetMapping(value = "queryRecMnyByProjectId")
    CommonResponse<BigDecimal> queryRecMnyByProjectId(@RequestParam(value = "projectId") Long projectId){
        QueryWrapper<ReceiptRegisterEntity> listQuery = new QueryWrapper<>();
        listQuery.select("ifnull(sum(sum_received_mny), 0) as sumReceivedMny");
        listQuery.eq("project_id", projectId);
        listQuery.eq("tenant_id", InvocationInfoProxy.getTenantid());
        listQuery.in("bill_state",  Arrays.asList(
                BillStateEnum.COMMITED_STATE.getBillStateCode(),
                BillStateEnum.PASSED_STATE.getBillStateCode()));
        Map<String,Object> resultMap = service.getMap(listQuery);
        BigDecimal sumReceivedMny = BigDecimal.ZERO;
        if (resultMap.containsKey("sumReceivedMny")){
            sumReceivedMny = null != resultMap.get("sumReceivedMny") && !new BigDecimal("0E-8").equals(resultMap.get("sumReceivedMny"))? new BigDecimal(resultMap.get("sumReceivedMny").toString()) : BigDecimal.ZERO;
        }
        return CommonResponse.success("查询累计收款金额成功！", sumReceivedMny);
    }


    /**
     * 通用查询收款列表-无分页
     * @param param
     * @return
     */
    @PostMapping(value = "queryReceiptRegisterList")
    public CommonResponse<List<ReceiptRegisterVO>> queryReceiptRegisterList(@RequestBody QueryParam queryParam){
        logger.info("获取收款数据开始---");
        QueryWrapper<ReceiptRegisterEntity> listQuery = BaseServiceImpl.changeToQueryWrapper(queryParam);
        List<ReceiptRegisterEntity> list = service.list(listQuery);
        logger.info("获取收款数据为---{}",JSONObject.toJSONString(list));
        List<ReceiptRegisterVO> registerVOS = BeanMapper.mapList(list, ReceiptRegisterVO.class);
        return CommonResponse.success("查询收款列表成功！", registerVOS);
    }

    /**
     * 更新或保存收款列表
     * @param
     * @return
     */
    @PostMapping(value = "saveOrUpdateReceiptRegisterList")
    public CommonResponse<Boolean> saveOrUpdateReceiptRegisterList(@RequestBody List<ReceiptRegisterVO> vos){
        logger.info("更新收款列表数据为---{}", JSONObject.toJSONString(vos));
        List<ReceiptRegisterEntity> entities = BeanMapper.mapList(vos, ReceiptRegisterEntity.class);
        boolean b = service.saveOrUpdateBatch(entities);
        logger.info("更新收款列表结果为---{}", b);
        return CommonResponse.success("更新收款列表成功！", b);
    }
}
