package com.ejianc.business.receipt.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.financeintegration.PMReceiptRegister.api.IPMSKSJApi;
import com.ejianc.business.financeintegration.PMReceiptRegister.vo.PMSKSJVO;
import com.ejianc.business.receipt.bean.ReceiptRegisterEntity;
import com.ejianc.business.receipt.mapper.ReceiptRegisterMapper;
import com.ejianc.business.receipt.service.IReceiptRegisterService;
import com.ejianc.business.receipt.vo.ReceiptRegisterVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.CustomerVO;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.api.IShareCustomerApi;
import com.ejianc.foundation.support.api.IShareSupplierWebApi;
import com.ejianc.foundation.support.vo.BankAccountVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.DateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 收款登记主实体
 * 
 * @author generator
 * 
 */
@Service("receiptRegisterService")
public class ReceiptRegisterServiceImpl extends BaseServiceImpl<ReceiptRegisterMapper, ReceiptRegisterEntity> implements IReceiptRegisterService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IProjectPoolApi projectPoolApi;

    @Autowired
    private IContractPoolApi contractApi;

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IDefdocApi defdocApi;

    @Autowired
    private IShareSupplierWebApi iShareSupplierWebApi;

    @Autowired
    private IShareCustomerApi shareCustomerApi;

    @Autowired
    private IPMSKSJApi ipmsksjApi;

    private static final String BILL_CODE = "RECEIPT_REGISTER";//此处需要根据实际修改

    @Autowired
    private IBillCodeApi billCodeApi;

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
//        QueryParam queryParam = new QueryParam();
//        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, tenantId));
//        queryParam.getParams().put("contractProperty",new Parameter(QueryParam.EQ,1));
        //List<ContractPoolVO> contractList = (List<ContractPoolVO>)getRespData(contractApi.queryList(queryParam),true,"导入失败，查询合同信息失败，请重试！");
        //List<BankAccountVO> accountList = (List<BankAccountVO>)getRespData(iShareSupplierWebApi.queryBankAccountList(),true,"导入失败，查询银行账户信息失败，请重试！");
        List<DefdocDetailVO> defList = (List<DefdocDetailVO>)getRespData(defdocApi.getDefDocByDefCode("profinance-clause-property"),true,"导入失败，查询款项属性信息失败，请重试！");
        List<DefdocDetailVO> defSettleList = (List<DefdocDetailVO>)getRespData(defdocApi.getDefDocByDefCode("profinance-settle-type"),true,"导入失败，查询档案下结算类型失败，请重试！");
        List<DefdocDetailVO> defFeeList = (List<DefdocDetailVO>)getRespData(defdocApi.getDefDocByDefCode("no_contract_fee_type"),true,"导入失败，查询档案下无合同费用类型失败，请重试！");
        //Map<String, ContractPoolVO> contractMap = contractList.stream().collect(Collectors.toMap(ContractPoolVO::getContractCode, Function.identity(), (key1, key2) -> key2));
       // Map<String, BankAccountVO> accountMap = accountList.stream().collect(Collectors.toMap(BankAccountVO::getBankAccount, Function.identity(), (key1, key2) -> key2));
        Map<String, DefdocDetailVO> defFeeMap = defFeeList.stream().collect(Collectors.toMap(DefdocDetailVO::getName, Function.identity(), (key1, key2) -> key2));
        Map<String, DefdocDetailVO> defSettleMap = defSettleList.stream().collect(Collectors.toMap(DefdocDetailVO::getName, Function.identity(), (key1, key2) -> key2));
        Map<String, DefdocDetailVO> defMap = defList.stream().collect(Collectors.toMap(DefdocDetailVO::getName, Function.identity(), (key1, key2) -> key2));
        //Map<String, BankAccountVO> accountMap = new HashMap<>();
        Map<String,ProjectPoolSetVO> poolSetVOMap = new HashMap<>();
        Map<String,OrgVO> orgVOMap = new HashMap<>();
        Map<String,ContractPoolVO> contractMap = new HashMap<>();
        Map<String,CustomerVO> customerMap = new HashMap<>();
        JSONObject resp = new JSONObject();
        if (isFailed) {
            return CommonResponse.error("文件格式不合法！");
        } else {
            if (mf == null) {
                throw new BusinessException("导入的文件中没有数据");
            }
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                List<ReceiptRegisterVO> voList = new ArrayList<>();
                List<ReceiptRegisterVO> successList = new ArrayList<>();
                List<ReceiptRegisterVO> errorList = new ArrayList<>();
                for (int i = 1; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    ReceiptRegisterVO vo = new ReceiptRegisterVO();
                    String warnType = "";
                    vo.setId(IdWorker.getId());
                    if (StringUtils.isBlank(datas.get(0))) {// 项目所属组织为空
                        vo.setParentOrgName(null);
                        warnType = warnType + "[项目所属组织为空]";
                    } else {
                        if (orgVOMap.containsKey(datas.get(0))){
                            vo.setParentOrgName(datas.get(0));
                            vo.setParentOrgCode(orgVOMap.get(datas.get(0)).getCode());
                            vo.setParentOrgId(orgVOMap.get(datas.get(0)).getId());
                        }else {
                            CommonResponse<OrgVO> orgVORes = iOrgApi.findByNameAndTenantId(datas.get(0), tenantId);
                            if (orgVORes.isSuccess() && orgVORes.getData()!=null) {
                                OrgVO orgVOs = orgVORes.getData();
                                orgVOMap.put(datas.get(0),orgVOs);
                                vo.setParentOrgName(datas.get(0));
                                vo.setParentOrgCode(orgVOs.getCode());
                                vo.setParentOrgId(orgVOs.getId());
                            }else {
                                vo.setParentOrgName(null);
                                warnType = warnType + "[组织管理中不存在当前组织]";
                            }
                        }
                    }
                    if ("有合同收款".equals(datas.get(3))) {
                        if (StringUtils.isBlank(datas.get(1))) {//条款属性为空
                            vo.setClausePropertyName(null);
                            warnType = warnType + "[条款属性为空]";
                        } else {
                            if (defMap.get(datas.get(1)) == null){
                                vo.setClausePropertyName(null);
                                warnType = warnType + "[档案中不存在当前条款属性]";
                            }else {
                                vo.setClausePropertyId(defMap.get(datas.get(1)).getId());
                                vo.setClausePropertyName(datas.get(1));
                            }
                        }
                    }

                    if (StringUtils.isBlank(datas.get(2))) {
                        vo.setReceiptDate(null);
                        warnType = warnType + "[收款日期为空]";
                    } else {
                        Date date = DateUtil.getJavaDate(Double.parseDouble(datas.get(2)));
                        vo.setReceiptDate(date);
                    }

                    if (StringUtils.isBlank(datas.get(3))) {
                        vo.setReceiptContractFlag(null);
                        warnType = warnType + "[收入类型为空]";
                    } else {
                        vo.setReceiptContractFlag("有合同收款".equals(datas.get(3)) ? 0 : 1);
                    }
                    if ("有合同收款".equals(datas.get(3))) {
                        if (StringUtils.isBlank(datas.get(4)) || StringUtils.isBlank(datas.get(5))) {
                            vo.setContractName(null);
                            warnType = warnType + "[合同名称和编码不能为空]";
                        } else {
                            if (contractMap.containsKey(datas.get(5))){
                                if (!datas.get(4).equals(contractMap.get(datas.get(5)).getContractName())){
                                    warnType = warnType + "[合同池中当前名称和编号不符合]";
                                }else {
                                    vo.setContractName(datas.get(4));
                                    vo.setContractId(contractMap.get(datas.get(5)).getContractId());
                                    vo.setContractCode(datas.get(5));
                                    vo.setContractTaxMny(contractMap.get(datas.get(5)).getContractTaxMny());
                                    vo.setContractMny(contractMap.get(datas.get(5)).getContractMny());
                                    vo.setOrgId(contractMap.get(datas.get(5)).getOrgId());
                                    vo.setOrgCode(contractMap.get(datas.get(5)).getOrgCode());
                                    vo.setOrgName(contractMap.get(datas.get(5)).getOrgName());
                                    vo.setProjectName(contractMap.get(datas.get(5)).getProjectName());
                                    vo.setProjectId(contractMap.get(datas.get(5)).getProjectId());
                                    vo.setProjectCode(contractMap.get(datas.get(5)).getProjectCode());
                                    vo.setParentOrgName(contractMap.get(datas.get(5)).getParentOrgName());
                                    vo.setParentOrgCode(contractMap.get(datas.get(5)).getParentOrgCode());
                                    vo.setParentOrgId(contractMap.get(datas.get(5)).getParentOrgId());
                                    vo.setCustomerId(contractMap.get(datas.get(5)).getPartyaId());
                                    vo.setCustomerName(contractMap.get(datas.get(5)).getPartyaName());
                                    vo.setSourceCategoryType(contractMap.get(datas.get(5)).getSourceType());
                                    vo.setSourceCategoryTypeName(contractMap.get(datas.get(5)).getSourceTypeName());
                                    vo.setContractCategoryId(contractMap.get(datas.get(5)).getCategoryId());
                                    vo.setContractCategoryName(contractMap.get(datas.get(5)).getCategoryName());
                                }
                            }else {
                                CommonResponse<ContractPoolVO> contractData = contractApi.queryContractByCode(datas.get(5));
                                if (contractData.isSuccess() && contractData.getData() != null) {
                                    contractMap.put(datas.get(5), contractData.getData());
                                    if (!datas.get(4).equals(contractMap.get(datas.get(5)).getContractName())){
                                        warnType = warnType + "[合同池中当前名称和编号不符合]";
                                    }else {
                                        vo.setContractName(datas.get(4));
                                        vo.setContractId(contractMap.get(datas.get(5)).getContractId());
                                        vo.setContractCode(datas.get(5));
                                        vo.setContractTaxMny(contractMap.get(datas.get(5)).getContractTaxMny());
                                        vo.setContractMny(contractMap.get(datas.get(5)).getContractMny());
                                        vo.setOrgId(contractMap.get(datas.get(5)).getOrgId());
                                        vo.setOrgCode(contractMap.get(datas.get(5)).getOrgCode());
                                        vo.setOrgName(contractMap.get(datas.get(5)).getOrgName());
                                        vo.setProjectName(contractMap.get(datas.get(5)).getProjectName());
                                        vo.setProjectId(contractMap.get(datas.get(5)).getProjectId());
                                        vo.setProjectCode(contractMap.get(datas.get(5)).getProjectCode());
                                        vo.setParentOrgName(contractMap.get(datas.get(5)).getParentOrgName());
                                        vo.setParentOrgCode(contractMap.get(datas.get(5)).getParentOrgCode());
                                        vo.setParentOrgId(contractMap.get(datas.get(5)).getParentOrgId());
                                        vo.setCustomerId(contractMap.get(datas.get(5)).getPartyaId());
                                        vo.setCustomerName(contractMap.get(datas.get(5)).getPartyaName());
                                        vo.setSourceCategoryType(contractMap.get(datas.get(5)).getSourceType());
                                        vo.setSourceCategoryTypeName(contractMap.get(datas.get(5)).getSourceTypeName());
                                        vo.setContractCategoryId(contractMap.get(datas.get(5)).getCategoryId());
                                        vo.setContractCategoryName(contractMap.get(datas.get(5)).getCategoryName());
                                    }
                                }else {
                                    warnType = warnType + "[合同池中不存在当前合同编码的合同]";
                                }
                            }
                        }
                    }
                    if ("无合同收款".equals(datas.get(3))){
                        if (StringUtils.isBlank(datas.get(6))) {
                            vo.setFeeName(null);
                            warnType = warnType + "[无合同费用类型为空]";
                        } else {
                            if (defFeeMap.get(datas.get(6)) == null){
                                vo.setFeeName(null);
                                warnType = warnType + "[档案不存在当前无合同费用类型]";
                            }else {
                                vo.setFeeName(datas.get(6));
                                vo.setFeeId(defFeeMap.get(datas.get(6)).getId());
                            }
                        }
                        if (StringUtils.isBlank(datas.get(7)) || StringUtils.isBlank(datas.get(8))) {
                            vo.setProjectName(null);
                            vo.setProjectCode(null);
                            warnType = warnType + "[项目名称和编码不能为空]";
                        } else {
                            if (poolSetVOMap.containsKey(datas.get(7))){
                                vo.setProjectId(poolSetVOMap.get(datas.get(7)).getId());
                                vo.setProjectCode(poolSetVOMap.get(datas.get(7)).getCode());
                                vo.setProjectName(poolSetVOMap.get(datas.get(7)).getName());
                                vo.setOrgId(poolSetVOMap.get(datas.get(7)).getProjectDepartmentId());
                                vo.setOrgName(poolSetVOMap.get(datas.get(7)).getProjectDepartmentName());
                                vo.setParentOrgName(poolSetVOMap.get(datas.get(7)).getOrgName());
                                vo.setParentOrgId(poolSetVOMap.get(datas.get(7)).getOrgId());
                            }else {
                                CommonResponse<List<ProjectPoolSetVO>> projectListRes = projectPoolApi.queryProjectListByNameAndCodeAndTenantId(datas.get(7), datas.get(8), tenantId);
                                if (projectListRes.isSuccess()) {
                                    List<ProjectPoolSetVO> projectLists = projectListRes.getData();
                                    if (CollectionUtils.isEmpty(projectLists)) {
                                        warnType = warnType + "[项目池中不存在当前项目]";
                                    }else {
                                        if (projectLists.size() == 1) {
                                            ProjectPoolSetVO projectPoolSetVO = projectLists.get(0);
                                            poolSetVOMap.put(datas.get(7),projectPoolSetVO);
                                            vo.setProjectId(projectPoolSetVO.getId());
                                            vo.setProjectCode(projectPoolSetVO.getCode());
                                            vo.setProjectName(projectPoolSetVO.getName());
                                            vo.setOrgId(projectPoolSetVO.getProjectDepartmentId());
                                            vo.setOrgName(projectPoolSetVO.getProjectDepartmentName());
                                            vo.setParentOrgName(projectPoolSetVO.getOrgName());
                                            vo.setParentOrgId(projectPoolSetVO.getOrgId());
                                        } else {
                                            warnType = warnType + "[根据项目名称和项目编码查询项目成功，但查询到多条数据]";
                                        }
                                    }
                                }
                            }
                        }
                        if (StringUtils.isBlank(datas.get(9))) {
                            vo.setCustomerName(null);
                            warnType = warnType + "[收款单位为空]";
                        } else {
                            if (customerMap.containsKey(datas.get(9))){
                                vo.setCustomerId(customerMap.get(datas.get(9)).getId());
                                vo.setCustomerName(datas.get(9));
                            }else {
                                CommonResponse<CustomerVO> vos = shareCustomerApi.findOneByName(datas.get(9),tenantId);
                                if (vos.isSuccess() && vos.getData() != null){
                                    customerMap.put(datas.get(9),vos.getData());
                                    vo.setCustomerId(vos.getData().getId());
                                    vo.setCustomerName(datas.get(9));
                                }else {
                                    vo.setCustomerName(null);
                                    warnType = warnType + "[客户档案数据不存在]";
                                }
                            }
                        }
                    }

                    if (StringUtils.isBlank(datas.get(10))) {
                        vo.setSumReceivedMny(null);
                        warnType = warnType + "[本次实收金额为空]";
                    } else {
                        vo.setSumReceivedMny(new BigDecimal(datas.get(10)));
                    }
                    vo.setReceiptReason(datas.get(11));
//                    if (StringUtils.isNotEmpty(datas.get(12))) {
//                        if (accountMap.get(datas.get(12)) == null) {
//                            vo.setAccountName(null);
//                            warnType = warnType + "[银行账户下不存在当前账户]";
//                        } else {
//                            if (vo.getCustomerId() != null){
//                                if (accountMap.get(datas.get(12)).getSupplierId().equals(vo.getCustomerId())){
//                                    if (accountMap.get(datas.get(12)).getEnabled() == 1){
//                                        vo.setAccountName(datas.get(12));
//                                        vo.setAccountId(accountMap.get(datas.get(12)).getId());
//                                        vo.setAccountNum(accountMap.get(datas.get(12)).getBankCode());
//                                        vo.setBankAccount(accountMap.get(datas.get(12)).getBankName());
//                                    }else {
//                                        warnType = warnType + "[当前银行账户没有启用]";
//                                    }
//                                }else {
//                                    warnType = warnType + "[当前银行账户不属于当前收款单位下的]";
//                                }
//                            }else {
//                                warnType = warnType + "[没有收款单位]";
//                            }
//                        }
//                    }
                    if (StringUtils.isBlank(datas.get(13))) {
                        vo.setSettleTypeName(null);
                        warnType = warnType + "[结算类型为空]";
                    } else {
                        if (defSettleMap.containsKey(datas.get(13))){
                            vo.setSettleTypeName(datas.get(13));
                            vo.setSettleTypeId(defSettleMap.get(datas.get(13)).getId());
                        }else {
                            vo.setSettleTypeName(null);
                            warnType = warnType + "[档案下不存在当前结算类型]";
                        }
                    }
                    vo.setWarnType(warnType);
                    vo.setRowState("add");
                    voList.add(vo);
                }
                if(CollectionUtils.isNotEmpty(voList)){
                    voList.forEach(vo ->{
                        if(StringUtils.isBlank(vo.getWarnType())){
                            successList.add(vo);
                        } else {
                            errorList.add(vo);
                        }
                    });
                }
                resp.put("successList", successList);
                resp.put("errorList", errorList);
                resp.put("successNum", successList.size());
                resp.put("errorNum", errorList.size());
                return CommonResponse.success(resp);
            }
            return CommonResponse.error("Excel为空");
        }
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

    @Override
    public String saveImportExcel(HttpServletRequest request, List<ReceiptRegisterVO> importVOS) {
        if (ListUtil.isEmpty(importVOS)) {
            throw new BusinessException("导入的数据为空！");
        }
        List<ReceiptRegisterEntity> entityList = BeanMapper.mapList(importVOS, ReceiptRegisterEntity.class);
        ReceiptRegisterVO vo = null;
        Map<String, BigDecimal> mny = new HashMap<>();
        for (ReceiptRegisterEntity entity : entityList) {
            mny = queryReceiptMny(entity.getContractId(),null);
            entity.setTotalReceiptMny(mny.get("sumReceivedMny"));
            vo = BeanMapper.map(entity, ReceiptRegisterVO.class);
            if(entity.getId() != null || entity.getId() != 0){
                BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),vo);
                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                if(billCode.isSuccess()) {
                    entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                }else{
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
            }
        }
        super.saveOrUpdateBatch(entityList,entityList.size(),false);
        return "保存成功";
    }

    @Override
    public Map<String, BigDecimal> queryReceiptMny(Long contractId,Long projectId) {
        Map<String, BigDecimal> info = new HashMap<>();
        QueryWrapper<ReceiptRegisterEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.select("sum( sum_received_Mny ) AS sumReceivedMny");
        if (projectId!=null){
            queryWrapper.eq("project_id", projectId);
        }
        queryWrapper.eq("contract_id", contractId);
        queryWrapper.eq("dr",0);
        queryWrapper.eq("tenant_id",InvocationInfoProxy.getTenantid());
        queryWrapper.in("bill_state",  Arrays.asList(
                BillStateEnum.COMMITED_STATE.getBillStateCode(),
                BillStateEnum.PASSED_STATE.getBillStateCode()));
        Map resultMap = super.getMap(queryWrapper);
        info.put("sumReceivedMny", null != resultMap && null != resultMap.get("sumReceivedMny") ? new BigDecimal(resultMap.get("sumReceivedMny").toString()) : BigDecimal.ZERO);
        return info;
    }

    @Override
    public String validateContract(Long contractId, Long id) {
        LambdaQueryWrapper<ReceiptRegisterEntity> queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(ReceiptRegisterEntity::getTenantId, InvocationInfoProxy.getTenantid());
        queryWrapper.eq(ReceiptRegisterEntity::getDr,0);
        queryWrapper.notIn(ReceiptRegisterEntity::getBillState, 1,3);
        if (id != null){
            queryWrapper.ne(ReceiptRegisterEntity::getId,id);
        }
        queryWrapper.eq(ReceiptRegisterEntity::getContractId,contractId);
        List<ReceiptRegisterEntity> list = this.list(queryWrapper);
        if (CollectionUtils.isNotEmpty(list)) {
            throw new BusinessException("当前合同下存在非审批通过态的收款登记，不允许新增!");
        }
        return "校验成功！";
    }

    @Override
    public BigDecimal getTotalColumnInfo(QueryParam param, boolean isEs) {
        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<ReceiptRegisterVO> list = baseMapper.queryPageList(null,wrapper);
        // 过滤为空的数据并求和
        BigDecimal sumReceivedMny = list.stream().filter(entity -> entity.getSumReceivedMny() != null)
                .map(ReceiptRegisterVO::getSumReceivedMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        return sumReceivedMny;
    }

    @Override
    public void autoPMReceipt() {
        CommonResponse<List<PMSKSJVO>> pmVos = ipmsksjApi.queryList();
        List<PMSKSJVO> pmList = new ArrayList<>();
        if (pmVos.isSuccess()) {
            pmList = pmVos.getData();
        }else {
            logger.error(pmVos.getMsg());
        }
        List<ReceiptRegisterEntity> updateList = new ArrayList<>();
        List<ReceiptRegisterEntity> registerList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(pmList)){
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
            CommonResponse<List<ContractPoolVO>> contractList = contractApi.queryList(queryParam);
            Map<Long, ContractPoolVO> contractMap = new HashMap<>();
            if (contractList.isSuccess()) {
                contractMap = contractList.getData().stream().collect(Collectors.toMap(ContractPoolVO::getContractId, Function.identity(), (key1, key2) -> key2));
            }else {
                logger.error(contractList.getMsg());
            }
            CommonResponse<JSONArray> resp = projectPoolApi.queryProjectPoolList(null, null, null);
            List<ProjectPoolSetVO> result = new ArrayList<>();
            Map<Long, ProjectPoolSetVO> projectMap = new HashMap<>();
            if(resp.isSuccess()){
                result = JSONArray.parseArray(JSONObject.toJSONString(resp.getData()), ProjectPoolSetVO.class);
                projectMap = result.stream().collect(Collectors.toMap(BaseVO::getId, Function.identity(), (key1, key2) -> key2));
            } else {
                logger.error(resp.getMsg());
            }
            for (PMSKSJVO vo : pmList) {
                ReceiptRegisterEntity entity = new ReceiptRegisterEntity();
                entity.setBillCode(StringUtils.isNotBlank(vo.getBillCode())?vo.getBillCode():null);
                if (StringUtils.isNotBlank(vo.getProjectId())){
                    entity.setProjectId(Long.valueOf(vo.getProjectId().trim()));
                    if (projectMap.containsKey(entity.getProjectId())){
                        ProjectPoolSetVO poolSetVO = projectMap.get(entity.getProjectId());
                        entity.setProjectCode(poolSetVO.getCode());
                        entity.setProjectName(poolSetVO.getName());
                    }else {
                        continue;
                    }
                }else {
                    continue;
                }
                if (StringUtils.isBlank(vo.getContractId()) || vo.getContractId().equals("999")){
                    ProjectPoolSetVO poolSetVO = projectMap.get(entity.getProjectId());
                    entity.setContractId(999L);
                    entity.setContractCode("999");
                    entity.setContractName("999");
                    entity.setOrgId(poolSetVO.getProjectDepartmentId());
                    entity.setOrgName(poolSetVO.getProjectDepartmentName());
                    entity.setParentOrgId(poolSetVO.getOrgId());
                    entity.setParentOrgName(poolSetVO.getOrgName());
                    entity.setCustomerId(poolSetVO.getConstructId());
                    entity.setCustomerName(poolSetVO.getConstructName());
                    //entity.setTotalReceiptMny(queryReceiptMny(999L,entity.getProjectId()).get("sumReceivedMny"));
                }else {
                    entity.setContractId(Long.valueOf(vo.getContractId().trim()));
                    if (contractMap.containsKey(entity.getContractId())){
                        ContractPoolVO cvo = contractMap.get(Long.valueOf(vo.getContractId().trim()));
                        entity.setContractCode(cvo.getContractCode());
                        entity.setContractTaxMny(cvo.getContractTaxMny());
                        entity.setContractMny(cvo.getContractMny());
                        entity.setContractCategoryId(cvo.getCategoryId());
                        entity.setContractCategoryName(cvo.getCategoryName());
                        entity.setSourceCategoryType(cvo.getSourceType());
                        entity.setSourceCategoryTypeName(cvo.getSourceTypeName());
                        entity.setOrgId(cvo.getOrgId());
                        entity.setOrgCode(cvo.getOrgCode());
                        entity.setOrgName(cvo.getOrgName());
                        entity.setParentOrgId(cvo.getParentOrgId());
                        entity.setParentOrgCode(cvo.getParentOrgCode());
                        entity.setParentOrgName(cvo.getParentOrgName());
                        entity.setCustomerId(cvo.getPartyaId());
                        entity.setCustomerName(cvo.getPartyaName());
                       // entity.setTotalReceiptMny(queryReceiptMny(entity.getContractId(),null).get("sumReceivedMny"));
                        entity.setTotalReceiptMny(cvo.getTotalActualPayRecTaxMny());
                    }else {
                        continue;
                    }
                }
                entity.setClausePropertyId(1522567880378720258L);
                entity.setClausePropertyName("进度款");
                if (StringUtils.isNotBlank(vo.getReceiptDate())) {
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
                    try {
                        entity.setReceiptDate(dateFormat.parse(vo.getReceiptDate()));
                    } catch (ParseException e) {
                        e.printStackTrace();
                    }
                }else {
                    entity.setReceiptDate(new Date());
                }
                entity.setSumReceivedMny(vo.getSumReceivedMny()!=null?vo.getSumReceivedMny():BigDecimal.ZERO);
                entity.setReceiptReason(vo.getMemo());
                entity.setSourceFlag(1);
                entity.setBillState(3);
                entity.setReceiptContractFlag(0);
                if (entity.getContractId()!=999L){
                    updateList.add(entity);
                }
                registerList.add(entity);
            }
        }
        if (CollectionUtils.isNotEmpty(registerList)){
            ReceiptRegisterVO vo = null;
            for (ReceiptRegisterEntity entity : registerList) {
                if(StringUtils.isBlank(entity.getBillCode())){
                    vo = BeanMapper.map(entity, ReceiptRegisterVO.class);
                    BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),vo);
                    CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                    if(billCode.isSuccess()) {
                        entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                    }else{
                        throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                    }
                }
            }
            super.saveOrUpdateBatch(registerList,registerList.size(),false);

            /**
             * 应收核销开始
             */


            /**
             * 应收核销结束
             */
            List<Long> projectIds = registerList.stream().map(ReceiptRegisterEntity::getProjectId).collect(Collectors.toList());
            List<Long> contractIds = registerList.stream().map(ReceiptRegisterEntity::getContractId).collect(Collectors.toList());
            PMSKSJVO pmvo = new PMSKSJVO();
            pmvo.setProjectIds(projectIds);
            pmvo.setContractIds(contractIds);
            pmvo.setCwFlag("1");
            SimpleDateFormat dateFormat1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            pmvo.setUpdateTime(dateFormat1.format(new Date()));
            ipmsksjApi.updateFlag(pmvo);
            //回写金额
            if (CollectionUtils.isNotEmpty(updateList)){
                for (ReceiptRegisterEntity entity : updateList) {
                    if (entity.getSumReceivedMny()!=null && !entity.getSumReceivedMny().equals(BigDecimal.ZERO)){
                        contractApi.updateActualPayRecMny(entity.getContractId(),entity.getSumReceivedMny(),entity.getSumReceivedMny(),true);
                    }
                }
            }
        }
    }

    @Override
    public List<ReceiptRegisterVO> querySumReceivedMny(QueryParam param) {
        param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
        QueryWrapper wrapper = changeToQueryWrapper(param);
        return baseMapper.querySumReceivedMny(wrapper);
    }
}
