/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.profinance.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.profinance.bean.PaymentRegisterEntity;
import com.ejianc.business.profinance.bean.PayrollRegisterDetailEntity;
import com.ejianc.business.profinance.bean.PayrollRegisterEntity;
import com.ejianc.business.profinance.bean.SalaryPayApplyEntity;
import com.ejianc.business.profinance.enums.PaymentContractEnum;
import com.ejianc.business.profinance.enums.SalaryDetailWorkerPayStateEnum;
import com.ejianc.business.profinance.mapper.PayrollRegisterMapper;
import com.ejianc.business.profinance.service.IPaymentRegisterService;
import com.ejianc.business.profinance.service.IPayrollRegisterDetailService;
import com.ejianc.business.profinance.service.IPayrollRegisterService;
import com.ejianc.business.profinance.service.ISalaryPayApplyService;
import com.ejianc.business.profinance.vo.ImportPayrollRegisterDetailVO;
import com.ejianc.business.profinance.vo.PaymentRegisterVO;
import com.ejianc.business.profinance.vo.PayrollRegisterDetailVO;
import com.ejianc.business.profinance.vo.PayrollRegisterVO;
import com.ejianc.business.profinance.vo.SalaryPayApplyDetailVO;
import com.ejianc.business.profinance.vo.SalaryPayApplyVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="payrollRegisterService")
public class PayrollRegisterServiceImpl
extends BaseServiceImpl<PayrollRegisterMapper, PayrollRegisterEntity>
implements IPayrollRegisterService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IContractPoolApi contractApi;
    private static final String BILL_CODE = "PAYROLL_REGISTER";
    private static final String regex = "^\\d{16}|\\d{19}$";
    private static final String IdCardRegex = "^\\d{17}[0-9X]";
    private static final String REGISTER_BILL_CODE = "PAYMENT_REGISTER";
    @Autowired
    private PayrollRegisterMapper payrollRegisterMapper;
    @Autowired
    private IPayrollRegisterDetailService payrollRegisterDetailService;
    @Autowired
    private ISalaryPayApplyService salaryPayApplyService;
    @Autowired
    private IPaymentRegisterService paymentRegisterService;
    @Autowired
    private CacheManager cacheManager;
    @Value(value="${common.env.base-host}")
    private String BASE_HOST;
    private final String tenantRootAuth = "TENANT_ROOT_AUTH::";

    @Override
    public PayrollRegisterVO insertOrUpdate(PayrollRegisterVO payrollRegisterVO) {
        PayrollRegisterEntity entity = (PayrollRegisterEntity)((Object)BeanMapper.map((Object)payrollRegisterVO, PayrollRegisterEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)payrollRegisterVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                this.logger.error("\u4fdd\u5b58\u5de5\u4eba\u5de5\u8d44\u5355\u5931\u8d25\uff0c\u81ea\u52a8\u751f\u6210\u5de5\u8d44\u5355\u7f16\u7801\u5931\u8d25: {}", (Object)billCode.getMsg());
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
        }
        super.saveOrUpdate((Object)entity, false);
        PayrollRegisterVO vo = (PayrollRegisterVO)BeanMapper.map((Object)super.selectById((Serializable)entity.getId()), PayrollRegisterVO.class);
        return vo;
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        ArrayList<ImportPayrollRegisterDetailVO> successList = new ArrayList<ImportPayrollRegisterDetailVO>();
        ArrayList<ImportPayrollRegisterDetailVO> errorList = new ArrayList<ImportPayrollRegisterDetailVO>();
        if (result != null && result.size() > 0) {
            if (((List)result.get(0)).size() != 5) {
                throw new BusinessException("\u8bf7\u6309\u7167\u5bfc\u5165\u6a21\u677f\u5bfc\u5165\u6570\u636e");
            }
            if (result.size() >= 10000) {
                throw new BusinessException("\u6587\u4ef6\u6570\u636e\u4e0d\u80fd\u8d85\u8fc710000\u884c\uff0c\u8d85\u8fc7\u8bf7\u5206\u6279\u6b21\u591a\u6b21\u5bfc\u5165");
            }
            for (int i = 1; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                ImportPayrollRegisterDetailVO detailVO = new ImportPayrollRegisterDetailVO();
                detailVO.setGroupName((String)datas.get(0));
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(1))) && (((String)datas.get(1)).length() > 20 || ((String)datas.get(1)).length() == 1)) {
                    detailVO.setErrorMessage("\u59d3\u540d\u586b\u5199\u957f\u5ea6\u4e3a2~20\u5b57");
                }
                detailVO.setWorkerName((String)datas.get(1));
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(2))) && !((String)datas.get(2)).matches(IdCardRegex)) {
                    detailVO.setErrorMessage("\u586b\u5199\u8eab\u4efd\u8bc1\u53f7\u9519\u8bef");
                }
                detailVO.setWorkerIdCard((String)datas.get(2));
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(3)))) {
                    try {
                        detailVO.setActualMny(new BigDecimal((String)datas.get(3)));
                    }
                    catch (Exception e) {
                        detailVO.setErrorMessage("\u672c\u671f\u5b9e\u53d1\u91d1\u989d\u5fc5\u987b\u4e3a\u6570\u5b57");
                    }
                } else {
                    detailVO.setErrorMessage("\u672c\u671f\u5b9e\u53d1\u91d1\u989d\u4e3a\u5fc5\u586b\u9879");
                }
                if (((String)datas.get(4)).length() > 100) {
                    detailVO.setErrorMessage("\u586b\u5199\u5907\u6ce8\u957f\u5ea6\u4e3a0~100\u5b57");
                }
                detailVO.setMemo((String)datas.get(4));
                if (StringUtils.isBlank((CharSequence)detailVO.getErrorMessage())) {
                    successList.add(detailVO);
                    continue;
                }
                errorList.add(detailVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success((Object)json);
    }

    @Override
    public PayrollRegisterVO generatePayrollRegister(SalaryPayApplyVO salaryPayApplyVO, BigDecimal actualTotalPaidTaxMny) {
        PayrollRegisterVO payrollRegisterVO = new PayrollRegisterVO();
        if (null != salaryPayApplyVO) {
            payrollRegisterVO.setId(Long.valueOf(IdWorker.getId()));
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)payrollRegisterVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                this.logger.error("\u4fdd\u5b58\u5de5\u4eba\u5de5\u8d44\u5355\u5931\u8d25\uff0c\u81ea\u52a8\u751f\u6210\u5de5\u8d44\u5355\u7f16\u7801\u5931\u8d25: {}", (Object)billCode.getMsg());
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            payrollRegisterVO.setBillCode((String)billCode.getData());
            payrollRegisterVO.setOrgId(salaryPayApplyVO.getOrgId());
            payrollRegisterVO.setOrgCode(salaryPayApplyVO.getOrgCode());
            payrollRegisterVO.setOrgName(salaryPayApplyVO.getOrgName());
            payrollRegisterVO.setParentOrgId(salaryPayApplyVO.getParentOrgId());
            payrollRegisterVO.setParentOrgCode(salaryPayApplyVO.getParentOrgCode());
            payrollRegisterVO.setParentOrgName(salaryPayApplyVO.getParentOrgName());
            payrollRegisterVO.setContractId(salaryPayApplyVO.getContractId());
            payrollRegisterVO.setContractCode(salaryPayApplyVO.getContractCode());
            payrollRegisterVO.setContractName(salaryPayApplyVO.getContractName());
            payrollRegisterVO.setContractType(salaryPayApplyVO.getContractSourceType());
            payrollRegisterVO.setProjectId(salaryPayApplyVO.getProjectId());
            payrollRegisterVO.setProjectCode(salaryPayApplyVO.getProjectCode());
            payrollRegisterVO.setProjectName(salaryPayApplyVO.getProjectName());
            payrollRegisterVO.setSupplierId(salaryPayApplyVO.getPaySupplierId());
            payrollRegisterVO.setSupplierName(salaryPayApplyVO.getPaySupplierName());
            payrollRegisterVO.setProvideDate(new Date());
            payrollRegisterVO.setProvideType(Integer.valueOf(2));
            payrollRegisterVO.setEmployeeId(salaryPayApplyVO.getApplyId());
            payrollRegisterVO.setEmployeeName(salaryPayApplyVO.getApplyName());
            payrollRegisterVO.setDepartmentId(salaryPayApplyVO.getDepartmentId());
            payrollRegisterVO.setDepartmentName(salaryPayApplyVO.getDepartmentName());
            payrollRegisterVO.setMemo(salaryPayApplyVO.getMemo());
            payrollRegisterVO.setTotalActualMny(actualTotalPaidTaxMny);
            payrollRegisterVO.setAccountId(salaryPayApplyVO.getAccountId());
            payrollRegisterVO.setAccountName(salaryPayApplyVO.getAccountName());
            payrollRegisterVO.setAccountNum(salaryPayApplyVO.getAccountNum());
            payrollRegisterVO.setBankName(salaryPayApplyVO.getBankName());
            payrollRegisterVO.setSalaryPayApplyId(salaryPayApplyVO.getId());
            payrollRegisterVO.setContractLinkUrl(salaryPayApplyVO.getContractLinkUrl());
            payrollRegisterVO.setSourceType(Integer.valueOf(0));
            if (CollectionUtils.isNotEmpty((Collection)salaryPayApplyVO.getSalaryList())) {
                ArrayList<PayrollRegisterDetailVO> payrollRegisterDetailVOList = new ArrayList<PayrollRegisterDetailVO>();
                for (SalaryPayApplyDetailVO salaryPayApplyDetailVO : salaryPayApplyVO.getSalaryList()) {
                    PayrollRegisterDetailVO payrollRegisterDetailVO = new PayrollRegisterDetailVO();
                    payrollRegisterDetailVO.setPayrollRegisterId(payrollRegisterVO.getId());
                    payrollRegisterDetailVO.setGroupId(salaryPayApplyDetailVO.getGroupId());
                    payrollRegisterDetailVO.setGroupCode(salaryPayApplyDetailVO.getGroupCode());
                    payrollRegisterDetailVO.setGroupName(salaryPayApplyDetailVO.getGroupName());
                    payrollRegisterDetailVO.setWorkerId(salaryPayApplyDetailVO.getWorkerId());
                    payrollRegisterDetailVO.setWorkerCode(salaryPayApplyDetailVO.getWorkerCode());
                    payrollRegisterDetailVO.setWorkerName(salaryPayApplyDetailVO.getWorkerName());
                    payrollRegisterDetailVO.setWorkerIdCard(salaryPayApplyDetailVO.getWorkerIdCard());
                    payrollRegisterDetailVO.setActualMny(salaryPayApplyDetailVO.getWorkerActualPaidTaxMny());
                    payrollRegisterDetailVO.setMemo(salaryPayApplyDetailVO.getWorkerMemo());
                    payrollRegisterDetailVO.setSourceId(salaryPayApplyDetailVO.getId());
                    payrollRegisterDetailVO.setSourcePayApplyId(salaryPayApplyVO.getId());
                    payrollRegisterDetailVOList.add(payrollRegisterDetailVO);
                }
                payrollRegisterVO.setPayrollRegisterDetailList(payrollRegisterDetailVOList);
            }
            super.saveOrUpdate(BeanMapper.map((Object)payrollRegisterVO, PayrollRegisterEntity.class), false);
        }
        return payrollRegisterVO;
    }

    @Override
    public IPage<PayrollRegisterVO> queryPayrollRegisterList(Page<PayrollRegisterVO> page, Long salaryPayApplyId) {
        SalaryPayApplyEntity salaryPayApplyEntity = (SalaryPayApplyEntity)((Object)this.salaryPayApplyService.selectById(salaryPayApplyId));
        List<Long> ids = new ArrayList<Long>();
        if (null != salaryPayApplyEntity) {
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("bill_code_old", new Parameter("eq", (Object)salaryPayApplyEntity.getBillCode()));
            List salaryPayApplyEntityList = this.salaryPayApplyService.queryList(queryParam);
            salaryPayApplyEntityList.add(salaryPayApplyEntity);
            ids = salaryPayApplyEntityList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        }
        return this.payrollRegisterMapper.selectListByPayApplyId(page, ids);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void generateBatchPayrollRegister(List<SalaryPayApplyDetailVO> sucList) {
        if (CollectionUtils.isNotEmpty(sucList)) {
            this.logger.info("\u5de5\u8d44\u652f\u4ed8\u7533\u8bf7\u5f00\u59cb\u751f\u6210\u5de5\u8d44\u53d1\u653e\u767b\u8bb0\u5355\uff1asucList----{}", (Object)JSONObject.toJSONString(sucList));
            LinkedHashMap detailMap = new LinkedHashMap();
            for (SalaryPayApplyDetailVO detail : sucList) {
                if (detailMap.containsKey(detail.getPid())) {
                    ((List)detailMap.get(detail.getPid())).add(detail);
                    continue;
                }
                ArrayList<SalaryPayApplyDetailVO> salaryPayApplyDetailEntityList = new ArrayList<SalaryPayApplyDetailVO>();
                salaryPayApplyDetailEntityList.add(detail);
                detailMap.put(detail.getPid(), salaryPayApplyDetailEntityList);
            }
            List pidList = sucList.stream().map(SalaryPayApplyDetailVO::getPid).distinct().collect(Collectors.toList());
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("id", new Parameter("in", pidList));
            List salaryPayApplyEntityList = this.salaryPayApplyService.queryList(queryParam);
            if (CollectionUtils.isNotEmpty((Collection)salaryPayApplyEntityList)) {
                List salaryPayApplyVOList = BeanMapper.mapList((Iterable)salaryPayApplyEntityList, SalaryPayApplyVO.class);
                for (SalaryPayApplyVO salaryPayApplyVO : salaryPayApplyVOList) {
                    if (!detailMap.containsKey(salaryPayApplyVO.getId())) continue;
                    salaryPayApplyVO.setSalaryList((List)detailMap.get(salaryPayApplyVO.getId()));
                }
                Long tenantId = sucList.get(0).getTenantId();
                String authority = this.getAuthority(tenantId);
                try {
                    if (StringUtils.isBlank((CharSequence)authority)) {
                        this.logger.error("\u6839\u636e\u5de5\u8d44\u652f\u4ed8\u7533\u8bf7\u5355\u5b50\u8868- [{}], \u83b7\u53d6\u6a21\u62df\u767b\u5f55\u5931\u8d25\uff0c\u65e0\u6cd5\u751f\u6210\u4ed8\u6b3e\u767b\u8bb0\u5355\uff01", (Object)JSONObject.toJSONString((Object)sucList.get(0)));
                        return;
                    }
                    InvocationInfoProxy.setTenantid((Long)tenantId);
                    String key = "userCode";
                    int idx = authority.indexOf(";" + key + "=");
                    if (idx >= 0) {
                        String tmp = authority.substring(idx + 1);
                        InvocationInfoProxy.setUsercode((String)tmp.substring(0, tmp.indexOf(";")).replace(key + "=", ""));
                    }
                    InvocationInfoProxy.setExtendAttribute((Object)"authority", (Object)authority);
                    ArrayList<PayrollRegisterVO> payrollRegisterVOList = new ArrayList<PayrollRegisterVO>();
                    this.logger.info("\u751f\u6210\u5de5\u8d44\u53d1\u653e\u767b\u8bb0\u6570\u636e-{}", (Object)JSONObject.toJSONString((Object)salaryPayApplyVOList));
                    for (SalaryPayApplyVO salaryPayApplyVO : salaryPayApplyVOList) {
                        if (null == salaryPayApplyVO) continue;
                        PayrollRegisterVO payrollRegisterVO = new PayrollRegisterVO();
                        payrollRegisterVO.setId(Long.valueOf(IdWorker.getId()));
                        payrollRegisterVO.setOrgId(salaryPayApplyVO.getOrgId());
                        payrollRegisterVO.setTenantId(salaryPayApplyVO.getTenantId());
                        payrollRegisterVO.setOrgCode(salaryPayApplyVO.getOrgCode());
                        payrollRegisterVO.setOrgName(salaryPayApplyVO.getOrgName());
                        BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)payrollRegisterVO);
                        Map reqParams = (Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)billCodeParam), Map.class);
                        HashMap<String, String> headers = new HashMap<String, String>();
                        headers.put("authority", authority);
                        headers.put("Content-Type", "application/json;charset=UTF-8");
                        this.logger.info("\u652f\u4ed8\u7ed3\u679c\u6838\u9500\uff0c\u751f\u6210\u53d1\u653e\u767b\u8bb0\u7f16\u7801\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)billCodeParam));
                        String url = this.BASE_HOST + "ejc-support-web/api/billCodeApi/generateBillCode";
                        String codeRespStr = HttpTookit.postByJson((String)url, (String)JSONObject.toJSONString((Object)reqParams), headers, (Integer)10000, (Integer)10000);
                        this.logger.info("\u83b7\u53d6\u53d1\u653e\u767b\u8bb0\u7f16\u7801\u7ed3\u679c\uff1a{}", (Object)codeRespStr);
                        CommonResponse codeResp = (CommonResponse)JSONObject.parseObject((String)codeRespStr, CommonResponse.class);
                        if (!codeResp.isSuccess()) {
                            this.logger.error("\u751f\u6210\u53d1\u653e\u767b\u8bb0\u5931\u8d25\uff0c\u81ea\u52a8\u751f\u6210\u53d1\u653e\u767b\u8bb0\u5355\u7f16\u7801\u5931\u8d25: {}", (Object)codeRespStr);
                            return;
                        }
                        payrollRegisterVO.setBillCode(codeResp.getData().toString());
                        payrollRegisterVO.setBillState(BillStateEnum.PASSED_STATE.getBillStateCode());
                        payrollRegisterVO.setParentOrgId(salaryPayApplyVO.getParentOrgId());
                        payrollRegisterVO.setParentOrgCode(salaryPayApplyVO.getParentOrgCode());
                        payrollRegisterVO.setParentOrgName(salaryPayApplyVO.getParentOrgName());
                        payrollRegisterVO.setContractId(salaryPayApplyVO.getContractId());
                        payrollRegisterVO.setContractCode(salaryPayApplyVO.getContractCode());
                        payrollRegisterVO.setContractName(salaryPayApplyVO.getContractName());
                        payrollRegisterVO.setContractType("laborSub");
                        payrollRegisterVO.setProjectId(salaryPayApplyVO.getProjectId());
                        payrollRegisterVO.setProjectCode(salaryPayApplyVO.getProjectCode());
                        payrollRegisterVO.setProjectName(salaryPayApplyVO.getProjectName());
                        payrollRegisterVO.setSupplierId(salaryPayApplyVO.getPaySupplierId());
                        payrollRegisterVO.setSupplierName(salaryPayApplyVO.getPaySupplierName());
                        payrollRegisterVO.setProvideDate(new Date());
                        payrollRegisterVO.setProvideType(Integer.valueOf(2));
                        payrollRegisterVO.setEmployeeId(salaryPayApplyVO.getApplyId());
                        payrollRegisterVO.setEmployeeName(salaryPayApplyVO.getApplyName());
                        payrollRegisterVO.setDepartmentId(salaryPayApplyVO.getDepartmentId());
                        payrollRegisterVO.setDepartmentName(salaryPayApplyVO.getDepartmentName());
                        payrollRegisterVO.setMemo(salaryPayApplyVO.getMemo());
                        payrollRegisterVO.setAccountId(salaryPayApplyVO.getAccountId());
                        payrollRegisterVO.setAccountName(salaryPayApplyVO.getAccountName());
                        payrollRegisterVO.setAccountNum(salaryPayApplyVO.getAccountNum());
                        payrollRegisterVO.setBankName(salaryPayApplyVO.getBankName());
                        payrollRegisterVO.setSalaryPayApplyId(salaryPayApplyVO.getId());
                        payrollRegisterVO.setSalaryPayApplyCode(salaryPayApplyVO.getBillCode());
                        payrollRegisterVO.setContractLinkUrl(salaryPayApplyVO.getContractLinkUrl());
                        payrollRegisterVO.setSourceType(Integer.valueOf(2));
                        BigDecimal actualTotalPaidTaxMny = BigDecimal.ZERO;
                        if (CollectionUtils.isNotEmpty((Collection)salaryPayApplyVO.getSalaryList())) {
                            ArrayList<PayrollRegisterDetailVO> payrollRegisterDetailVOList = new ArrayList<PayrollRegisterDetailVO>();
                            for (SalaryPayApplyDetailVO salaryPayApplyDetailVO : salaryPayApplyVO.getSalaryList()) {
                                PayrollRegisterDetailVO payrollRegisterDetailVO = new PayrollRegisterDetailVO();
                                payrollRegisterDetailVO.setPayrollRegisterId(payrollRegisterVO.getId());
                                payrollRegisterDetailVO.setGroupId(salaryPayApplyDetailVO.getGroupId());
                                payrollRegisterDetailVO.setGroupCode(salaryPayApplyDetailVO.getGroupCode());
                                payrollRegisterDetailVO.setGroupName(salaryPayApplyDetailVO.getGroupName());
                                payrollRegisterDetailVO.setWorkerId(salaryPayApplyDetailVO.getWorkerId());
                                if (SalaryDetailWorkerPayStateEnum.\u652f\u4ed8\u5931\u8d25.getCode().equals(salaryPayApplyDetailVO.getWorkerPayState().toString())) {
                                    salaryPayApplyDetailVO.setWorkerActualPaidTaxMny(salaryPayApplyDetailVO.getWorkerApplyTaxMny().negate());
                                }
                                payrollRegisterDetailVO.setWorkerCode(salaryPayApplyDetailVO.getWorkerCode());
                                payrollRegisterDetailVO.setWorkerName(salaryPayApplyDetailVO.getWorkerName());
                                payrollRegisterDetailVO.setWorkerIdCard(salaryPayApplyDetailVO.getWorkerIdCard());
                                payrollRegisterDetailVO.setActualMny(salaryPayApplyDetailVO.getWorkerActualPaidTaxMny());
                                payrollRegisterDetailVO.setMemo(salaryPayApplyDetailVO.getWorkerMemo());
                                payrollRegisterDetailVO.setSourceId(salaryPayApplyDetailVO.getId());
                                payrollRegisterDetailVO.setSourcePayApplyId(salaryPayApplyVO.getId());
                                payrollRegisterDetailVOList.add(payrollRegisterDetailVO);
                                actualTotalPaidTaxMny = actualTotalPaidTaxMny.add(salaryPayApplyDetailVO.getWorkerActualPaidTaxMny());
                            }
                            payrollRegisterVO.setPayrollRegisterDetailList(payrollRegisterDetailVOList);
                        }
                        payrollRegisterVO.setTotalActualMny(actualTotalPaidTaxMny);
                        payrollRegisterVO.setPayType(salaryPayApplyVO.getPayType());
                        payrollRegisterVOList.add(payrollRegisterVO);
                    }
                    ArrayList payrollRegisterDetailVOList = new ArrayList();
                    for (PayrollRegisterVO payrollRegisterVO : payrollRegisterVOList) {
                        if (!CollectionUtils.isNotEmpty((Collection)payrollRegisterVO.getPayrollRegisterDetailList())) continue;
                        payrollRegisterDetailVOList.addAll(payrollRegisterVO.getPayrollRegisterDetailList());
                    }
                    super.saveOrUpdateBatch(BeanMapper.mapList(payrollRegisterVOList, PayrollRegisterEntity.class), payrollRegisterVOList.size(), false);
                    this.payrollRegisterDetailService.saveOrUpdateBatch(BeanMapper.mapList(payrollRegisterDetailVOList, PayrollRegisterDetailEntity.class), payrollRegisterDetailVOList.size(), false);
                    this.logger.info("\u751f\u6210\u5de5\u8d44\u53d1\u653e\u767b\u8bb0\u6210\u529f\uff0c\u7ee7\u800c\u751f\u6210\u4ed8\u6b3e\u767b\u8bb0");
                    this.generatePaymentRegister(payrollRegisterVOList);
                }
                catch (Exception e) {
                    this.logger.error("\u6839\u636e\u4ed8\u6b3e\u7533\u8bf7\u5355- [{}], \u751f\u6210\u4ed8\u6b3e\u767b\u8bb0\u5355\u5f02\u5e38\uff01", (Object)JSONObject.toJSONString((Object)sucList.get(0)), (Object)e);
                }
            }
        }
    }

    @Override
    public void generatePaymentRegister(List<PayrollRegisterVO> payrollRegisterVOList) {
        try {
            if (CollectionUtils.isEmpty(payrollRegisterVOList)) {
                QueryParam queryParam1 = new QueryParam();
                ArrayList<Long> contactIdList1 = new ArrayList<Long>();
                contactIdList1.add(1542056874833813506L);
                contactIdList1.add(561292423826391102L);
                queryParam1.getParams().put("contractId", new Parameter("in", contactIdList1));
                payrollRegisterVOList = BeanMapper.mapList((Iterable)super.queryList(queryParam1), PayrollRegisterVO.class);
                this.logger.info(JSONObject.toJSONString((Object)payrollRegisterVOList));
            }
            this.logger.info("\u8fdb\u5165\u5de5\u8d44\u53d1\u653e\u767b\u8bb0\u751f\u6210\u4ed8\u6b3e\u767b\u8bb0generatePaymentRegister\u65b9\u6cd5-------------->begin");
            this.logger.info("\u63a5\u6536\u53c2\u6570-\u5de5\u8d44\u53d1\u653e\u767b\u8bb0\u6570\u636e\u96c6\u5408payrollRegisterVOList\uff1a{}", (Object)JSONObject.toJSONString(payrollRegisterVOList));
            ArrayList<Object> paymentRegisterList = new ArrayList<Object>();
            List contactIdList = payrollRegisterVOList.stream().map(PayrollRegisterVO::getContractId).collect(Collectors.toList());
            this.logger.info("\u5bf9\u5e94\u5408\u540cid\u96c6\u5408\uff1a{}", contactIdList);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenantId", new Parameter("eq", (Object)((PayrollRegisterVO)payrollRegisterVOList.get(0)).getTenantId()));
            queryParam.getParams().put("contractId", new Parameter("in", contactIdList));
            this.logger.info("\u652f\u4ed8\u7ed3\u679c\u6838\u9500\uff0c\u83b7\u53d6\u5408\u540c\u4fe1\u606f\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)queryParam));
            String authority = this.getAuthority(((PayrollRegisterVO)payrollRegisterVOList.get(0)).getTenantId());
            this.logger.info("authority:{}", (Object)authority);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("authority", authority);
            headers.put("Content-Type", "application/json;charset=UTF-8");
            String url = this.BASE_HOST + "ejc-contractbase-web/api/contractpool/queryList";
            String contractData = HttpTookit.postByJson((String)url, (String)JSONObject.toJSONString((Object)queryParam), headers, (Integer)10000, (Integer)10000);
            this.logger.info("\u83b7\u53d6\u5408\u540c\u4fe1\u606f\u7ed3\u679c\uff1a{}", (Object)contractData);
            CommonResponse contractListData = (CommonResponse)JSONObject.parseObject((String)contractData, CommonResponse.class);
            if (!contractListData.isSuccess()) {
                this.logger.error("\u751f\u6210\u4ed8\u6b3e\u767b\u8bb0\u5931\u8d25\uff0c\u83b7\u53d6\u5408\u540c\u6c60\u4fe1\u606f\u5931\u8d25: {}", (Object)contractListData);
                return;
            }
            Map<Object, Object> contractMap = new HashMap();
            if (contractListData.isSuccess()) {
                List contractList = JSONArray.parseArray((String)JSONObject.toJSONString((Object)contractListData.getData())).toJavaList(ContractPoolVO.class);
                contractMap = contractList.stream().collect(Collectors.toMap(BaseVO::getId, Function.identity(), (key1, key2) -> key2));
            } else {
                this.logger.info("\u5408\u540c\u6c60\u672a\u67e5\u8be2\u5230\u5408\u540c\u6570\u636e\uff01");
                this.logger.error(contractListData.getMsg());
            }
            this.logger.info("\u5de5\u8d44\u53d1\u653e\u767b\u8bb0\u7684\u5408\u540cid\u96c6\u5408\uff1a{}", (Object)JSONObject.toJSONString(contactIdList));
            if (null != contractMap) {
                this.logger.info("\u6839\u636e\u5408\u540cid\u67e5\u5230\u7684\u5408\u540c\u96c6\u5408contractMap\uff1a{}", (Object)JSONObject.toJSONString(contractMap));
            }
            for (PayrollRegisterVO sourceVO : payrollRegisterVOList) {
                if (sourceVO.getPayType() != null && sourceVO.getPayType() != 1) continue;
                PaymentRegisterVO register = (PaymentRegisterVO)BeanMapper.map((Object)sourceVO, PaymentRegisterVO.class);
                register.setSourceType("\u5de5\u4eba\u5de5\u8d44");
                register.setSourceId(sourceVO.getId());
                register.setSourceCode(sourceVO.getBillCode());
                register.setSourceCategoryType(((ContractPoolVO)contractMap.get(sourceVO.getContractId())).getSourceType());
                register.setSourceCategoryTypeName(((ContractPoolVO)contractMap.get(sourceVO.getContractId())).getSourceTypeName());
                register.setContractCategoryId(((ContractPoolVO)contractMap.get(sourceVO.getContractId())).getCategoryId());
                register.setContractCategoryName(((ContractPoolVO)contractMap.get(sourceVO.getContractId())).getCategoryName());
                register.setContractTaxMny(((ContractPoolVO)contractMap.get(sourceVO.getContractId())).getContractTaxMny());
                register.setContractMny(((ContractPoolVO)contractMap.get(sourceVO.getContractId())).getContractMny());
                register.setAlreadyPayMny(BigDecimal.ZERO);
                register.setPayMny(sourceVO.getTotalActualMny());
                register.setPaymentDate(sourceVO.getProvideDate());
                register.setPaymentReason(sourceVO.getMemo());
                register.setPaymentContractFlag(PaymentContractEnum.\u6709\u5408\u540c.getCode());
                register.setId(Long.valueOf(IdWorker.getId()));
                BillCodeParam billCodeParam = BillCodeParam.build((String)REGISTER_BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)register);
                Map reqCodeParams = (Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)billCodeParam), Map.class);
                HashMap<String, String> codeHeaders = new HashMap<String, String>();
                codeHeaders.put("authority", authority);
                codeHeaders.put("Content-Type", "application/json;charset=UTF-8");
                this.logger.info("\u652f\u4ed8\u7ed3\u679c\u6838\u9500\uff0c\u751f\u6210\u4ed8\u6b3e\u767b\u8bb0\u7f16\u7801\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)billCodeParam));
                String codeUrl = this.BASE_HOST + "ejc-support-web/api/billCodeApi/generateBillCode";
                String codeRespStr = HttpTookit.postByJson((String)codeUrl, (String)JSONObject.toJSONString((Object)reqCodeParams), codeHeaders, (Integer)10000, (Integer)10000);
                this.logger.info("\u83b7\u53d6\u4ed8\u6b3e\u767b\u8bb0\u7f16\u7801\u7ed3\u679c\uff1a{}", (Object)codeRespStr);
                CommonResponse codeResp = (CommonResponse)JSONObject.parseObject((String)codeRespStr, CommonResponse.class);
                if (!codeResp.isSuccess()) {
                    this.logger.error("\u751f\u6210\u4ed8\u6b3e\u767b\u8bb0\u5931\u8d25\uff0c\u81ea\u52a8\u751f\u6210\u4ed8\u6b3e\u767b\u8bb0\u5355\u7f16\u7801\u5931\u8d25: {}", (Object)codeRespStr);
                    return;
                }
                register.setBillCode(codeResp.getData().toString());
                this.logger.info("\u4ed8\u6b3e\u767b\u8bb0\u4fe1\u606f-{}\uff0c\u5de5\u8d44\u53d1\u653e\u767b\u8bb0\u5355\u4fe1\u606f{}", (Object)JSONObject.toJSONString((Object)register), (Object)JSONObject.toJSONString((Object)sourceVO));
                paymentRegisterList.add(BeanMapper.map((Object)register, PaymentRegisterEntity.class));
            }
            if (CollectionUtils.isNotEmpty(paymentRegisterList)) {
                this.paymentRegisterService.saveOrUpdateBatch(paymentRegisterList, paymentRegisterList.size(), false);
            }
            this.logger.info("\u5de5\u8d44\u53d1\u653e\u767b\u8bb0\u751f\u6210\u4ed8\u6b3e\u767b\u8bb0generatePaymentRegister\u65b9\u6cd5-------------->end");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getAuthority(Long tenantId) {
        String authority = (String)((Object)this.cacheManager.get("TENANT_ROOT_AUTH::" + tenantId.toString()));
        if (StringUtils.isBlank((CharSequence)authority)) {
            try {
                HashMap<String, Long> params = new HashMap<String, Long>();
                params.put("tenantId", tenantId);
                this.logger.info("baseHost " + this.BASE_HOST);
                HashMap<String, String> headers = new HashMap<String, String>();
                headers.put("Content-Type", "application/json;charset=UTF-8");
                String back = HttpTookit.get((String)(this.BASE_HOST + "ejc-idm-web/user/context/getBytenantid"), params, headers);
                JSONObject jsonBack = JSONObject.parseObject((String)back);
                if (jsonBack.get((Object)"data") != null) {
                    JSONObject data = (JSONObject)jsonBack.get((Object)"data");
                    this.logger.info("data  " + data.toJSONString());
                    if (data.get((Object)"userContext") != null) {
                        JSONObject userContext = (JSONObject)data.get((Object)"userContext");
                        authority = "userType=" + userContext.getString("userType") + ";userCode=" + userContext.getString("userCode") + ";orgId=" + userContext.getString("orgId") + ";tenantid=" + userContext.getString("tenantid") + ";token=" + userContext.getString("token") + ";u_logints=" + userContext.getString("u_logints") + ";u_usercode=" + userContext.getString("u_usercode") + ";userId=" + userContext.getString("userId");
                        this.cacheManager.setex("TENANT_ROOT_AUTH::" + tenantId.toString(), (Serializable)((Object)authority), 1500);
                    }
                }
            }
            catch (Exception e) {
                this.logger.error("\u6a21\u62df\u767b\u5f55\u5f02\u5e38: ", (Throwable)e);
                return null;
            }
        }
        return authority;
    }
}

