package com.ejianc.business.profinance.paysupplement.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.profinance.bean.ContractLawsuitEntity;
import com.ejianc.business.profinance.bean.PMPayEntity;
import com.ejianc.business.profinance.paysupplement.bean.PaymentSupplementEntity;
import com.ejianc.business.profinance.paysupplement.service.IPaymentSupplementService;
import com.ejianc.business.profinance.service.IPMPayService;
import com.ejianc.business.profinance.vo.PMPayVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;

@Service("paymentSupplement") 
public class PaymentSupplementBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private IPaymentSupplementService paymentSupplementService;
	@Autowired
	private IPMPayService pMPayService;
	@Autowired
	private IProjectPoolApi projectPoolApi;

	private final Logger logger = LoggerFactory.getLogger(this.getClass());

	private PMPayEntity getWriteInfo(PaymentSupplementEntity entity, boolean isRedRush) {
		//单据审批生效，按照单据付款金额去财务中间表进行核销
		PMPayEntity pmPayEntity = new PMPayEntity();
		//项目Id
		pmPayEntity.setProjectId(entity.getProjectId());
		//核销单据来源
		if(isRedRush) {
			pmPayEntity.setSourceType(PMPayVO.SOURCE_TYPE_PAYMENT_SUPPLEMENT_RETRN);
		} else {
			pmPayEntity.setSourceType(PMPayVO.SOURCE_TYPE_PAYMENT_SUPPLEMENT);
		}
		//推送日期
		pmPayEntity.setPushTime(new Date());
		//实际支付时间
		pmPayEntity.setActualPayTime(entity.getPaymentDate());
		//供应商
		pmPayEntity.setSupplyId(entity.getSupplierId());
		//收款方
		pmPayEntity.setPayeeId(entity.getPayeeId());
		//合同Id
		if(entity.getPaymentContractFlag().equals(0)) {
			//有合同付款
			pmPayEntity.setContractId(entity.getContractId());
		} else {
			//无合同付款
			pmPayEntity.setContractId(-1L);
		}
		//本次支付金额
		if(isRedRush) {
			pmPayEntity.setPayMnyActual(entity.getPayMny().negate());
            //来源单据Id
            pmPayEntity.setSourceId("paymentSupplement-bpmback-"+entity.getId().toString()+"-ts-"+ (new Date()).getTime());
		} else {
			pmPayEntity.setPayMnyActual(entity.getPayMny());
            //来源单据Id
            pmPayEntity.setSourceId("paymentSupplement-approved-"+entity.getId().toString()+"-ts-"+ (new Date()).getTime());
		}
		pmPayEntity.setSourceTypeCode(PMPayVO.SOURCE_TYPE_CODE_PAYMENT_SUPPLEMENT);
        pmPayEntity.setId(IdWorker.getId());

		return pmPayEntity;
	}


	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return bpmBackCheck(billId, state, billTypeCode);
	};

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	@Transactional(rollbackFor = Exception.class)
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		PaymentSupplementEntity entity = paymentSupplementService.selectById(billId);
		PMPayEntity pmPayEntity = getWriteInfo(entity, false);
		logger.info("付款补录单-【{}】审批通过生成对应付款核销单-【{}】进行付款核销。", JSONObject.toJSONString(entity), JSONObject.toJSONString(pmPayEntity));
		// 保存
		pMPayService.saveOrUpdate(pmPayEntity, false);
		pMPayService.sendMessage(BeanMapper.map(pmPayEntity, PMPayVO.class));
		return CommonResponse.success("审批回调成功！");
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		return bpmBackCheck(billId, state, billTypeCode);
	}

	@Transactional(rollbackFor = Exception.class)
	public CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
		PaymentSupplementEntity entity = paymentSupplementService.selectById(billId);

		//根据项目Id，合同Id、供应商Id、收款方Id查询是否存在自由态付款补录单，若存在，则不允许弃审
		QueryWrapper<PaymentSupplementEntity> query = new QueryWrapper<>();
		query.eq("project_id", entity.getProjectId());
		query.eq("contract_id", entity.getContractId());
		query.eq("supplier_id", entity.getSupplierId());
		query.eq("payee_id", entity.getPayeeId());
		//未生效的单据
		query.in("bill_state", Arrays.asList(BillStateEnum.UNCOMMITED_STATE.getBillStateCode(),
				BillStateEnum.UNAPPROVED.getBillStateCode(),
				BillStateEnum.SUSPEND.getBillStateCode()));

		List<PaymentSupplementEntity> list = paymentSupplementService.list(query);
		if(CollectionUtils.isNotEmpty(list)) {
			logger.error("单据-[{}]存在同一维度未生效单据，不允许弃审！");
			return CommonResponse.error("单据存在同一维度未生效单据，不允许弃审！");
		}

		//出现未审批通过直接驳回时，执行了此代码；现增加单据状态的判断，审批通过撤回的才执行操作
		if(entity.getBillState() == 3 || entity.getBillState() == 1) {
			PMPayEntity pmPayEntity = getWriteInfo(entity, true);
			logger.info("付款补录单-【{}】审批通过生成对应付款核销单-【{}】进行付款核销红冲。", JSONObject.toJSONString(entity), JSONObject.toJSONString(pmPayEntity));
			// 保存
			pMPayService.saveOrUpdate(pmPayEntity, false);
			pMPayService.sendMessage(BeanMapper.map(pmPayEntity, PMPayVO.class));
		}
		return CommonResponse.success("审批回调成功！");
	}
	/**
	 * 审批--获取当前节点的审批人---从服务中选择
	 *
	 * @param billId 单据id
	 * @param billTypeCode 单据类型编码
	 * @param sign 节点标志
	 * @return
	 */
	@Override
	public CommonResponse<JSONArray> queryApproveUser(Long billId, String billTypeCode, String sign, Map<String, Object> other){
		JSONArray arr = new JSONArray();
		logger.info("sign:{}",sign);

		//根据标识判断是否（成本相关人员审批的）节点
		if ("choseCostUser".equals(sign)){
			//获取表单详情数据

			//根据项目id获取项目基本信息中的成本对接人信息
			PaymentSupplementEntity entity = paymentSupplementService.selectById(billId);
			Long projectId = entity.getProjectId();

			JSONObject jsonObject = new JSONObject();
			CommonResponse<JSONArray> commonResponse = projectPoolApi.queryProjectPoolById(projectId);


			if(!commonResponse.isSuccess()){
				throw new BusinessException("查询项目失败!");
			}
			JSONArray array = commonResponse.getData();
			List<ProjectPoolSetVO> vos = JSONObject.parseArray(array.toJSONString(), ProjectPoolSetVO.class);

			logger.info("vos:{}",JSONObject.toJSONString(vos));

			ProjectPoolSetVO vo = vos.get(0);
			Long costAdapter = vo.getCostAdapter();
			String costAdapterName = vo.getCostAdapterName();

			logger.info("userId:{}",costAdapter);
			logger.info("userName:{}",costAdapterName);


			jsonObject.put("userId",costAdapter);
			jsonObject.put("userName",costAdapterName);

			arr.add(jsonObject);

		}
		return CommonResponse.success(arr);
	}

}
