/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.profinance.odd.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.profinance.odd.bean.OddFeeEntity;
import com.ejianc.business.profinance.odd.mapper.OddFeeMapper;
import com.ejianc.business.profinance.odd.service.IOddFeeService;
import com.ejianc.business.profinance.odd.vo.ImportOddFeeVO;
import com.ejianc.business.profinance.odd.vo.OddFeeVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="oddFeeService")
public class OddFeeServiceImpl
extends BaseServiceImpl<OddFeeMapper, OddFeeEntity>
implements IOddFeeService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_CODE = "ODD_FEE_CODE";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private IProjectPoolApi projectPoolApi;
    @Autowired
    private OddFeeMapper oddFeeMapper;
    @Autowired
    private IProSupplierApi iProSupplierApi;
    @Autowired
    private IEmployeeApi iEmployeeApi;

    @Override
    public Map<String, BigDecimal> countOddFeeAmount(QueryParam queryParam) {
        HashMap<String, BigDecimal> rtnMap = new HashMap<String, BigDecimal>();
        BigDecimal feeTaxMnyAmount = BigDecimal.ZERO;
        BigDecimal payTaxMnyAmount = BigDecimal.ZERO;
        List list = super.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (OddFeeEntity entity : list) {
                feeTaxMnyAmount = feeTaxMnyAmount.add(this.setDefaultValue(entity.getFeeTaxMny()));
                payTaxMnyAmount = payTaxMnyAmount.add(this.setDefaultValue(entity.getPayTaxMny()));
            }
        }
        rtnMap.put("feeTaxMnyAmount", feeTaxMnyAmount);
        rtnMap.put("payTaxMnyAmount", payTaxMnyAmount);
        return rtnMap;
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        ArrayList<Integer> typeList = new ArrayList<Integer>();
        for (int i = 1; i < 6; ++i) {
            typeList.add(i);
        }
        Date startDate = new Date();
        this.logger.info("\u96f6\u661f\u8d39\u7528\u5355\u5bfc\u5165\u6821\u9a8c\u5f00\u59cb\uff1a\u5f00\u59cb\u65f6\u95f4----------->{}", (Object)startDate);
        CommonResponse defFeeList = this.defdocApi.getDefDocByDefCode("no_contract_fee_type");
        this.logger.info("\u81ea\u5b9a\u4e49\u6863\u6848\u67e5\u8be2\u4f7f\u7528\u65f6\u95f4----------->{}", (Object)new Date());
        if (!defFeeList.isSuccess()) {
            return CommonResponse.error((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u67e5\u8be2\u81ea\u5b9a\u4e49\u6863\u6848\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01");
        }
        ArrayList unitCodeOrTaxPayerIdentifierList = new ArrayList();
        ArrayList iDCardOrOAAccountList = new ArrayList();
        HashMap projectPoolSetVOMap = new HashMap();
        List<Object> billCodeList = new ArrayList();
        List<OddFeeEntity> oddFeeEntityList = this.oddFeeMapper.queryAllData();
        if (CollectionUtils.isNotEmpty(oddFeeEntityList)) {
            billCodeList = oddFeeEntityList.stream().map(OddFeeEntity::getBillCode).collect(Collectors.toList());
        }
        Map defFeeMap = ((List)defFeeList.getData()).stream().collect(Collectors.toMap(DefdocDetailVO::getName, Function.identity(), (key1, key2) -> key2));
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel((MultipartFile)mf);
        ArrayList<ImportOddFeeVO> successList = new ArrayList<ImportOddFeeVO>();
        ArrayList<ImportOddFeeVO> errorList = new ArrayList<ImportOddFeeVO>();
        ArrayList<ImportOddFeeVO> reDataList = new ArrayList<ImportOddFeeVO>();
        if (result != null && result.size() > 0) {
            if (((List)result.get(0)).size() != 18) {
                throw new BusinessException("\u8bf7\u6309\u7167\u5bfc\u5165\u6a21\u677f\u5bfc\u5165\u6570\u636e");
            }
            if (result.size() >= 10000) {
                throw new BusinessException("\u6587\u4ef6\u6570\u636e\u4e0d\u80fd\u8d85\u8fc710000\u884c\uff0c\u8d85\u8fc7\u8bf7\u5206\u6279\u6b21\u591a\u6b21\u5bfc\u5165");
            }
            for (int i = 1; i < result.size(); ++i) {
                StringBuilder errorMessage = new StringBuilder();
                List datas = (List)result.get(i);
                ImportOddFeeVO importOddFeeVO = new ImportOddFeeVO();
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(0)))) {
                    importOddFeeVO.setProjectCode((String)datas.get(0));
                    if (((String)datas.get(0)).length() > 64) {
                        errorMessage.append("[\u586b\u5199\u9879\u76ee\u7f16\u7801\u957f\u5ea6\u4e3a1~64\u5b57]");
                    } else if (projectPoolSetVOMap.get(datas.get(0)) != null) {
                        importOddFeeVO.setProjectId(((ProjectPoolSetVO)projectPoolSetVOMap.get(datas.get(0))).getId());
                        importOddFeeVO.setProjectName(((ProjectPoolSetVO)projectPoolSetVOMap.get(datas.get(0))).getName());
                        importOddFeeVO.setOrgId(((ProjectPoolSetVO)projectPoolSetVOMap.get(datas.get(0))).getProjectDepartmentId());
                        importOddFeeVO.setOrgName(((ProjectPoolSetVO)projectPoolSetVOMap.get(datas.get(0))).getProjectDepartmentName());
                        importOddFeeVO.setOrgCode(((ProjectPoolSetVO)projectPoolSetVOMap.get(datas.get(0))).getProjectDepartmentCode());
                        importOddFeeVO.setParentOrgName(((ProjectPoolSetVO)projectPoolSetVOMap.get(datas.get(0))).getOrgName());
                        importOddFeeVO.setParentOrgId(((ProjectPoolSetVO)projectPoolSetVOMap.get(datas.get(0))).getOrgId());
                        importOddFeeVO.setParentOrgCode(((ProjectPoolSetVO)projectPoolSetVOMap.get(datas.get(0))).getOrgCode());
                    } else {
                        CommonResponse projectData = this.projectPoolApi.queryProjectListByCodeAndTenantId((String)datas.get(0), tenantId);
                        if (!projectData.isSuccess()) {
                            errorMessage.append("[\u9879\u76ee\u6c60\u4e0d\u5b58\u5728\u5f53\u524d\u9879\u76ee\u7f16\u7801\u7684\u9879\u76ee]");
                        } else if (CollectionUtils.isNotEmpty((Collection)((Collection)projectData.getData())) && null != ((List)projectData.getData()).get(0)) {
                            projectPoolSetVOMap.put(datas.get(0), ((List)projectData.getData()).get(0));
                            importOddFeeVO.setProjectId(((ProjectPoolSetVO)projectPoolSetVOMap.get(datas.get(0))).getId());
                            importOddFeeVO.setProjectName(((ProjectPoolSetVO)projectPoolSetVOMap.get(datas.get(0))).getName());
                            importOddFeeVO.setOrgId(((ProjectPoolSetVO)projectPoolSetVOMap.get(datas.get(0))).getProjectDepartmentId());
                            importOddFeeVO.setOrgCode(((ProjectPoolSetVO)projectPoolSetVOMap.get(datas.get(0))).getProjectDepartmentCode());
                            importOddFeeVO.setOrgName(((ProjectPoolSetVO)projectPoolSetVOMap.get(datas.get(0))).getProjectDepartmentName());
                            importOddFeeVO.setParentOrgId(((ProjectPoolSetVO)projectPoolSetVOMap.get(datas.get(0))).getOrgId());
                            importOddFeeVO.setParentOrgName(((ProjectPoolSetVO)projectPoolSetVOMap.get(datas.get(0))).getOrgName());
                            importOddFeeVO.setParentOrgCode(((ProjectPoolSetVO)projectPoolSetVOMap.get(datas.get(0))).getOrgCode());
                        } else {
                            errorMessage.append("[\u9879\u76ee\u6c60\u4e0d\u5b58\u5728\u5f53\u524d\u9879\u76ee\u7f16\u7801\u7684\u9879\u76ee]");
                        }
                    }
                } else {
                    errorMessage.append("[\u9879\u76ee\u7f16\u7801\u4e3a\u5fc5\u586b\u9879]");
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(2)))) {
                    importOddFeeVO.setBillCode((String)datas.get(2));
                    if (((String)datas.get(2)).length() > 64) {
                        errorMessage.append("[\u586b\u5199\u5355\u636e\u7f16\u53f7\u957f\u5ea6\u4e3a1~64\u5b57]");
                    } else if (billCodeList.contains(datas.get(2))) {
                        errorMessage.append("[\u5f53\u524d\u5355\u636e\u7f16\u53f7" + (String)datas.get(2) + "\u5df2\u5b58\u5728\uff0c\u8bf7\u66f4\u6362\u5355\u636e\u7f16\u53f7]");
                    }
                } else {
                    errorMessage.append("[\u5355\u636e\u7f16\u53f7\u4e3a\u5fc5\u586b\u9879]");
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(3)))) {
                    importOddFeeVO.setNoContractFeeTypeName((String)datas.get(3));
                    if (((String)datas.get(3)).length() > 100) {
                        errorMessage.append("[\u586b\u5199\u65e0\u5408\u540c\u8d39\u7528\u7c7b\u578b\u957f\u5ea6\u4e3a1~100\u5b57]");
                    } else if (defFeeMap.get(datas.get(3)) == null) {
                        errorMessage.append("[\u81ea\u5b9a\u4e49\u6863\u6848\u4e0d\u5b58\u5728\u5f53\u524d\u65e0\u5408\u540c\u8d39\u7528\u7c7b\u578b]");
                    } else {
                        importOddFeeVO.setNoContractFeeTypeId(((DefdocDetailVO)defFeeMap.get(datas.get(3))).getId());
                        importOddFeeVO.setNoContractFeeTypeCode(((DefdocDetailVO)defFeeMap.get(datas.get(3))).getCode());
                    }
                } else {
                    errorMessage.append("[\u65e0\u5408\u540c\u8d39\u7528\u7c7b\u578b\u4e3a\u5fc5\u586b\u9879]");
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(4)))) {
                    importOddFeeVO.setBusinessExplain((String)datas.get(4));
                    if (((String)datas.get(4)).length() > 500) {
                        errorMessage.append("[\u586b\u5199\u4e1a\u52a1\u8bf4\u660e\u957f\u5ea6\u4e3a1~500\u5b57]");
                    }
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(5)))) {
                    errorMessage.append("[\u53d1\u751f\u65e5\u671f\u4e3a\u5fc5\u586b\u9879]");
                } else {
                    try {
                        importOddFeeVO.setHappenDate(DateUtils.parseDate((String)((String)datas.get(5)), (String[])new String[]{"YYYY-MM-dd"}));
                    }
                    catch (ParseException e) {
                        errorMessage.append("[\u53d1\u751f\u65e5\u671f\u586b\u5199\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u586b\u5199 YYYY-MM-dd \u7c7b\u578b\u7684\u65e5\u671f\u683c\u5f0f]");
                        e.printStackTrace();
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(6)))) {
                    try {
                        importOddFeeVO.setFeeMny(new BigDecimal((String)datas.get(6)));
                    }
                    catch (Exception e) {
                        errorMessage.append("[\u4e0d\u542b\u7a0e\u91d1\u989d\u5fc5\u987b\u4e3a\u6570\u5b57]");
                    }
                } else {
                    errorMessage.append("[\u4e0d\u542b\u7a0e\u91d1\u989d\u4e3a\u5fc5\u586b\u9879]");
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(7)))) {
                    try {
                        importOddFeeVO.setTaxRate(new BigDecimal((String)datas.get(7)));
                    }
                    catch (Exception e) {
                        errorMessage.append("[\u7a0e\u7387\u5fc5\u987b\u4e3a\u6570\u5b57]");
                    }
                } else {
                    errorMessage.append("[\u7a0e\u7387\u4e3a\u5fc5\u586b\u9879]");
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(8)))) {
                    try {
                        importOddFeeVO.setFeeTaxMny(new BigDecimal((String)datas.get(8)));
                        if (importOddFeeVO.getFeeMny() != null) {
                            importOddFeeVO.setTax(importOddFeeVO.getFeeTaxMny().subtract(importOddFeeVO.getFeeMny()));
                            importOddFeeVO.setSurplusAllocatedMny(importOddFeeVO.getFeeMny());
                            importOddFeeVO.setSurplusPayMny(importOddFeeVO.getFeeMny());
                            importOddFeeVO.setSurplusAllocatedTaxMny(importOddFeeVO.getFeeTaxMny());
                            importOddFeeVO.setSurplusPayTaxMny(importOddFeeVO.getFeeTaxMny());
                        }
                    }
                    catch (Exception e) {
                        errorMessage.append("[\u542b\u7a0e\u91d1\u989d\u5fc5\u987b\u4e3a\u6570\u5b57]");
                    }
                } else {
                    errorMessage.append("[\u542b\u7a0e\u91d1\u989d\u4e3a\u5fc5\u586b\u9879]");
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(9)))) {
                    errorMessage.append("[\u652f\u4ed8\u5bf9\u8c61\u7c7b\u578b\u4e3a\u5fc5\u586b\u9879]");
                } else {
                    if (((String)datas.get(9)).equals("\u5ba2\u5546")) {
                        importOddFeeVO.setPayTargetType(Integer.valueOf(1));
                    } else if (((String)datas.get(9)).equals("\u5458\u5de5")) {
                        importOddFeeVO.setPayTargetType(Integer.valueOf(2));
                    } else {
                        errorMessage.append("[\u652f\u4ed8\u5bf9\u8c61\u7c7b\u578b\u586b\u5199\u9519\u8bef]");
                    }
                    if (null != importOddFeeVO.getPayTargetType()) {
                        if (importOddFeeVO.getPayTargetType() == 1) {
                            if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(10))) && StringUtils.isBlank((CharSequence)((CharSequence)datas.get(11)))) {
                                errorMessage.append("[\u652f\u4ed8\u5bf9\u8c61\u7c7b\u578b\u4e3a\u4f9b\u5e94\u5546\u65f6\uff0cI8\u5355\u4f4d\u7f16\u7801\u548c\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u5e94\u6709\u4e00\u4e2a\u5fc5\u586b]");
                            } else {
                                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(10)))) {
                                    importOddFeeVO.setI8DeptCode((String)datas.get(10));
                                    unitCodeOrTaxPayerIdentifierList.add(datas.get(10));
                                }
                                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(11)))) {
                                    importOddFeeVO.setTaxPayerNum((String)datas.get(11));
                                    unitCodeOrTaxPayerIdentifierList.add(datas.get(11));
                                }
                            }
                        } else if (importOddFeeVO.getPayTargetType() == 2) {
                            if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(12))) && StringUtils.isBlank((CharSequence)((CharSequence)datas.get(13)))) {
                                errorMessage.append("[\u652f\u4ed8\u5bf9\u8c61\u7c7b\u578b\u4e3a\u5185\u90e8\u5458\u5de5\u65f6\uff0c\u8eab\u4efd\u8bc1\u53f7\u548cOA\u8d26\u53f7\u5e94\u6709\u4e00\u4e2a\u5fc5\u586b]");
                            } else {
                                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(12)))) {
                                    importOddFeeVO.setIdCardNum((String)datas.get(12));
                                    iDCardOrOAAccountList.add(datas.get(12));
                                }
                                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(13)))) {
                                    importOddFeeVO.setOAAccount((String)datas.get(13));
                                    iDCardOrOAAccountList.add(datas.get(13));
                                }
                            }
                        }
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(14)))) {
                    importOddFeeVO.setEmployOAAccount((String)datas.get(14));
                    iDCardOrOAAccountList.add(datas.get(14));
                } else {
                    errorMessage.append("[\u7ecf\u529e\u4ebaOA\u8d26\u53f7\u4e3a\u5fc5\u586b\u9879]");
                }
                if (StringUtils.isNotBlank((CharSequence)errorMessage)) {
                    importOddFeeVO.setErrorMessage(String.valueOf(errorMessage));
                }
                importOddFeeVO.setId(Long.valueOf(IdWorker.getId()));
                reDataList.add(importOddFeeVO);
            }
            CommonResponse supplierData = this.iProSupplierApi.selectByUnitCodeOrTaxPayerIdentifier(unitCodeOrTaxPayerIdentifierList);
            if (!supplierData.isSuccess() || CollectionUtils.isEmpty((Collection)((Collection)supplierData.getData()))) {
                reDataList.forEach(item -> {
                    if (item.getPayTargetType() == 1) {
                        item.setErrorMessage(item.getErrorMessage() != null ? item.getErrorMessage() + "[\u4f9b\u5e94\u5546\u6863\u6848\u6570\u636e\u4e0d\u5b58\u5728]" : "[\u4f9b\u5e94\u5546\u6863\u6848\u6570\u636e\u4e0d\u5b58\u5728]");
                    }
                });
            } else {
                List supplierDTOList = (List)supplierData.getData();
                Map i8UnitCodeMap = supplierDTOList.stream().filter(item -> item.getUnitI8Code() != null).collect(Collectors.toMap(SupplierDTO::getUnitI8Code, Function.identity(), (key1, key2) -> key2));
                Map taxPayerIdentifierMap = supplierDTOList.stream().filter(item -> item.getTaxPayerIdentifier() != null).collect(Collectors.toMap(SupplierDTO::getTaxPayerIdentifier, Function.identity(), (key1, key2) -> key2));
                for (ImportOddFeeVO importOddFeeVO : reDataList) {
                    if (importOddFeeVO.getPayTargetType() != 1 || !i8UnitCodeMap.containsKey(importOddFeeVO.getI8DeptCode())) continue;
                    importOddFeeVO.setSupplierId(((SupplierDTO)i8UnitCodeMap.get(importOddFeeVO.getI8DeptCode())).getId());
                    importOddFeeVO.setSupplierName(((SupplierDTO)i8UnitCodeMap.get(importOddFeeVO.getI8DeptCode())).getName());
                }
                for (ImportOddFeeVO importOddFeeVO : reDataList) {
                    if (importOddFeeVO.getPayTargetType() != 1 || null != importOddFeeVO.getSupplierId()) continue;
                    if (taxPayerIdentifierMap.containsKey(importOddFeeVO.getTaxPayerNum())) {
                        importOddFeeVO.setSupplierId(((SupplierDTO)taxPayerIdentifierMap.get(importOddFeeVO.getTaxPayerNum())).getId());
                        importOddFeeVO.setSupplierName(((SupplierDTO)taxPayerIdentifierMap.get(importOddFeeVO.getTaxPayerNum())).getName());
                        continue;
                    }
                    importOddFeeVO.setErrorMessage(importOddFeeVO.getErrorMessage() != null ? importOddFeeVO.getErrorMessage() + "[\u4f9b\u5e94\u5546\u6863\u6848\u6570\u636e\u4e0d\u5b58\u5728]" : "[\u4f9b\u5e94\u5546\u6863\u6848\u6570\u636e\u4e0d\u5b58\u5728]");
                }
            }
            CommonResponse employeeData = this.iEmployeeApi.getByCodeOrIdcard(iDCardOrOAAccountList);
            if (!employeeData.isSuccess() || CollectionUtils.isEmpty((Collection)((Collection)employeeData.getData()))) {
                reDataList.forEach(item -> {
                    if (item.getPayTargetType() == 2) {
                        item.setErrorMessage(item.getErrorMessage() != null ? item.getErrorMessage() + "[\u5185\u90e8\u5458\u5de5\u6863\u6848\u6570\u636e\u4e0d\u5b58\u5728]" : "[\u5185\u90e8\u5458\u5de5\u6863\u6848\u6570\u636e\u4e0d\u5b58\u5728]");
                    }
                });
            } else {
                List employeeVOList = (List)employeeData.getData();
                Map idCardMap = employeeVOList.stream().filter(item -> item.getIdcard() != null).collect(Collectors.toMap(EmployeeVO::getIdcard, Function.identity(), (key1, key2) -> key2));
                Map oAAccountMap = employeeVOList.stream().filter(item -> item.getCode() != null).collect(Collectors.toMap(EmployeeVO::getCode, Function.identity(), (key1, key2) -> key2));
                for (ImportOddFeeVO importOddFeeVO : reDataList) {
                    if (importOddFeeVO.getPayTargetType() == 2 && oAAccountMap.containsKey(importOddFeeVO.getOAAccount())) {
                        importOddFeeVO.setOwnStaffId(((EmployeeVO)oAAccountMap.get(importOddFeeVO.getOAAccount())).getUserId());
                        importOddFeeVO.setOwnStaffName(((EmployeeVO)oAAccountMap.get(importOddFeeVO.getOAAccount())).getName());
                    }
                    if (oAAccountMap.containsKey(importOddFeeVO.getEmployOAAccount())) {
                        importOddFeeVO.setEmployeeId(((EmployeeVO)oAAccountMap.get(importOddFeeVO.getEmployOAAccount())).getUserId());
                        importOddFeeVO.setEmployeeName(((EmployeeVO)oAAccountMap.get(importOddFeeVO.getEmployOAAccount())).getName());
                        importOddFeeVO.setDepartmentId(((EmployeeVO)oAAccountMap.get(importOddFeeVO.getEmployOAAccount())).getDeptId());
                        importOddFeeVO.setDepartmentName(((EmployeeVO)oAAccountMap.get(importOddFeeVO.getEmployOAAccount())).getDeptName());
                        continue;
                    }
                    importOddFeeVO.setErrorMessage(importOddFeeVO.getErrorMessage() != null ? importOddFeeVO.getErrorMessage() + "[\u5185\u90e8\u5458\u5de5\u6863\u6848\u6570\u636e\u4e0d\u5b58\u5728\u8be5\u7ecf\u529e\u4eba\u4fe1\u606f]" : "[\u5185\u90e8\u5458\u5de5\u6863\u6848\u6570\u636e\u4e0d\u5b58\u5728\u8be5\u7ecf\u529e\u4eba\u4fe1\u606f]");
                }
                for (ImportOddFeeVO importOddFeeVO : reDataList) {
                    if (importOddFeeVO.getPayTargetType() != 2 || null != importOddFeeVO.getOwnStaffId()) continue;
                    if (idCardMap.containsKey(importOddFeeVO.getIdCardNum())) {
                        importOddFeeVO.setOwnStaffId(((EmployeeVO)idCardMap.get(importOddFeeVO.getIdCardNum())).getUserId());
                        importOddFeeVO.setOwnStaffName(((EmployeeVO)idCardMap.get(importOddFeeVO.getIdCardNum())).getName());
                        continue;
                    }
                    importOddFeeVO.setErrorMessage(importOddFeeVO.getErrorMessage() != null ? importOddFeeVO.getErrorMessage() + "[\u5185\u90e8\u5458\u5de5\u6863\u6848\u6570\u636e\u4e0d\u5b58\u5728]" : "[\u5185\u90e8\u5458\u5de5\u6863\u6848\u6570\u636e\u4e0d\u5b58\u5728]");
                }
            }
            for (ImportOddFeeVO importOddFeeVO : reDataList) {
                if (StringUtils.isBlank((CharSequence)importOddFeeVO.getErrorMessage())) {
                    successList.add(importOddFeeVO);
                    continue;
                }
                errorList.add(importOddFeeVO);
            }
        }
        this.logger.info("\u5bfc\u5165\u7ed3\u675f\u65f6\u95f4----------->{}", (Object)new Date());
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success((Object)json);
    }

    @Override
    public String saveImportExcel(HttpServletRequest request, List<OddFeeVO> importVOS) {
        if (ListUtil.isEmpty(importVOS)) {
            throw new BusinessException("\u5bfc\u5165\u7684\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        List entityList = BeanMapper.mapList(importVOS, OddFeeEntity.class);
        for (OddFeeEntity entity : entityList) {
            entity.setSourceType(1);
            if (null == entity.getBillCode()) {
                BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)((BaseVO)BeanMapper.map((Object)((Object)entity), OddFeeVO.class)));
                CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
                if (!billCode.isSuccess()) {
                    this.logger.error("\u4fdd\u5b58\u96f6\u661f\u8d39\u7528\u5931\u8d25\uff0c\u81ea\u52a8\u751f\u6210\u96f6\u661f\u8d39\u7528\u7f16\u7801\u5931\u8d25: {}", (Object)billCode.getMsg());
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
                entity.setBillCode((String)billCode.getData());
            }
            entity.setBillState(BillStateEnum.COMMITED_STATE.getBillStateCode());
        }
        super.saveOrUpdateBatch(entityList, entityList.size(), false);
        return "\u4fdd\u5b58\u6210\u529f";
    }

    private BigDecimal setDefaultValue(BigDecimal v) {
        if (v == null) {
            return BigDecimal.ZERO;
        }
        return v;
    }
}

