package com.ejianc.business.financial.service.impl;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.financial.bean.StampDutyDetailEntity;
import com.ejianc.business.financial.mapper.StampDutyDetailMapper;
import com.ejianc.business.financial.service.IStampDutyDetailService;
import com.ejianc.business.financial.vo.StampDutyDetailVO;
import com.ejianc.business.financial.vo.StampDutyVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.financial.mapper.StampDutyMapper;
import com.ejianc.business.financial.bean.StampDutyEntity;
import com.ejianc.business.financial.service.IStampDutyService;
import org.springframework.transaction.annotation.Transactional;

import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;

/**
 * 印花税管理
 * 
 * @author generator
 * 
 */
@Service("stampDutyService")
public class StampDutyServiceImpl extends BaseServiceImpl<StampDutyMapper, StampDutyEntity> implements IStampDutyService{
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private StampDutyMapper mapper;
    @Autowired
    private StampDutyDetailMapper detailMapper;
    @Autowired
    private IStampDutyDetailService detailService;

    @Override
    public void updateStampDutyData() {

        //获取消耗材合同数据
        List<StampDutyDetailEntity> stampDutyEntities = detailMapper.selectMaterialList();
        if (CollectionUtils.isNotEmpty(stampDutyEntities)) {
            detailService.saveOrUpdateBatch(stampDutyEntities);
        }
        //获取消耗材合同-变更数据
        List<StampDutyDetailEntity> stampDutyDetailEntities = detailMapper.selectMaterialChangeList();
        if (CollectionUtils.isNotEmpty(stampDutyDetailEntities)) {
            detailService.saveOrUpdateBatch(stampDutyDetailEntities);
        }

        //获取数据
        List<StampDutyDetailEntity> stampDutyDetailEntities1 = detailMapper.selectIncomeList();
        if (CollectionUtils.isNotEmpty(stampDutyDetailEntities1)) {
            detailService.saveOrUpdateBatch(stampDutyDetailEntities1);
        }
        //获取-变更数据
        List<StampDutyDetailEntity> stampDutyDetailEntities2 = detailMapper.selectIncomeChangeList();
        if (CollectionUtils.isNotEmpty(stampDutyDetailEntities2)) {
            detailService.saveOrUpdateBatch(stampDutyDetailEntities2);
        }

         //获取数据
        List<StampDutyDetailEntity> stampDutyDetailEntities3 = detailMapper.selectConcreteList();
        if (CollectionUtils.isNotEmpty(stampDutyDetailEntities3)) {
            detailService.saveOrUpdateBatch(stampDutyDetailEntities3);
        }
        //获取-变更数据
        List<StampDutyDetailEntity> stampDutyDetailEntities4 = detailMapper.selectConcreteChangeList();
        if (CollectionUtils.isNotEmpty(stampDutyDetailEntities4)) {
            detailService.saveOrUpdateBatch(stampDutyDetailEntities4);
        }

         //获取数据
        List<StampDutyDetailEntity> stampDutyDetailEntities5 = detailMapper.selectRmatList();
        if (CollectionUtils.isNotEmpty(stampDutyDetailEntities5)) {
            detailService.saveOrUpdateBatch(stampDutyDetailEntities5);
        }
        //获取-变更数据
        List<StampDutyDetailEntity> stampDutyDetailEntities6 = detailMapper.selectRmatChangeList();
        if (CollectionUtils.isNotEmpty(stampDutyDetailEntities6)) {
            detailService.saveOrUpdateBatch(stampDutyDetailEntities6);
        }

         //获取数据
        List<StampDutyDetailEntity> stampDutyDetailEntities7 = detailMapper.selectLaborList();
        if (CollectionUtils.isNotEmpty(stampDutyDetailEntities7)) {
            detailService.saveOrUpdateBatch(stampDutyDetailEntities7);
        }
        //获取-变更数据
        List<StampDutyDetailEntity> stampDutyDetailEntities8 = detailMapper.selectLaborChangeList();
        if (CollectionUtils.isNotEmpty(stampDutyDetailEntities8)) {
            detailService.saveOrUpdateBatch(stampDutyDetailEntities8);
        }

         //获取数据
        List<StampDutyDetailEntity> stampDutyDetailEntities9 = detailMapper.selectProsubList();
        if (CollectionUtils.isNotEmpty(stampDutyDetailEntities9)) {
            detailService.saveOrUpdateBatch(stampDutyDetailEntities9);
        }
        //获取-变更数据
        List<StampDutyDetailEntity> stampDutyDetailEntities10 = detailMapper.selectProsubChangeList();
        if (CollectionUtils.isNotEmpty(stampDutyDetailEntities10)) {
            detailService.saveOrUpdateBatch(stampDutyDetailEntities10);
        }

         //获取数据
        List<StampDutyDetailEntity> stampDutyDetailEntities11 = detailMapper.selectRentList();
        if (CollectionUtils.isNotEmpty(stampDutyDetailEntities11)) {
            detailService.saveOrUpdateBatch(stampDutyDetailEntities11);
        }
        //获取-变更数据
        List<StampDutyDetailEntity> stampDutyDetailEntities12 = detailMapper.selectRentChangeList();
        if (CollectionUtils.isNotEmpty(stampDutyDetailEntities12)) {
            detailService.saveOrUpdateBatch(stampDutyDetailEntities12);
        }

         //获取数据
        List<StampDutyDetailEntity> stampDutyDetailEntities13 = detailMapper.selectAcList();
        if (CollectionUtils.isNotEmpty(stampDutyDetailEntities13)) {
            detailService.saveOrUpdateBatch(stampDutyDetailEntities13);
        }
        //获取-变更数据
        List<StampDutyDetailEntity> stampDutyDetailEntities14 = detailMapper.selectAcChangeList();
        if (CollectionUtils.isNotEmpty(stampDutyDetailEntities14)) {
            detailService.saveOrUpdateBatch(stampDutyDetailEntities14);
        }

         //获取数据
        List<StampDutyDetailEntity> stampDutyDetailEntities15 = detailMapper.selectPurchaseList();
        if (CollectionUtils.isNotEmpty(stampDutyDetailEntities15)) {
            detailService.saveOrUpdateBatch(stampDutyDetailEntities15);
        }
        //获取-变更数据
        List<StampDutyDetailEntity> stampDutyDetailEntities16 = detailMapper.selectPurchaseChangeList();
        if (CollectionUtils.isNotEmpty(stampDutyDetailEntities16)) {
            detailService.saveOrUpdateBatch(stampDutyDetailEntities16);
        }

         //获取数据
        List<StampDutyDetailEntity> stampDutyDetailEntities17 = detailMapper.selectOtherList();
        if (CollectionUtils.isNotEmpty(stampDutyDetailEntities17)) {
            detailService.saveOrUpdateBatch(stampDutyDetailEntities17);
        }
        //获取-变更数据
        List<StampDutyDetailEntity> stampDutyDetailEntities18 = detailMapper.selectOtherChangeList();
        if (CollectionUtils.isNotEmpty(stampDutyDetailEntities18)) {
            detailService.saveOrUpdateBatch(stampDutyDetailEntities18);
        }














        //获取合同所属项目信息,并修改
        updateDetailPid();


    }

    @Override
    public void updateDetailPid() {
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMM");
        //获取当前时间String类型
        String time_string = sdf.format(date);

        //获取合同所属项目信息
        List<StampDutyEntity> stampDutyEntities1 = detailMapper.selectProjectList();
        if (CollectionUtils.isNotEmpty(stampDutyEntities1)){
            for (StampDutyEntity stampDutyEntity : stampDutyEntities1) {
                BillCodeParam billCodeParam = BillCodeParam.build("Invoice_Open_Apply_Code", InvocationInfoProxy.getTenantid(),new StampDutyVO());
                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                if(billCode.isSuccess()) {
                    stampDutyEntity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                }else{
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }

                stampDutyEntity.setYearmonth(time_string);
                this.saveOrUpdate(stampDutyEntity);
                //更新明细子表的id
                detailMapper.updateDetailPid(stampDutyEntity.getProjectId(),stampDutyEntity.getId());
            }
        }
    }
}
