package com.ejianc.business.profinance.service;

import com.ejianc.business.profinance.bean.ContractLawsuitEntity;
import com.ejianc.business.profinance.vo.ContractLawsuitVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.math.BigDecimal;

/**
 * 诉讼费结算实体
 * 
 * @author generator
 * 
 */
public interface IContractLawsuitService extends IBaseService<ContractLawsuitEntity> {



    /**
     * 查询当前合同下已生效的诉讼结算单 中的 诉讼工程款的合计
     * @param contractId
     * @return
     */
    BigDecimal queryTotalLawsuitMny(Long contractId);

    /**
     * 推送结算池
     * @param vo
     */
    String pushLawsuitToPool(ContractLawsuitVO vo);

    /**
     * 更新推送状态
     * @param id
     * @param flag
     */
    void executeUpdatePool(Long id, Boolean flag);
    /**
     * 从结算池中删除数据
     *
     * @param id
     * @return
     */
    boolean delSettleFromPool(Long id);


    /**
     * 保存更新诉讼费结算
     *
     * @param saveOrUpdateVO
     * @return
     */
    ContractLawsuitVO saveContractLawsuitVO(ContractLawsuitVO saveOrUpdateVO);


    /**
     *  推送实际成本
     * @param entity
     */
    void costPush(ContractLawsuitEntity entity);

    void costDeletePush(ContractLawsuitEntity entity);


    CommonResponse<ContractLawsuitVO> pushCost(ContractLawsuitVO vo);
}
