package com.ejianc.business.profinance.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.process.enums.BillPushStatusEnum;
import com.ejianc.business.profinance.bean.ContractLawsuitEntity;
import com.ejianc.business.profinance.bean.PaymentApplyDetailEntity;
import com.ejianc.business.profinance.bean.SalaryPayApplyEntity;
import com.ejianc.business.profinance.service.IContractLawsuitService;
import com.ejianc.business.profinance.service.IPaymentApplyDetailService;
import com.ejianc.business.profinance.vo.ContractLawsuitVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;
import java.util.Map;

@Service("contractLawsuit")
public class ContractLawsuitBpmServiceImpl implements ICommonBusinessService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IContractLawsuitService service;
    @Autowired
    private IPaymentApplyDetailService payAppService;
    @Autowired
    private IProjectPoolApi projectPoolApi;

    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success("诉讼 提交前回调成功");
    }

    ;

    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {


        ContractLawsuitEntity entity = service.selectById(billId);
        if (state.equals(BillStateEnum.COMMITED_STATE.getBillStateCode())) {
            //直审时添加单据提交人等信息
            UserContext userContext = sessionManager.getUserContext();
            entity.setCommitDate(new Date());
            entity.setCommitUserCode(userContext.getUserCode());
            entity.setCommitUserName(userContext.getUserName());
        }
        service.saveOrUpdate(entity, false);
        return CommonResponse.success("诉讼费结算审批回调处理成功");
    }

    /**
     * 有审批流的撤回前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return bpmBackCheck(billId, state, billTypeCode);
    }

    ;

    /**
     * 有审批流的撤回后回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 审批节点审批中时节点审批前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    ;

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        ContractLawsuitEntity entity = service.selectById(billId);
        if (entity != null) {
            entity.setEffectiveDate(new Date());
        }
        if (state.equals(BillStateEnum.COMMITED_STATE.getBillStateCode())) {
            //直审时添加单据提交人等信息
            UserContext userContext = sessionManager.getUserContext();
            entity.setCommitDate(new Date());
            entity.setCommitUserCode(userContext.getUserCode());
            entity.setCommitUserName(userContext.getUserName());
        }
        //推送结算池
        String msg = service.pushLawsuitToPool(BeanMapper.map(entity, ContractLawsuitVO.class));
        service.saveOrUpdate(entity, false);
        // 推送 实际成本
        service.costPush(entity);
        return CommonResponse.success("诉讼费结算审批回调成功！");
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return bpmBackCheck(billId, state, billTypeCode);
    }

    private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
        logger.info("诉讼单据billId-{}, state-{}, billTypeCode-{}撤回前校验", billId, state, billTypeCode);
        ContractLawsuitEntity entity = service.selectById(billId);
        LambdaQueryWrapper<PaymentApplyDetailEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(PaymentApplyDetailEntity::getSourceId, entity.getId());
        lambda.eq(PaymentApplyDetailEntity::getSourceType, "诉讼");
        lambda.eq(PaymentApplyDetailEntity::getDr, 0);

        int resultCount = payAppService.count(lambda);
        CommonResponse<String> res = billTypeApi.checkQuote(billTypeCode, billId);
        logger.info("平台返回查询被引用情况: {}" + JSONObject.toJSONString(res));

        if (!res.isSuccess()||resultCount>0) {
            return CommonResponse.error("当前单据已被下游业务引用，不能弃审！");
        }
        // 从结算池中删除数据
        boolean unPushRes = service.delSettleFromPool(entity.getId());
        if (unPushRes) {
            entity.setPushPoolFlag(BillPushStatusEnum.未成功推送.getStatus());
        } else {
            logger.error("将诉讼结算单-{}从结算池删除失败！", JSONObject.toJSONString(entity));
            return CommonResponse.error("诉讼结算单从结算池删除失败！");
        }

        //删除实际成本数据
        if ("1".equals(entity.getRelationFlag())){
            service.costDeletePush(entity);
        }
        return CommonResponse.success("弃审/撤回前校验回调成功！");
    }
    /**
     * 审批--获取当前节点的审批人---从服务中选择
     *
     * @param billId 单据id
     * @param billTypeCode 单据类型编码
     * @param sign 节点标志
     * @return
     */
    @Override
    public CommonResponse<JSONArray> queryApproveUser(Long billId, String billTypeCode, String sign, Map<String, Object> other){
        JSONArray arr = new JSONArray();
        logger.info("sign:{}",sign);

        //根据标识判断是否（成本相关人员审批的）节点
        if ("choseCostUser".equals(sign)){
            //获取表单详情数据

            //根据项目id获取项目基本信息中的成本对接人信息
            ContractLawsuitEntity entity = service.selectById(billId);
            Long projectId = entity.getProjectId();

            JSONObject jsonObject = new JSONObject();
            CommonResponse<JSONArray> commonResponse = projectPoolApi.queryProjectPoolById(projectId);


            if(!commonResponse.isSuccess()){
                throw new BusinessException("查询项目失败!");
            }
            JSONArray array = commonResponse.getData();
            List<ProjectPoolSetVO> vos = JSONObject.parseArray(array.toJSONString(), ProjectPoolSetVO.class);

            logger.info("vos:{}",JSONObject.toJSONString(vos));

            ProjectPoolSetVO vo = vos.get(0);
            Long costAdapter = vo.getCostAdapter();
            String costAdapterName = vo.getCostAdapterName();

            logger.info("userId:{}",costAdapter);
            logger.info("userName:{}",costAdapterName);


            jsonObject.put("userId",costAdapter);
            jsonObject.put("userName",costAdapterName);

            arr.add(jsonObject);

        }
        return CommonResponse.success(arr);
    }

}
