package com.ejianc.business.profinance.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.profinance.bean.SalaryPayApplyDetailEntity;
import com.ejianc.business.profinance.bean.SalaryPayApplyEntity;
import com.ejianc.business.profinance.mapper.SalaryDetailMapper;
import com.ejianc.business.profinance.mapper.SalaryPayApplyDetailMapper;
import com.ejianc.business.profinance.service.IPayrollRegisterService;
import com.ejianc.business.profinance.service.ISalaryDetailService;
import com.ejianc.business.profinance.service.ISalaryPayApplyDetailService;
import com.ejianc.business.profinance.service.ISalaryPayApplyService;
import com.ejianc.business.profinance.vo.SalaryPayApplyDetailVO;
import com.ejianc.business.profinance.vo.SalaryPayApplyVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 工人工资支付申请子实体
 *
 * @author generator
 */
@Service("salaryPayApplyDetailService")
public class SalaryPayApplyDetailServiceImpl extends BaseServiceImpl<SalaryPayApplyDetailMapper, SalaryPayApplyDetailEntity> implements ISalaryPayApplyDetailService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    SalaryPayApplyDetailMapper payApplyDetailMapper;

    @Autowired
    ISalaryPayApplyService salaryPayApplyService;

    @Autowired
    ISalaryDetailService salaryDetailService;

    @Autowired
    private RabbitTemplate rabbitTemplate;

    @Autowired
    private SalaryDetailMapper salaryDetailMapper;

    @Autowired
    private IPayrollRegisterService payrollRegisterService;

    // 根据ID批量更新工人工资支付申请子表的支付结果（即支付状态）和支付日期字段
    @Override
    public void updatePayStateByIds(List<Long> idList, Integer payState, Date payDate) {
        payApplyDetailMapper.updatePayStateByIds(idList, payState, payDate);
    }

    // 确认支付结果
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void confirmPayResult(List<SalaryPayApplyDetailVO> detailVOList) {
        List<SalaryPayApplyEntity> mainEntityUpdateList = new ArrayList<>();
        List<SalaryPayApplyDetailEntity> subEntityUpdateList = new ArrayList<>();
        SalaryPayApplyEntity oldMainEntity = null;
        List<Long> oldIds = new ArrayList<>();
        //获取主表信息，此处需要更新主表中实付金额，
        SalaryPayApplyEntity mainEntity = salaryPayApplyService.selectById(detailVOList.get(0).getPid());
        //主表实付含税
        BigDecimal curTotalActualPaidTaxMny = mainEntity.getActualPaidTaxMny();
        //主表实付无税
        BigDecimal curTotalActualPaidTMny = mainEntity.getActualPaidMny();
        //主表实付税额
        BigDecimal curTotalActualPaidTax = mainEntity.getActualPaidTax();
        if(null == curTotalActualPaidTaxMny) {
            curTotalActualPaidTaxMny = BigDecimal.ZERO;
        }
        if(null == curTotalActualPaidTMny) {
            curTotalActualPaidTMny = BigDecimal.ZERO;
        }
        if(null == curTotalActualPaidTax) {
            curTotalActualPaidTax = BigDecimal.ZERO;
        }

        Integer workerPayState = detailVOList.get(0).getWorkerPayState();
        Date workerPayDate = detailVOList.get(0).getWorkerPayDate();
        Integer isRepeatBill = detailVOList.get(0).getWorkerIsRepeatBill();
        Long pid = detailVOList.get(0).getPid();
        List<Long> ids = detailVOList.stream().map(SalaryPayApplyDetailVO::getId).collect(Collectors.toList());
        QueryWrapper<SalaryPayApplyDetailEntity> wrapper = new QueryWrapper<>();
        wrapper.in("id", ids);
        List<SalaryPayApplyDetailEntity> salaryPayApplyDetailEntityList = payApplyDetailMapper.selectList(wrapper);
        // 用于更新自己子表
        Map<String, SalaryPayApplyDetailEntity> salaryPayApplyDetailEntityMap = new HashMap();
        // 用于更新原申请子表
        Map<String, SalaryPayApplyDetailEntity> salaryPayApplyDetailEntityMapOld = new HashMap();
        if (CollectionUtils.isNotEmpty(salaryPayApplyDetailEntityList)) {
            for(SalaryPayApplyDetailEntity item : salaryPayApplyDetailEntityList) {
                if (item.getIdOld() != null) {
                    salaryPayApplyDetailEntityMapOld.put(item.getIdOld().toString(), item);
                }
                // 确认成功时 更新实际支付金额、支付日期、支付结果；确认失败时  只更新支付结果
                if (workerPayState == 1) {
                    //确认支付成功，那么实付金额默认等于申请金额
                    BigDecimal workerApplyTaxMny = item.getWorkerApplyTaxMny();
                    workerApplyTaxMny = workerApplyTaxMny == null ? BigDecimal.ZERO : workerApplyTaxMny;

                    //工资实付基金额含税
                    item.setWorkerActualPaidTaxMny(workerApplyTaxMny);
                    //目前税率按照0来处理
                    //计算工资实付金额无税
                    item.setWorkerActualPaidMny(workerApplyTaxMny);
                    //计算工资实付金额数额
                    item.setWorkerActualPaidTax(BigDecimal.ZERO);

                    curTotalActualPaidTaxMny = curTotalActualPaidTaxMny.add(item.getWorkerActualPaidTaxMny());
                    curTotalActualPaidTMny = curTotalActualPaidTMny.add(item.getWorkerActualPaidMny());
                    curTotalActualPaidTax = curTotalActualPaidTax.add(item.getWorkerActualPaidTax());

                    item.setWorkerPayDate(workerPayDate);
                }
                item.setWorkerPayState(workerPayState);
                subEntityUpdateList.add(item);
                salaryPayApplyDetailEntityMap.put(item.getId().toString(), item);
            }

            //更新主表实付字段
            mainEntity.setActualPaidTaxMny(curTotalActualPaidTaxMny);
            mainEntity.setActualPaidMny(curTotalActualPaidTMny);
            mainEntity.setActualPaidTax(curTotalActualPaidTax);
            mainEntityUpdateList.add(mainEntity);

            if (workerPayState == 1) {
                // 选择支付成功，推送给工资登记新增一条数据
                SalaryPayApplyVO generatePayrollRegisterVO = BeanMapper.map(mainEntity, SalaryPayApplyVO.class);
                generatePayrollRegisterVO.setSalaryList(BeanMapper.mapList(salaryPayApplyDetailEntityList, SalaryPayApplyDetailVO.class));
                generatePayrollRegisterVO.setContractCode(mainEntity.getContractCode());
                generatePayrollRegisterVO.setContractId(mainEntity.getContractId());
                //设置总实发金额便于生成工资发放登记单
                BigDecimal actualTotalPaidTaxMny = BigDecimal.ZERO;
                List<SalaryPayApplyDetailVO> salaryPayApplyDetailVOList = generatePayrollRegisterVO.getSalaryList();
                List<SalaryPayApplyDetailVO> generatePayrollRegisterDetailVOList = new ArrayList<>();
                if (CollectionUtils.isNotEmpty(salaryPayApplyDetailVOList)){
                    for (SalaryPayApplyDetailVO salaryPayApplyDetail : salaryPayApplyDetailVOList) {
                        if (ids.contains(salaryPayApplyDetail.getId())){
                            actualTotalPaidTaxMny = actualTotalPaidTaxMny.add(salaryPayApplyDetail.getWorkerActualPaidTaxMny());
                            generatePayrollRegisterDetailVOList.add(salaryPayApplyDetail);
                        }
                    }
                }
                generatePayrollRegisterVO.setSalaryList(generatePayrollRegisterDetailVOList);
                payrollRegisterService.generatePayrollRegister(generatePayrollRegisterVO, actualTotalPaidTaxMny);
                //更新工人工资单实发金额
                salaryDetailService.writeBackSalaryDetail(generatePayrollRegisterDetailVOList);
            }
        }
        if (isRepeatBill == 1) {
            // 是重发的申请单的子表数据，需要将重发的申请单子表中的数据回写到原申请单子表中，
            // 即 将重发申请的申请金额回写到原申请单子表的申请金额（覆盖），并将原申请单子表对应数据支付状态更新为成功
            List<Long> idsOld = detailVOList.stream().map(SalaryPayApplyDetailVO::getIdOld).collect(Collectors.toList());
            QueryWrapper<SalaryPayApplyDetailEntity> wrapperOld = new QueryWrapper<>();
            wrapperOld.in("id", idsOld);
            List<SalaryPayApplyDetailEntity> salaryPayApplyDetailEntityListOld = payApplyDetailMapper.selectList(wrapperOld);
            if (CollectionUtils.isNotEmpty(salaryPayApplyDetailEntityListOld)) {
                //查询出旧单据的主表
                //获取主表信息，此处需要更新主表中实付金额，
                oldMainEntity = salaryPayApplyService.selectById(detailVOList.get(0).getPid());

                //主表实付含税
                BigDecimal oldTotalActualPaidTaxMny = oldMainEntity.getActualPaidTaxMny();
                //主表实付无税
                BigDecimal oldTotalActualPaidTMny = oldMainEntity.getActualPaidMny();
                //主表实付税额
                BigDecimal oldTotalActualPaidTax = oldMainEntity.getActualPaidTax();
                if(null == oldTotalActualPaidTaxMny) {
                    oldTotalActualPaidTaxMny = BigDecimal.ZERO;
                }
                if(null == oldTotalActualPaidTMny) {
                    oldTotalActualPaidTMny = BigDecimal.ZERO;
                }
                if(null == oldTotalActualPaidTax) {
                    oldTotalActualPaidTax = BigDecimal.ZERO;
                }

                for(SalaryPayApplyDetailEntity item : salaryPayApplyDetailEntityListOld) {
                    SalaryPayApplyDetailEntity salaryPayApplyDetailEntity = salaryPayApplyDetailEntityMapOld.get(item.getId().toString());
                    if (salaryPayApplyDetailEntity != null) {
                        BigDecimal workerApplyTaxMny = salaryPayApplyDetailEntity.getWorkerApplyTaxMny();
                        workerApplyTaxMny = workerApplyTaxMny == null ? BigDecimal.ZERO : workerApplyTaxMny;
                        item.setWorkerApplyTaxMny(workerApplyTaxMny);
                        Integer workerPayState1 = salaryPayApplyDetailEntity.getWorkerPayState();
                        if (workerPayState1 == 1) {
                            item.setWorkerPayState(1);
                        }
                        //更新旧子表实付金额字段
                        //工资实付基金额含税
                        item.setWorkerActualPaidTaxMny(salaryPayApplyDetailEntity.getWorkerActualPaidTaxMny());
                        //计算工资实付金额无税
                        item.setWorkerActualPaidMny(salaryPayApplyDetailEntity.getWorkerActualPaidMny());
                        //计算工资实付金额数额
                        item.setWorkerActualPaidTax(salaryPayApplyDetailEntity.getWorkerApplyTax());
                        subEntityUpdateList.add(item);
                        oldIds.add(item.getId());

                        //累计实付金额
                        oldTotalActualPaidTaxMny = curTotalActualPaidTaxMny.add(item.getWorkerActualPaidTaxMny());
                        oldTotalActualPaidTMny = curTotalActualPaidTMny.add(item.getWorkerActualPaidMny());
                        oldTotalActualPaidTax = curTotalActualPaidTax.add(item.getWorkerActualPaidTax());
                    }
                }

                //更新旧的主表
                oldMainEntity.setActualPaidTaxMny(oldTotalActualPaidTaxMny);
                oldMainEntity.setActualPaidMny(oldTotalActualPaidTMny);
                oldMainEntity.setActualPaidTax(oldTotalActualPaidTax);
                mainEntityUpdateList.add(oldMainEntity);
            }
        }

        // 回写主表支付状态
        // 查询当前主表下的子表的支付状态
        judgeIfAllSalaryApplyDetailPaid(mainEntity, ids, workerPayState);

        if(mainEntity.getIsRepeatBill() == 1) {
            judgeIfAllSalaryApplyDetailPaid(oldMainEntity, oldIds, workerPayState);
        }

        //更新数据
        if(CollectionUtils.isNotEmpty(mainEntityUpdateList)) {
            salaryPayApplyService.saveOrUpdateBatch(mainEntityUpdateList, mainEntityUpdateList.size(), false);
        }
        if(CollectionUtils.isNotEmpty(subEntityUpdateList)) {
            super.saveOrUpdateBatch(subEntityUpdateList, subEntityUpdateList.size(), false);
        }
    }

    private void judgeIfAllSalaryApplyDetailPaid(SalaryPayApplyEntity mainEntity, List<Long> ids, Integer payState) {
        QueryWrapper<SalaryPayApplyDetailEntity> query = new QueryWrapper<>();
        query.select("sum( IF ( worker_pay_state = 0, 1, 0 ) ) AS totalWaitNum, sum( IF ( worker_pay_state = 1, 1,0 ) ) AS totalSucNum, sum( IF ( worker_pay_state = 3, 1,0 ) ) AS totalFailNum");
        query.eq("pid", mainEntity.getId());
        query.notIn("id", ids);

        Map payStateNum = super.getMap(query);
        Integer totalWaitNum = null != payStateNum && null != payStateNum.get("totalWaitNum") ? Integer.valueOf(payStateNum.get("totalWaitNum").toString()) : 0;
        Integer totalSucNum = null != payStateNum && null != payStateNum.get("totalSucNum") ? Integer.valueOf(payStateNum.get("totalSucNum").toString()) : 0;
        Integer totalFailNum = null != payStateNum && null != payStateNum.get("totalFailNum") ? Integer.valueOf(payStateNum.get("totalFailNum").toString()) : 0;

        //当存在待支付、或存在部分成功、部分失败时，状态设置为部分支付，否则状态设置为支付成功或支付失败
        Integer curPayState = (totalWaitNum > 0 || (payState == 1 && totalFailNum == 0) || (payState == 3 && totalSucNum > 0)) ? 2 : payState;
        mainEntity.setPayState(curPayState);
    }

    // 查询当前申请单下的所有子表数据
    @Override
    public List<SalaryPayApplyDetailEntity> queryByPid(Long pid) {
        QueryWrapper<SalaryPayApplyDetailEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("pid", pid)
                .eq("dr", 0)
                .eq("tenant_id", InvocationInfoProxy.getTenantid());
        return payApplyDetailMapper.selectList(wrapper);
    }
}
