/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.profinance.paysupplement.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.profinance.paysupplement.bean.PaymentSupplementEntity;
import com.ejianc.business.profinance.paysupplement.service.IPaymentSupplementService;
import com.ejianc.business.profinance.paysupplement.vo.PaymentSupplementVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"paymentSupplement"})
public class PaymentSupplementController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IPaymentSupplementService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    public CommonResponse<PaymentSupplementVO> saveOrUpdate(@RequestBody PaymentSupplementVO saveOrUpdateVO) {
        PaymentSupplementEntity entity = (PaymentSupplementEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, PaymentSupplementEntity.class));
        if (null == saveOrUpdateVO.getId()) {
            if (entity.getPaymentContractFlag().equals(1)) {
                entity.setContractId(-1L);
            }
            QueryWrapper query = new QueryWrapper();
            query.eq((Object)"project_id", (Object)saveOrUpdateVO.getProjectId());
            query.eq((Object)"contract_id", (Object)saveOrUpdateVO.getContractId());
            query.eq((Object)"supplier_id", (Object)saveOrUpdateVO.getSupplierId());
            query.eq((Object)"payee_id", (Object)saveOrUpdateVO.getPayeeId());
            query.in((Object)"bill_state", Arrays.asList(BillStateEnum.UNCOMMITED_STATE.getBillStateCode(), BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(), BillStateEnum.UNAPPROVED.getBillStateCode(), BillStateEnum.SUSPEND.getBillStateCode(), BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode()));
            List list = this.service.list((Wrapper)query);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                this.logger.error("\u5355\u636e-[{}]\u5b58\u5728\u540c\u4e00\u7ef4\u5ea6\u672a\u751f\u6548\u5355\u636e\uff0c\u4fdd\u5b58\u5931\u8d25\uff01");
                return CommonResponse.error((String)"\u540c\u4e00\u7ef4\u5ea6\u4e0b\u5b58\u5728\u751f\u6548\u5355\u636e\uff0c\u4fdd\u5b58\u5931\u8d25\uff01");
            }
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        PaymentSupplementVO vo = (PaymentSupplementVO)BeanMapper.map((Object)((Object)entity), PaymentSupplementVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    public CommonResponse<PaymentSupplementVO> queryDetail(Long id) {
        PaymentSupplementEntity entity = (PaymentSupplementEntity)((Object)this.service.selectById(id));
        PaymentSupplementVO vo = (PaymentSupplementVO)BeanMapper.map((Object)((Object)entity), PaymentSupplementVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    public CommonResponse<String> delete(@RequestBody List<PaymentSupplementVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    public CommonResponse<IPage<PaymentSupplementVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("payeeName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        ArrayList commonOrgIds = new ArrayList();
        ArrayList<Long> departmentIds = new ArrayList<Long>();
        if (StringUtils.isNotBlank((CharSequence)authOrgIds)) {
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            orgVOList.stream().forEach(org -> {
                if (OrgVO.ORG_TYPE_DEPARTMENT.equals(org.getOrgType())) {
                    departmentIds.add(org.getId());
                } else {
                    commonOrgIds.add(org.getId());
                }
            });
        } else if (OrgVO.ORG_TYPE_DEPARTMENT.equals(InvocationInfoProxy.getOrgType())) {
            departmentIds.add(InvocationInfoProxy.getOrgId());
        } else {
            CommonResponse orgVOListResp = this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId());
            if (!orgVOListResp.isSuccess()) {
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            commonOrgIds.addAll(((List)orgVOListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        }
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PaymentSupplementVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        List voList = BeanMapper.mapList((Iterable)list, PaymentSupplementVO.class);
        voList.forEach(item -> {
            item.setPaymentTypeName(item.getPaymentContractFlag().equals(0) ? "\u6709\u5408\u540c\u4ed8\u6b3e" : "\u65e0\u5408\u540c\u4ed8\u6b3e");
            item.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)item.getBillState()).getDescription());
        });
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("PaymentSupplement-export.xlsx", beans, response);
    }
}

