package com.ejianc.business.financial.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.financial.bean.StampDutyEntity;
import com.ejianc.business.financial.vo.StampDutyDetailVO;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.financial.bean.StampDutyDetailEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 印花税管理-明细表
 * 
 * @author generator
 * 
 */
@Mapper
public interface StampDutyDetailMapper extends BaseCrudMapper<StampDutyDetailEntity> {

    //获取上个季度的有合同签订的项目
    List<StampDutyEntity> selectProjectList();
    //更新明细子表的id
    void updateDetailPid(@Param("projectId") Long projectId, @Param("pid") Long pid);

    //消耗材合同
    List<StampDutyDetailEntity> selectMaterialList();
    //消耗材合同-变更
    List<StampDutyDetailEntity> selectMaterialChangeList();

    List<StampDutyDetailEntity> selectIncomeList();
    List<StampDutyDetailEntity> selectIncomeChangeList();
    List<StampDutyDetailEntity> selectConcreteList();
    List<StampDutyDetailEntity> selectConcreteChangeList();
    List<StampDutyDetailEntity> selectRmatList();
    List<StampDutyDetailEntity> selectRmatChangeList();
    List<StampDutyDetailEntity> selectLaborList();
    List<StampDutyDetailEntity> selectLaborChangeList();
    List<StampDutyDetailEntity> selectProsubList();
    List<StampDutyDetailEntity> selectProsubChangeList();
    List<StampDutyDetailEntity> selectRentList();
    List<StampDutyDetailEntity> selectRentChangeList();
    List<StampDutyDetailEntity> selectAcList();
    List<StampDutyDetailEntity> selectAcChangeList();
    List<StampDutyDetailEntity> selectPurchaseList();
    List<StampDutyDetailEntity> selectPurchaseChangeList();
    List<StampDutyDetailEntity> selectOtherList();
    List<StampDutyDetailEntity> selectOtherChangeList();


    List<StampDutyDetailVO> queryDetailData(Page<StampDutyDetailVO> page, @Param(Constants.WRAPPER)  QueryWrapper wrapper);
}
