package com.ejianc.business.profinance.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.profinance.bean.PaymentRegisterEntity;
import com.ejianc.business.profinance.bean.PayrollRegisterDetailEntity;
import com.ejianc.business.profinance.bean.PayrollRegisterEntity;
import com.ejianc.business.profinance.bean.SalaryPayApplyEntity;
import com.ejianc.business.profinance.enums.PaymentContractEnum;
import com.ejianc.business.profinance.enums.SalaryDetailWorkerPayStateEnum;
import com.ejianc.business.profinance.mapper.PayrollRegisterMapper;
import com.ejianc.business.profinance.service.IPaymentRegisterService;
import com.ejianc.business.profinance.service.IPayrollRegisterDetailService;
import com.ejianc.business.profinance.service.IPayrollRegisterService;
import com.ejianc.business.profinance.service.ISalaryPayApplyService;
import com.ejianc.business.profinance.vo.*;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 工资发放登记主实体
 *
 * @author generator
 *
 */
@Service("payrollRegisterService")
public class PayrollRegisterServiceImpl extends BaseServiceImpl<PayrollRegisterMapper, PayrollRegisterEntity> implements IPayrollRegisterService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IContractPoolApi contractApi;

    private static final String BILL_CODE = "PAYROLL_REGISTER";//此处需要根据实际修改

    private static final String regex = "^\\d{16}|\\d{19}$";
    private static final String IdCardRegex="^\\d{17}[0-9X]";
    private static final String REGISTER_BILL_CODE = "PAYMENT_REGISTER";//此处需要根据实际修改

    @Autowired
    private PayrollRegisterMapper payrollRegisterMapper;

    @Autowired
    private IPayrollRegisterDetailService payrollRegisterDetailService;

    @Autowired
    private ISalaryPayApplyService salaryPayApplyService;

    @Autowired
    private IPaymentRegisterService paymentRegisterService;

    @Autowired
    private CacheManager cacheManager;

    @Value("${common.env.base-host}")
    private String BASE_HOST;


    private final String tenantRootAuth = "TENANT_ROOT_AUTH::";

    @Override
    public PayrollRegisterVO insertOrUpdate(PayrollRegisterVO payrollRegisterVO) {
        PayrollRegisterEntity entity = BeanMapper.map(payrollRegisterVO, PayrollRegisterEntity.class);

        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), payrollRegisterVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(!billCode.isSuccess()) {
                logger.error("保存工人工资单失败，自动生成工资单编码失败: {}", billCode.getMsg());
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            entity.setBillCode(billCode.getData());
        }

        super.saveOrUpdate(entity, false);
        PayrollRegisterVO vo = BeanMapper.map(super.selectById(entity.getId()), PayrollRegisterVO.class);
        return vo;
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }

        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            List<ImportPayrollRegisterDetailVO> successList = new ArrayList<>();
            List<ImportPayrollRegisterDetailVO> errorList = new ArrayList<>();
            if (result != null && result.size() > 0) {
                if (result.get(0).size() != 5) {
                    throw new BusinessException("请按照导入模板导入数据");
                }
                if (result.size()>=10000){
                    throw new BusinessException("文件数据不能超过10000行，超过请分批次多次导入");
                }

                for (int i = 1; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    ImportPayrollRegisterDetailVO detailVO = new ImportPayrollRegisterDetailVO();

                    //班组名称-groupName
                    detailVO.setGroupName(datas.get(0));

                    //姓名-workerName
                    if (StringUtils.isNotBlank(datas.get(1)) && (datas.get(1).length() > 20 || datas.get(1).length() == 1 )) {
                        detailVO.setErrorMessage("姓名填写长度为2~20字");
                    }
                    detailVO.setWorkerName(datas.get(1));

                    //身份证号-workerIdCard
                    if (StringUtils.isNotBlank(datas.get(2)) && !datas.get(2).matches(IdCardRegex)){
                        detailVO.setErrorMessage("填写身份证号错误");
                    }
                    detailVO.setWorkerIdCard(datas.get(2));

                    //实发金额-actualMny
                    if (StringUtils.isNotBlank(datas.get(3))) {
                        try {
                            detailVO.setActualMny(new BigDecimal(datas.get(3)));
                        } catch (Exception e) {
                            detailVO.setErrorMessage("本期实发金额必须为数字");
                        }
                    } else {
                        detailVO.setErrorMessage("本期实发金额为必填项");
                    }

                    //备注-memo
                    if (datas.get(4).length() > 100){
                        detailVO.setErrorMessage("填写备注长度为0~100字");
                    }
                    detailVO.setMemo(datas.get(4));

                    if (StringUtils.isBlank(detailVO.getErrorMessage())) {
                        successList.add(detailVO);
                    }else {
                        errorList.add(detailVO);
                    }
                }
            }
            JSONObject json = new JSONObject();
            json.put("successList", successList);
            json.put("errorList", errorList);
            return CommonResponse.success(json);
        }
    }

    @Override
    public PayrollRegisterVO generatePayrollRegister(SalaryPayApplyVO salaryPayApplyVO, BigDecimal actualTotalPaidTaxMny) {
        PayrollRegisterVO payrollRegisterVO = new PayrollRegisterVO();
        if (null != salaryPayApplyVO){
            payrollRegisterVO.setId(IdWorker.getId());

            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), payrollRegisterVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(!billCode.isSuccess()) {
                logger.error("保存工人工资单失败，自动生成工资单编码失败: {}", billCode.getMsg());
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            payrollRegisterVO.setBillCode(billCode.getData());

            payrollRegisterVO.setOrgId(salaryPayApplyVO.getOrgId());
            payrollRegisterVO.setOrgCode(salaryPayApplyVO.getOrgCode());
            payrollRegisterVO.setOrgName(salaryPayApplyVO.getOrgName());
            payrollRegisterVO.setParentOrgId(salaryPayApplyVO.getParentOrgId());
            payrollRegisterVO.setParentOrgCode(salaryPayApplyVO.getParentOrgCode());
            payrollRegisterVO.setParentOrgName(salaryPayApplyVO.getParentOrgName());
            payrollRegisterVO.setContractId(salaryPayApplyVO.getContractId());
            payrollRegisterVO.setContractCode(salaryPayApplyVO.getContractCode());
            payrollRegisterVO.setContractName(salaryPayApplyVO.getContractName());
            payrollRegisterVO.setContractType(salaryPayApplyVO.getContractSourceType());
            payrollRegisterVO.setProjectId(salaryPayApplyVO.getProjectId());
            payrollRegisterVO.setProjectCode(salaryPayApplyVO.getProjectCode());
            payrollRegisterVO.setProjectName(salaryPayApplyVO.getProjectName());
            payrollRegisterVO.setSupplierId(salaryPayApplyVO.getPaySupplierId());
            payrollRegisterVO.setSupplierName(salaryPayApplyVO.getPaySupplierName());
            payrollRegisterVO.setProvideDate(new Date());
            //直接生成的为总包代发
            payrollRegisterVO.setProvideType(2);
            payrollRegisterVO.setEmployeeId(salaryPayApplyVO.getApplyId());
            payrollRegisterVO.setEmployeeName(salaryPayApplyVO.getApplyName());
            payrollRegisterVO.setDepartmentId(salaryPayApplyVO.getDepartmentId());
            payrollRegisterVO.setDepartmentName(salaryPayApplyVO.getDepartmentName());
            payrollRegisterVO.setMemo(salaryPayApplyVO.getMemo());
            payrollRegisterVO.setTotalActualMny(actualTotalPaidTaxMny);
            payrollRegisterVO.setAccountId(salaryPayApplyVO.getAccountId());
            payrollRegisterVO.setAccountName(salaryPayApplyVO.getAccountName());
            payrollRegisterVO.setAccountNum(salaryPayApplyVO.getAccountNum());
            payrollRegisterVO.setBankName(salaryPayApplyVO.getBankName());
            payrollRegisterVO.setSalaryPayApplyId(salaryPayApplyVO.getId());
            payrollRegisterVO.setContractLinkUrl(salaryPayApplyVO.getContractLinkUrl());
            payrollRegisterVO.setSourceType(0);

            if (CollectionUtils.isNotEmpty(salaryPayApplyVO.getSalaryList())){
                List<PayrollRegisterDetailVO> payrollRegisterDetailVOList = new ArrayList<>();
                for (SalaryPayApplyDetailVO salaryPayApplyDetailVO : salaryPayApplyVO.getSalaryList()) {
                    PayrollRegisterDetailVO payrollRegisterDetailVO = new PayrollRegisterDetailVO();
                    payrollRegisterDetailVO.setPayrollRegisterId(payrollRegisterVO.getId());
                    payrollRegisterDetailVO.setGroupId(salaryPayApplyDetailVO.getGroupId());
                    payrollRegisterDetailVO.setGroupCode(salaryPayApplyDetailVO.getGroupCode());
                    payrollRegisterDetailVO.setGroupName(salaryPayApplyDetailVO.getGroupName());
                    payrollRegisterDetailVO.setWorkerId(salaryPayApplyDetailVO.getWorkerId());
                    payrollRegisterDetailVO.setWorkerCode(salaryPayApplyDetailVO.getWorkerCode());
                    payrollRegisterDetailVO.setWorkerName(salaryPayApplyDetailVO.getWorkerName());
                    payrollRegisterDetailVO.setWorkerIdCard(salaryPayApplyDetailVO.getWorkerIdCard());
                    payrollRegisterDetailVO.setActualMny(salaryPayApplyDetailVO.getWorkerActualPaidTaxMny());
                    payrollRegisterDetailVO.setMemo(salaryPayApplyDetailVO.getWorkerMemo());
                    payrollRegisterDetailVO.setSourceId(salaryPayApplyDetailVO.getId());
                    payrollRegisterDetailVO.setSourcePayApplyId(salaryPayApplyVO.getId());
                    payrollRegisterDetailVOList.add(payrollRegisterDetailVO);
                }
                payrollRegisterVO.setPayrollRegisterDetailList(payrollRegisterDetailVOList);
            }
            super.saveOrUpdate(BeanMapper.map(payrollRegisterVO, PayrollRegisterEntity.class), false);
        }
        return payrollRegisterVO;
    }

    /**
     * 查询当前支付申请单下所有的 工资发放登记单（包含重发）
     * @param page
     * @param salaryPayApplyId
     * @return
     */
    @Override
    public IPage<PayrollRegisterVO> queryPayrollRegisterList(Page<PayrollRegisterVO> page, Long salaryPayApplyId) {
        SalaryPayApplyEntity salaryPayApplyEntity = salaryPayApplyService.selectById(salaryPayApplyId);
        List<Long> ids = new ArrayList<>();
        if (null != salaryPayApplyEntity){
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("bill_code_old", new Parameter(QueryParam.EQ, salaryPayApplyEntity.getBillCode()));
            List<SalaryPayApplyEntity> salaryPayApplyEntityList = salaryPayApplyService.queryList(queryParam);
            salaryPayApplyEntityList.add(salaryPayApplyEntity);
            ids = salaryPayApplyEntityList.stream().map(SalaryPayApplyEntity::getId).collect(Collectors.toList());
        }
        return payrollRegisterMapper.selectListByPayApplyId(page, ids);
    }

    /**
     * 批量生成工资发放登记
     * 财务推送，自动新增，不可撤回
     * @param sucList 支付状态为已支付的 支付申请子表杰
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void generateBatchPayrollRegister(List<SalaryPayApplyDetailVO> sucList) {
        if (CollectionUtils.isNotEmpty(sucList)){
            logger.info("工资支付申请开始生成工资发放登记单：sucList----{}", JSONObject.toJSONString(sucList));
            Map<Long, List<SalaryPayApplyDetailVO>> detailMap = new LinkedHashMap<>();
            for (SalaryPayApplyDetailVO detail : sucList) {
                if (detailMap.containsKey(detail.getPid())){
                    detailMap.get(detail.getPid()).add(detail);
                }else {
                    List<SalaryPayApplyDetailVO> salaryPayApplyDetailEntityList = new ArrayList<>();
                    salaryPayApplyDetailEntityList.add(detail);
                    detailMap.put(detail.getPid(), salaryPayApplyDetailEntityList);
                }
            }
            List<Long> pidList = sucList.stream().map(SalaryPayApplyDetailVO::getPid).distinct().collect(Collectors.toList());
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("id", new Parameter(QueryParam.IN, pidList));
            List<SalaryPayApplyEntity> salaryPayApplyEntityList = salaryPayApplyService.queryList(queryParam);
            if (CollectionUtils.isNotEmpty(salaryPayApplyEntityList)) {
                List<SalaryPayApplyVO> salaryPayApplyVOList = BeanMapper.mapList(salaryPayApplyEntityList, SalaryPayApplyVO.class);
                for (SalaryPayApplyVO salaryPayApplyVO : salaryPayApplyVOList) {
                    if (detailMap.containsKey(salaryPayApplyVO.getId())) {
                        salaryPayApplyVO.setSalaryList(detailMap.get(salaryPayApplyVO.getId()));
                    }
                }
                //获取模拟登陆对象
                Long tenantId = sucList.get(0).getTenantId();
                String authority = getAuthority(tenantId);
                try {
                    if(StringUtils.isBlank(authority)) {
                        logger.error("根据工资支付申请单子表- [{}], 获取模拟登录失败，无法生成付款登记单！", JSONObject.toJSONString(sucList.get(0)));
                        return;
                    }
                    InvocationInfoProxy.setTenantid(tenantId);
                    String key = "userCode";
                    int idx = authority.indexOf(";" + key + "=");
                    if (idx >= 0) {
                        String tmp = authority.substring(idx + 1);
                        InvocationInfoProxy.setUsercode(tmp.substring(0, tmp.indexOf(";")).replace(key + "=", ""));
                    }
                    InvocationInfoProxy.setExtendAttribute("authority", authority);


                    List<PayrollRegisterVO> payrollRegisterVOList = new ArrayList<>();
                    logger.info("生成工资发放登记数据-{}", JSONObject.toJSONString(salaryPayApplyVOList));
                    //批量初始化发放登记表
                    for (SalaryPayApplyVO salaryPayApplyVO : salaryPayApplyVOList) {
                        if (null != salaryPayApplyVO){
                            PayrollRegisterVO payrollRegisterVO = new PayrollRegisterVO();
                            payrollRegisterVO.setId(IdWorker.getId());
                            payrollRegisterVO.setOrgId(salaryPayApplyVO.getOrgId());
                            payrollRegisterVO.setTenantId(salaryPayApplyVO.getTenantId());
                            payrollRegisterVO.setOrgCode(salaryPayApplyVO.getOrgCode());
                            payrollRegisterVO.setOrgName(salaryPayApplyVO.getOrgName());

                            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), payrollRegisterVO);
                            Map<String, String> reqParams = JSONObject.parseObject(JSONObject.toJSONString(billCodeParam), Map.class);
                            Map<String, String> headers = new HashMap<>();
                            headers.put("authority", authority);
                            headers.put("Content-Type", "application/json;charset=UTF-8");

                            logger.info("支付结果核销，生成发放登记编码参数：{}", JSONObject.toJSONString(billCodeParam));
                            String url = BASE_HOST + "ejc-support-web/api/billCodeApi/generateBillCode";
                            String codeRespStr = HttpTookit.postByJson(url, JSONObject.toJSONString(reqParams), headers, 10000, 10000);
                            logger.info("获取发放登记编码结果：{}", codeRespStr);
                            CommonResponse codeResp = JSONObject.parseObject(codeRespStr, CommonResponse.class);
                            if(!codeResp.isSuccess()) {
                                logger.error("生成发放登记失败，自动生成发放登记单编码失败: {}", codeRespStr);
                                return;
                            }

                            payrollRegisterVO.setBillCode(codeResp.getData().toString());
                            //工资发放登记单生成为审批通过的
                            payrollRegisterVO.setBillState(BillStateEnum.PASSED_STATE.getBillStateCode());

                            payrollRegisterVO.setParentOrgId(salaryPayApplyVO.getParentOrgId());
                            payrollRegisterVO.setParentOrgCode(salaryPayApplyVO.getParentOrgCode());
                            payrollRegisterVO.setParentOrgName(salaryPayApplyVO.getParentOrgName());
                            payrollRegisterVO.setContractId(salaryPayApplyVO.getContractId());
                            payrollRegisterVO.setContractCode(salaryPayApplyVO.getContractCode());
                            payrollRegisterVO.setContractName(salaryPayApplyVO.getContractName());
                            payrollRegisterVO.setContractType("laborSub");
                            payrollRegisterVO.setProjectId(salaryPayApplyVO.getProjectId());
                            payrollRegisterVO.setProjectCode(salaryPayApplyVO.getProjectCode());
                            payrollRegisterVO.setProjectName(salaryPayApplyVO.getProjectName());
                            payrollRegisterVO.setSupplierId(salaryPayApplyVO.getPaySupplierId());
                            payrollRegisterVO.setSupplierName(salaryPayApplyVO.getPaySupplierName());
                            payrollRegisterVO.setProvideDate(new Date());
                            //直接生成的为总包代发
                            payrollRegisterVO.setProvideType(2);
                            payrollRegisterVO.setEmployeeId(salaryPayApplyVO.getApplyId());
                            payrollRegisterVO.setEmployeeName(salaryPayApplyVO.getApplyName());
                            payrollRegisterVO.setDepartmentId(salaryPayApplyVO.getDepartmentId());
                            payrollRegisterVO.setDepartmentName(salaryPayApplyVO.getDepartmentName());
                            payrollRegisterVO.setMemo(salaryPayApplyVO.getMemo());

                            payrollRegisterVO.setAccountId(salaryPayApplyVO.getAccountId());
                            payrollRegisterVO.setAccountName(salaryPayApplyVO.getAccountName());
                            payrollRegisterVO.setAccountNum(salaryPayApplyVO.getAccountNum());
                            payrollRegisterVO.setBankName(salaryPayApplyVO.getBankName());

                            //设置支付申请id、code
                            payrollRegisterVO.setSalaryPayApplyId(salaryPayApplyVO.getId());
                            payrollRegisterVO.setSalaryPayApplyCode(salaryPayApplyVO.getBillCode());

                            payrollRegisterVO.setContractLinkUrl(salaryPayApplyVO.getContractLinkUrl());
                            payrollRegisterVO.setSourceType(2);// 财务推送

                            BigDecimal actualTotalPaidTaxMny = BigDecimal.ZERO;
                            if (CollectionUtils.isNotEmpty(salaryPayApplyVO.getSalaryList())){
                                List<PayrollRegisterDetailVO> payrollRegisterDetailVOList = new ArrayList<>();
                                for (SalaryPayApplyDetailVO salaryPayApplyDetailVO : salaryPayApplyVO.getSalaryList()) {
                                    PayrollRegisterDetailVO payrollRegisterDetailVO = new PayrollRegisterDetailVO();
                                    payrollRegisterDetailVO.setPayrollRegisterId(payrollRegisterVO.getId());
                                    payrollRegisterDetailVO.setGroupId(salaryPayApplyDetailVO.getGroupId());
                                    payrollRegisterDetailVO.setGroupCode(salaryPayApplyDetailVO.getGroupCode());
                                    payrollRegisterDetailVO.setGroupName(salaryPayApplyDetailVO.getGroupName());
                                    payrollRegisterDetailVO.setWorkerId(salaryPayApplyDetailVO.getWorkerId());
                                    if(SalaryDetailWorkerPayStateEnum.支付失败.getCode().equals(salaryPayApplyDetailVO.getWorkerPayState().toString())) {
                                        //如果当前支付状态为失败，则将金额置为负值
                                        salaryPayApplyDetailVO.setWorkerActualPaidTaxMny(salaryPayApplyDetailVO.getWorkerApplyTaxMny().negate());
                                    }
                                    payrollRegisterDetailVO.setWorkerCode(salaryPayApplyDetailVO.getWorkerCode());
                                    payrollRegisterDetailVO.setWorkerName(salaryPayApplyDetailVO.getWorkerName());
                                    payrollRegisterDetailVO.setWorkerIdCard(salaryPayApplyDetailVO.getWorkerIdCard());
                                    payrollRegisterDetailVO.setActualMny(salaryPayApplyDetailVO.getWorkerActualPaidTaxMny());
                                    payrollRegisterDetailVO.setMemo(salaryPayApplyDetailVO.getWorkerMemo());
                                    payrollRegisterDetailVO.setSourceId(salaryPayApplyDetailVO.getId());
                                    payrollRegisterDetailVO.setSourcePayApplyId(salaryPayApplyVO.getId());
                                    payrollRegisterDetailVOList.add(payrollRegisterDetailVO);
                                    actualTotalPaidTaxMny = actualTotalPaidTaxMny.add(salaryPayApplyDetailVO.getWorkerActualPaidTaxMny());
                                }
                                payrollRegisterVO.setPayrollRegisterDetailList(payrollRegisterDetailVOList);
                            }
                            payrollRegisterVO.setTotalActualMny(actualTotalPaidTaxMny);

                            //增加此字段，判断非总包代发不推送付款登记   payType; // 支付类型(1：总包代发，2：劳务班组垫付，3：劳务公司直发)
                            payrollRegisterVO.setPayType(salaryPayApplyVO.getPayType());

                            payrollRegisterVOList.add(payrollRegisterVO);
                        }
                    }
                    List<PayrollRegisterDetailVO> payrollRegisterDetailVOList = new ArrayList<>();
                    for (PayrollRegisterVO payrollRegisterVO : payrollRegisterVOList) {
                        if (CollectionUtils.isNotEmpty(payrollRegisterVO.getPayrollRegisterDetailList())){
                            payrollRegisterDetailVOList.addAll(payrollRegisterVO.getPayrollRegisterDetailList());
                        }
                    }
                    super.saveOrUpdateBatch(BeanMapper.mapList(payrollRegisterVOList, PayrollRegisterEntity.class), payrollRegisterVOList.size(), false);
                    payrollRegisterDetailService.saveOrUpdateBatch(BeanMapper.mapList(payrollRegisterDetailVOList, PayrollRegisterDetailEntity.class), payrollRegisterDetailVOList.size(), false);

                    logger.info("生成工资发放登记成功，继而生成付款登记");
                    //根据 工资支付申请生成的 工资发放登记单 生成 付款登记
                    this.generatePaymentRegister(payrollRegisterVOList);

                } catch (Exception e) {
                    logger.error("根据付款申请单- [{}], 生成付款登记单异常！", JSONObject.toJSONString(sucList.get(0)), e);
                }
            }
        }

    }



    /**
     * 工资发放登记生成付款登记
     * @param payrollRegisterVOList
     */
    @Override
    public void generatePaymentRegister(List<PayrollRegisterVO> payrollRegisterVOList) {
        try {
            //测试用
            if (CollectionUtils.isEmpty(payrollRegisterVOList)){
                QueryParam queryParam1 = new QueryParam();
                List<Long> contactIdList1 = new ArrayList<>();
                contactIdList1.add(1542056874833813506L);
                contactIdList1.add(561292423826391102L);

                queryParam1.getParams().put("contractId", new Parameter(QueryParam.IN, contactIdList1));
                payrollRegisterVOList = BeanMapper.mapList(super.queryList(queryParam1), PayrollRegisterVO.class);
                logger.info(JSONObject.toJSONString(payrollRegisterVOList));
            }

            logger.info("进入工资发放登记生成付款登记generatePaymentRegister方法-------------->begin");

            logger.info("接收参数-工资发放登记数据集合payrollRegisterVOList：{}", JSONObject.toJSONString(payrollRegisterVOList));
            List<PaymentRegisterEntity> paymentRegisterList = new ArrayList<>();
            //获取发放登记合同id
            List<Long> contactIdList = payrollRegisterVOList.stream().map(PayrollRegisterVO::getContractId).collect(Collectors.toList());
            logger.info("对应合同id集合：{}", contactIdList);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, payrollRegisterVOList.get(0).getTenantId()));
            queryParam.getParams().put("contractId", new Parameter(QueryParam.IN, contactIdList));
            logger.info("支付结果核销，获取合同信息参数：{}", JSONObject.toJSONString(queryParam));



            String authority = getAuthority(payrollRegisterVOList.get(0).getTenantId());
            logger.info("authority:{}", authority);
            Map<String, String> headers = new HashMap<>();
            headers.put("authority", authority);
            headers.put("Content-Type", "application/json;charset=UTF-8");

            String url = BASE_HOST + "ejc-contractbase-web/api/contractpool/queryList";
            String contractData = HttpTookit.postByJson(url, JSONObject.toJSONString(queryParam), headers, 10000, 10000);
            logger.info("获取合同信息结果：{}", contractData);
            CommonResponse contractListData = JSONObject.parseObject(contractData, CommonResponse.class);
            if(!contractListData.isSuccess()) {
                logger.error("生成付款登记失败，获取合同池信息失败: {}", contractListData);
                return;
            }

            Map<Long, ContractPoolVO> contractMap = new HashMap<>();
            if (contractListData.isSuccess()) {
                List<ContractPoolVO> contractList = JSONArray.parseArray(JSONObject.toJSONString(contractListData.getData())).toJavaList(ContractPoolVO.class);
                contractMap = contractList.stream().collect(Collectors.toMap(ContractPoolVO::getId, Function.identity(), (key1, key2) -> key2));
            }else {
                logger.info("合同池未查询到合同数据！");
                logger.error(contractListData.getMsg());
            }
            logger.info("工资发放登记的合同id集合：{}", JSONObject.toJSONString(contactIdList));
            if (null != contractMap){
                logger.info("根据合同id查到的合同集合contractMap：{}", JSONObject.toJSONString(contractMap));
            }

            for (PayrollRegisterVO sourceVO : payrollRegisterVOList) {
                if (sourceVO.getPayType() == null || sourceVO.getPayType() == 1) {
                    //登记单
                    PaymentRegisterVO register = BeanMapper.map(sourceVO, PaymentRegisterVO.class);
                    //来源
                    register.setSourceType("工人工资");
                    register.setSourceId(sourceVO.getId());
                    register.setSourceCode(sourceVO.getBillCode());
                    //合同类别
                    register.setSourceCategoryType(contractMap.get(sourceVO.getContractId()).getSourceType());
                    register.setSourceCategoryTypeName(contractMap.get(sourceVO.getContractId()).getSourceTypeName());
                    register.setContractCategoryId(contractMap.get(sourceVO.getContractId()).getCategoryId());
                    register.setContractCategoryName(contractMap.get(sourceVO.getContractId()).getCategoryName());
                    //合同金额
                    register.setContractTaxMny(contractMap.get(sourceVO.getContractId()).getContractTaxMny());
                    register.setContractMny(contractMap.get(sourceVO.getContractId()).getContractMny());
                    register.setAlreadyPayMny(BigDecimal.ZERO);
                    register.setPayMny(sourceVO.getTotalActualMny());

                    register.setPaymentDate(sourceVO.getProvideDate());

                    register.setPaymentReason(sourceVO.getMemo());
                    register.setPaymentContractFlag(PaymentContractEnum.有合同.getCode());


                    register.setId(IdWorker.getId());

                    BillCodeParam billCodeParam = BillCodeParam.build(REGISTER_BILL_CODE, InvocationInfoProxy.getTenantid(), register);
                    Map<String, String> reqCodeParams = JSONObject.parseObject(JSONObject.toJSONString(billCodeParam), Map.class);
                    Map<String, String> codeHeaders = new HashMap<>();
                    codeHeaders.put("authority", authority);
                    codeHeaders.put("Content-Type", "application/json;charset=UTF-8");

                    logger.info("支付结果核销，生成付款登记编码参数：{}", JSONObject.toJSONString(billCodeParam));
                    String codeUrl = BASE_HOST + "ejc-support-web/api/billCodeApi/generateBillCode";
                    String codeRespStr = HttpTookit.postByJson(codeUrl, JSONObject.toJSONString(reqCodeParams), codeHeaders, 10000, 10000);
                    logger.info("获取付款登记编码结果：{}", codeRespStr);
                    CommonResponse codeResp = JSONObject.parseObject(codeRespStr, CommonResponse.class);
                    if (!codeResp.isSuccess()) {
                        logger.error("生成付款登记失败，自动生成付款登记单编码失败: {}", codeRespStr);
                        return;
                    }

                    register.setBillCode(codeResp.getData().toString());

                    logger.info("付款登记信息-{}，工资发放登记单信息{}", JSONObject.toJSONString(register), JSONObject.toJSONString(sourceVO));

                    paymentRegisterList.add(BeanMapper.map(register, PaymentRegisterEntity.class));
                }
            }

            if (CollectionUtils.isNotEmpty(paymentRegisterList)) {
                paymentRegisterService.saveOrUpdateBatch(paymentRegisterList, paymentRegisterList.size(), false);
            }
            logger.info("工资发放登记生成付款登记generatePaymentRegister方法-------------->end");
        } catch (Exception e) {
            e.printStackTrace();
        }

    }


    public String getAuthority(Long tenantId) {
        String authority = cacheManager.get(tenantRootAuth + tenantId.toString());

        if(StringUtils.isBlank(authority)) {
            try {
                Map<String, Object> params = new HashMap<>();
                params.put("tenantId", tenantId);
                logger.info("baseHost " + BASE_HOST);

                Map<String, String> headers = new HashMap<>();
                headers.put("Content-Type", "application/json;charset=UTF-8");

                String back = HttpTookit.get(BASE_HOST + "ejc-idm-web/user/context/getBytenantid", params, headers);
                JSONObject jsonBack = JSONObject.parseObject(back);
                if (jsonBack.get("data") != null) {
                    JSONObject data = (JSONObject) jsonBack.get("data");
                    logger.info("data  " + data.toJSONString());
                    if (data.get("userContext") != null) {
                        JSONObject userContext = (JSONObject) data.get("userContext");
                        authority = "userType=" + userContext.getString("userType") + ";userCode="
                                + userContext.getString("userCode") +
                                ";orgId=" + userContext.getString("orgId") +
                                ";tenantid=" + userContext.getString("tenantid") + ";token="
                                + userContext.getString("token") + ";u_logints=" + userContext.getString("u_logints")
                                + ";u_usercode=" + userContext.getString("u_usercode") + ";userId="
                                + userContext.getString("userId");

                        cacheManager.setex(tenantRootAuth + tenantId.toString(), authority, 25 * 60);
                    }
                }
            } catch (Exception e) {
                logger.error("模拟登录异常: ", e);
                return null;
            }
        }
        return authority;
    }
}
