/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.performance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.financeintegration.PMPerformance.api.IPMPerformanceApi;
import com.ejianc.business.financeintegration.PMPerformance.vo.PMPerformanceReceiptVO;
import com.ejianc.business.financeintegration.PMPerformance.vo.PMPerformanceVO;
import com.ejianc.business.performance.bean.PerformanceContractEntity;
import com.ejianc.business.performance.bean.PerformanceDeductedEntity;
import com.ejianc.business.performance.bean.PerformanceRecordEntity;
import com.ejianc.business.performance.mapper.PerformanceDeductedMapper;
import com.ejianc.business.performance.service.IPerformanceContractService;
import com.ejianc.business.performance.service.IPerformanceDeductedService;
import com.ejianc.business.performance.service.IPerformanceRecordService;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="performanceDeductedService")
public class PerformanceDeductedServiceImpl
extends BaseServiceImpl<PerformanceDeductedMapper, PerformanceDeductedEntity>
implements IPerformanceDeductedService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPerformanceRecordService performanceRecordService;
    @Autowired
    private IPerformanceContractService contractService;
    @Autowired
    private IPMPerformanceApi performanceApi;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void handMQMessageReceipt(String receiptResultMsg) {
        this.logger.info("\u83b7\u53d6\u6536\u6b3e\u5355\u6570\u636e\uff0c\u5f00\u59cb\u751f\u6210\u6263\u6b3e\u5355--begin\uff01");
        if (StringUtils.isNotBlank((CharSequence)receiptResultMsg)) {
            List resultList = JSONObject.parseArray((String)receiptResultMsg, PMPerformanceReceiptVO.class);
            this.logger.info("\u63a5\u6536\u4e00\u5efa\u8d22\u52a1\u7cfb\u7edf\u7684\u5c65\u7ea6\u4fdd\u8bc1\u91d1\u6536\u6b3e\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)resultList));
            if (CollectionUtils.isNotEmpty((Collection)resultList)) {
                ArrayList<PerformanceRecordEntity> saveList = new ArrayList<PerformanceRecordEntity>();
                ArrayList<String> cwBillCodeList = new ArrayList<String>();
                for (PMPerformanceReceiptVO pmPerformanceReceiptVO : resultList) {
                    PerformanceRecordEntity performanceRecordEntity = new PerformanceRecordEntity();
                    performanceRecordEntity.setProjectId(Long.getLong(pmPerformanceReceiptVO.getProjectId()));
                    performanceRecordEntity.setBillCode(pmPerformanceReceiptVO.getBillCode());
                    performanceRecordEntity.setMny(pmPerformanceReceiptVO.getMny());
                    performanceRecordEntity.setHxMny(pmPerformanceReceiptVO.getHxMny());
                    performanceRecordEntity.setSkMny(pmPerformanceReceiptVO.getSkMny());
                    performanceRecordEntity.setBillDate(pmPerformanceReceiptVO.getCreateTime());
                    cwBillCodeList.add(pmPerformanceReceiptVO.getBillCode());
                    saveList.add(performanceRecordEntity);
                }
                this.performanceRecordService.saveOrUpdateBatch(saveList);
                QueryParam queryParam = new QueryParam();
                queryParam.getParams().put("receiveBillCode", new Parameter("in", cwBillCodeList));
                List performanceDeductedEntities = super.queryList(queryParam);
                Map<String, PerformanceDeductedEntity> collect = new HashMap<String, PerformanceDeductedEntity>();
                if (CollectionUtils.isNotEmpty((Collection)performanceDeductedEntities)) {
                    collect = performanceDeductedEntities.stream().collect(Collectors.toMap(PerformanceDeductedEntity::getReceiveBillCode, Function.identity(), (v1, v2) -> v2));
                }
                this.createDeductedByResultList(resultList, collect);
            }
        }
        this.logger.info("\u83b7\u53d6\u6536\u6b3e\u5355\u6570\u636e\uff0c\u5f00\u59cb\u751f\u6210\u6263\u6b3e\u5355--end\uff01");
    }

    private void createDeductedByResultList(List<PMPerformanceReceiptVO> resultList, Map<String, PerformanceDeductedEntity> map) {
        for (PMPerformanceReceiptVO pmPerformanceReceiptVO : resultList) {
            if (map.containsKey(pmPerformanceReceiptVO.getBillCode())) continue;
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("billState", new Parameter("in", Arrays.asList(1, 3)));
            queryParam.getParams().put("projectId", new Parameter("eq", (Object)pmPerformanceReceiptVO.getProjectId()));
            queryParam.getParams().put("payType", new Parameter("in", Arrays.asList(1)));
            queryParam.getParams().put("withholdingType", new Parameter("in", Arrays.asList(1)));
            queryParam.getParams().put("performanceBondReturn", new Parameter("in", Arrays.asList(1)));
            List performanceContractEntities = this.contractService.queryList(queryParam);
            if (!CollectionUtils.isNotEmpty((Collection)performanceContractEntities)) continue;
            PerformanceContractEntity performanceContractEntity = (PerformanceContractEntity)((Object)performanceContractEntities.get(0));
            BigDecimal amountDue = performanceContractEntity.getAmountDue();
            QueryParam queryParam1 = new QueryParam();
            queryParam1.getParams().put("projectId", new Parameter("eq", (Object)pmPerformanceReceiptVO.getProjectId()));
            List performanceDeductedEntities = super.queryList(queryParam1);
            BigDecimal receiptMnySum = BigDecimal.ZERO;
            BigDecimal deductedMnySum = BigDecimal.ZERO;
            if (CollectionUtils.isNotEmpty((Collection)performanceDeductedEntities)) {
                deductedMnySum = performanceDeductedEntities.stream().map(PerformanceDeductedEntity::getDeductedMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                receiptMnySum = performanceDeductedEntities.stream().map(PerformanceDeductedEntity::getReceiveMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
            BigDecimal shouldDeductedMny = (receiptMnySum = receiptMnySum.add(pmPerformanceReceiptVO.getMny()).multiply(new BigDecimal("0.1"))).compareTo(amountDue) > 0 ? amountDue : receiptMnySum;
            BigDecimal remainAmount = shouldDeductedMny.subtract(deductedMnySum);
            PerformanceDeductedEntity performanceDeductedEntity = new PerformanceDeductedEntity();
            performanceDeductedEntity.setContractId(performanceContractEntity.getId());
            performanceDeductedEntity.setProjectId(performanceContractEntity.getProjectId());
            performanceDeductedEntity.setProjectCode(performanceContractEntity.getProjectCode());
            performanceDeductedEntity.setProjectName(performanceContractEntity.getProjectName());
            performanceDeductedEntity.setOrgId(performanceContractEntity.getOrgId());
            performanceDeductedEntity.setOrgCode(performanceContractEntity.getOrgCode());
            performanceDeductedEntity.setOrgName(performanceContractEntity.getOrgName());
            performanceDeductedEntity.setParentOrgId(performanceContractEntity.getParentOrgId());
            performanceDeductedEntity.setParentOrgCode(performanceContractEntity.getParentOrgCode());
            performanceDeductedEntity.setParentOrgName(performanceContractEntity.getParentOrgName());
            performanceDeductedEntity.setBillDate(new Date());
            performanceDeductedEntity.setReceiveMny(pmPerformanceReceiptVO.getMny());
            performanceDeductedEntity.setReceiveBillCode(pmPerformanceReceiptVO.getBillCode());
            performanceDeductedEntity.setReceiveBillType("\u8d22\u52a1\u7cfb\u7edf\u6536\u6b3e");
            performanceDeductedEntity.setReceiveDate(pmPerformanceReceiptVO.getCreateTime());
            performanceDeductedEntity.setDeductedMny(remainAmount);
            performanceDeductedEntity.setDeductedPercent(new BigDecimal("10"));
            performanceDeductedEntity.setDeductedType("\u81ea\u52a8\u751f\u6210\u6263\u6b3e\u5355");
            performanceDeductedEntity.setAmountDue(amountDue);
            performanceDeductedEntity.setAlreadyDeductedAmount(deductedMnySum);
            performanceDeductedEntity.setRemainAmount(amountDue.subtract(deductedMnySum));
            super.saveOrUpdate((Object)performanceDeductedEntity, false);
        }
    }

    @Override
    public CommonResponse<String> pushDataToFinance(Long billId) {
        PerformanceDeductedEntity performanceDeductedEntity = (PerformanceDeductedEntity)((Object)super.selectById((Serializable)billId));
        if (performanceDeductedEntity != null) {
            if (performanceDeductedEntity.getPayState() == 2) {
                return CommonResponse.error((String)"\u8be5\u5355\u5df2\u63a8\u9001\u8d22\u52a1\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\uff01");
            }
            ArrayList<PMPerformanceVO> vo = new ArrayList<PMPerformanceVO>();
            PMPerformanceVO performanceVO = new PMPerformanceVO();
            performanceVO.setId(IdWorker.getId() + "");
            performanceVO.setPmBillId(performanceDeductedEntity.getId() + "");
            performanceVO.setProjectId(performanceDeductedEntity.getProjectId() + "");
            performanceVO.setQuoteFlag("N");
            performanceVO.setActualMny(performanceDeductedEntity.getDeductedMny());
            vo.add(performanceVO);
            CommonResponse pmPerformanceVOCommonResponse = this.performanceApi.performanceTakeEffect(vo);
            if (pmPerformanceVOCommonResponse.isSuccess()) {
                performanceDeductedEntity.setPayState(2);
                super.updateById((Object)performanceDeductedEntity);
                return CommonResponse.success((String)"\u63a8\u9001\u8d22\u52a1\u6210\u529f\uff01");
            }
            return CommonResponse.error((String)"\u63a8\u9001\u8d22\u52a1\u5931\u8d25\uff01");
        }
        return CommonResponse.error((String)"\u83b7\u53d6\u5355\u636e\u4fe1\u606f\u5931\u8d25\uff01");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void handMQMessageDeducted(String deductedResultMsg) {
        this.logger.info("\u83b7\u53d6\u6263\u6b3e\u5355\u652f\u4ed8\u6570\u636e--begin\uff01");
        if (StringUtils.isNotBlank((CharSequence)deductedResultMsg)) {
            List resultList = JSONObject.parseArray((String)deductedResultMsg, PMPerformanceVO.class);
            this.logger.info("\u63a5\u6536\u4e00\u5efa\u8d22\u52a1\u7cfb\u7edf\u7684\u5c65\u7ea6\u4fdd\u8bc1\u91d1\u6263\u6b3e\u6570\u636e\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)resultList));
            if (CollectionUtils.isNotEmpty((Collection)resultList)) {
                List deductedIds = resultList.stream().map(PMPerformanceVO::getPmBillId).collect(Collectors.toList());
                QueryParam queryParam = new QueryParam();
                queryParam.getParams().put("id", new Parameter("in", deductedIds));
                List performanceDeductedEntities = super.queryList(queryParam);
                Map collect = performanceDeductedEntities.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity(), (v1, v2) -> v2));
                for (PMPerformanceVO pMPerformanceVO : resultList) {
                    if (!collect.containsKey(Long.parseLong(pMPerformanceVO.getPmBillId()))) continue;
                    PerformanceDeductedEntity performanceDeductedEntity = (PerformanceDeductedEntity)((Object)collect.get(Long.parseLong(pMPerformanceVO.getPmBillId())));
                    if (pMPerformanceVO.getState() == null) continue;
                    if ("1".equals(pMPerformanceVO.getState())) {
                        performanceDeductedEntity.setPayState(3);
                    } else if ("2".equals(pMPerformanceVO.getState())) {
                        performanceDeductedEntity.setPayState(4);
                    }
                    super.updateById((Object)performanceDeductedEntity);
                }
            }
        }
        this.logger.info("\u83b7\u53d6\u6536\u6b3e\u5355\u6570\u636e\uff0c\u5f00\u59cb\u751f\u6210\u6263\u6b3e\u5355--end\uff01");
    }
}

