/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.profinance.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.profinance.bean.RegulateEntity;
import com.ejianc.business.profinance.enums.PaymentContractEnum;
import com.ejianc.business.profinance.plan.service.IPlanContractService;
import com.ejianc.business.profinance.plan.service.IPlanFeeService;
import com.ejianc.business.profinance.plan.service.IPlanMaterialService;
import com.ejianc.business.profinance.plan.service.IPlanService;
import com.ejianc.business.profinance.plan.service.IPlanTemporaryService;
import com.ejianc.business.profinance.service.IPaymentRegisterService;
import com.ejianc.business.profinance.service.IRegulateService;
import com.ejianc.business.profinance.vo.RegulateVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.redisson.api.RList;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"regulate"})
public class RegulateController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private RedissonClient redissonClient;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IRegulateService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IPaymentRegisterService registerService;
    @Autowired
    private IPlanContractService planContractService;
    @Autowired
    private IPlanMaterialService planMaterialService;
    @Autowired
    private IPlanTemporaryService planTemporaryService;
    @Autowired
    private IPlanFeeService planFeeService;
    @Autowired
    private IPlanService planService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<RegulateVO> saveOrUpdate(@RequestBody RegulateVO saveOrUpdateVO) {
        RegulateEntity entity = (RegulateEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, RegulateEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        RegulateVO vo = (RegulateVO)BeanMapper.map((Object)((Object)entity), RegulateVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<RegulateVO> queryDetail(Long id) {
        RegulateEntity entity = (RegulateEntity)((Object)this.service.selectById(id));
        RegulateVO vo = (RegulateVO)BeanMapper.map((Object)((Object)entity), RegulateVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @Transactional(rollbackFor={Exception.class})
    @RequestMapping(value={"/closeByState"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> closeByState(@RequestBody List<RegulateVO> entity) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        List collect = entity.stream().map(item -> item.getId()).collect(Collectors.toList());
        List contractIds = entity.stream().filter(item -> item.getPaymentContractFlag() == 2).map(item -> item.getSourceId()).collect(Collectors.toList());
        List materialIds = entity.stream().filter(item -> item.getPaymentContractFlag() == 3).map(item -> item.getSourceId()).collect(Collectors.toList());
        List temporaryIds = entity.stream().filter(item -> item.getPaymentContractFlag() == 4).map(item -> item.getSourceId()).collect(Collectors.toList());
        List planFeeIds = entity.stream().filter(item -> item.getPaymentContractFlag() == 5).map(item -> item.getSourceId()).collect(Collectors.toList());
        updateWrapper.in((Object)"id", collect);
        if ("\u672a\u5173\u95ed".equals(entity.get(0).getCloseState())) {
            updateWrapper.set((Object)"close_date_time", (Object)new Date());
            updateWrapper.set((Object)"close_user_id", (Object)this.sessionManager.getUserContext().getUserId());
            updateWrapper.set((Object)"close_user_name", (Object)this.sessionManager.getUserContext().getUserName());
            updateWrapper.set((Object)"close_user_code", (Object)this.sessionManager.getUserContext().getUserCode());
            updateWrapper.set((Object)"close_state", (Object)"\u5df2\u5173\u95ed");
        } else {
            updateWrapper.set((Object)"close_date_time", null);
            updateWrapper.set((Object)"close_user_id", null);
            updateWrapper.set((Object)"close_user_name", null);
            updateWrapper.set((Object)"close_user_code", null);
            updateWrapper.set((Object)"close_state", (Object)"\u5df2\u5173\u95ed");
        }
        if (CollectionUtils.isNotEmpty(contractIds)) {
            UpdateWrapper updateContract = new UpdateWrapper();
            updateContract.in((Object)"id", contractIds);
            updateContract.set((Object)"close_state", (Object)"\u5df2\u5173\u95ed");
            this.planContractService.update((Wrapper)updateContract);
        }
        if (CollectionUtils.isNotEmpty(materialIds)) {
            UpdateWrapper updateMate = new UpdateWrapper();
            updateMate.in((Object)"id", materialIds);
            updateMate.set((Object)"close_state", (Object)"\u5df2\u5173\u95ed");
            this.planMaterialService.update((Wrapper)updateMate);
        }
        if (CollectionUtils.isNotEmpty(temporaryIds)) {
            UpdateWrapper updateTem = new UpdateWrapper();
            updateTem.in((Object)"id", temporaryIds);
            updateTem.set((Object)"close_state", (Object)"\u5df2\u5173\u95ed");
            this.planTemporaryService.update((Wrapper)updateTem);
        }
        if (CollectionUtils.isNotEmpty(planFeeIds)) {
            UpdateWrapper updateFee = new UpdateWrapper();
            updateFee.in((Object)"id", planFeeIds);
            updateFee.set((Object)"close_state", (Object)"\u5df2\u5173\u95ed");
            this.planFeeService.update((Wrapper)updateFee);
        }
        this.service.update((Wrapper)updateWrapper);
        return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<RegulateVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (RegulateVO regulateVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        JSONObject resp = new JSONObject();
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter("eq", (Object)orgId));
        } else {
            CommonResponse orgResp = this.iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            param.getParams().put("parentOrgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        Map<String, BigDecimal> map = this.service.fetchTotalMny(param);
        param.getOrderMap().put("create_time", "asc");
        IPage page = this.service.queryPage(param, false);
        List vos = BeanMapper.mapList((Iterable)page.getRecords(), RegulateVO.class);
        resp.put("current", (Object)page.getCurrent());
        resp.put("size", (Object)page.getSize());
        resp.put("pages", (Object)page.getPages());
        resp.put("total", (Object)page.getTotal());
        resp.put("records", (Object)vos);
        resp.put("totalPlanPayMny", (Object)map.get("totalPlanPayMny"));
        resp.put("totalPaidMny", (Object)map.get("totalPaidMny"));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)resp);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        CommonResponse<JSONObject> commonResponse = this.queryList(param);
        List paymentRegisterVOList = new ArrayList();
        if (null != commonResponse.getData() && CollectionUtils.isNotEmpty(paymentRegisterVOList = (List)((JSONObject)commonResponse.getData()).get((Object)"records"))) {
            for (RegulateVO paymentRegisterVO : paymentRegisterVOList) {
                paymentRegisterVO.setPaymentContractFlagName(PaymentContractEnum.getByCode((Integer)paymentRegisterVO.getPaymentContractFlag()).getName());
            }
        }
        HashMap beans = new HashMap();
        beans.put("records", paymentRegisterVOList);
        ExcelExport.getInstance().export("Regulate-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refRegulateData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<RegulateVO>> refRegulateData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.setSearchObject(searchObject);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("sourceBillCode");
        Long orgId = InvocationInfoProxy.getOrgId();
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter("eq", (Object)orgId));
        } else {
            CommonResponse orgResp = this.iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            param.getParams().put("parentOrgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("unpaidMny", new Parameter("gt", (Object)0));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            String excludeIdStr;
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (_con.containsKey((Object)"projectId")) {
                param.getParams().put("projectId", new Parameter("eq", _con.get((Object)"projectId")));
            }
            if (_con.containsKey((Object)"supplierId")) {
                String supplierId = _con.getString("supplierId");
                param.getParams().put("", new Parameter("sql", (Object)(" (supplier_user_id= '" + supplierId + "'or supplier_org_id ='" + supplierId + "')")));
            }
            if (_con.containsKey((Object)"paymentContractFlag")) {
                param.getParams().put("paymentContractFlag", new Parameter("eq", _con.get((Object)"paymentContractFlag")));
                String paymentContractFlag = _con.getString("paymentContractFlag");
                if ("5".equals(paymentContractFlag) && _con.containsKey((Object)"feeTypeId") && _con.get((Object)"feeTypeId") != null) {
                    param.getParams().put("feeTypeId", new Parameter("eq", _con.get((Object)"feeTypeId")));
                }
            }
            if (StringUtils.isNotBlank((CharSequence)(excludeIdStr = _con.getString("excludeIds")))) {
                param.getParams().put("sourceId", new Parameter("not_in", (Object)Lists.newArrayList((Object[])excludeIdStr.split(","))));
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), RegulateVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @PostMapping(value={"/regulateData"})
    @ResponseBody
    public CommonResponse<Map<String, List<RegulateVO>>> regulateData(@RequestBody JSONObject jsonObject) {
        HashMap<String, List> data = new HashMap<String, List>();
        if (!jsonObject.containsKey((Object)"key")) {
            throw new BusinessException("\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String key = jsonObject.getString("key");
        RList regulateList = this.redissonClient.getList(key);
        if (CollectionUtils.isEmpty((Collection)regulateList) && jsonObject.containsKey((Object)"ids")) {
            List ids = jsonObject.getJSONArray("ids").toJavaList(Long.class);
            Collection pls = this.service.listByIds(ids);
            this.checkRefStatus(pls);
            regulateList.addAll((Collection)BeanMapper.mapList((Iterable)pls, RegulateVO.class));
            regulateList.expire(Long.parseLong("5"), TimeUnit.MINUTES);
        } else {
            this.checkRefStatus(BeanMapper.mapList((Iterable)regulateList, RegulateEntity.class));
        }
        data.put(key, BeanMapper.mapList((Iterable)this.redissonClient.getList(key), RegulateVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", data);
    }

    private void checkRefStatus(Collection<RegulateEntity> entities) {
        for (RegulateEntity entity : entities) {
            if (entity.getRefStatus() == null || !"\u5f15\u7528".equals(entity.getRefStatus())) continue;
            throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff01\u8be5\u6570\u636e\u5b58\u5728\u672a\u751f\u6548\u7684\u3010\u4ed8\u6b3e\u767b\u8bb0\u3011\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u786e\u8ba4\u652f\u4ed8");
        }
    }
}

