/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.profinance.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.profinance.plan.bean.PlanTemporaryEntity;
import com.ejianc.business.profinance.plan.mapper.PlanTemporaryMapper;
import com.ejianc.business.profinance.plan.service.IPlanTemporaryService;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service(value="planTemporaryService")
public class PlanTemporaryServiceImpl
extends BaseServiceImpl<PlanTemporaryMapper, PlanTemporaryEntity>
implements IPlanTemporaryService {
    private static final String TEMPORARY_SETTLE_ID = "temporary_settle_id";

    @Override
    public void updateBillState(Long planId, Integer billStateCode) {
        LambdaUpdateWrapper updateWrapper = Wrappers.lambdaUpdate();
        updateWrapper.eq(PlanTemporaryEntity::getPlanId, (Object)planId);
        updateWrapper.set(PlanTemporaryEntity::getBillState, (Object)billStateCode);
        updateWrapper.set(PlanTemporaryEntity::getBillStateName, (Object)BillStateEnum.getEnumByStateCode((Integer)billStateCode).getDescription());
        super.update((Wrapper)updateWrapper);
    }

    @Override
    public Map<String, Object> fetchTemporaryValue(Collection<Long> settleIds) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        QueryWrapper queryWrapper = Wrappers.query();
        queryWrapper.in((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        queryWrapper.in((Object)TEMPORARY_SETTLE_ID, settleIds);
        queryWrapper.groupBy((Object[])new String[]{TEMPORARY_SETTLE_ID});
        queryWrapper.select(new String[]{"temporary_settle_id as temporarySettleId,ifnull(sum(temporary_plan_payment_mny), 0) as temporaryAppliedMny"});
        List resultMap = super.listMaps((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)resultMap)) {
            return this.converToMap(resultMap);
        }
        return result;
    }

    private Map<String, Object> converToMap(List<Map<String, Object>> listMap) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        for (Map<String, Object> map : listMap) {
            if (resultMap.containsKey(map.get("temporarySettleId").toString())) continue;
            resultMap.put(map.get("temporarySettleId").toString(), map.get("temporaryAppliedMny").toString());
        }
        return resultMap;
    }
}

