package com.ejianc.business.performance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.financeintegration.PMPerformance.api.IPMPerformanceReturnApi;
import com.ejianc.business.financeintegration.PMPerformance.vo.PMPerformanceReturnVO;
import com.ejianc.business.financeintegration.PMPerformance.vo.PMPerformanceVO;
import com.ejianc.business.performance.bean.PerformanceDeductedEntity;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.performance.mapper.PerformanceReturnMapper;
import com.ejianc.business.performance.bean.PerformanceReturnEntity;
import com.ejianc.business.performance.service.IPerformanceReturnService;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 履约保证金退还
 * 
 * @author generator
 * 
 */
@Service("performanceReturnService")
public class PerformanceReturnServiceImpl extends BaseServiceImpl<PerformanceReturnMapper, PerformanceReturnEntity> implements IPerformanceReturnService{

    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IPMPerformanceReturnApi performanceApi;
    @Override
    public CommonResponse<String> pushDataToFinance(Long billId){
        PerformanceReturnEntity performanceReturnEntity = super.selectById(billId);
        if (performanceReturnEntity != null) {
            if (performanceReturnEntity.getPayState() == 2) {
                return CommonResponse.error("该单已推送财务，请勿重复操作！");
            }
            List<PMPerformanceReturnVO> vo = new ArrayList<>();

            PMPerformanceReturnVO performanceVO = new PMPerformanceReturnVO();
            performanceVO.setId(IdWorker.getId()+"");
            performanceVO.setPmBillId(performanceReturnEntity.getId()+"");
            performanceVO.setProjectId(performanceReturnEntity.getProjectId()+ "");
            performanceVO.setQuoteFlag("N");
//            performanceVO.setCreateTime();
            performanceVO.setActualMny(performanceReturnEntity.getAmountReturn());
            vo.add(performanceVO);

            //执行推送操作
            CommonResponse<PMPerformanceReturnVO> pmPerformanceVOCommonResponse = performanceApi.performanceReturnTakeEffect(vo);
            if (pmPerformanceVOCommonResponse.isSuccess()) {
                //更改推送状态
                performanceReturnEntity.setPayState(2);
                super.updateById(performanceReturnEntity);

                return CommonResponse.success("推送财务成功！");
            }else{
                return CommonResponse.error("推送财务失败！");
            }
        }else {
            return CommonResponse.error("获取单据信息失败！");
        }

    }

    //履约保证金扣款数据支付状态处理
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void handMQMessageReturn(String deductedResultMsg) {
        /*
            获取要更新状态的数据
         */
        logger.info("获取扣款单支付数据--begin！");
        if (StringUtils.isNotBlank(deductedResultMsg)){
            List<PMPerformanceVO> resultList = JSONObject.parseArray(deductedResultMsg, PMPerformanceVO.class);
            logger.info("接收一建财务系统的履约保证金扣款数据结果：{}", JSONObject.toJSONString(resultList));
            if (CollectionUtils.isNotEmpty(resultList)){
                //
                List<String> deductedIds = resultList.stream().map(PMPerformanceVO::getPmBillId).collect(Collectors.toList());
                QueryParam queryParam = new QueryParam();
                queryParam.getParams().put("id", new Parameter(QueryParam.IN, deductedIds));
                List<PerformanceReturnEntity> performanceReturnEntities = super.queryList(queryParam);
                Map<Long, PerformanceReturnEntity> collect = performanceReturnEntities.stream().collect(Collectors.toMap(PerformanceReturnEntity::getId, Function.identity(), (v1, v2) -> v2));

                for (PMPerformanceVO pMPerformanceVO : resultList) {
                    if(collect.containsKey(Long.parseLong(pMPerformanceVO.getPmBillId()))){
                        PerformanceReturnEntity performanceDeductedEntity = collect.get(Long.parseLong(pMPerformanceVO.getPmBillId()));
                        if(pMPerformanceVO.getState() != null){
                            if("1".equals(pMPerformanceVO.getState())){
                                performanceDeductedEntity.setPayState(3);//支付成功
                            }else if("2".equals(pMPerformanceVO.getState())){
                                performanceDeductedEntity.setPayState(4);//支付失败
                            }
                            super.updateById(performanceDeductedEntity);
                        }
                    }
                }
            }
        }

        logger.info("获取收款单数据，开始生成扣款单--end！");
    }
}
