package com.ejianc.business.profinance.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 诉讼费结算实体
 * 
 * @author generator
 * 
 */
 @TableName("ejc_contract_lawsuit")
public class ContractLawsuitEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="create_user_id")
    private Long createUserId; // 创建者账号
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="bill_state")
    private Integer billState; // 单据状态 ：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    @TableField(value="org_id")
    private Long orgId; // 项目部id
    @TableField(value="org_code")
    private String orgCode; // 项目部编码
    @TableField(value="org_name")
    private String orgName; // 项目部名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 项目部所属组织id
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 项目部所属组织编码
    @TableField(value="parent_org_name")
    private String parentOrgName; // 项目部所属组织名称
    @TableField(value="contract_id")
    private Long contractId; // 合同id
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="contract_code")
    private String contractCode; // 合同编码
    @TableField(value="contract_category_id")
    private Long contractCategoryId; // 合同类别id
    @TableField(value="contract_category_code")
    private String contractCategoryCode; // 合同类别编码
    @TableField(value="contract_category_name")
    private String contractCategoryName; // 合同类别名称
    @TableField(value="supplement_flag")
    private Integer supplementFlag; // 是否主合同：0-主合同 1-补充协议
    @TableField(value="project_id")
    private Long projectId; // 项目Id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_code")
    private String projectCode; // 项目编号
    @TableField(value="supplier_id")
    private Long supplierId; // 乙方id（供应商）
    @TableField(value="supplier_name")
    private String supplierName; // 乙方名称（供应商）
    @TableField(value="contract_mny")
    private BigDecimal contractMny; // 合同金额(无税)
    @TableField(value="contract_tax_mny")
    private BigDecimal contractTaxMny; // 合同金额
    @TableField(value="settle_mny")
    private BigDecimal settleMny; // 结算金额
    @TableField(value="settle_date")
    private Date settleDate; // 结算日期
    @TableField(value="memo")
    private String memo; // 备注 非必填，0-500字
    @TableField(value="employee_id")
    private Long employeeId; // 经办人id（申请人）
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称（申请人）
    @TableField(value="department_id")
    private Long departmentId; // 经办（申请人）部门id
    @TableField(value="department_name")
    private String departmentName; // 经办（申请人）部门名称

    @TableField(value = "commit_date")
    private Date commitDate; // 提交日期
    @TableField(value = "commit_user_name")
    private String commitUserName; // 提交人名称
    @TableField(value = "commit_user_code")
    private String commitUserCode; // 提交人账号
    @TableField(value = "effective_date")
    private Date effectiveDate; // 生效日期


    @TableField(value="lawsuit_work_mny")
    private BigDecimal lawsuitWorkMny; // 诉讼工程款金额
    @TableField(value="other_lawsuit_mny")
    private BigDecimal otherLawsuitMny; // 其他诉讼金额

    @TableField(value="project_wbs_id")
    private Long projectWbsId; // 项目WBS id
    @TableField(value="project_wbs_code")
    private String projectWbsCode; // 项目WBS 编码
    @TableField(value="project_wbs_name")
    private String projectWbsName; // 项目WBS 名称

    @TableField(value="cost_of_course_id")
    private Long costOfCourseId; // 成本科目 id
    @TableField(value="cost_of_course_name")
    private String costOfCourseName; // 成本科目 编码
    @TableField(value="cost_of_course_code")
    private String costOfCourseCode; // 成本科目 名称
    @TableField(value = "push_pool_flag")
    private String pushPoolFlag; //推送结算池标识：unSucPush-未成功推送供方，sucPushed-已成功推送供方
    @TableField(value = "relation_flag")
    private String relationFlag; // 关联状态(1:是，0：否)
    @TableField(value = "proportion_flag")
    private String proportionFlag; // 分摊状态(1:是，0：否)
    /**
     * 分包合同明细实体
     */
    @TableField(exist = false)
    @SubEntity(serviceName = "contractLawsuitDetailService", pidName = "lawsuitId")
    private List<ContractLawsuitDetailEntity> detailList = new ArrayList<>();

    @TableField(value = "contract_total_pay_apply_tax_mny")
    private BigDecimal contractTotalPayApplyTaxMny; // 合同累计付款申请金额（含税）
    @TableField(value = "contract_total_settle_tax_mny")
    private BigDecimal contractTotalSettleTaxMny; //合同累计结算金额（含税）
    @TableField(value = "unpaid_settle_tax_mny")
    private BigDecimal unpaidSettleTaxMny; //待支付结算金额（含税） = 合同累计付款申请金额（不含税） - 合同累计付款申请金额（含税）


    /**
     * 已结算诉讼工程款(不含本次)
     *  合同审批通过或已提交的【诉讼费结算】“诉讼工程款金额”之和
     */
    @TableField(value = "last_lawsuit_work_mny")
    private BigDecimal lastLawsuitWorkMny;
    /**
     * 累计结算诉讼工程款
     *  已结算诉讼工程款(不含本次)+诉讼工程款金额；
     */
    @TableField(value = "total_lawsuit_work_mny")
    private BigDecimal totalLawsuitWorkMny;

    /**
     * 本期可结算诉讼工程款
     *  合同累计结算金额-合同累计申请付款金额-已结算诉讼工程款(不含本次)。
     */
    @TableField(value = "residue_lawsuit_work_mny")
    private BigDecimal residueLawsuitWorkMny;

    /**
     * 合同结算列表
     */
    @TableField(exist = false)
    @SubEntity(serviceName = "contractLawsuitSubSettleService", pidName = "lawsuitId")
    private List<ContractLawsuitSubSettleEntity> subSettleList = new ArrayList<>();

    public String getRelationFlag() {
        return relationFlag;
    }

    public void setRelationFlag(String relationFlag) {
        this.relationFlag = relationFlag;
    }

    public String getProportionFlag() {
        return proportionFlag;
    }

    public void setProportionFlag(String proportionFlag) {
        this.proportionFlag = proportionFlag;
    }

    public List<ContractLawsuitDetailEntity> getDetailList() {
        return detailList;
    }

    public String getPushPoolFlag() {
        return pushPoolFlag;
    }

    public void setPushPoolFlag(String pushPoolFlag) {
        this.pushPoolFlag = pushPoolFlag;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public void setDetailList(List<ContractLawsuitDetailEntity> detailList) {
        this.detailList = detailList;
    }

    public BigDecimal getLawsuitWorkMny() {
        return lawsuitWorkMny;
    }

    public void setLawsuitWorkMny(BigDecimal lawsuitWorkMny) {
        this.lawsuitWorkMny = lawsuitWorkMny;
    }

    public BigDecimal getOtherLawsuitMny() {
        return otherLawsuitMny;
    }

    public void setOtherLawsuitMny(BigDecimal otherLawsuitMny) {
        this.otherLawsuitMny = otherLawsuitMny;
    }

    public Long getProjectWbsId() {
        return projectWbsId;
    }

    public void setProjectWbsId(Long projectWbsId) {
        this.projectWbsId = projectWbsId;
    }

    public String getProjectWbsCode() {
        return projectWbsCode;
    }

    public void setProjectWbsCode(String projectWbsCode) {
        this.projectWbsCode = projectWbsCode;
    }

    public String getProjectWbsName() {
        return projectWbsName;
    }

    public void setProjectWbsName(String projectWbsName) {
        this.projectWbsName = projectWbsName;
    }

    public Long getCostOfCourseId() {
        return costOfCourseId;
    }

    public void setCostOfCourseId(Long costOfCourseId) {
        this.costOfCourseId = costOfCourseId;
    }

    public String getCostOfCourseName() {
        return costOfCourseName;
    }

    public void setCostOfCourseName(String costOfCourseName) {
        this.costOfCourseName = costOfCourseName;
    }

    public String getCostOfCourseCode() {
        return costOfCourseCode;
    }

    public void setCostOfCourseCode(String costOfCourseCode) {
        this.costOfCourseCode = costOfCourseCode;
    }

    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }

    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }

    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }

    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public Long getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public Long getContractCategoryId() {
        return contractCategoryId;
    }

    public void setContractCategoryId(Long contractCategoryId) {
        this.contractCategoryId = contractCategoryId;
    }
    public String getContractCategoryCode() {
        return contractCategoryCode;
    }

    public void setContractCategoryCode(String contractCategoryCode) {
        this.contractCategoryCode = contractCategoryCode;
    }
    public String getContractCategoryName() {
        return contractCategoryName;
    }

    public void setContractCategoryName(String contractCategoryName) {
        this.contractCategoryName = contractCategoryName;
    }
    public Integer getSupplementFlag() {
        return supplementFlag;
    }

    public void setSupplementFlag(Integer supplementFlag) {
        this.supplementFlag = supplementFlag;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    public BigDecimal getSettleMny() {
        return settleMny;
    }

    public void setSettleMny(BigDecimal settleMny) {
        this.settleMny = settleMny;
    }
    public Date getSettleDate() {
        return settleDate;
    }

    public void setSettleDate(Date settleDate) {
        this.settleDate = settleDate;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    public BigDecimal getContractTotalPayApplyTaxMny() {
        return contractTotalPayApplyTaxMny;
    }

    public void setContractTotalPayApplyTaxMny(BigDecimal contractTotalPayApplyTaxMny) {
        this.contractTotalPayApplyTaxMny = contractTotalPayApplyTaxMny;
    }

    public BigDecimal getContractTotalSettleTaxMny() {
        return contractTotalSettleTaxMny;
    }

    public void setContractTotalSettleTaxMny(BigDecimal contractTotalSettleTaxMny) {
        this.contractTotalSettleTaxMny = contractTotalSettleTaxMny;
    }

    public BigDecimal getUnpaidSettleTaxMny() {
        return unpaidSettleTaxMny;
    }

    public void setUnpaidSettleTaxMny(BigDecimal unpaidSettleTaxMny) {
        this.unpaidSettleTaxMny = unpaidSettleTaxMny;
    }

    public List<ContractLawsuitSubSettleEntity> getSubSettleList() {
        return subSettleList;
    }

    public void setSubSettleList(List<ContractLawsuitSubSettleEntity> subSettleList) {
        this.subSettleList = subSettleList;
    }

    public BigDecimal getLastLawsuitWorkMny() {
        return lastLawsuitWorkMny;
    }

    public void setLastLawsuitWorkMny(BigDecimal lastLawsuitWorkMny) {
        this.lastLawsuitWorkMny = lastLawsuitWorkMny;
    }

    public BigDecimal getTotalLawsuitWorkMny() {
        return totalLawsuitWorkMny;
    }

    public void setTotalLawsuitWorkMny(BigDecimal totalLawsuitWorkMny) {
        this.totalLawsuitWorkMny = totalLawsuitWorkMny;
    }

    public BigDecimal getResidueLawsuitWorkMny() {
        return residueLawsuitWorkMny;
    }

    public void setResidueLawsuitWorkMny(BigDecimal residueLawsuitWorkMny) {
        this.residueLawsuitWorkMny = residueLawsuitWorkMny;
    }
}
