package com.ejianc.business.profinance.common.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

/**
 * 单据处理结果记录表
 *
 * @author CJ
 * @Description:
 * @date 2022/6/18 17:03
 */
@TableName(value = "ejc_profinance_bill_handle_result")
public class BillHandleResultEntity extends BaseEntity {

    private static final long serialVersionUID = 3734083783791593137L;

    /**
     * 处理单据的类型:paymentApply-付款申请单,salaryPayApply-工人工资支付申请单
     */
    @TableField(value = "handle_bill_type")
    private String handleBillType;

    /**
     * 处理单据的数据
     */
    @TableField(value = "bill_data_json")
    private String billDataJson;

    /**
     * 单据处理结果码：success-成功，fail-失败
     */
    @TableField(value = "handle_result_code")
    private String handleResultCode;

    /**
     * 单据处理结果信息
     */
    @TableField(value = "handle_result_msg")
    private String handleResultMsg;

    /**
     * 处理单据的业务主键
     */
    @TableField(value = "handle_bill_id_str")
    private String handleBillIdStr;

    public String getHandleBillType() {
        return handleBillType;
    }

    public void setHandleBillType(String handleBillType) {
        this.handleBillType = handleBillType;
    }

    public String getBillDataJson() {
        return billDataJson;
    }

    public void setBillDataJson(String billDataJson) {
        this.billDataJson = billDataJson;
    }

    public String getHandleResultCode() {
        return handleResultCode;
    }

    public void setHandleResultCode(String handleResultCode) {
        this.handleResultCode = handleResultCode;
    }

    public String getHandleResultMsg() {
        return handleResultMsg;
    }

    public void setHandleResultMsg(String handleResultMsg) {
        this.handleResultMsg = handleResultMsg;
    }

    public String getHandleBillIdStr() {
        return handleBillIdStr;
    }

    public void setHandleBillIdStr(String handleBillIdStr) {
        this.handleBillIdStr = handleBillIdStr;
    }
}
