package com.ejianc.business.profinance.mapper;

import com.ejianc.business.profinance.bean.PaymentApplyEntity;
import com.ejianc.business.report.vo.DailyFinanceInfoVO;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;

/**
 * 付款申请主实体
 * 
 * @author generator
 * 
 */
@Mapper
public interface PaymentApplyMapper extends BaseCrudMapper<PaymentApplyEntity> {
    /**
     * 查找申请日期最大值
     *
     */
    Date selectMaxPaymentApplyDate(Integer paymentType, Long projectId, Long supplierId) ;
    /**
     * 查找有合同日期最大值
     *
     */
    Date selectMaxDate(Integer paymentType, Long projectId, Long contractId) ;

    List<PaymentApplyEntity> querySumMny(@Param("suplyIds") List<Long> suplyIds,@Param("orgIds") List<Long> orgIds);

    List<DailyFinanceInfoVO> dailyFinanceInfo(@Param("financeDate") String financeDate);
}
