package com.ejianc.business.profinance.paysupplement.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.profinance.paysupplement.bean.PaymentSupplementEntity;
import com.ejianc.business.profinance.paysupplement.service.IPaymentSupplementService;
import com.ejianc.business.profinance.paysupplement.vo.PaymentSupplementVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 付款补录业务数据实体
 *
 * @author generator
 *
 */
@RestController
@RequestMapping("paymentSupplement")
public class PaymentSupplementController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IPaymentSupplementService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    public CommonResponse<PaymentSupplementVO> saveOrUpdate(@RequestBody PaymentSupplementVO saveOrUpdateVO) {
    	PaymentSupplementEntity entity = BeanMapper.map(saveOrUpdateVO, PaymentSupplementEntity.class);

    	if(null == saveOrUpdateVO.getId()) {
    	    if(entity.getPaymentContractFlag().equals(1)) {
                //无合同付款补录设时，将合同Id赋值为-1
                entity.setContractId(-1L);
            }

            //根据项目Id，合同Id、供应商Id、收款方Id查询是否存在自由态付款补录单，若存在，则不允许弃审
            QueryWrapper<PaymentSupplementEntity> query = new QueryWrapper<>();
            query.eq("project_id", saveOrUpdateVO.getProjectId());
            query.eq("contract_id", saveOrUpdateVO.getContractId());
            query.eq("supplier_id", saveOrUpdateVO.getSupplierId());
            query.eq("payee_id", saveOrUpdateVO.getPayeeId());
            //未生效的单据
            query.in("bill_state", Arrays.asList(BillStateEnum.UNCOMMITED_STATE.getBillStateCode(),
                    BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(),
                    BillStateEnum.UNAPPROVED.getBillStateCode(),
                    BillStateEnum.SUSPEND.getBillStateCode(),
                    BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode()));

            List<PaymentSupplementEntity> list = service.list(query);
            if(CollectionUtils.isNotEmpty(list)) {
                logger.error("单据-[{}]存在同一维度未生效单据，保存失败！");
                return CommonResponse.error("同一维度下存在生效单据，保存失败！");
            }
        }

    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	PaymentSupplementVO vo = BeanMapper.map(entity, PaymentSupplementVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    public CommonResponse<PaymentSupplementVO> queryDetail(Long id) {
    	PaymentSupplementEntity entity = service.selectById(id);
    	PaymentSupplementVO vo = BeanMapper.map(entity, PaymentSupplementVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    public CommonResponse<String> delete(@RequestBody List<PaymentSupplementVO> vos) {
        service.removeByIds(vos.stream().map(PaymentSupplementVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    public CommonResponse<IPage<PaymentSupplementVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("payeeName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();

        if(StringUtils.isNotBlank(authOrgIds)){
            //移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
            orgVOList.stream().forEach(org -> {
                if(OrgVO.ORG_TYPE_DEPARTMENT.equals(org.getOrgType())) {
                    //项目部
                    departmentIds.add(org.getId());
                } else {
                    //普通组织
                    commonOrgIds.add(org.getId());
                }
            });
        }else {
            //pc端查询
            if(OrgVO.ORG_TYPE_DEPARTMENT.equals(InvocationInfoProxy.getOrgType())) {
                departmentIds.add(InvocationInfoProxy.getOrgId());
            } else {
                CommonResponse<List<OrgVO>> orgVOListResp = iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId());
                if(!orgVOListResp.isSuccess()) {
                    return CommonResponse.error("查询失败，获取组织信息失败！");
                }
                commonOrgIds.addAll(orgVOListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
            }
        }

        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }

        IPage<PaymentSupplementEntity> page = service.queryPage(param,false);
        IPage<PaymentSupplementVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), PaymentSupplementVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<PaymentSupplementEntity> list = service.queryList(param);
        List<PaymentSupplementVO> voList = BeanMapper.mapList(list, PaymentSupplementVO.class);
        voList.forEach(item -> {
            item.setPaymentTypeName(item.getPaymentContractFlag().equals(0) ? "有合同付款" : "无合同付款");
            item.setBillStateName(BillStateEnum.getEnumByStateCode(item.getBillState()).getDescription());
        });

        Map<String, Object> beans = new HashMap<>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("PaymentSupplement-export.xlsx", beans, response);
    }

}
