package com.ejianc.business.profinance.person.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 借款管理-个人还款
 * 
 * @author generator
 * 
 */
 @TableName("ejc_profinance_person_repay")
public class PersonRepayEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="commit_date")
    private Date commitDate; // 提交日期
    @TableField(value="commit_user_name")
    private String commitUserName; // 提交人名称
    @TableField(value="commit_user_code")
    private String commitUserCode; // 提交人账号
    @TableField(value="effective_date")
    private Date effectiveDate; // 生效日期
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_name")
    private String billName; // 单据名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="bill_state_name")
    private String billStateName; // 单据状态名称
    @TableField(value="employee_id")
    private Long employeeId; // 经办人id
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="department_id")
    private Long departmentId; // 经办部门id
    @TableField(value="department_name")
    private String departmentName; // 经办部门名称
    @TableField(value="org_id")
    private Long orgId; // 项目部id
    @TableField(value="org_code")
    private String orgCode; // 项目部编码
    @TableField(value="org_name")
    private String orgName; // 项目部名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 项目部所属组织id
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 项目部所属组织编码
    @TableField(value="parent_org_name")
    private String parentOrgName; // 项目部所属组织名称
    @TableField(value="repay_project_id")
    private Long repayProjectId; // 还款人所在项目id
    @TableField(value="repay_project_code")
    private String repayProjectCode; // 还款人所在项目编码
    @TableField(value="repay_project_name")
    private String repayProjectName; // 还款人所在项目名称
    @TableField(value="repay_person_id")
    private Long repayPersonId; // 还款人id
    @TableField(value="repay_person_code")
    private String repayPersonCode; // 还款人编码
    @TableField(value="repay_person_name")
    private String repayPersonName; // 还款人名称
    @TableField(value="repay_date")
    private Date repayDate; // 还款日期
    @TableField(value="settle_type_id")
    private Long settleTypeId; // 结算方式id
    @TableField(value="settle_type_code")
    private String settleTypeCode; // 结算方式编码
    @TableField(value="settle_type_name")
    private String settleTypeName; // 结算方式名称
    @TableField(value="cur_total_repay_mny")
    private BigDecimal curTotalRepayMny; // 本次还款金额合计
    @TableField(value="memo")
    private String memo; // 备注

    @TableField(exist = false)
    @SubEntity(serviceName = "personRepayDetailService",pidName = "personRepayId")
    private List<PersonRepayDetailEntity> detailList = new ArrayList<>();


    public List<PersonRepayDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<PersonRepayDetailEntity> detailList) {
        this.detailList = detailList;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }
    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }
    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }
    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getBillName() {
        return billName;
    }

    public void setBillName(String billName) {
        this.billName = billName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public Long getRepayProjectId() {
        return repayProjectId;
    }

    public void setRepayProjectId(Long repayProjectId) {
        this.repayProjectId = repayProjectId;
    }
    public String getRepayProjectCode() {
        return repayProjectCode;
    }

    public void setRepayProjectCode(String repayProjectCode) {
        this.repayProjectCode = repayProjectCode;
    }
    public String getRepayProjectName() {
        return repayProjectName;
    }

    public void setRepayProjectName(String repayProjectName) {
        this.repayProjectName = repayProjectName;
    }
    public Long getRepayPersonId() {
        return repayPersonId;
    }

    public void setRepayPersonId(Long repayPersonId) {
        this.repayPersonId = repayPersonId;
    }
    public String getRepayPersonCode() {
        return repayPersonCode;
    }

    public void setRepayPersonCode(String repayPersonCode) {
        this.repayPersonCode = repayPersonCode;
    }
    public String getRepayPersonName() {
        return repayPersonName;
    }

    public void setRepayPersonName(String repayPersonName) {
        this.repayPersonName = repayPersonName;
    }
    public Date getRepayDate() {
        return repayDate;
    }

    public void setRepayDate(Date repayDate) {
        this.repayDate = repayDate;
    }
    public Long getSettleTypeId() {
        return settleTypeId;
    }

    public void setSettleTypeId(Long settleTypeId) {
        this.settleTypeId = settleTypeId;
    }
    public String getSettleTypeCode() {
        return settleTypeCode;
    }

    public void setSettleTypeCode(String settleTypeCode) {
        this.settleTypeCode = settleTypeCode;
    }
    public String getSettleTypeName() {
        return settleTypeName;
    }

    public void setSettleTypeName(String settleTypeName) {
        this.settleTypeName = settleTypeName;
    }
    public BigDecimal getCurTotalRepayMny() {
        return curTotalRepayMny;
    }

    public void setCurTotalRepayMny(BigDecimal curTotalRepayMny) {
        this.curTotalRepayMny = curTotalRepayMny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    
}
