package com.ejianc.business.profinance.plan.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 项目资金计划
 *
 * @author baipengyan
 */
@TableName("ejc_profinance_plan")
public class PlanEntity extends BaseEntity {
	private static final long serialVersionUID = -904719264710203953L;

	@TableField(value = "commit_date")
	private Date commitDate; // 提交日期
	@TableField(value = "commit_user_name")
	private String commitUserName; // 提交人名称
	@TableField(value = "commit_user_code")
	private String commitUserCode; // 提交人账号
	@TableField(value = "effective_date")
	private Date effectiveDate; // 生效日期
	@TableField(value = "bill_code")
	private String billCode; // 单据编号
	@TableField(value = "bill_name")
	private String billName; // 单据名称
	@TableField(value = "bill_state")
	private Integer billState; // 单据状态
	@TableField(value = "bill_state_name")
	private String billStateName; // 单据状态名称
	@TableField(value = "org_id")
	private Long orgId; // 项目部id
	@TableField(value = "org_code")
	private String orgCode; // 项目部编码
	@TableField(value = "org_name")
	private String orgName; // 项目部名称
	@TableField(value = "parent_org_id")
	private Long parentOrgId; // 项目部所属组织id
	@TableField(value = "parent_org_code")
	private String parentOrgCode; // 项目部所属组织编码
	@TableField(value = "parent_org_name")
	private String parentOrgName; // 项目部所属组织名称
	@TableField(value = "project_id")
	private Long projectId; // 项目id
	@TableField(value = "project_code")
	private String projectCode; // 项目编码
	@TableField(value = "project_name")
	private String projectName; // 项目名称
	@TableField(value = "project_route_url")
	private String projectRouteUrl; // 项目路由地址
	@TableField(value = "last_plan_date")
	private Date lastPlanDate; // 上次计划日期 =上一次的【项目资金计划】“本次计划日期”
	@TableField(value = "plan_date")
	private Date planDate; // 本次计划日期 =大于“上期计划日期”的日期
	@TableField(value = "plan_receipt")
	private BigDecimal planReceipt; // 本次计划收款
	@TableField(value = "employee_id")
	private Long employeeId; // 经办人id
	@TableField(value = "employee_name")
	private String employeeName; // 经办人名称
	@TableField(value = "department_id")
	private Long departmentId; // 经办部门id
	@TableField(value = "department_code")
	private String departmentCode; // 经办部门编码
	@TableField(value = "department_name")
	private String departmentName; // 经办部门名称
	@TableField(value = "total_plan_payment")
	private BigDecimal totalPlanPayment; // 本次计划付款 =子表的本次计划付款的汇总
	@TableField(value = "predict_balance")
	private BigDecimal predictBalance; // 本次预计结存余额 =本次计划收款-本次计划付款
	@TableField(value = "cur_total_actual_payment_mny")
	private BigDecimal curTotalActualPaymentMny; // 本次累计实付金额
	@TableField(value = "memo")
	private String memo; // 备注
	@TableField(value = "total_complete_taking_tax_mny")
	private BigDecimal totalCompleteTakingTaxMny; // 累计完成营业收入(含税)
	@TableField(value = "last_total_project_receipt")
	private BigDecimal lastTotalProjectReceipt; // 累计工程收款(不含本次) =该项目往期已审批通过的【收款登记】“本次实收金额”之和
	@TableField(value = "total_project_receipt")
	private BigDecimal totalProjectReceipt; // 累计工程收款(含本次) =“累计工程收款(不含本次)”+本次计划收款
	@TableField(value = "last_total_output_value_tax_mny")
	private BigDecimal lastTotalOutputValueTaxMny; // 累计产值金额 =【产值报量】的“产值金额(含税)”之和 =“结算单类型”为“产值报量”【结算池】“本期结算金额(含税)”之和
	@TableField(value = "receipt_scale")
	private BigDecimal receiptScale; // 已收款比例(含本次) =累计工程收款(含本次)/累计产值金额
	@TableField(value = "node_mark")
	private Integer nodeMark; // 财务确认标识
	@TableField(value = "project_fund_balance")
	private BigDecimal projectFundBalance; // 项目资金余额
	@TableField(value = "unit_deposit_balance")
	private BigDecimal unitDepositBalance; // 单位存款余额


	@TableField(exist = false)
	@SubEntity(serviceName = "planOverdraftService", pidName = "planId")//此处有pid="xxx"，默认值pid="pid"
	private List<PlanOverdraftEntity> planOverdraftList = new ArrayList<>(); // 项目资金计划-公司机关欠款情况
	@TableField(exist = false)
	@SubEntity(serviceName = "planContractService", pidName = "planId")//此处有pid="xxx"，默认值pid="pid"
	private List<PlanContractEntity> planContractList = new ArrayList<>(); // 项目资金计划-支出合同
	@TableField(exist = false)
	@SubEntity(serviceName = "planMaterialService", pidName = "planId")//此处有pid="xxx"，默认值pid="pid"
	private List<PlanMaterialEntity> planMaterialList = new ArrayList<>(); // 项目资金计划-零星材料采购
	@TableField(exist = false)
	@SubEntity(serviceName = "planTemporaryService", pidName = "planId")//此处有pid="xxx"，默认值pid="pid"
	private List<PlanTemporaryEntity> planTemporaryList = new ArrayList<>(); // 项目资金计划-临时机械租赁
	@TableField(exist = false)
	@SubEntity(serviceName = "planFeeService", pidName = "planId")//此处有pid="xxx"，默认值pid="pid"
	private List<PlanFeeEntity> planFeeList = new ArrayList<>(); // 项目资金计划-零星费用


	public Date getCommitDate() {
		return commitDate;
	}

	public void setCommitDate(Date commitDate) {
		this.commitDate = commitDate;
	}

	public String getCommitUserName() {
		return commitUserName;
	}

	public void setCommitUserName(String commitUserName) {
		this.commitUserName = commitUserName;
	}

	public String getCommitUserCode() {
		return commitUserCode;
	}

	public void setCommitUserCode(String commitUserCode) {
		this.commitUserCode = commitUserCode;
	}

	public Date getEffectiveDate() {
		return effectiveDate;
	}

	public void setEffectiveDate(Date effectiveDate) {
		this.effectiveDate = effectiveDate;
	}

	public String getBillCode() {
		return billCode;
	}

	public void setBillCode(String billCode) {
		this.billCode = billCode;
	}

	public String getBillName() {
		return billName;
	}

	public void setBillName(String billName) {
		this.billName = billName;
	}

	public Integer getBillState() {
		return billState;
	}

	public void setBillState(Integer billState) {
		this.billState = billState;
	}

	public String getBillStateName() {
		return billStateName;
	}

	public void setBillStateName(String billStateName) {
		this.billStateName = billStateName;
	}

	public Long getOrgId() {
		return orgId;
	}

	public void setOrgId(Long orgId) {
		this.orgId = orgId;
	}

	public String getOrgCode() {
		return orgCode;
	}

	public void setOrgCode(String orgCode) {
		this.orgCode = orgCode;
	}

	public String getOrgName() {
		return orgName;
	}

	public void setOrgName(String orgName) {
		this.orgName = orgName;
	}

	public Long getParentOrgId() {
		return parentOrgId;
	}

	public void setParentOrgId(Long parentOrgId) {
		this.parentOrgId = parentOrgId;
	}

	public String getParentOrgCode() {
		return parentOrgCode;
	}

	public void setParentOrgCode(String parentOrgCode) {
		this.parentOrgCode = parentOrgCode;
	}

	public String getParentOrgName() {
		return parentOrgName;
	}

	public void setParentOrgName(String parentOrgName) {
		this.parentOrgName = parentOrgName;
	}

	public Long getProjectId() {
		return projectId;
	}

	public void setProjectId(Long projectId) {
		this.projectId = projectId;
	}

	public String getProjectCode() {
		return projectCode;
	}

	public void setProjectCode(String projectCode) {
		this.projectCode = projectCode;
	}

	public String getProjectName() {
		return projectName;
	}

	public void setProjectName(String projectName) {
		this.projectName = projectName;
	}

	public String getProjectRouteUrl() {
		return projectRouteUrl;
	}

	public void setProjectRouteUrl(String projectRouteUrl) {
		this.projectRouteUrl = projectRouteUrl;
	}

	public Date getLastPlanDate() {
		return lastPlanDate;
	}

	public void setLastPlanDate(Date lastPlanDate) {
		this.lastPlanDate = lastPlanDate;
	}

	public Date getPlanDate() {
		return planDate;
	}

	public void setPlanDate(Date planDate) {
		this.planDate = planDate;
	}

	public BigDecimal getPlanReceipt() {
		return planReceipt;
	}

	public void setPlanReceipt(BigDecimal planReceipt) {
		this.planReceipt = planReceipt;
	}

	public Long getEmployeeId() {
		return employeeId;
	}

	public void setEmployeeId(Long employeeId) {
		this.employeeId = employeeId;
	}

	public String getEmployeeName() {
		return employeeName;
	}

	public void setEmployeeName(String employeeName) {
		this.employeeName = employeeName;
	}

	public Long getDepartmentId() {
		return departmentId;
	}

	public void setDepartmentId(Long departmentId) {
		this.departmentId = departmentId;
	}

	public String getDepartmentCode() {
		return departmentCode;
	}

	public void setDepartmentCode(String departmentCode) {
		this.departmentCode = departmentCode;
	}

	public String getDepartmentName() {
		return departmentName;
	}

	public void setDepartmentName(String departmentName) {
		this.departmentName = departmentName;
	}

	public BigDecimal getTotalPlanPayment() {
		return totalPlanPayment;
	}

	public void setTotalPlanPayment(BigDecimal totalPlanPayment) {
		this.totalPlanPayment = totalPlanPayment;
	}

	public BigDecimal getPredictBalance() {
		return predictBalance;
	}

	public void setPredictBalance(BigDecimal predictBalance) {
		this.predictBalance = predictBalance;
	}

	public BigDecimal getCurTotalActualPaymentMny() {
		return curTotalActualPaymentMny;
	}

	public void setCurTotalActualPaymentMny(BigDecimal curTotalActualPaymentMny) {
		this.curTotalActualPaymentMny = curTotalActualPaymentMny;
	}

	public String getMemo() {
		return memo;
	}

	public void setMemo(String memo) {
		this.memo = memo;
	}

	public BigDecimal getTotalCompleteTakingTaxMny() {
		return totalCompleteTakingTaxMny;
	}

	public void setTotalCompleteTakingTaxMny(BigDecimal totalCompleteTakingTaxMny) {
		this.totalCompleteTakingTaxMny = totalCompleteTakingTaxMny;
	}

	public BigDecimal getLastTotalProjectReceipt() {
		return lastTotalProjectReceipt;
	}

	public void setLastTotalProjectReceipt(BigDecimal lastTotalProjectReceipt) {
		this.lastTotalProjectReceipt = lastTotalProjectReceipt;
	}

	public BigDecimal getTotalProjectReceipt() {
		return totalProjectReceipt;
	}

	public void setTotalProjectReceipt(BigDecimal totalProjectReceipt) {
		this.totalProjectReceipt = totalProjectReceipt;
	}

	public BigDecimal getLastTotalOutputValueTaxMny() {
		return lastTotalOutputValueTaxMny;
	}

	public void setLastTotalOutputValueTaxMny(BigDecimal lastTotalOutputValueTaxMny) {
		this.lastTotalOutputValueTaxMny = lastTotalOutputValueTaxMny;
	}

	public BigDecimal getReceiptScale() {
		return receiptScale;
	}

	public void setReceiptScale(BigDecimal receiptScale) {
		this.receiptScale = receiptScale;
	}

	public Integer getNodeMark() {
		return nodeMark;
	}

	public void setNodeMark(Integer nodeMark) {
		this.nodeMark = nodeMark;
	}

	public BigDecimal getProjectFundBalance() {
		return projectFundBalance;
	}

	public void setProjectFundBalance(BigDecimal projectFundBalance) {
		this.projectFundBalance = projectFundBalance;
	}

	public BigDecimal getUnitDepositBalance() {
		return unitDepositBalance;
	}

	public void setUnitDepositBalance(BigDecimal unitDepositBalance) {
		this.unitDepositBalance = unitDepositBalance;
	}

	public List<PlanOverdraftEntity> getPlanOverdraftList() {
		return planOverdraftList;
	}

	public void setPlanOverdraftList(List<PlanOverdraftEntity> planOverdraftList) {
		this.planOverdraftList = planOverdraftList;
	}

	public List<PlanContractEntity> getPlanContractList() {
		return planContractList;
	}

	public void setPlanContractList(List<PlanContractEntity> planContractList) {
		this.planContractList = planContractList;
	}

	public List<PlanMaterialEntity> getPlanMaterialList() {
		return planMaterialList;
	}

	public void setPlanMaterialList(List<PlanMaterialEntity> planMaterialList) {
		this.planMaterialList = planMaterialList;
	}

	public List<PlanTemporaryEntity> getPlanTemporaryList() {
		return planTemporaryList;
	}

	public void setPlanTemporaryList(List<PlanTemporaryEntity> planTemporaryList) {
		this.planTemporaryList = planTemporaryList;
	}

	public List<PlanFeeEntity> getPlanFeeList() {
		return planFeeList;
	}

	public void setPlanFeeList(List<PlanFeeEntity> planFeeList) {
		this.planFeeList = planFeeList;
	}
}
