package com.ejianc.business.profinance.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.profinance.plan.bean.PlanMaterialEntity;
import com.ejianc.business.profinance.plan.mapper.PlanMaterialMapper;
import com.ejianc.business.profinance.plan.service.IPlanMaterialService;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * 项目资金计划-零星材料采购
 *
 * @author generator
 */
@Service("planMaterialService")
public class PlanMaterialServiceImpl extends BaseServiceImpl<PlanMaterialMapper, PlanMaterialEntity> implements IPlanMaterialService {

	private static final String MATERIAL_SETTLE_ID = "material_settle_id";

	/**
	 * 根据项目资金计划id，修改项目资金计划-零星材料的单据状态
	 *
	 * @param planId        项目资金计划id
	 * @param billStateCode 单据状态
	 */
	@Override
	public void updateBillState(Long planId, Integer billStateCode) {
		LambdaUpdateWrapper<PlanMaterialEntity> updateWrapper = Wrappers.lambdaUpdate();
		updateWrapper.eq(PlanMaterialEntity::getPlanId, planId);
		updateWrapper.set(PlanMaterialEntity::getBillState, billStateCode);
		updateWrapper.set(PlanMaterialEntity::getBillStateName, BillStateEnum.getEnumByStateCode(billStateCode).getDescription());
		super.update(updateWrapper);
	}

	/**
	 * 已申请金额(不含本次)=查询所有审批通过或已提交的【项目资金计划】-【零星材料】页签数据，统计该结算单的“本次计划付款金额”
	 *
	 * @param settleIds 结算单ids
	 *
	 * @return 已申请金额(不含本次)
	 */
	@Override
	public Map<String, Object> fetchMaterialValue(Collection<Long> settleIds) {
		HashMap<String, Object> result = new HashMap<>();

		QueryWrapper<PlanMaterialEntity> queryWrapper = Wrappers.query();
		queryWrapper.in("bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
		queryWrapper.in(MATERIAL_SETTLE_ID, settleIds);
		queryWrapper.groupBy(MATERIAL_SETTLE_ID);
		queryWrapper.select("material_settle_id as materialSettleId,ifnull(sum(material_plan_payment_mny), 0) as materialAppliedMny");
		List<Map<String, Object>> resultMap = super.listMaps(queryWrapper);
		if (CollectionUtils.isNotEmpty(resultMap)) {
			return converToMap(resultMap);
		}

		return result;
	}

	private Map<String, Object> converToMap(List<Map<String, Object>> listMap) {
		Map<String, Object> resultMap = new HashMap<>();
		for (Map<String, Object> map : listMap) {
			if (!resultMap.containsKey(map.get("materialSettleId").toString())) {
				resultMap.put(map.get("materialSettleId").toString(), map.get("materialAppliedMny").toString());
			}
		}
		return resultMap;
	}

}
