package com.ejianc.business.profinance.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.profinance.plan.bean.PlanTemporaryEntity;
import com.ejianc.business.profinance.plan.mapper.PlanTemporaryMapper;
import com.ejianc.business.profinance.plan.service.IPlanTemporaryService;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * 项目资金计划-临时机械租赁
 *
 * @author generator
 */
@Service("planTemporaryService")
public class PlanTemporaryServiceImpl extends BaseServiceImpl<PlanTemporaryMapper, PlanTemporaryEntity> implements IPlanTemporaryService {

	private static final String TEMPORARY_SETTLE_ID = "temporary_settle_id";

	/**
	 * 根据项目资金计划id，修改项目资金计划-临时机械租赁的单据状态
	 *
	 * @param planId        项目资金计划id
	 * @param billStateCode 单据状态
	 */
	@Override
	public void updateBillState(Long planId, Integer billStateCode) {
		LambdaUpdateWrapper<PlanTemporaryEntity> updateWrapper = Wrappers.lambdaUpdate();
		updateWrapper.eq(PlanTemporaryEntity::getPlanId, planId);
		updateWrapper.set(PlanTemporaryEntity::getBillState, billStateCode);
		updateWrapper.set(PlanTemporaryEntity::getBillStateName, BillStateEnum.getEnumByStateCode(billStateCode).getDescription());
		super.update(updateWrapper);
	}

	/**
	 * 已申请金额(不含本次)=根据结算单ids查询所有审批通过或已提交的【项目资金计划】-【临时机械租赁】页签数据，统计该结算单的“本次计划付款金额”
	 *
	 * @param settleIds 结算单ids
	 *
	 * @return 已申请金额(不含本次)
	 */
	@Override
	public Map<String, Object> fetchTemporaryValue(Collection<Long> settleIds) {
		HashMap<String, Object> result = new HashMap<>();

		QueryWrapper<PlanTemporaryEntity> queryWrapper = Wrappers.query();
		queryWrapper.in("bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
		queryWrapper.in(TEMPORARY_SETTLE_ID, settleIds);
		queryWrapper.groupBy(TEMPORARY_SETTLE_ID);
		queryWrapper.select("temporary_settle_id as temporarySettleId,ifnull(sum(temporary_plan_payment_mny), 0) as temporaryAppliedMny");
		List<Map<String, Object>> resultMap = super.listMaps(queryWrapper);
		if (CollectionUtils.isNotEmpty(resultMap)) {
			return converToMap(resultMap);
		}

		return result;
	}

	private Map<String, Object> converToMap(List<Map<String, Object>> listMap) {
		Map<String, Object> resultMap = new HashMap<>();
		for (Map<String, Object> map : listMap) {
			if (!resultMap.containsKey(map.get("temporarySettleId").toString())) {
				resultMap.put(map.get("temporarySettleId").toString(), map.get("temporaryAppliedMny").toString());
			}
		}
		return resultMap;
	}

}
