package com.ejianc.business.profinance.projectloan.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 借款管理-项目还款实体
 *
 * @author baipengyan
 */
@TableName("ejc_profinance_project_repay")
public class ProjectRepayEntity extends BaseEntity {
	private static final long serialVersionUID = -3367495226253555287L;

	@TableField(value = "commit_date")
	private Date commitDate; // 提交日期
	@TableField(value = "commit_user_name")
	private String commitUserName; // 提交人名称
	@TableField(value = "commit_user_code")
	private String commitUserCode; // 提交人账号
	@TableField(value = "effective_date")
	private Date effectiveDate; // 生效日期
	@TableField(value = "bill_code")
	private String billCode; // 单据编号
	@TableField(value = "bill_name")
	private String billName; // 单据名称
	@TableField(value = "bill_state")
	private Integer billState; // 单据状态
	@TableField(value = "bill_state_name")
	private String billStateName; // 单据状态名称
	@TableField(value = "employee_id")
	private Long employeeId; // 经办人id
	@TableField(value = "employee_name")
	private String employeeName; // 经办人名称
	@TableField(value = "department_id")
	private Long departmentId; // 经办部门id
	@TableField(value = "department_name")
	private String departmentName; // 经办部门名称
	@TableField(value = "repay_unit_id")
	private Long repayUnitId; // 还款单位id
	@TableField(value = "repay_unit_code")
	private String repayUnitCode; // 还款单位编码
	@TableField(value = "repay_unit_name")
	private String repayUnitName; // 还款单位名称
	@TableField(value = "repay_date")
	private Date repayDate; // 还款日期
	@TableField(value = "settle_type_id")
	private Long settleTypeId; // 结算方式id
	@TableField(value = "settle_type_code")
	private String settleTypeCode; // 结算方式编码
	@TableField(value = "settle_type_name")
	private String settleTypeName; // 结算方式名称
	@TableField(value = "cur_total_repay_mny")
	private BigDecimal curTotalRepayMny; // 本次还款金额合计
	@TableField(value = "memo")
	private String memo; // 备注


	@TableField(exist = false)
	@SubEntity(serviceName = "projectRepayDetailService", pidName = "projectRepayId")
	private List<ProjectRepayDetailEntity> projectRepayDetailList = new ArrayList<>(); // 借款管理-项目还款明细


	public Date getCommitDate() {
		return commitDate;
	}

	public void setCommitDate(Date commitDate) {
		this.commitDate = commitDate;
	}

	public String getCommitUserName() {
		return commitUserName;
	}

	public void setCommitUserName(String commitUserName) {
		this.commitUserName = commitUserName;
	}

	public String getCommitUserCode() {
		return commitUserCode;
	}

	public void setCommitUserCode(String commitUserCode) {
		this.commitUserCode = commitUserCode;
	}

	public Date getEffectiveDate() {
		return effectiveDate;
	}

	public void setEffectiveDate(Date effectiveDate) {
		this.effectiveDate = effectiveDate;
	}

	public String getBillCode() {
		return billCode;
	}

	public void setBillCode(String billCode) {
		this.billCode = billCode;
	}

	public String getBillName() {
		return billName;
	}

	public void setBillName(String billName) {
		this.billName = billName;
	}

	public Integer getBillState() {
		return billState;
	}

	public void setBillState(Integer billState) {
		this.billState = billState;
	}

	public String getBillStateName() {
		return billStateName;
	}

	public void setBillStateName(String billStateName) {
		this.billStateName = billStateName;
	}

	public Long getEmployeeId() {
		return employeeId;
	}

	public void setEmployeeId(Long employeeId) {
		this.employeeId = employeeId;
	}

	public String getEmployeeName() {
		return employeeName;
	}

	public void setEmployeeName(String employeeName) {
		this.employeeName = employeeName;
	}

	public Long getDepartmentId() {
		return departmentId;
	}

	public void setDepartmentId(Long departmentId) {
		this.departmentId = departmentId;
	}

	public String getDepartmentName() {
		return departmentName;
	}

	public void setDepartmentName(String departmentName) {
		this.departmentName = departmentName;
	}

	public Long getRepayUnitId() {
		return repayUnitId;
	}

	public void setRepayUnitId(Long repayUnitId) {
		this.repayUnitId = repayUnitId;
	}

	public String getRepayUnitCode() {
		return repayUnitCode;
	}

	public void setRepayUnitCode(String repayUnitCode) {
		this.repayUnitCode = repayUnitCode;
	}

	public String getRepayUnitName() {
		return repayUnitName;
	}

	public void setRepayUnitName(String repayUnitName) {
		this.repayUnitName = repayUnitName;
	}

	public Date getRepayDate() {
		return repayDate;
	}

	public void setRepayDate(Date repayDate) {
		this.repayDate = repayDate;
	}

	public Long getSettleTypeId() {
		return settleTypeId;
	}

	public void setSettleTypeId(Long settleTypeId) {
		this.settleTypeId = settleTypeId;
	}

	public String getSettleTypeCode() {
		return settleTypeCode;
	}

	public void setSettleTypeCode(String settleTypeCode) {
		this.settleTypeCode = settleTypeCode;
	}

	public String getSettleTypeName() {
		return settleTypeName;
	}

	public void setSettleTypeName(String settleTypeName) {
		this.settleTypeName = settleTypeName;
	}

	public BigDecimal getCurTotalRepayMny() {
		return curTotalRepayMny;
	}

	public void setCurTotalRepayMny(BigDecimal curTotalRepayMny) {
		this.curTotalRepayMny = curTotalRepayMny;
	}

	public String getMemo() {
		return memo;
	}

	public void setMemo(String memo) {
		this.memo = memo;
	}


	public List<ProjectRepayDetailEntity> getProjectRepayDetailList() {
		return projectRepayDetailList;
	}

	public void setProjectRepayDetailList(List<ProjectRepayDetailEntity> projectRepayDetailList) {
		this.projectRepayDetailList = projectRepayDetailList;
	}
}
