package com.ejianc.business.profinance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.contractbase.pool.enums.SettleSourceTypeEnum;
import com.ejianc.business.contractbase.pool.settlepool.api.ISettlePoolApi;
import com.ejianc.business.contractbase.pool.settlepool.vo.SettlePoolVO;
import com.ejianc.business.financeintegration.PMPayApply.api.IPMPayApplyApi;
import com.ejianc.business.profinance.bean.PaymentApplyDetailEntity;
import com.ejianc.business.profinance.bean.PaymentApplyEntity;
import com.ejianc.business.profinance.mapper.PaymentApplyDetailMapper;
import com.ejianc.business.profinance.service.IPaymentApplyDetailService;
import com.ejianc.business.profinance.service.IPaymentApplyService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 付款申请详情
 *
 * @author generator
 */
@Service("paymentApplyDetailService")
public class PaymentApplyDetailServiceImpl extends BaseServiceImpl<PaymentApplyDetailMapper, PaymentApplyDetailEntity> implements IPaymentApplyDetailService {
    @Autowired
    private ISettlePoolApi settlePoolApi;
    @Autowired
    private IPaymentApplyService applyService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPMPayApplyApi ipmPayApplyApi;
    @Override
    public BigDecimal queryAlreadyApplyMny(String sourceId) {
        //已申请金额
        BigDecimal alreadyApplyMny = BigDecimal.ZERO;
        BigDecimal advancePaymentDeduction = BigDecimal.ZERO;

        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("source_id", new Parameter(QueryParam.EQ, sourceId));
        List<PaymentApplyDetailEntity> paymentApplyDetailEntities = super.queryList(queryParam, false);
        for (PaymentApplyDetailEntity entity : paymentApplyDetailEntities) {
            if (entity.getCurrentApplyMny() != null) {
                alreadyApplyMny = alreadyApplyMny.add(entity.getCurrentApplyMny());
            }
            if (entity.getAdvancePaymentDeduction() != null) {
                advancePaymentDeduction = advancePaymentDeduction.add(entity.getAdvancePaymentDeduction());
            }
        }
        return alreadyApplyMny.add(advancePaymentDeduction);
    }

    @Override
    public SettlePoolVO setResidueMny(SettlePoolVO settlePoolVO) {
        BigDecimal alreadyMny = BigDecimal.ZERO; //已申请金额
        BigDecimal residueMny = BigDecimal.ZERO;//剩余可申请金额
        BigDecimal settleMny = BigDecimal.ZERO;//结算金额
        QueryWrapper<PaymentApplyDetailEntity> listQuery = new QueryWrapper<>();
        listQuery.eq("source_id", settlePoolVO.getId());
        listQuery.select("sum(current_apply_mny)");
        PaymentApplyDetailEntity entity = super.getOne(listQuery); //获取到当前结算单的已结算金额
        //设置剩余可申请金额
        settlePoolVO.setResidueApplyMny(settlePoolVO.getCurTaxMny().subtract(entity.getCurrentApplyMny()));
        return settlePoolVO;
    }

    @Override
    public boolean releaseApplyList(PaymentApplyEntity entity){
        boolean flag = false;
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("pay_id", new Parameter(QueryParam.EQ, entity.getId()));
        List<PaymentApplyDetailEntity> paymentApplyDetailEntities = super.queryList(queryParam);
        List<Long> sourceIdS = paymentApplyDetailEntities.stream()
                .filter(item -> item.getSourceId() != null)
                .map(PaymentApplyDetailEntity::getSourceId).collect(Collectors.toList());
        //判断是否需要去结算池释放
        if (sourceIdS.size() > 0) {
            //查询当前引用的结算单
            CommonResponse<List<SettlePoolVO>> bySourceIds = settlePoolApi.getBySourceIds(sourceIdS);
            logger.info("根据结算单ids-{}查询对应结算单结果：{}", JSONObject.toJSONString(sourceIdS), JSONObject.toJSONString(bySourceIds));
            if (!bySourceIds.isSuccess()) {
                logger.error("根据结算单ids-{}查询对应结算单结果：{}", JSONObject.toJSONString(sourceIdS), JSONObject.toJSONString(bySourceIds));
                throw new BusinessException("付款单关闭失败，根据结算单Id列表查询结算单信息失败！");
            }
            //针对每个结算单的id去处理值
            List<SettlePoolVO> data = bySourceIds.getData();
            Map<Long, PaymentApplyDetailEntity> detailMap =
                    paymentApplyDetailEntities.stream()
                            .collect(Collectors.toMap(PaymentApplyDetailEntity::getSourceId, detailEntity -> detailEntity));
            logger.info("本次关闭付款单-{}查询到结算单列表：{}", entity.getId().toString(), JSONObject.toJSONString(data));
            //根据id对应去修改值
            for (SettlePoolVO poolVO : data) {
                PaymentApplyDetailEntity detailEntity = detailMap.get(poolVO.getSourceId());
                //设置实际申请占用金额 默认等于申请金额 关闭后默认等于实际付款
                detailEntity.setActualApplyMny(detailEntity.getActualPaymentMny());
                //计算金额
                //设置结算单剩余可申请金额  结算单剩余可申请金额 = 结算单剩余可申请金额 + 本期申请金额 - 已支付金额
                logger.info("结算单 id-{}，当前剩余可申请金额-{}，本次付款单中的申请金额-{}, 已支付金额-{}", poolVO.getId().toString(), poolVO.getResidueApplyMny(), detailEntity.getCurrentApplyMny(), null != detailEntity.getActualPaymentMny() ? detailEntity.getActualPaymentMny() : BigDecimal.ZERO);
                poolVO.setResidueApplyMny(poolVO.getResidueApplyMny().add(detailEntity.getCurrentApplyMny()).subtract(null != detailEntity.getActualPaymentMny() ? detailEntity.getActualPaymentMny() : BigDecimal.ZERO));
                //设置结算单已申请金额   结算单已申请金额 = 结算单可申请金额 - 结算单剩余可申请金额
                if (poolVO.getSourceType().equals(SettleSourceTypeEnum.劳务分包最终结算.getCode()) || poolVO.getSourceType().equals(SettleSourceTypeEnum.专业分包最终结算.getCode())) {
                    if (poolVO.getTotalNodeTaxDifference() != null) {
                        poolVO.setAlreadyApplyMny(poolVO.getTotalNodeTaxDifference().subtract(poolVO.getResidueApplyMny()));
                    }
                } else {
                    poolVO.setAlreadyApplyMny(poolVO.getCurTaxMny().subtract(poolVO.getResidueApplyMny()));
                }
            }

            logger.info("本次关闭付款单-{}修改的结算单列表：{}",entity.getId().toString(), JSONObject.toJSONString(data));
            CommonResponse<List<SettlePoolVO>> listCommonResponse = settlePoolApi.saveOrUpdateBatch(data);
            logger.info("关闭付款单-{}修改的结算单结果: {}", JSONObject.toJSONString(listCommonResponse));

            if (!listCommonResponse.isSuccess()) {
                flag = false;
                logger.error("关闭付款单-{}失败，更新其下结算单剩余可申请金额失败，调用结算池服务结果：{}", JSONObject.toJSONString(entity), JSONObject.toJSONString(listCommonResponse));
                throw new BusinessException("关闭付款单失败，更新其下结算单剩余可申请金额失败！");
            }
            flag = true;
        }else {
            flag =  true;
        }
        return flag;
    }

}
