package com.ejianc.business.profinance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractPerformanceStateEnum;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.pool.enums.SettleSourceTypeEnum;
import com.ejianc.business.contractbase.pool.settlepool.api.ISettlePoolApi;
import com.ejianc.business.contractbase.pool.settlepool.vo.SettlePoolVO;
import com.ejianc.business.financeintegration.PMPayApply.api.IPMPayApplyApi;
import com.ejianc.business.financeintegration.PMPayApply.vo.PMPayApplyVO;
import com.ejianc.business.profinance.bean.*;
import com.ejianc.business.profinance.common.enums.BillHandleTypeEnum;
import com.ejianc.business.profinance.common.service.IBillHandleResultService;
import com.ejianc.business.profinance.common.vo.BillHandleResultVO;
import com.ejianc.business.profinance.enums.PaymentTypeEnum;
import com.ejianc.business.profinance.mapper.PaymentApplyMapper;
import com.ejianc.business.profinance.service.*;
import com.ejianc.business.profinance.vo.ContractPaymentResultVO;
import com.ejianc.business.profinance.vo.PaymentApplyDetailVO;
import com.ejianc.business.profinance.vo.PaymentApplyMnyTopVO;
import com.ejianc.business.profinance.vo.PaymentApplyVO;
import com.ejianc.business.promaterial.check.api.ICheckApi;
import com.ejianc.business.promaterial.check.vo.CheckVO;
import com.ejianc.business.report.vo.DailyFinanceInfoVO;
import com.ejianc.business.temporary.userecord.api.ITemporaryUseRecordApi;
import com.ejianc.business.temporary.userecord.vo.TemporaryUseRecordVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.seata.spring.annotation.GlobalTransactional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 付款申请主实体
 * 
 * @author generator
 * 
 */
@Service("paymentApplyService")
public class PaymentApplyServiceImpl extends BaseServiceImpl<PaymentApplyMapper, PaymentApplyEntity> implements IPaymentApplyService{

    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String OPERATE = "PROFINANCE_PAY_RESULT";
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private PaymentApplyMapper paymentApplyMapper;

    @Autowired
    private IContractLawsuitService lawsuitService;
    @Autowired
    private IPaymentApplyDetailService detailService;
    @Autowired
    private IContractPoolApi contractPoolApi;
    @Autowired
    private ISettlePoolApi settlePoolApi;
    @Autowired
    private ISalaryPayApplyService payApplyService;

    @Autowired
    private IPMPayApplyApi ipmPayApplyApi;

    @Autowired
    private IBillHandleResultService billHandleResultService;

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private ICheckApi checkApi;
    @Autowired
    private ITemporaryUseRecordApi recordApi;
    private static final String BILL_CODE = "PAY_CON_REF";
    private static final String NO_CONTRACT_BILL_CODE = "PAY_NO_CON_REF";

    @Autowired
    private IPaymentApplyRecordService recordService;

    @Autowired
    private IPMPayApplyApi pmPayApplyApi;


    @Override
    public CommonResponse updateSettlePool(List<Long> sourceIdS) {
        CommonResponse<List<SettlePoolVO>> bySourceIds = settlePoolApi.getBySourceIds(sourceIdS);
        logger.info("查询信息"+JSONObject.toJSONString(bySourceIds));
        if (bySourceIds.isSuccess()) {
            List<SettlePoolVO> data = bySourceIds.getData();
            for (SettlePoolVO vo : data) {
                QueryWrapper<PaymentApplyDetailEntity> listQuery = new QueryWrapper<>();
                listQuery.eq("source_id", vo.getSourceId());
                listQuery.select("ifnull(sum(current_apply_mny + advance_payment_deduction),0) as current_apply_mny");
                listQuery.eq("dr", BaseVO.DR_UNDELETE);
                PaymentApplyDetailEntity entity = detailService.getOne(listQuery); //获取到当前结算单的已结算金额
                logger.info("结算单id-{}累计已申请付款金额：{}", vo.getSourceId(), entity.getCurrentApplyMny());
                //设置剩余可申请金额
                String sourceType = vo.getSourceType();
                vo.setAlreadyApplyMny(entity.getCurrentApplyMny());
                if (sourceType.equals(SettleSourceTypeEnum.劳务分包最终结算.getCode())||sourceType.equals(SettleSourceTypeEnum.专业分包最终结算.getCode())){
                    if (vo.getTotalNodeTaxDifference()!=null){
                        vo.setResidueApplyMny(vo.getTotalNodeTaxDifference().subtract(vo.getAlreadyApplyMny()));
                    }
                }else {
                    vo.setResidueApplyMny(vo.getCurTaxMny().subtract(vo.getAlreadyApplyMny()));
                }
            }
            logger.info("修改信息"+JSONObject.toJSONString(data));
            CommonResponse<List<SettlePoolVO>> listCommonResponse = settlePoolApi.saveOrUpdateBatch(data);
            logger.info("修改返回信息"+JSONObject.toJSONString(listCommonResponse));
            CommonResponse<List<SettlePoolVO>> updateLate = settlePoolApi.getBySourceIds(sourceIdS);
            logger.info("修改后查询信息"+JSONObject.toJSONString(updateLate));

            if (!listCommonResponse.isSuccess()){
                logger.info("合同公共服务错误"+JSONObject.toJSONString(listCommonResponse.getMsg()));
                throw new BusinessException(listCommonResponse.getMsg());
            }
        } else {
            logger.error(bySourceIds.getMsg());
            throw new BusinessException("网络异常，获取结算单失败,请稍后再试");
        }
        return CommonResponse.success();
    }

    @Override
    public boolean saveOrUpdatePaymentApply(PaymentApplyEntity entity, boolean syncEs) {
        if (entity.getPaymentContractFlag()==0){
            PaymentApplyEntity dbEntity = null;
            if(null != entity.getId()) {
                dbEntity = super.selectById(entity.getId());
            }
            Integer finallyFlag = entity.getFinallyFlag();
            if(0 == finallyFlag) {
                if(null == dbEntity || dbEntity.getFinallyFlag() == 1) {
                    logger.info("当前付款申请的是否最后一次付款状态为 是 ，调用合同接口修改合同履约状态为已结束");
                    // 保存数据时：当是最后一次支付时调用接口修改合同履约状态为已封账
                    ContractPoolVO contractPoolVO = new ContractPoolVO();
                    //设置同步更新对应合同单据
                    contractPoolVO.setSyncWithContractBill(true);
                    contractPoolVO.setId(entity.getContractId());
                    contractPoolVO.setPerformanceStatus(ContractPerformanceStateEnum.已结束.getStateCode());
                    CommonResponse<ContractPoolVO> updateResp = contractPoolApi.updatePerformanceStatusByContractId(contractPoolVO);
                    if(!updateResp.isSuccess()) {
                        logger.error("付款申请最后一次付款更改合同履约状态，{}", JSONObject.toJSONString(updateResp));
                        throw new BusinessException("保存失败，更新合同履约状态失败！");
                    }
                }
            } else if(null != dbEntity && dbEntity.getFinallyFlag() == 0) {
                if(null == dbEntity.getContractPerformanceStatus()) {
                    logger.error("付款单最后一次付款由是改为否，当前单据并未存储合同-【{}】原有履约状态，请处理！", dbEntity.getContractId());
                    throw new BusinessException("保存失败，更新合同履约状态失败！");
                }
                logger.info("当前付款申请的是否最后一次付款状态为 否, 旧付款申请数据为是，还原合同-{}的履约状态为：{}", dbEntity.getContractId(), dbEntity.getContractPerformanceStatus());
                ContractPoolVO contractPoolVO = new ContractPoolVO();
                //设置同步更新对应合同单据
                contractPoolVO.setSyncWithContractBill(true);
                contractPoolVO.setId(entity.getContractId());
                contractPoolVO.setPerformanceStatus(dbEntity.getContractPerformanceStatus());
                CommonResponse<ContractPoolVO> updateResp = contractPoolApi.updatePerformanceStatusByContractId(contractPoolVO);
                if(!updateResp.isSuccess()) {
                    logger.error("付款申请最后一次付款更改合同履约状态，{}", JSONObject.toJSONString(updateResp));
                    throw new BusinessException("保存失败，更新合同履约状态失败！");
                }
            }
        }
        // 保存数据
        return super.saveOrUpdate(entity, syncEs);
    }

    @Override
    public CommonResponse<PaymentApplyVO> queryUnusedPaymentApply(Integer paymentType, Long projectId, Long supplierId, Date applyDate) {
        PaymentApplyVO paymentApplyVO = new PaymentApplyVO();

        //若当前条件 同一项目+供应商+付款类型 有未生效的申请单，则不能添加新的申请单
        LambdaQueryWrapper<PaymentApplyEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(PaymentApplyEntity::getPaymentType, paymentType);
        lambda.eq(PaymentApplyEntity::getProjectId, projectId);
        lambda.eq(PaymentApplyEntity::getSupplierId, supplierId);
        lambda.and(c -> c.notIn(PaymentApplyEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()));
        int resultCount = super.count(lambda);
        if (resultCount > 0) {
            return CommonResponse.error("当前条件（同一项目+供应商+付款类型）已有未生效的单据，请选择其他项目、供应商或付款类型！。");
        }

        //设置最小可用申请日期
        Date resultDate = queryMaxApplyDate(paymentType, projectId, supplierId);
        if (null == resultDate){
            resultDate = null != applyDate ? applyDate : new Date();
            paymentApplyVO.setMinApplyDate(null);
        }else {
            //如果页面日期大于当前查询出最大日期，则返回页面日期，否则返回最大时间加1秒
            resultDate = DateUtils.addSeconds(resultDate, 1);
            paymentApplyVO.setMinApplyDate(resultDate);
            if (null != applyDate && applyDate.compareTo(resultDate) > 0){
                resultDate = applyDate;
            }
        }
        paymentApplyVO.setApplyDate(resultDate);
        paymentApplyVO.setProjectId(projectId);
        paymentApplyVO.setSupplierId(supplierId);
        paymentApplyVO.setPaymentType(paymentType);
        queryNoContractTotalMny(paymentApplyVO);
        return CommonResponse.success("当前申请单可操作！", paymentApplyVO);
    }

    private Date queryMaxApplyDate(Integer paymentType, Long projectId, Long supplierId) {
        return paymentApplyMapper.selectMaxPaymentApplyDate(paymentType, projectId, supplierId);
    }
    private Date queryMaxDate(Integer paymentType, Long projectId, Long contractId) {
        return paymentApplyMapper.selectMaxDate(paymentType, projectId, contractId);
    }
    @Override
    public CommonResponse<PaymentApplyVO>  checkPayApply(PaymentApplyVO vo) {
        LambdaQueryWrapper<PaymentApplyEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(PaymentApplyEntity::getContractId, vo.getContractId());
        lambda.eq(PaymentApplyEntity::getProjectId, vo.getProjectId());
        lambda.eq(PaymentApplyEntity::getCloseState, 0);
        lambda.and(c -> c.notIn(PaymentApplyEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()));

        int resultCount = super.count(lambda);
        if (resultCount > 0) {
            return CommonResponse.error("当前条件（合同）已有未生效的单据，请选择其他合同！");
        }
        PaymentApplyVO entity = new PaymentApplyVO();
        //设置最小可用申请日期
        Date resultDate = queryMaxDate(vo.getPaymentType(), vo.getProjectId(), vo.getContractId());
        if (null == resultDate){
            resultDate = null != vo.getApplyDate() ? vo.getApplyDate() : new Date();
            entity.setMinApplyDate(null);
        }else {
            //如果页面日期大于当前查询出最大日期，则返回页面日期，否则返回最大时间加1秒
            resultDate = DateUtils.addSeconds(resultDate, 1);
            entity.setMinApplyDate(resultDate);
            if (null != vo.getApplyDate() && vo.getApplyDate().compareTo(resultDate) > 0){
                resultDate = vo.getApplyDate();
            }
        }
        entity.setApplyDate(resultDate);

        return CommonResponse.success("当前申请单可操作！", entity);
    }
    @Override
    public BigDecimal queryAdvanceApplyMny(PaymentApplyVO vo) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contract_id",new Parameter(QueryParam.EQ,vo.getContractId()));
        queryParam.getParams().put("project_id",new Parameter(QueryParam.EQ,vo.getProjectId()));
        queryParam.getParams().put("paymentType",new Parameter(QueryParam.EQ,1));
        queryParam.getParams().put("close_state",new Parameter(QueryParam.EQ,0));
        queryParam.getParams().put("bill_state", new Parameter(QueryParam.IN, Arrays.asList(
                BillStateEnum.COMMITED_STATE.getBillStateCode(),
                BillStateEnum.PASSED_STATE.getBillStateCode())));
        List<PaymentApplyEntity> paymentApplyEntities = super.queryList(queryParam,false);
        BigDecimal advanceApplyMny = BigDecimal.ZERO;
        for (PaymentApplyEntity entity:paymentApplyEntities){
            if (entity.getApprovalMny()!=null){
                advanceApplyMny = advanceApplyMny.add(entity.getApprovalMny());
            }
        }
        return advanceApplyMny;
    }

    @Override
    public BigDecimal queryTotalPayMny(PaymentApplyVO vo) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contract_id",new Parameter(QueryParam.EQ,vo.getContractId()));
        queryParam.getParams().put("project_id",new Parameter(QueryParam.EQ,vo.getProjectId()));
        queryParam.getParams().put("bill_state", new Parameter(QueryParam.IN, Arrays.asList(
                BillStateEnum.COMMITED_STATE.getBillStateCode(),
                BillStateEnum.PASSED_STATE.getBillStateCode())));
        List<PaymentApplyEntity> paymentApplyEntities = super.queryList(queryParam,false);
        BigDecimal totalPayMny = BigDecimal.ZERO;
        for (PaymentApplyEntity entity:paymentApplyEntities){
            if (entity.getApplyMny()!=null){
                if (entity.getActualMny()!=null) {
                    totalPayMny = totalPayMny.add(entity.getActualMny());
                }
            }
        }
        return totalPayMny;
    }

    @Override
    public BigDecimal queryLastApplyMny(PaymentApplyVO vo) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contract_id",new Parameter(QueryParam.EQ,vo.getContractId()));
        queryParam.getParams().put("project_id",new Parameter(QueryParam.EQ,vo.getProjectId()));
        queryParam.getParams().put("close_state",new Parameter(QueryParam.EQ,0));
        queryParam.getParams().put("bill_state", new Parameter(QueryParam.IN, Arrays.asList(
                BillStateEnum.COMMITED_STATE.getBillStateCode(),
                BillStateEnum.PASSED_STATE.getBillStateCode())));
        List<PaymentApplyEntity> paymentApplyEntities = super.queryList(queryParam,false);
        BigDecimal advanceApplyMny = BigDecimal.ZERO;
        for (PaymentApplyEntity entity:paymentApplyEntities){
            if (entity.getApprovalMny()!=null){
                advanceApplyMny = advanceApplyMny.add(entity.getApprovalMny());
            }
        }
        return advanceApplyMny;
    }

    @Override
    public BigDecimal queryPendDeduct(PaymentApplyVO vo) {
        BigDecimal advanceMny = BigDecimal.ZERO;
        BigDecimal normalMny = BigDecimal.ZERO;
        BigDecimal pendDeductAdvancePayment = BigDecimal.ZERO;

        //代扣回预付款 = 工程预付款申请金额 +工人工资支付申请金额
        //正常付款  扣减预付款金额

        //查询当前合同下 付款类型是正常付款的 抵扣预付付款金额
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contract_id",new Parameter(QueryParam.EQ,vo.getContractId()));
        queryParam.getParams().put("project_id",new Parameter(QueryParam.EQ,vo.getProjectId()));
        queryParam.getParams().put("payment_type",new Parameter(QueryParam.EQ,0));
        queryParam.getParams().put("close_state",new Parameter(QueryParam.EQ,0));
        queryParam.getParams().put("bill_state", new Parameter(QueryParam.IN, Arrays.asList(
                BillStateEnum.COMMITED_STATE.getBillStateCode(),
                BillStateEnum.PASSED_STATE.getBillStateCode())));
        List<PaymentApplyEntity> normalList = super.queryList(queryParam, false);
        for (PaymentApplyEntity entity:normalList){
            if (entity.getDeductAdvancePayment()!=null){
                //抵扣预付付款金额
                normalMny = normalMny.add(entity.getDeductAdvancePayment());
            }
        }
        //查询当前合同下 付款类型是预付款的 实际支付金额
        QueryParam query = new QueryParam();
        query.getParams().put("contract_id",new Parameter(QueryParam.EQ,vo.getContractId()));
        query.getParams().put("project_id",new Parameter(QueryParam.EQ,vo.getProjectId()));
        query.getParams().put("payment_type",new Parameter(QueryParam.EQ,1));
        query.getParams().put("bill_state", new Parameter(QueryParam.IN, Arrays.asList(
                BillStateEnum.COMMITED_STATE.getBillStateCode(),
                BillStateEnum.PASSED_STATE.getBillStateCode())));
        queryParam.getParams().put("close_state",new Parameter(QueryParam.EQ,0));

        List<PaymentApplyEntity> advanceList  = super.queryList(query, false);
        for (PaymentApplyEntity entity:advanceList){
            if (entity.getApplyMny()!=null){
                advanceMny = advanceMny.add(entity.getApplyMny());
            }
        }
        //实际付款-扣减
        pendDeductAdvancePayment = advanceMny.subtract(normalMny);
        BigDecimal paySalary = BigDecimal.ZERO;

        //待扣回预付款”=该合同累计预付款金额+该合同的累计工人工资支付金额
        if (StringUtils.isNotEmpty(vo.getSourceCategoryType())||ContractTypeEnum.劳务分包合同.getTypeCode().equals(vo.getSourceCategoryType())){
            //查询该合同的 累计工人工资支付金额
            QueryParam queryParam1 = new QueryParam();
            queryParam1.getParams().put("contract_id",new Parameter(QueryParam.EQ,vo.getContractId()));
            queryParam1.getParams().put("bill_state", new Parameter(QueryParam.IN, Arrays.asList(
                    BillStateEnum.COMMITED_STATE.getBillStateCode(),
                    BillStateEnum.PASSED_STATE.getBillStateCode())));
            queryParam1.getParams().put("is_repeat_bill", new Parameter(QueryParam.EQ, 0)); //排除掉重发的单据
            queryParam1.getParams().put("pay_type", new Parameter(QueryParam.IN, Arrays.asList("1","4"))); //只要总包代发的单据

            List<SalaryPayApplyEntity> payApplyEntities = payApplyService.queryList(queryParam1);
            for (SalaryPayApplyEntity entity:payApplyEntities){
                if (null!=entity.getApplyTaxMny()){
                    paySalary = paySalary.add(entity.getApplyTaxMny());
                }
            }
        }

        return pendDeductAdvancePayment.add(paySalary);
    }

    @Override
    public BigDecimal queryPendDisbursements(PaymentApplyVO vo) {
        BigDecimal normalMny = BigDecimal.ZERO;
        //代扣回垫付 = 工人工资支付申请垫付金额 - 已扣回垫付
        //查询当前合同下 付款类型是正常付款的 垫付金额
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contract_id",new Parameter(QueryParam.EQ,vo.getContractId()));
        queryParam.getParams().put("project_id",new Parameter(QueryParam.EQ,vo.getProjectId()));
        queryParam.getParams().put("payment_type",new Parameter(QueryParam.EQ,0));
        queryParam.getParams().put("close_state",new Parameter(QueryParam.EQ,0));
        queryParam.getParams().put("bill_state", new Parameter(QueryParam.IN, Arrays.asList(
                BillStateEnum.COMMITED_STATE.getBillStateCode(),
                BillStateEnum.PASSED_STATE.getBillStateCode())));
        List<PaymentApplyEntity> normalList = super.queryList(queryParam, false);
        for (PaymentApplyEntity entity:normalList){
            if (entity.getDisbursementsPayment()!=null){
                //抵扣垫付金额
                normalMny = normalMny.add(entity.getDisbursementsPayment());
            }
        }

        BigDecimal paySalary = BigDecimal.ZERO;

        if (StringUtils.isNotEmpty(vo.getSourceCategoryType())||ContractTypeEnum.劳务分包合同.getTypeCode().equals(vo.getSourceCategoryType())){
            //查询该合同的 累计工人工资支付金额
            QueryParam queryParam1 = new QueryParam();
            queryParam1.getParams().put("contract_id",new Parameter(QueryParam.EQ,vo.getContractId()));
            queryParam1.getParams().put("bill_state", new Parameter(QueryParam.IN, Arrays.asList(
                    BillStateEnum.COMMITED_STATE.getBillStateCode(),
                    BillStateEnum.PASSED_STATE.getBillStateCode())));
            queryParam1.getParams().put("is_repeat_bill", new Parameter(QueryParam.EQ, 0)); //排除掉重发的单据
            queryParam1.getParams().put("pay_type", new Parameter(QueryParam.EQ, 2)); //只要垫付的单据

            List<SalaryPayApplyEntity> payApplyEntities = payApplyService.queryList(queryParam1);
            for (SalaryPayApplyEntity entity:payApplyEntities){
                if (null!=entity.getApplyTaxMny()){
                    paySalary = paySalary.add(entity.getApplyTaxMny());
                }
            }
        }

        return paySalary.subtract(normalMny);
    }


    @Override
    public BigDecimal queryTotalLitigationMny(PaymentApplyVO vo) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contract_id",new Parameter(QueryParam.EQ,vo.getContractId()));
        queryParam.getParams().put("project_id",new Parameter(QueryParam.EQ,vo.getProjectId()));
        queryParam.getParams().put("bill_state", new Parameter(QueryParam.IN, Arrays.asList(
                BillStateEnum.COMMITED_STATE.getBillStateCode(),
                BillStateEnum.PASSED_STATE.getBillStateCode())));
        List<ContractLawsuitEntity> entities = lawsuitService.queryList(queryParam,false);
        BigDecimal advanceApplyMny = BigDecimal.ZERO;
        for (ContractLawsuitEntity entity:entities){
            if (entity.getSettleMny()!=null){
                advanceApplyMny = advanceApplyMny.add(entity.getSettleMny());
            }
        }
        System.err.println("累计诉讼"+JSONObject.toJSONString(advanceApplyMny));
        return advanceApplyMny;
    }

    @Override
    public BigDecimal queryLastLitigationMny(PaymentApplyVO vo) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contract_id",new Parameter(QueryParam.EQ,vo.getContractId()));
        queryParam.getParams().put("project_id",new Parameter(QueryParam.EQ,vo.getProjectId()));
        queryParam.getParams().put("paymentType",new Parameter(QueryParam.EQ,vo.getPaymentType()));
        queryParam.getParams().put("bill_state", new Parameter(QueryParam.IN, Arrays.asList(
                BillStateEnum.COMMITED_STATE.getBillStateCode(),
                BillStateEnum.PASSED_STATE.getBillStateCode())));
        queryParam.getParams().put("close_state",new Parameter(QueryParam.EQ,0));
        List<PaymentApplyEntity> paymentApplyEntities = super.queryList(queryParam,false);
        BigDecimal lastLitigationMny = BigDecimal.ZERO;
        for (PaymentApplyEntity entity:paymentApplyEntities){
            if (entity.getApprovalMny()!=null){
                lastLitigationMny = lastLitigationMny.add(entity.getApprovalMny());
            }
        }
        return lastLitigationMny;
    }

    @Override
    public BigDecimal queryAlreadyApplyMny(String sourceId) {
        return detailService.queryAlreadyApplyMny(sourceId);
    }

    @Override
    public Map<String, Object> countSumMny(QueryParam param) {
        Map<String, Object> resp = new HashMap<>();
        QueryWrapper wrapper = changeToQueryWrapper(param);
            wrapper.select("sum(apply_mny) as totalApplyMny, sum(approval_mny) as totalApprovalMny, sum(actual_mny) as totalActualMny");
        resp = super.getMap(wrapper);
        if (null == resp) {
            resp = new HashMap<>();
            resp.put("totalApplyMny", 0);
            resp.put("totalApprovalMny", 0);
            resp.put("totalActualMny", 0);
        }
        return resp;
    }

    @Override
    public BigDecimal queryTotalLawsuitMny(PaymentApplyVO vo) {
        return lawsuitService.queryTotalLawsuitMny(vo.getContractId())==null?BigDecimal.ZERO:lawsuitService.queryTotalLawsuitMny(vo.getContractId());
    }

    @Override
    public List<PaymentApplyVO> queryListByContractId(Long contractId) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("contractId", new Parameter(QueryParam.EQ,contractId));
        param.getParams().put("bill_state", new Parameter(QueryParam.IN, Arrays.asList(
                BillStateEnum.COMMITED_STATE.getBillStateCode(),
                BillStateEnum.PASSED_STATE.getBillStateCode())));
        param.getOrderMap().put("apply_date", QueryParam.DESC);
        List<PaymentApplyEntity> list = super.queryList(param);
        List<PaymentApplyVO> vos = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(list)){
            vos = BeanMapper.mapList(list, PaymentApplyVO.class);
        }
        return vos;
    }



    @Override
    public CommonResponse<ContractPaymentResultVO> queryJsonByContractId(Long contractId) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("contractId", new Parameter(QueryParam.EQ,contractId));
        param.getParams().put("bill_state", new Parameter(QueryParam.IN, Arrays.asList(
                BillStateEnum.COMMITED_STATE.getBillStateCode(),
                BillStateEnum.PASSED_STATE.getBillStateCode())));
        param.getOrderMap().put("apply_date", QueryParam.DESC);
        List<PaymentApplyEntity> list = super.queryList(param);
        List<PaymentApplyVO> vos = new ArrayList<>();
        BigDecimal totalApplyMny = BigDecimal.ZERO;
        BigDecimal totalApprovalMny = BigDecimal.ZERO;
        BigDecimal totalActualMny = BigDecimal.ZERO;
        BigDecimal paymentRate = BigDecimal.ZERO;
        BigDecimal contractTaxMny = BigDecimal.ZERO;
        BigDecimal contractMny = BigDecimal.ZERO;
        BigDecimal totalStayActualMny = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(list)){
            contractTaxMny = list.get(0).getContractTaxMny();
            contractMny = list.get(0).getContractMny();

            for (PaymentApplyEntity entity:list){
                if (null!=entity.getApplyMny()){
                    totalApplyMny = totalApplyMny.add(entity.getApplyMny());
                }
                if (null!=entity.getApprovalMny()){
                    totalApprovalMny = totalApprovalMny.add(entity.getApprovalMny());
                }
                if (null!=entity.getActualMny()){
                    totalActualMny = totalActualMny.add(entity.getActualMny());
                }

            }
            paymentRate = totalActualMny.divide(contractTaxMny,BigDecimal.ROUND_CEILING);
            vos = BeanMapper.mapList(list, PaymentApplyVO.class);
        }
        ContractPaymentResultVO resultVO = new ContractPaymentResultVO();

        QueryWrapper<PaymentApplyEntity> listQuery = new QueryWrapper<>();
        listQuery.eq("contract_id", contractId);
        listQuery.eq("bill_state", BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        int resultCount = super.count(listQuery);
        if (resultCount > 0) {
            resultVO.setAddFlag(false);
        }else {
            resultVO.setAddFlag(true);
        }

        resultVO.setTotalStayActualMny(totalApplyMny.subtract(totalActualMny));
        resultVO.setContractId(contractId);
        resultVO.setContractMny(contractMny);
        resultVO.setContractTaxMny(contractTaxMny);
        resultVO.setTotalApplyMny(totalApplyMny);
        resultVO.setTotalApprovalMny(totalApprovalMny);
        resultVO.setTotalActualMny(totalActualMny);
        resultVO.setPaymentRate(paymentRate);
        resultVO.setPaymentApplyList(vos);
        return CommonResponse.success("查询成功",resultVO);
    }

//7、
//
//8、当“合同大类”=“大型设备安拆合同”时，取该合同对应的““结算单类型”为“大型设备安拆合同结算”的【结算池】，“本次结算金额”之和
//
//9、
    @Override
    public BigDecimal queryContractHonourMny(PaymentApplyVO vo) {
        ContractPoolVO contractPoolVO = new ContractPoolVO();
        contractPoolVO.setContractId(vo.getContractId());
        contractPoolVO.setSourceTypeName(vo.getSourceCategoryTypeName());
        contractPoolVO.setSourceType(vo.getSourceCategoryType());
        CommonResponse<BigDecimal> res = contractPoolApi.queryContractHonourMny(contractPoolVO);
        if (!res.isSuccess()){
            logger.error("查询合同履约金额报错："+res.getMsg());
        }
        return res.getData();
    }



    @Override
    @Transactional(rollbackFor = Exception.class)
    public CommonResponse<PaymentApplyVO> updateCloseState(PaymentApplyEntity entity,String type){
        //更新结算单可申请金额，将结算单未支付金额加入到其剩余可申请金额中
        boolean b = detailService.releaseApplyList(entity);
        if(!b){
            return CommonResponse.error("付款单关闭失败，回写结算单剩余可申请金额失败！");
        }
        //申请单释放完毕 开始 对接一键支付
        logger.info("结算单可申请金额释放完毕 开始对接一键支付");
        String PMMsg = abandonOrClose(entity, type);
        if (StringUtils.isNotBlank(PMMsg)){
            logger.error("付款单-[{}]关闭失败，更新付款中间表失败，回滚结算单释放的可支付金额! ", JSONObject.toJSONString(entity));
            throw new BusinessException(PMMsg);
        }
        logger.info("对接一键支付完毕 开始修改实体");
        super.saveOrUpdate(entity, false);
        PaymentApplyVO vo = BeanMapper.map(entity, PaymentApplyVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * 关闭 弃审 对接 一键支付
     * @param entity
     * @return
     */
    @Override
    public String abandonOrClose(PaymentApplyEntity entity,String type) {
        boolean locked = false;
        String handleMsg =  null;
        StringBuilder msgBuilder = new StringBuilder();
        msgBuilder.append("付款单[").append(entity.getBillCode()).append("]中间表处理");

        Jedis jedis = jedisPool.getResource();
        String contractS = "-1";
        if (entity.getContractId()!=null){
            contractS = entity.getContractId().toString();
        }
        String redisKey = entity.getProjectId() + "::" + entity.getSupplierId() + "::" + contractS + "::" + entity.getPayeeId();
        boolean flag = false;
        try {
            //获取redis锁
            //执行弃审刷数据逻辑
            locked = RedisTool.tryLock(jedis, redisKey, OPERATE, 600);
            if(!locked) {
                logger.error("付款单据{}进行操作：{} 失败，根据单据获取redis锁失败！", JSONObject.toJSONString(entity), type);

                //记录处理结果
                msgBuilder.append("失败，操作前获取Redis锁失败！");
                billHandleResultService.sendHandleResult(JSONObject.toJSONString(entity), entity.getId().toString(), BillHandleTypeEnum.付款申请单.getTypeCode(),
                         BillHandleResultVO.HANDLE_CODE_FAIL, msgBuilder.toString(), false);
                return "操作失败，付款单更新财务表前加锁失败！";
            }

            PMPayApplyVO paramVO = new PMPayApplyVO();
            // 项目ID
            paramVO.setProjectId(entity.getProjectId().toString());
            // 供应商ID
            paramVO.setSupplierId(entity.getSupplierId().toString());
            // 收款单位ID
            paramVO.setPayeeId(entity.getPayeeId().toString());

            // 是否有合同    sourceEntity中：0-有合同，1无合同，targetVO中：1-有合同，0-无合同
            Integer paymentContractFlag = entity.getPaymentContractFlag();
            // 合同登记ID
            Long contractId = entity.getContractId();
            paramVO.setIsContract(null);
            paramVO.setContractRegisterId(null);
            if (paymentContractFlag != null) {
                if (paymentContractFlag == 0) {// 有合同
                    paramVO.setIsContract(1);
                    paramVO.setContractRegisterId(contractId.toString());
                } else {// 无合同
                    paramVO.setIsContract(0);
                    paramVO.setContractRegisterId("-1");
                }
            }
            paramVO.setCurApplyMny(entity.getApprovalMny());
            if (type.equals("关闭")){
                //1-PM付款申请弃审、2-PM付款申请关闭
                paramVO.setType(2);
                //本次释放金额 = 关闭单子 涉及到 批复金额-付款金额 这些 是需要关闭的
                paramVO.setCurReleaseMny(entity.getApprovalMny().subtract(null != entity.getActualMny() ? entity.getActualMny() : BigDecimal.ZERO));
                // 本次申请金额
            }else if (type.equals("弃审")){
                paramVO.setType(1);
                paramVO.setCurReleaseMny(entity.getApprovalMny());
            }

            logger.info("调用zzyj-financeintegration，对付款单进行【{}】操作，数据-【{}】", type, JSONObject.toJSONString(paramVO));
            CommonResponse<PMPayApplyVO> res = ipmPayApplyApi.abandonOrClose(paramVO);
            logger.info("调用zzyj-financeintegration，对付款单进行【{}】操作，数据-【{}】，接口返回结果-{}",type, JSONObject.toJSONString(paramVO), JSONObject.toJSONString(res, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));

            if (!res.isSuccess()){
                logger.error("调用PM付款申请的接口 返回错误信息: {}", JSONObject.toJSONString(res));
                //记录处理结果
                msgBuilder.append("失败，调用PM付款申请接口返回失败，返回错误信息：" + res.getMsg());
                billHandleResultService.sendHandleResult(JSONObject.toJSONString(entity), entity.getId().toString(), BillHandleTypeEnum.付款申请单.getTypeCode(),
                        BillHandleResultVO.HANDLE_CODE_FAIL, msgBuilder.toString(), false);
                handleMsg = StringUtils.isNotBlank(res.getMsg()) ? res.getMsg() : "操作失败，付款单更新财务表失败！";
            }else {
                flag = true;
            }

        } catch (Exception e) {
            flag = false;
            logger.error("执行刷数据-【{}】逻辑异常，", JSONObject.toJSONString(entity), e);

            //记录处理结果
            msgBuilder.append("失败，中间表处理异常：" + e.getMessage());
            handleMsg = "操作失败，付款单更新财务表失败！";
            billHandleResultService.sendHandleResult(JSONObject.toJSONString(entity), entity.getId().toString(), BillHandleTypeEnum.付款申请单.getTypeCode(),
                    BillHandleResultVO.HANDLE_CODE_FAIL, msgBuilder.toString(), false);
        } finally {
            //释放锁
            releaseLock(jedis, locked, redisKey, OPERATE);
        }

        if(flag) {
            //记录处理结果
            msgBuilder.append("成功！");
            billHandleResultService.sendHandleResult(JSONObject.toJSONString(entity), entity.getId().toString(), BillHandleTypeEnum.付款申请单.getTypeCode(),
                    BillHandleResultVO.HANDLE_CODE_SUC, msgBuilder.toString(), false);
        }
        return handleMsg;

    }

    @Override
    public Map<Long, BigDecimal> querySumMny(Map<String, List<Long>> map) {
        logger.info("打印入参map:"+JSONObject.toJSONString(map));
        Map<Long,BigDecimal> resultMap = new HashMap<>();
        List<Long> suplyIds = map.get("suplyIds");
        List<Long> orgIds = map.get("orgIds");
        if(null == suplyIds || null == orgIds){
            logger.info("参数验证失败！");
            return null;
        }
        List<PaymentApplyEntity> paymentApplyEntities = paymentApplyMapper.querySumMny(suplyIds, orgIds);
        for (PaymentApplyEntity entity:paymentApplyEntities
             ) {
            resultMap.put(entity.getSupplierId(),entity.getActualMny());
        }
        return resultMap;
    }

    @Override
    @GlobalTransactional(name="PaymentApplyServiceImpl_batchDel", rollbackFor = Exception.class)
    public void batchDel(List<PaymentApplyVO> vos) {
        logger.info("11111111111111111111111111111111111111111111111111111111111111111111111111111111");
        List<Long> ids = vos.stream().map(PaymentApplyVO::getId).collect(Collectors.toList());

        //需要根据 结算类型做删除分支
        for (Long id : ids) {
            PaymentApplyEntity entity = super.selectById(id);
            logger.info("22222222222222222222222222222222222222222222222222222222,id:{}",id);
            //有子表对接结算池
            if (entity.getPaymentApplyDetailList().size() > 0) {
                //查询当前子表 有多少数据 这些都是要被删除的
                List<PaymentApplyDetailEntity> detailList = entity.getPaymentApplyDetailList();
                //过滤类型
                List<Long> sourceIdS = detailList.stream().filter(item -> item.getSourceId()!=null).map(PaymentApplyDetailEntity::getSourceId).collect(Collectors.toList());
                logger.info("3333333333333333333333333333333333333333333333333333333333333333,sourceIdS:{}",sourceIdS.toString());
                if (sourceIdS.size()>0){
                    //查询当前引用的结算单
                    CommonResponse<List<SettlePoolVO>> bySourceIds = settlePoolApi.getBySourceIds(sourceIdS);
                    if (!bySourceIds.isSuccess()) {
                        logger.info("4444444444444444444444444444444444444444444444444444444444444,bySourceIds.getMsg:{}",bySourceIds.getMsg());
                        throw new BusinessException(bySourceIds.getMsg());
                    }
                    //针对每个结算单的id去处理值
                    List<SettlePoolVO> data = bySourceIds.getData();

                    logger.info("55555555555555555555555555555555555555555555555555555555555555,data.toString:{}",data.toString());
                    Map<Long, PaymentApplyDetailEntity> detailMap = detailList.stream().collect(Collectors.toMap(PaymentApplyDetailEntity::getSourceId, detailEntity -> detailEntity));
                    //根据id对应去修改值
                    for (SettlePoolVO poolVO : data) {
                        logger.info("666666666666666666666666666666666666666666666666666666666666666666666666666,poolVO.id:{}",poolVO.getId());
                        PaymentApplyDetailEntity detailEntity = detailMap.get(poolVO.getSourceId());
                        //计算金额
                        //设置结算单剩余可申请金额  结算单剩余可申请金额 = 结算单剩余可申请金额 + 本期申请金额 + 预扣款
                        poolVO.setResidueApplyMny(poolVO.getResidueApplyMny().add(detailEntity.getCurrentApplyMny()).add(detailEntity.getAdvancePaymentDeduction()));
                        //设置结算单已申请金额   结算单已申请金额 = 结算单可申请金额 - 结算单剩余可申请金额
                        if (poolVO.getSourceType().equals(SettleSourceTypeEnum.劳务分包最终结算.getCode())||poolVO.getSourceType().equals(SettleSourceTypeEnum.专业分包最终结算.getCode())){
                            if (poolVO.getTotalNodeTaxDifference()!=null){
                                poolVO.setAlreadyApplyMny(poolVO.getTotalNodeTaxDifference().subtract(poolVO.getResidueApplyMny()));
                            }
                        }else {
                            poolVO.setAlreadyApplyMny(poolVO.getCurTaxMny().subtract(poolVO.getResidueApplyMny()));
                        }
                    }
                    logger.info(JSONObject.toJSONString(data) + "@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
                    CommonResponse<List<SettlePoolVO>> listCommonResponse = settlePoolApi.saveOrUpdateBatch(data);
                    if (!listCommonResponse.isSuccess()) {
                        throw new BusinessException(listCommonResponse.getMsg());
                    }
                }

            }

            if (entity.getFinallyFlag() !=null && 0 == entity.getFinallyFlag() && (null != entity.getContractId()) && StringUtils.isNotBlank(entity.getContractPerformanceStatus())){
                ContractPoolVO contractPoolVO = new ContractPoolVO();
                //设置同步更新合同单据
                contractPoolVO.setSyncWithContractBill(true);
                contractPoolVO.setId(entity.getContractId());
                //取出保存付款单时，保存的合同履约状态
                contractPoolVO.setPerformanceStatus(entity.getContractPerformanceStatus());
                logger.info("更新合同-【{}】履约状态为-{}：", contractPoolVO.getId(), entity.getContractPerformanceStatus());
                CommonResponse<ContractPoolVO> updateResp = contractPoolApi.updatePerformanceStatusByContractId(contractPoolVO);
                if(!updateResp.isSuccess()) {
                    throw new BusinessException(StringUtils.isNotBlank(updateResp.getMsg()) ? updateResp.getMsg() : "操作失败，更新合同池履约状态失败！");
                }
            }
        }
        super.removeByIds(ids, false);
    }

    @Override
    @GlobalTransactional(name="PaymentApplyServiceImpl_savePaymentApply", rollbackFor = Exception.class)
    public PaymentApplyVO savePaymentApply(PaymentApplyVO saveOrUpdateVO) {
        PaymentApplyEntity  entity = BeanMapper.map(saveOrUpdateVO, PaymentApplyEntity.class);

        if (entity.getId() == null || entity.getId() == 0) {
            CommonResponse<String> billCode = billCodeApi.generateBillCode(BillCodeParam.build(saveOrUpdateVO.getPaymentContractFlag() == 0 ?
                    BILL_CODE:NO_CONTRACT_BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO));
            if (!billCode.isSuccess()){
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            entity.setBillCode(billCode.getData());
            entity.setPaymentStatus(1);
            entity.setCloseState(0);
            entity.setActualMny(BigDecimal.ZERO);
        }
        saveOrUpdatePaymentApply(entity, false);

        //对接结算池
        List<Long> sourceIdS = saveOrUpdateVO.getPaymentApplyDetailList().stream().filter(item -> item.getSourceId()!=null).map(PaymentApplyDetailVO::getSourceId).collect(Collectors.toList());
        logger.info("本次更新结算单Id列表-{}", JSONObject.toJSONString(sourceIdS));
        if (CollectionUtils.isNotEmpty(sourceIdS)) {
            updateSettlePool(sourceIdS);
        }
        return BeanMapper.map(entity, PaymentApplyVO.class);
    }

    @Override
    public JSONObject queryDataModelInfo(Long projectId) {
        logger.info("queryDataModelInfo--");
        JSONObject data = new JSONObject();
        DecimalFormat df1 = new DecimalFormat("0.##");

        //初始化履约金额
        BigDecimal totalPerformanceMny = BigDecimal.ZERO;
        BigDecimal checkTaxMny = BigDecimal.ZERO;
        BigDecimal recordTaxMny = BigDecimal.ZERO;


        //初始化结算金额
        BigDecimal totalSettleMny = BigDecimal.ZERO;
        //初始化批复金额
        BigDecimal totalActualMny = BigDecimal.ZERO;
        //初始化实付金额
        BigDecimal totalApprovalMny = BigDecimal.ZERO;
        //查询项目下的 材料验收入库单
        CommonResponse<JSONObject> jsonObjectCommonResponse = checkApi.querycheckMnyByProjectId(projectId);
        if (!jsonObjectCommonResponse.isSuccess()){
            throw new BusinessException(jsonObjectCommonResponse.getMsg());
        }

        logger.info("获取材料验收入库单 结果：____{}返回内容:____{}",jsonObjectCommonResponse.isSuccess(),JSONObject.toJSONString(jsonObjectCommonResponse));
        if (!jsonObjectCommonResponse.isSuccess()){
            throw new BusinessException(jsonObjectCommonResponse.getMsg());
        }
        checkTaxMny =(null != jsonObjectCommonResponse.getData() && jsonObjectCommonResponse.getData().get("checkTaxMny") != null) ? new BigDecimal(jsonObjectCommonResponse.getData().get("checkTaxMny").toString()):BigDecimal.ZERO;
        //查询项目下的 临时设备使用记录
        CommonResponse<JSONObject> response = recordApi.queryTemporaryUseProject(projectId);
        if (!response.isSuccess()){
            throw new BusinessException(response.getMsg());
        }

        logger.info("临时设备使用记录 结果：____{}返回内容:____{}",response.isSuccess(),JSONObject.toJSONString(response));
        if (!jsonObjectCommonResponse.isSuccess()){
            throw new BusinessException(jsonObjectCommonResponse.getMsg());
        }
        recordTaxMny =(null != response.getData() && response.getData().get("useMny") != null) ? new BigDecimal(response.getData().get("useMny").toString()):BigDecimal.ZERO;
        totalPerformanceMny = recordTaxMny.add(checkTaxMny);


        //查询累计结算金额
        SettlePoolVO poolVO = new SettlePoolVO();
        poolVO.setProjectId(projectId);
        poolVO.setContractFlag(0);
        poolVO.setSourceType("sporadic_material,temp_equip");
        CommonResponse<JSONObject> settleRep = settlePoolApi.queryNoContractTotalMny(poolVO);
        logger.info("获取结算金额 结果：____{}返回内容:____{}",settleRep.isSuccess(),JSONObject.toJSONString(settleRep));

        if (!settleRep.isSuccess()){
            throw new BusinessException(settleRep.getMsg());
        }
        totalSettleMny = (null != settleRep && settleRep.getData().get("totalSettleMny") != null) ? new BigDecimal(settleRep.getData().get("totalSettleMny").toString()):BigDecimal.ZERO;



        //查询当前合同下的无合同付款
        QueryWrapper<PaymentApplyEntity> queryWrapper = new QueryWrapper();
        queryWrapper.eq("project_id",projectId);
        queryWrapper.in("bill_state",Arrays.asList(
                BillStateEnum.COMMITED_STATE.getBillStateCode(),
                BillStateEnum.PASSED_STATE.getBillStateCode()));
        queryWrapper.in("payment_type",Arrays.asList(PaymentTypeEnum.临时机械.getCode(),PaymentTypeEnum.零星材料.getCode()));
        List<PaymentApplyEntity> queryList = super.list(queryWrapper);

        for (PaymentApplyEntity entity:queryList){
            if (entity.getActualMny()!=null){
                totalActualMny = totalActualMny.add(entity.getActualMny());
            }
            if (entity.getApprovalMny()!=null){
                totalApprovalMny = totalApprovalMny.add(entity.getApprovalMny());
            }

        }
        totalApprovalMny = totalApprovalMny.compareTo(new BigDecimal("0E-8"))==0?new BigDecimal("0"):totalApprovalMny;
        //设置占施工合同比例
        BigDecimal contractTaxMny = querySumContractMny(projectId);

        BigDecimal contractRate = BigDecimal.ZERO;
        if (contractTaxMny.compareTo(BigDecimal.ZERO)!=0&&totalApprovalMny.compareTo(BigDecimal.ZERO)!=0){
            logger.info("totalApprovalMny--{}",totalApprovalMny);
            logger.info("contractTaxMny--{}",contractTaxMny);
            contractRate = totalApprovalMny.divide(contractTaxMny,BigDecimal.ROUND_CEILING);
            contractRate =contractRate.multiply(new BigDecimal("100"));
        }
        //设置履约金额
        data.put("totalPerformanceMny", df1.format(totalPerformanceMny));
        //设置结算金额
        data.put("totalSettleMny",  df1.format(totalSettleMny));
        //设置实付金额
        data.put("totalActualMny",  df1.format(totalActualMny));
        //设置批复金额
        data.put("totalApprovalMny",  df1.format(totalApprovalMny));
        //设置施工合同总金额
        data.put("contractTaxMny", df1.format(contractTaxMny));
        if (contractRate!=BigDecimal.ZERO){
            String format = df1.format(contractRate);
            data.put("contractRate",format);
        }else {
            data.put("contractRate","0");
        }
        return data;
    }


    public List<JSONObject> queryDataModelMaterial(Long projectId){
        List<JSONObject> materialList = new ArrayList<>();
        DecimalFormat df1 = new DecimalFormat("0.##");

        //设置占施工合同比例
        BigDecimal contractTaxMny = querySumContractMny(projectId);
        //查询项目下的 材料验收入库单

        CommonResponse<List<CheckVO>> checkResponse = checkApi.querycheckListByProjectId(projectId);
        if (!checkResponse.isSuccess()){
            throw new BusinessException(checkResponse.getMsg());
        }
        if(CollectionUtils.isNotEmpty(checkResponse.getData())){
            List<CheckVO> data = checkResponse.getData();
            Map<Long, List<CheckVO>> collect = data.stream().collect(Collectors.groupingBy(CheckVO::getSupplierId));
            Iterator<Map.Entry<Long, List<CheckVO>>> iterator = collect.entrySet().iterator();
            while (iterator.hasNext()){
                Map.Entry<Long, List<CheckVO>> next = iterator.next();
                List<CheckVO> value = next.getValue();
                //填充 list 值
                JSONObject material = new JSONObject();//零星  入库单
                //设置供应商
                material.put("supplyName",value.get(0).getSupplierName());
                //获取履约金额
                CommonResponse<JSONObject> childrenCheck = checkApi.querycheckMnyById(projectId, next.getKey());
                logger.info("获取履约金额 结果：____{}返回内容:____{}",childrenCheck.isSuccess(),JSONObject.toJSONString(childrenCheck));
                if (!childrenCheck.isSuccess()){
                    throw new BusinessException(childrenCheck.getMsg());
                }
                //设置履约金额
                material.put("performanceMny",df1.format((null != childrenCheck.getData() && childrenCheck.getData().get("checkTaxMny") != null) ? new BigDecimal(childrenCheck.getData().get("checkTaxMny").toString()):BigDecimal.ZERO));
                //设置供应商

                BigDecimal materialApprovalMny = BigDecimal.ZERO;
                BigDecimal materialActualMny = BigDecimal.ZERO;

                QueryWrapper<PaymentApplyEntity> queryWrapper = new QueryWrapper();
                queryWrapper.eq("project_id",projectId);
                queryWrapper.eq("supplier_id",next.getKey());
                queryWrapper.in("bill_state",Arrays.asList(
                        BillStateEnum.COMMITED_STATE.getBillStateCode(),
                        BillStateEnum.PASSED_STATE.getBillStateCode()));
                queryWrapper.eq("payment_type",PaymentTypeEnum.零星材料.getCode());
                List<PaymentApplyEntity> queryList = super.list(queryWrapper);

                for (PaymentApplyEntity entity:queryList){
                    if (entity.getActualMny()!=null){
                        materialActualMny = materialActualMny.add(entity.getActualMny());
                    }
                    if (entity.getApprovalMny()!=null){
                        materialApprovalMny = materialApprovalMny.add(entity.getApprovalMny());
                    }
                }
                //设置    累计实付金额
                material.put("actualMny",df1.format((materialActualMny.compareTo(new BigDecimal("0E-8"))==0?new BigDecimal("0"):materialActualMny)));
                materialApprovalMny = materialApprovalMny.compareTo(new BigDecimal("0E-8")) == 0 ? new BigDecimal("0") : materialApprovalMny;
                material.put("approvalMny",materialApprovalMny);


                //查询无合同 累计结算金额
                SettlePoolVO poolVO = new SettlePoolVO();
                poolVO.setProjectId(projectId);
                poolVO.setPartybId(value.get(0).getSupplierId());
                poolVO.setContractFlag(0);
                poolVO.setSourceType("sporadic_material");
                CommonResponse<JSONObject> settleRep = settlePoolApi.queryNoContractTotalMny(poolVO);
                logger.info("获取结算金额 结果：____{}返回内容:____{}",settleRep.isSuccess(),JSONObject.toJSONString(settleRep));

                if (!settleRep.isSuccess()){
                    throw new BusinessException(settleRep.getMsg());
                }
                BigDecimal totalSettleMny = (null != settleRep && settleRep.getData().get("totalSettleMny") != null) ? new BigDecimal(settleRep.getData().get("totalSettleMny").toString()):BigDecimal.ZERO;
                material.put("totalSettleMny", df1.format(totalSettleMny));


                BigDecimal contractRate = BigDecimal.ZERO;
                if (contractTaxMny.compareTo(BigDecimal.ZERO)!=0&&materialApprovalMny.compareTo(BigDecimal.ZERO)!=0){
                    contractRate = materialApprovalMny.divide(contractTaxMny,BigDecimal.ROUND_CEILING);
                    contractRate = contractRate.multiply(new BigDecimal("100"));
                }
                if (contractRate!=BigDecimal.ZERO){
                    String format = df1.format(contractRate);
                    material.put("contractRate",format);
                }else {
                    material.put("contractRate","0");
                }
                materialList.add(material);
            }
        }
        return materialList;
    }

    public List<JSONObject> queryDataModelEquip(Long projectId){
        List<JSONObject> equipList = new ArrayList<>();
        BigDecimal contractTaxMny = querySumContractMny(projectId);
        CommonResponse<List<TemporaryUseRecordVO>> listCommonResponse = recordApi.queryTemporaryListUseProject(projectId);
        DecimalFormat df1 = new DecimalFormat("0.##");

        if (!listCommonResponse.isSuccess()){
            throw new BusinessException(listCommonResponse.getMsg());
        }
        if(CollectionUtils.isNotEmpty(listCommonResponse.getData())){
            List<TemporaryUseRecordVO> data = listCommonResponse.getData();
            Map<Long, List<TemporaryUseRecordVO>> collect = data.stream().collect(Collectors.groupingBy(TemporaryUseRecordVO::getSupplierId));
            Iterator<Map.Entry<Long, List<TemporaryUseRecordVO>>> iterator = collect.entrySet().iterator();
            while (iterator.hasNext()){
                Map.Entry<Long, List<TemporaryUseRecordVO>> next = iterator.next();
                List<TemporaryUseRecordVO> value = next.getValue();

                JSONObject equip = new JSONObject();//临时
                //设置供应商
                equip.put("supplyName",value.get(0).getSupplierName());
                CommonResponse<JSONObject> childrenRec = recordApi.queryTemporaryUseRecordMny(projectId, next.getKey());
                logger.info("获取履约金额 结果：____{}返回内容:____{}",childrenRec.isSuccess(),JSONObject.toJSONString(childrenRec));
                if (!childrenRec.isSuccess()){
                    throw new BusinessException(childrenRec.getMsg());
                }
                //设置履约金额
                BigDecimal performanceMny = (null != childrenRec.getData() && childrenRec.getData().get("useMny") != null) ? new BigDecimal(childrenRec.getData().get("useMny").toString()) : BigDecimal.ZERO;
                String format = df1.format(performanceMny);
                equip.put("performanceMny",format);
                BigDecimal equipApprovalMny = BigDecimal.ZERO;
                BigDecimal equipActualMny = BigDecimal.ZERO;

                QueryWrapper<PaymentApplyEntity> queryWrapper = new QueryWrapper();
                queryWrapper.eq("project_id",projectId);
                queryWrapper.eq("supplier_id",next.getKey());
                queryWrapper.in("bill_state",Arrays.asList(
                        BillStateEnum.COMMITED_STATE.getBillStateCode(),
                        BillStateEnum.PASSED_STATE.getBillStateCode()));
                queryWrapper.eq("payment_type",PaymentTypeEnum.临时机械.getCode());
                List<PaymentApplyEntity> queryList = super.list(queryWrapper);
                for (PaymentApplyEntity entity:queryList){
                    if (entity.getActualMny()!=null){
                        equipActualMny = equipActualMny.add(entity.getActualMny());
                    }
                    if (entity.getApprovalMny()!=null){
                        equipApprovalMny = equipApprovalMny.add(entity.getApprovalMny());
                    }
                }
                //设置    累计实付金额

                equip.put("actualMny",df1.format(equipActualMny.compareTo(new BigDecimal("0E-8"))==0?new BigDecimal("0"):equipActualMny));
                //设置    累计批复金额
                equip.put("approvalMny",df1.format(equipApprovalMny.compareTo(new BigDecimal("0E-8")) == 0 ? new BigDecimal("0") : equipApprovalMny));
                //查询无合同 累计结算金额
                SettlePoolVO poolVO = new SettlePoolVO();
                poolVO.setProjectId(projectId);
                poolVO.setPartybId(value.get(0).getSupplierId());
                poolVO.setContractFlag(0);
                poolVO.setSourceType("temp_equip");
                CommonResponse<JSONObject> settleRep = settlePoolApi.queryNoContractTotalMny(poolVO);
                logger.info("获取结算金额 结果：____{}返回内容:____{} 查询条件----{}",settleRep.isSuccess(),JSONObject.toJSONString(settleRep),JSONObject.toJSONString(poolVO));

                if (!settleRep.isSuccess()){
                    throw new BusinessException(settleRep.getMsg());
                }
                BigDecimal totalSettleMny = (null != settleRep && settleRep.getData().get("totalSettleMny") != null) ? new BigDecimal(settleRep.getData().get("totalSettleMny").toString()):BigDecimal.ZERO;
                equip.put("totalSettleMny", df1.format(totalSettleMny.compareTo(new BigDecimal("0E-8"))==0?new BigDecimal("0"):totalSettleMny));


                BigDecimal contractRate = BigDecimal.ZERO;
                if (contractTaxMny.compareTo(BigDecimal.ZERO)!=0&&equipApprovalMny.compareTo(BigDecimal.ZERO)!=0){
                    contractRate = equipApprovalMny.divide(contractTaxMny,BigDecimal.ROUND_CEILING);
                    contractRate = contractRate.multiply(new BigDecimal("100"));
                }
                if (contractRate!=BigDecimal.ZERO){
                    equip.put("contractRate",df1.format(contractRate));
                }else {
                    equip.put("contractRate","0");
                }

                equipList.add(equip);
            }
        }
        return equipList;
    }

    /**
     * 设置合同累计批复金额、累计实付金额
     * @param paymentApplyVO
     */
    @Override
    public void setTotalContractRelateMny(PaymentApplyVO paymentApplyVO) {
        Map<String, BigDecimal> info = new HashMap<>();
        QueryWrapper<SalaryPayApplyEntity> applyQuery = new QueryWrapper<>();
        applyQuery.select("sum( actual_paid_tax_mny ) AS totalActualPaidTaxMny, sum( apply_tax_mny ) as lastApplyTaxMny");
        applyQuery.eq("contract_id", paymentApplyVO.getContractId());
        applyQuery.eq("is_repeat_bill", "0");
        applyQuery.in("pay_type", Arrays.asList("1","4"));

        //查询累计合同付款申请单金额，合同累计付款申请单实付金额
        applyQuery.in("bill_state", new Integer[]{
                BillStateEnum.PASSED_STATE.getBillStateCode(),
                BillStateEnum.COMMITED_STATE.getBillStateCode()
        });
        Map validApplyResult = payApplyService.getMap(applyQuery);

        QueryWrapper<PaymentApplyEntity> payApplyQuery = new QueryWrapper<>();
        payApplyQuery.select("sum( actual_mny ) AS totalActualPaidTaxMny, sum( approval_mny ) as totalApproveTaxMny");
        payApplyQuery.eq("contract_id", paymentApplyVO.getContractId());
        payApplyQuery.in("bill_state", new Integer[]{
                BillStateEnum.PASSED_STATE.getBillStateCode(),
                BillStateEnum.COMMITED_STATE.getBillStateCode()
        });
        Map validPayApplyResult = super.getMap(payApplyQuery);
        info.put("totalContractActualPaidTaxMny", null != validApplyResult && null != validApplyResult.get("totalActualPaidTaxMny") ? new BigDecimal(validApplyResult.get("totalActualPaidTaxMny").toString()) : BigDecimal.ZERO);
        info.put("totalContractApproveTaxMny", null != validApplyResult && null != validApplyResult.get("lastApplyTaxMny") ? new BigDecimal(validApplyResult.get("lastApplyTaxMny").toString()) : BigDecimal.ZERO);
        info.put("totalContractActualPaidTaxMny",info.get("totalContractActualPaidTaxMny").add(null != validPayApplyResult && null != validPayApplyResult.get("totalActualPaidTaxMny") ? new BigDecimal(validPayApplyResult.get("totalActualPaidTaxMny").toString()) : BigDecimal.ZERO));
        info.put("totalContractApproveTaxMny", info.get("totalContractApproveTaxMny").add(null != validPayApplyResult && null != validPayApplyResult.get("totalApproveTaxMny") ? new BigDecimal(validPayApplyResult.get("totalApproveTaxMny").toString()) : BigDecimal.ZERO));

        paymentApplyVO.setContractTotalActualTaxMny(info.get("totalContractActualPaidTaxMny"));
        paymentApplyVO.setContractTotalApproveTaxMny(info.get("totalContractApproveTaxMny"));
    }

    @Override
    public List<DailyFinanceInfoVO> dailyFinanceInfo(String yesterday) {
        return paymentApplyMapper.dailyFinanceInfo(yesterday);
    }

    private BigDecimal querySumContractMny (Long projectId){

        //设置占施工合同比例
        QueryParam query = new QueryParam();
        query.getParams().put("project_id",new Parameter(QueryParam.EQ, projectId));
        query.getParams().put("source_type",new Parameter(QueryParam.EQ, ContractTypeEnum.施工合同.getTypeCode()));
        query.getParams().put("performance_status",new Parameter(QueryParam.IN, Arrays.asList(ContractPerformanceStateEnum.履约中.getStateCode(),ContractPerformanceStateEnum.已终止.getStateCode())));
        CommonResponse<BigDecimal> bigDecimalCommonResponse = contractPoolApi.querySumContractMny(query);
        BigDecimal contractTaxMny = BigDecimal.ZERO;
        if (!bigDecimalCommonResponse.isSuccess()){
            throw new BusinessException(bigDecimalCommonResponse.getMsg());
        }
        if (bigDecimalCommonResponse.getData()!=null&&bigDecimalCommonResponse.getData()!=BigDecimal.ZERO){
            contractTaxMny = new BigDecimal(bigDecimalCommonResponse.getData().toString());
        }
        return contractTaxMny.compareTo(new BigDecimal("0E-8"))==0?new BigDecimal("0"):contractTaxMny;
    }
    public PaymentApplyVO queryNoContractTotalMny(PaymentApplyVO vo) {
        //查询无合同 累计结算金额
        SettlePoolVO poolVO = new SettlePoolVO();
        poolVO.setProjectId(vo.getProjectId());
        poolVO.setPartybId(vo.getSupplierId());
        poolVO.setContractFlag(0);
        poolVO.setSourceType(vo.getPaymentType()==3?"sporadic_material":"temp_equip");
        CommonResponse<JSONObject> settleRep = settlePoolApi.queryNoContractTotalMny(poolVO);
        logger.info("获取结算金额 结果：____{}返回内容:____{}",settleRep.isSuccess(),JSONObject.toJSONString(settleRep));

        if (!settleRep.isSuccess()){
            throw new BusinessException(settleRep.getMsg());
        }
        if (settleRep.getData().containsKey("totalSettleMny")){
            BigDecimal checkTaxMny = settleRep.getData().get("totalSettleMny")!=null?new BigDecimal(settleRep.getData().get("totalSettleMny").toString()):BigDecimal.ZERO;
            vo.setTotalSettleMny(checkTaxMny);
        }
        //查询累计履约金额
        if (vo.getPaymentType()==3){
            CommonResponse<JSONObject> checkRsp = checkApi.querycheckMnyById(vo.getProjectId(), vo.getSupplierId());
            logger.info("获取履约金额 结果：____{}返回内容:____{}",checkRsp.isSuccess(),JSONObject.toJSONString(checkRsp));

            if (!checkRsp.isSuccess()){
                throw new BusinessException(checkRsp.getMsg());
            }

            if (checkRsp.getData().containsKey("checkTaxMny")){
                BigDecimal checkTaxMny =checkRsp.getData().get("checkTaxMny")!=null?new BigDecimal(checkRsp.getData().get("checkTaxMny").toString()):BigDecimal.ZERO;
                vo.setTotalPerformanceMny(checkTaxMny);
            }
        }else {
            CommonResponse<JSONObject> recordRsp = recordApi.queryTemporaryUseRecordMny(vo.getProjectId(), vo.getSupplierId());
            logger.info("获取履约金额 结果：____{}返回内容:____{}",recordRsp.isSuccess(),JSONObject.toJSONString(recordRsp));
            if (!recordRsp.isSuccess()){
                throw new BusinessException(recordRsp.getMsg());
            }
            if (recordRsp.getData().containsKey("useMny")){
                BigDecimal useMny =recordRsp.getData().get("useMny")!=null?new BigDecimal(recordRsp.getData().get("useMny").toString()):BigDecimal.ZERO;
                vo.setTotalPerformanceMny(useMny);
            }
        }

        //查询累计实付金额
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("project_id",new Parameter(QueryParam.EQ,vo.getProjectId()));
        queryParam.getParams().put("supplier_id",new Parameter(QueryParam.EQ,vo.getSupplierId()));
        queryParam.getParams().put("payment_type",new Parameter(QueryParam.EQ,vo.getPaymentType()));
        List<PaymentApplyEntity> applyList = super.queryList(queryParam);
        BigDecimal totalActualMny = BigDecimal.ZERO;
        for (PaymentApplyEntity entity:applyList){
            if (entity.getActualMny()!=null){
                totalActualMny = totalActualMny.add(entity.getActualMny());
            }
        }
        vo.setTotalActualMny(totalActualMny);
        return vo;
    }


    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if(locked) {
                RedisTool.releaseLock(jedis, key, OPERATE);
            }
        } finally {
            if(null != jedis) {
                jedis.close();
            }
        }
    }


    @Override
    public CommonResponse<List<PaymentApplyMnyTopVO>> queryPaymentApplyMnyTop(Long orgId) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        //查询本下
        if (orgId == null) {
            orgId = InvocationInfoProxy.getOrgId();
        }
        if(OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
        } else {
            CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if(!orgResp.isSuccess()) {
                logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
                return CommonResponse.error("查询失败，获取组织信息失败！");
            }
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN,
                    orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        param.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(1, 3)));
        param.getParams().put("actualMny", new Parameter(QueryParam.GT, 0));

        QueryWrapper<PaymentApplyEntity> paymentApplyEntityQueryWrapper = changeToQueryWrapper(param);
        paymentApplyEntityQueryWrapper
                .orderByDesc("apply_date")
                .last("limit 20");
        List<PaymentApplyEntity> paymentApplyEntityList = super.list(paymentApplyEntityQueryWrapper);
        List<PaymentApplyMnyTopVO> paymentApplyMnyTopVOList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(paymentApplyEntityList)){
            logger.info("查出20条付款申请数据：{}", JSONObject.toJSONString(paymentApplyEntityList));
            for (PaymentApplyEntity paymentApplyEntity : paymentApplyEntityList) {
                PaymentApplyMnyTopVO paymentApplyMnyTopVO = BeanMapper.map(paymentApplyEntity, PaymentApplyMnyTopVO.class);
                //设置合同类型
                if (null != paymentApplyEntity.getPaymentContractFlag()) {
                    if (paymentApplyEntity.getPaymentContractFlag() == 0) {// 有合同
                        paymentApplyMnyTopVO.setContractType(paymentApplyEntity.getSourceCategoryTypeName());
                    } else {// 无合同
                        paymentApplyMnyTopVO.setContractType(PaymentTypeEnum.getEnumByCode(paymentApplyEntity.getPaymentType() + "").getDescription());
                        if (PaymentTypeEnum.预付款.getCode().equals(paymentApplyEntity.getPaymentType() + "")){
                            paymentApplyMnyTopVO.setPrepaidFlag(true);
                        }
                    }
                }
                paymentApplyMnyTopVOList.add(paymentApplyMnyTopVO);
            }
        }
        return CommonResponse.success("实时付款情况成功！", paymentApplyMnyTopVOList);
    }


    @Override
    @GlobalTransactional(name="PaymentApplyServiceImpl_saveAndSubmit", rollbackFor = Exception.class)
    public PaymentApplyVO saveAndSubmit(PaymentApplyVO saveOrUpdateVO) {
        PaymentApplyEntity paymentApplyEntity = this.selectById(saveOrUpdateVO.getId());

        if (saveOrUpdateVO.getApplyMny().compareTo(paymentApplyEntity.getApplyMny()) == 1){
            throw new BusinessException("申请金额应小于等于原始的申请金额！");
        }

        if (saveOrUpdateVO.getApplyMny().compareTo(paymentApplyEntity.getActualMny()) == -1){
            throw new BusinessException("申请金额应大于等于实付金额！");
        }

        PaymentApplyRecordEntity map = BeanMapper.map(paymentApplyEntity, PaymentApplyRecordEntity.class);
        map.setApplyId(paymentApplyEntity.getId());
        map.setId(null);
        map.setUpdateTime(null);
        map.setUpdateUserCode(null);
        map.setCreateTime(new Date());
        map.setCreateUserId(InvocationInfoProxy.getUserid());
        map.setCreateUserCode(InvocationInfoProxy.getUsercode());
        recordService.saveOrUpdate(map);

        PaymentApplyEntity  entity = BeanMapper.map(saveOrUpdateVO, PaymentApplyEntity.class);
        entity.setTenantId(999999L);
        entity.setVersion(paymentApplyEntity.getVersion());
        entity.setPaymentStatus(paymentApplyEntity.getPaymentStatus());

        saveOrUpdatePaymentApply(entity, false);

        //对接结算池
        List<Long> sourceIdS = saveOrUpdateVO.getPaymentApplyDetailList().stream().filter(item -> item.getSourceId()!=null).map(PaymentApplyDetailVO::getSourceId).collect(Collectors.toList());
        logger.info("本次更新结算单Id列表-{}", JSONObject.toJSONString(sourceIdS));
        if (CollectionUtils.isNotEmpty(sourceIdS)) {
            updateSettlePool(sourceIdS);
        }

        //推送中间库--开始
        PMPayApplyVO paramVO = new PMPayApplyVO();
        // 项目ID
        Long projectId = saveOrUpdateVO.getProjectId();
        paramVO.setProjectId(null);
        if (projectId != null) {
            paramVO.setProjectId(projectId.toString());
        }
        // 供应商ID
        Long supplierId = saveOrUpdateVO.getSupplierId();
        paramVO.setSupplierId(null);
        if (supplierId != null) {
            paramVO.setSupplierId(supplierId.toString());
        }
        // 收款单位ID
        Long payeeId = saveOrUpdateVO.getPayeeId();
        paramVO.setPayeeId(null);
        if (payeeId != null) {
            paramVO.setPayeeId(payeeId.toString());
        }
        // 是否有合同    sourceEntity中：0-有合同，1无合同，targetVO中：1-有合同，0-无合同
        Integer paymentContractFlag = saveOrUpdateVO.getPaymentContractFlag();
        // 合同登记ID
        Long contractId = saveOrUpdateVO.getContractId();
        paramVO.setIsContract(null);
        paramVO.setContractRegisterId(null);
        if (paymentContractFlag != null) {
            if (paymentContractFlag == 0) {// 有合同
                paramVO.setIsContract(1);
                if (contractId != null) {
                    paramVO.setContractRegisterId(contractId.toString());
                }
            } else {// 无合同
                paramVO.setIsContract(0);
                paramVO.setContractRegisterId("-1");
            }
        }
        // 本次申请金额
        paramVO.setCurApplyMny(saveOrUpdateVO.getApplyMny().subtract(paymentApplyEntity.getApprovalMny()));

        logger.info("开始调用PM付款申请调减生效接口，接口参数VO-{}", paramVO.toString());
        CommonResponse<PMPayApplyVO> res = pmPayApplyApi.takeEffect(paramVO);
        logger.info("调用PM付款申请的调减生效接口---ejc-profinance项目---saveAndSubmit方法---end，接口返回结果-{}", JSONObject.toJSONString(res, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
        if (!res.isSuccess()){
            throw new BusinessException("付款申请推送中间表失败");
        }
        //推送中间库--结束
        return BeanMapper.map(entity, PaymentApplyVO.class);
    }
}
