package com.ejianc.business.profinance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.profinance.bean.SalaryDetailEntity;
import com.ejianc.business.profinance.vo.ImportSalaryDetailVO;
import com.ejianc.business.profinance.vo.SalaryVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.profinance.mapper.SalaryMapper;
import com.ejianc.business.profinance.bean.SalaryEntity;
import com.ejianc.business.profinance.service.ISalaryService;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 工人工资单主实体
 * 
 * @author generator
 * 
 */
@Service("salaryService")
public class SalaryServiceImpl extends BaseServiceImpl<SalaryMapper, SalaryEntity> implements ISalaryService{


    private Logger logger = LoggerFactory.getLogger(this.getClass());

//    private static final String regex = "^\\d{16}|\\d{19}$";
//    private static final String IdCardRegex="/(^\\d{15}$)|(^\\d{18}$)|(^\\d{17}(\\d|X|x)$)/";
//    private static final String IdCardRegex="/^[1-9]\\d{5}(18|19|20|(3\\d))\\d{2}((0[1-9])|(1[0-2]))(([0-2][1-9])|10|20|30|31)\\d{3}[0-9Xx]$/";


    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;


    private static final String BILL_CODE = "WORKER_SALARY";//此处需要根据实际修改

    @Override
    public SalaryVO insertOrUpdate(SalaryVO salaryVO) {
        SalaryEntity entity = BeanMapper.map(salaryVO, SalaryEntity.class);

        //如果编码为空，就新增编码
        if (StringUtils.isBlank(entity.getBillCode())){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), salaryVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(!billCode.isSuccess()) {
                logger.error("保存工人工资单失败，自动生成工资单编码失败: {}", billCode.getMsg());
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            entity.setBillCode(billCode.getData());
        }else {
            //验证编码是否唯一
            if (checkSameBillCode(BeanMapper.map(entity, SalaryVO.class))){
                throw new BusinessException("编码重复，不允许保存!");
            }
        }
        if (CollectionUtils.isNotEmpty(entity.getSalaryDetailList())){
            for (SalaryDetailEntity salaryDetailEntity : entity.getSalaryDetailList()) {
                salaryDetailEntity.setSalaryBillCode(entity.getBillCode());
            }
        }
        super.saveOrUpdate(entity, false);
        SalaryVO vo = BeanMapper.map(super.selectById(entity.getId()), SalaryVO.class);
        return vo;
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }

        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            List<ImportSalaryDetailVO> successList = new ArrayList<>();
            List<ImportSalaryDetailVO> errorList = new ArrayList<>();
            if (result != null && result.size() > 0) {
                if (result.get(0).size() != 23) {
                    throw new BusinessException("请按照导入模板导入数据");
                }
                if (result.size()>=10000){
                    throw new BusinessException("文件数据不能超过10000行，超过请分批次多次导入");
                }

                for (int i = 1; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    ImportSalaryDetailVO salaryDetailVO = new ImportSalaryDetailVO();
                    //姓名-workerName
                    if (StringUtils.isBlank(datas.get(0))) {
                        salaryDetailVO.setErrorMessage("工人姓名为必填项");
                    } else if (datas.get(0).length() > 20 || datas.get(0).length() == 1 ) {
                        salaryDetailVO.setErrorMessage("工人姓名填写长度为2~20字");
                    }else {
                        salaryDetailVO.setWorkerName(datas.get(0).trim());
                    }

                    //工种-workType
                    if (StringUtils.isBlank(datas.get(1))) {
                        salaryDetailVO.setErrorMessage("工种为必填项");
                    } else if (datas.get(1).length() > 20) {
                        salaryDetailVO.setErrorMessage("填写工种长度为1~20字");
                    }else {
                        salaryDetailVO.setWorkType(datas.get(1).trim());
                    }

                    //身份证号-workerIdCard
                    if (StringUtils.isBlank(datas.get(2))) {
                        salaryDetailVO.setErrorMessage("身份证号为必填项");
                    }else if (datas.get(2).length() > 18) {
                        salaryDetailVO.setErrorMessage("填写身份证号长度最大为18位");
                    }else {
                        salaryDetailVO.setWorkerIdCard(datas.get(2).trim());
                    }

                    //队伍名称-teamName
                    if (StringUtils.isBlank(datas.get(3))) {
                        salaryDetailVO.setErrorMessage("队伍名称为必填项");
                    } else if (datas.get(3).length() > 20) {
                        salaryDetailVO.setErrorMessage("填写队伍名称长度为1~20字");
                    }else {
                        salaryDetailVO.setTeamName(datas.get(3).trim());
                    }

                    //班组名称-groupName
                    if (StringUtils.isBlank(datas.get(4))) {
                        salaryDetailVO.setErrorMessage("班组名称为必填项");
                    } else if (datas.get(4).length() > 20) {
                        salaryDetailVO.setErrorMessage("填写班组名称长度为1~20字");
                    }else {
                        salaryDetailVO.setGroupName(datas.get(4).trim());
                    }


                    //个人工日-personalWorkingDayOfMonth
                    if (StringUtils.isNotBlank(datas.get(5))) {
                        try {
                            salaryDetailVO.setPersonalWorkingDayOfMonth(new BigDecimal(datas.get(5)));
                        } catch (Exception e) {
                            salaryDetailVO.setErrorMessage("个人工日必须为数字");
                        }
                    } else {
                        salaryDetailVO.setErrorMessage("个人工日为必填项");
                    }


                    //计量方式-measureType （0:按天，1计件 2：按小时 3：按月）
                    if (StringUtils.isBlank(datas.get(6))) {
                        salaryDetailVO.setErrorMessage("计量方式为必填项");
                    } else {
                        switch (datas.get(6)){
                            case "按天" :
                                salaryDetailVO.setMeasureType(0);
                                break;
                            case "计件" :
                                salaryDetailVO.setMeasureType(1);
                                break;
                            case "按小时" :
                                salaryDetailVO.setMeasureType(2);
                                break;
                            case "按月" :
                                salaryDetailVO.setMeasureType(3);
                                break;
                        }
                    }

                    //工作量-workNum
                    if (StringUtils.isNotBlank(datas.get(7))) {
                        try {
                            salaryDetailVO.setWorkNum(new BigDecimal(datas.get(7)));
                        } catch (Exception e) {
                            salaryDetailVO.setErrorMessage("工作量为必须为数字");
                        }
                    } else {
                        salaryDetailVO.setErrorMessage("工作量为必填项");
                    }

                    //单价-price
                    if (StringUtils.isNotBlank(datas.get(8))) {
                        try {
                            salaryDetailVO.setPrice(new BigDecimal(datas.get(8)));
                        } catch (Exception e) {
                            salaryDetailVO.setErrorMessage("单价为必须为数字");
                        }
                    } else {
                        salaryDetailVO.setErrorMessage("单价为必填项");
                    }

                    //班组工日-workingDayOfMonth
                    if (StringUtils.isNotBlank(datas.get(9))) {
                        try {
                            salaryDetailVO.setWorkingDayOfMonth(new BigDecimal(datas.get(9)));
                        } catch (Exception e) {
                            salaryDetailVO.setErrorMessage("班组工日必须为数字");
                        }
                    } else {
                        salaryDetailVO.setErrorMessage("班组工日为必填项");
                    }

                    //工资总额-totalSalary
                    if (StringUtils.isNotBlank(datas.get(10))) {
                        try {
                            salaryDetailVO.setTotalSalary(new BigDecimal(datas.get(10)));
                        } catch (Exception e) {
                            salaryDetailVO.setErrorMessage("工资总额必须为数字");
                        }
                    } else {
                        salaryDetailVO.setErrorMessage("工资总额为必填项");
                    }

                    //其他扣款-otherDeduct
                    if (StringUtils.isNotBlank(datas.get(11))) {
                        try {
                            salaryDetailVO.setOtherDeduct(new BigDecimal(datas.get(11)));
                        } catch (Exception e) {
                            salaryDetailVO.setErrorMessage("其他扣款必须为数字");
                        }
                    }

                    //奖励-award
                    if (StringUtils.isNotBlank(datas.get(12))) {
                        try {
                            salaryDetailVO.setAward(new BigDecimal(datas.get(12)));
                        } catch (Exception e) {
                            salaryDetailVO.setErrorMessage("奖励必须为数字");
                        }
                    }

                    //核定工资金额-approvalSalaryMny
                    if (StringUtils.isNotBlank(datas.get(13))) {
                        try {
                            salaryDetailVO.setApprovalSalaryMny(new BigDecimal(datas.get(13)));
                        } catch (Exception e) {
                            salaryDetailVO.setErrorMessage("核定工资必须为数字");
                        }
                    } else {
                        salaryDetailVO.setErrorMessage("核定工资为必填项");
                    }


                    //预支工资-deductMny
                    if (StringUtils.isNotBlank(datas.get(14))) {
                        try {
                            salaryDetailVO.setDeductMny(new BigDecimal(datas.get(14)));
                        } catch (Exception e) {
                            salaryDetailVO.setErrorMessage("预支工资必须为数字");
                        }
                    }


                    //应发-salaryMmy
                    if (StringUtils.isNotBlank(datas.get(15))) {
                        try {
                            salaryDetailVO.setSalaryMny(new BigDecimal(datas.get(15)));
                        } catch (Exception e) {
                            salaryDetailVO.setErrorMessage("应发必须为数字");
                        }
                    } else {
                        salaryDetailVO.setErrorMessage("应发为必填项");
                    }

                    //拟支付金额-proposedPaymentMny
                    if (StringUtils.isNotBlank(datas.get(16))) {
                        try {
                            salaryDetailVO.setProposedPaymentMny(new BigDecimal(datas.get(16)));
                        } catch (Exception e) {
                            salaryDetailVO.setErrorMessage("拟支付金额必须为数字");
                        }
                    }else {
                        salaryDetailVO.setProposedPaymentMny(BigDecimal.ZERO);
                    }

                    //银行卡号-accountNum
                    if (StringUtils.isBlank(datas.get(17))){
                        salaryDetailVO.setErrorMessage("银行卡号为必填项");
                    } else if (datas.get(17).trim().length() > 19) {
                        salaryDetailVO.setErrorMessage("填写银行卡号长度最大为19位");
                    }else {
                        salaryDetailVO.setAccountNum(datas.get(17).trim());
                    }

                    //开户行-bankName
                    if (StringUtils.isBlank(datas.get(18))){
                        salaryDetailVO.setErrorMessage("开户行长度为必填项");
                    }else if (datas.get(18).length() > 30){
                        salaryDetailVO.setErrorMessage("填写开户行长度为0~30字");
                    }else {
                        salaryDetailVO.setBankName(datas.get(18).trim());
                    }

                    //开户行省份-bankName
                    if (StringUtils.isBlank(datas.get(19))){
                        salaryDetailVO.setErrorMessage("开户行省份为必填项");
                    }else if (datas.get(19).length() > 50){
                        salaryDetailVO.setErrorMessage("填写开户行省份长度为0~50字");
                    }else {
                        salaryDetailVO.setBankProvince(datas.get(19).trim());
                    }

                    //联行号-bankName
                    if (StringUtils.isNotBlank(datas.get(20))){
                        if (datas.get(20).length() > 500){
                            salaryDetailVO.setErrorMessage("联行号长度为0~500字");
                        }else {
                            salaryDetailVO.setInterBankNum(datas.get(20).trim());
                        }
                    }
                    //手机号-workerPhone
                    if (StringUtils.isNotBlank(datas.get(21))){
                        if (datas.get(21).length() != 11){
                            salaryDetailVO.setErrorMessage("手机号长度为11位");
                        }else {
                            salaryDetailVO.setWorkerPhone(datas.get(21).trim());
                        }
                    }

                    //备注-memo
                    if (datas.get(22).length() > 100){
                        salaryDetailVO.setErrorMessage("填写备注长度为0~100字");
                    }
                    salaryDetailVO.setMemo(datas.get(22));

                    if (StringUtils.isBlank(salaryDetailVO.getErrorMessage())) {
                        successList.add(salaryDetailVO);
                    }else {
                        errorList.add(salaryDetailVO);
                    }
                }
            }
            JSONObject json = new JSONObject();
            json.put("successList", successList);
            json.put("errorList", errorList);
            return CommonResponse.success(json);
        }
    }

    /**
     * 检查单据是否存在相同编码
     * @param salaryVO
     * @return
     */
    private boolean checkSameBillCode(SalaryVO salaryVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper<SalaryEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(SalaryEntity::getBillCode, salaryVO.getBillCode());
        lambda.eq(SalaryEntity::getTenantId, tenantId);
        if (null != salaryVO.getId() && salaryVO.getId() > 0) {
            lambda.ne(SalaryEntity::getId, salaryVO.getId());
        }
        return super.list(lambda).size() > 0;
    }
}
