package com.ejianc.business.receipt.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.receipt.bean.ReceiptRegisterEntity;
import com.ejianc.business.receipt.service.IReceiptRegisterService;
import com.ejianc.business.receipt.vo.ReceiptRegisterVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.*;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 收款登记主实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("receiptRegister")
public class ReceiptRegisterController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "RECEIPT_REGISTER";//此处需要根据实际修改

    @Autowired
    private IReceiptRegisterService service;

    @Autowired
    private IProjectPoolApi projectPoolApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ReceiptRegisterVO> saveOrUpdate(@RequestBody ReceiptRegisterVO saveOrUpdateVO) {
    	ReceiptRegisterEntity entity = BeanMapper.map(saveOrUpdateVO, ReceiptRegisterEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        entity.setUnMny(entity.getSumReceivedMny());
    	service.saveOrUpdate(entity, false);
    	ReceiptRegisterVO vo = BeanMapper.map(entity, ReceiptRegisterVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ReceiptRegisterVO> queryDetail(Long id) {
    	ReceiptRegisterEntity entity = service.selectById(id);
    	ReceiptRegisterVO vo = BeanMapper.map(entity, ReceiptRegisterVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ReceiptRegisterVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (ReceiptRegisterVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(ReceiptRegisterVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ReceiptRegisterVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("employeeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        Long orgId = InvocationInfoProxy.getOrgId();
        //若当前上下文为项目部，则根据项目部Id来进行查询
        if(OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
        } else {
            CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if(!orgResp.isSuccess()) {
                logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
                return CommonResponse.error("查询失败，获取组织信息失败！");
            }
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN,
                    orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }


        String projectRange = null != param.getParams().get("projectRange") ? param.getParams().get("projectRange").getValue().toString() : null;
        String dateIn = null != param.getParams().get("dateIn") ? param.getParams().get("dateIn").getValue().toString() : null;
        param.getParams().remove("dateIn");
        param.getParams().remove("projectRange");

        if(StringUtils.isNotBlank(projectRange) || StringUtils.isNotBlank(dateIn)) {
            CommonResponse<List<Long>> projectIdsResp = projectPoolApi.queryProjectIdsByorgId(InvocationInfoProxy.getOrgId(),
                    projectRange, dateIn);
            if(!projectIdsResp.isSuccess()) {
                logger.error("根据组织Id-{}查询其下在建项目列表失败, {}", JSONObject.toJSONString(projectIdsResp));
                return CommonResponse.error("查询失败，获取组织下项目信息失败！");
            }

            if(CollectionUtils.isNotEmpty(projectIdsResp.getData())) {
                param.getParams().put("projectId", new Parameter(QueryParam.IN, projectIdsResp.getData()));
                param.getParams().remove("projectRange");
            } else {
                logger.info("根据组织Id-{}查询其下在建项目列表为空, 则返回空的数据列表！");
                IPage<ReceiptRegisterVO> emptyPageData = new Page<>(param.getPageIndex(), param.getPageSize(), 0);
                return CommonResponse.success("查询列表数据成功！", emptyPageData);
            }
        }

        IPage<ReceiptRegisterEntity> page = service.queryPage(param,false);
        IPage<ReceiptRegisterVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<ReceiptRegisterVO> vos = BeanMapper.mapList(page.getRecords(), ReceiptRegisterVO.class);
        vos.forEach(item->{
            item.setReceiptContractFlagName(item.getReceiptContractFlag() == 1 ? "无合同收款": "有合同收款");
        });
  		pageData.setRecords(vos);

        return CommonResponse.success("查询列表数据成功！",pageData);
    }



    /**
     * @Description querySumReceivedMny 查询项目累计收款
     *      2024-3-21添加
     *      由于门户后端调用只要SumReceivedMny,使用queryList,数据量太大,现在直接返回同样类型数据，只包含项目SumReceivedMny
     * @param param
     */
    @RequestMapping(value = "/querySumReceivedMny", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ReceiptRegisterVO>> querySumReceivedMny(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("employeeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        Long orgId = InvocationInfoProxy.getOrgId();
        //若当前上下文为项目部，则根据项目部Id来进行查询
        if(OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
        } else {
            CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if(!orgResp.isSuccess()) {
                logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
                return CommonResponse.error("查询失败，获取组织信息失败！");
            }
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN,
                    orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }


        String projectRange = null != param.getParams().get("projectRange") ? param.getParams().get("projectRange").getValue().toString() : null;
        String dateIn = null != param.getParams().get("dateIn") ? param.getParams().get("dateIn").getValue().toString() : null;
        param.getParams().remove("dateIn");
        param.getParams().remove("projectRange");

        if(StringUtils.isNotBlank(projectRange) || StringUtils.isNotBlank(dateIn)) {
            CommonResponse<List<Long>> projectIdsResp = projectPoolApi.queryProjectIdsByorgId(InvocationInfoProxy.getOrgId(),
                    projectRange, dateIn);
            if(!projectIdsResp.isSuccess()) {
                logger.error("根据组织Id-{}查询其下在建项目列表失败, {}", JSONObject.toJSONString(projectIdsResp));
                return CommonResponse.error("查询失败，获取组织下项目信息失败！");
            }

            if(CollectionUtils.isNotEmpty(projectIdsResp.getData())) {
                param.getParams().put("projectId", new Parameter(QueryParam.IN, projectIdsResp.getData()));
                param.getParams().remove("projectRange");
            } else {
                logger.info("根据组织Id-{}查询其下在建项目列表为空, 则返回空的数据列表！");
                IPage<ReceiptRegisterVO> emptyPageData = new Page<>(param.getPageIndex(), param.getPageSize(), 0);
                return CommonResponse.success("查询列表数据成功！", emptyPageData);
            }
        }

        List<ReceiptRegisterVO> vos = service.querySumReceivedMny(param);
        IPage<ReceiptRegisterVO> pageData = new Page<>(param.getPageIndex(),param.getPageSize(), vos.size());

//        vos.forEach(item->{
//            item.setReceiptContractFlagName(item.getReceiptContractFlag() == 1 ? "无合同收款": "有合同收款");
//        });
        pageData.setRecords(vos);

        return CommonResponse.success("查询列表数据成功！",pageData);
    }
    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ReceiptRegisterEntity> list = service.queryList(param);
        List<ReceiptRegisterVO> vos = BeanMapper.mapList(list, ReceiptRegisterVO.class);
        vos.forEach(item->{
            item.setReceiptContractFlagName(item.getReceiptContractFlag() == 1 ? "无合同收款": "有合同收款");
            if (item.getReceiptContractFlag() == 1){
                item.setContractName(null);
            }else {
                item.setFeeName(null);
            }
            item.setBillStateName(BillStateEnum.getEnumByStateCode(item.getBillState()).getDescription());
        });
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", vos);
        ExcelExport.getInstance().export("receipt-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refReceiptRegisterData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ReceiptRegisterVO>> refReceiptRegisterData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ReceiptRegisterEntity> page = service.queryPage(param,false);
        IPage<ReceiptRegisterVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ReceiptRegisterVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/download")
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "receipt-import.xlsx", "收款登记-导入模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        CommonResponse<JSONObject> commonResponse = service.excelImport(request,response);
        return commonResponse;
    }

    @RequestMapping(value = "/saveImportExcel", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> saveImportExcel(HttpServletRequest request, @RequestBody List<ReceiptRegisterVO> importVOS) {
        return CommonResponse.success(service.saveImportExcel(request, importVOS));
    }

    /**
     * 查询当前合同下已收款的金额
     * @param contractId
     * @return
     */
    @GetMapping(value = "/queryReceiptMny")
    @ResponseBody
    public CommonResponse<Map<String, BigDecimal>> queryReceiptMny(@RequestParam Long contractId,@RequestParam(value = "projectId",required = false) Long projectId) {
        Map<String, BigDecimal> receiptMnyMap = service.queryReceiptMny(contractId,projectId);
        return CommonResponse.success(receiptMnyMap);
    }

    /**
     * 查询当前合同下是否有自由态的收款登记单
     * @param contractId
     * @return
     */
    @GetMapping("/validateContract")
    @ResponseBody
    public CommonResponse<String> validateContract(@RequestParam("contractId") Long contractId,@RequestParam(value = "id",required = false) Long id) {
        String msg = service.validateContract(contractId,id);
        return CommonResponse.success("校验成功",msg);
    }

    @RequestMapping(value = "getTotalColumnInfo", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BigDecimal> getTotalColumnInfo(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("employeeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        Long orgId = InvocationInfoProxy.getOrgId();
        //若当前上下文为项目部，则根据项目部Id来进行查询
        if(OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
        } else {
            CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if(!orgResp.isSuccess()) {
                logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
                return CommonResponse.error("查询失败，获取组织信息失败！");
            }
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN,
                    orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        param.getOrderMap().put("createTime", QueryParam.DESC);
        String projectRange = null != param.getParams().get("projectRange") ? param.getParams().get("projectRange").getValue().toString() : null;
        String dateIn = null != param.getParams().get("dateIn") ? param.getParams().get("dateIn").getValue().toString() : null;
        param.getParams().remove("dateIn");
        param.getParams().remove("projectRange");
        if(StringUtils.isNotBlank(projectRange) || StringUtils.isNotBlank(dateIn)) {
            CommonResponse<List<Long>> projectIdsResp = projectPoolApi.queryProjectIdsByorgId(InvocationInfoProxy.getOrgId(),
                    projectRange, dateIn);
            if(!projectIdsResp.isSuccess()) {
                logger.error("根据组织Id-{}查询其下在建项目列表失败, {}", JSONObject.toJSONString(projectIdsResp));
                return CommonResponse.error("查询失败，获取组织下项目信息失败！");
            }
            if(CollectionUtils.isNotEmpty(projectIdsResp.getData())) {
                param.getParams().put("projectId", new Parameter(QueryParam.IN, projectIdsResp.getData()));
                param.getParams().remove("projectRange");
            } else {
                logger.info("根据组织Id-{}查询其下在建项目列表为空, 则返回空的数据列表！");
                return CommonResponse.success("查询列表数据成功！", BigDecimal.ZERO);
            }
        }
        return CommonResponse.success("查询成功！", service.getTotalColumnInfo(param, false));
    }

    //一建自动中间表生成收款登记
    @PostMapping("/PMReceipt")
    @ResponseBody
    public CommonResponse<String> PMReceipt() {
        service.autoPMReceipt();
        return CommonResponse.success("收款成功！");
    }

}
