/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.performance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.financeintegration.PMPerformance.api.IPMPerformanceReturnApi;
import com.ejianc.business.financeintegration.PMPerformance.vo.PMPerformanceReturnVO;
import com.ejianc.business.financeintegration.PMPerformance.vo.PMPerformanceVO;
import com.ejianc.business.performance.bean.PerformanceReturnEntity;
import com.ejianc.business.performance.mapper.PerformanceReturnMapper;
import com.ejianc.business.performance.service.IPerformanceReturnService;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="performanceReturnService")
public class PerformanceReturnServiceImpl
extends BaseServiceImpl<PerformanceReturnMapper, PerformanceReturnEntity>
implements IPerformanceReturnService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPMPerformanceReturnApi performanceApi;

    @Override
    public CommonResponse<String> pushDataToFinance(Long billId) {
        PerformanceReturnEntity performanceReturnEntity = (PerformanceReturnEntity)((Object)super.selectById((Serializable)billId));
        if (performanceReturnEntity != null) {
            if (performanceReturnEntity.getPayState() == 2) {
                return CommonResponse.error((String)"\u8be5\u5355\u5df2\u63a8\u9001\u8d22\u52a1\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\uff01");
            }
            ArrayList<PMPerformanceReturnVO> vo = new ArrayList<PMPerformanceReturnVO>();
            PMPerformanceReturnVO performanceVO = new PMPerformanceReturnVO();
            performanceVO.setId(IdWorker.getId() + "");
            performanceVO.setPmBillId(performanceReturnEntity.getId() + "");
            performanceVO.setProjectId(performanceReturnEntity.getProjectId() + "");
            performanceVO.setQuoteFlag("N");
            performanceVO.setActualMny(performanceReturnEntity.getAmountReturn());
            vo.add(performanceVO);
            CommonResponse pmPerformanceVOCommonResponse = this.performanceApi.performanceReturnTakeEffect(vo);
            if (pmPerformanceVOCommonResponse.isSuccess()) {
                performanceReturnEntity.setPayState(2);
                super.updateById((Object)performanceReturnEntity);
                return CommonResponse.success((String)"\u63a8\u9001\u8d22\u52a1\u6210\u529f\uff01");
            }
            return CommonResponse.error((String)"\u63a8\u9001\u8d22\u52a1\u5931\u8d25\uff01");
        }
        return CommonResponse.error((String)"\u83b7\u53d6\u5355\u636e\u4fe1\u606f\u5931\u8d25\uff01");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void handMQMessageReturn(String deductedResultMsg) {
        this.logger.info("\u83b7\u53d6\u6263\u6b3e\u5355\u652f\u4ed8\u6570\u636e--begin\uff01");
        if (StringUtils.isNotBlank((CharSequence)deductedResultMsg)) {
            List resultList = JSONObject.parseArray((String)deductedResultMsg, PMPerformanceVO.class);
            this.logger.info("\u63a5\u6536\u4e00\u5efa\u8d22\u52a1\u7cfb\u7edf\u7684\u5c65\u7ea6\u4fdd\u8bc1\u91d1\u6263\u6b3e\u6570\u636e\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)resultList));
            if (CollectionUtils.isNotEmpty((Collection)resultList)) {
                List deductedIds = resultList.stream().map(PMPerformanceVO::getPmBillId).collect(Collectors.toList());
                QueryParam queryParam = new QueryParam();
                queryParam.getParams().put("id", new Parameter("in", deductedIds));
                List performanceReturnEntities = super.queryList(queryParam);
                Map collect = performanceReturnEntities.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity(), (v1, v2) -> v2));
                for (PMPerformanceVO pMPerformanceVO : resultList) {
                    if (!collect.containsKey(Long.parseLong(pMPerformanceVO.getPmBillId()))) continue;
                    PerformanceReturnEntity performanceDeductedEntity = (PerformanceReturnEntity)((Object)collect.get(Long.parseLong(pMPerformanceVO.getPmBillId())));
                    if (pMPerformanceVO.getState() == null) continue;
                    if ("1".equals(pMPerformanceVO.getState())) {
                        performanceDeductedEntity.setPayState(3);
                    } else if ("2".equals(pMPerformanceVO.getState())) {
                        performanceDeductedEntity.setPayState(4);
                    }
                    super.updateById((Object)performanceDeductedEntity);
                }
            }
        }
        this.logger.info("\u83b7\u53d6\u6536\u6b3e\u5355\u6570\u636e\uff0c\u5f00\u59cb\u751f\u6210\u6263\u6b3e\u5355--end\uff01");
    }
}

