/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.profinance.paysupplement.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.profinance.bean.PMPayEntity;
import com.ejianc.business.profinance.paysupplement.bean.PaymentSupplementEntity;
import com.ejianc.business.profinance.paysupplement.service.IPaymentSupplementService;
import com.ejianc.business.profinance.service.IPMPayService;
import com.ejianc.business.profinance.vo.PMPayVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="paymentSupplement")
public class PaymentSupplementBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IPaymentSupplementService paymentSupplementService;
    @Autowired
    private IPMPayService pMPayService;
    @Autowired
    private IProjectPoolApi projectPoolApi;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    private PMPayEntity getWriteInfo(PaymentSupplementEntity entity, boolean isRedRush) {
        PMPayEntity pmPayEntity = new PMPayEntity();
        pmPayEntity.setProjectId(entity.getProjectId());
        if (isRedRush) {
            pmPayEntity.setSourceType("\u4ed8\u6b3e\u8865\u5f55\u6838\u9500\u7ea2\u51b2");
        } else {
            pmPayEntity.setSourceType("\u4ed8\u6b3e\u8865\u5f55\u6838\u9500");
        }
        pmPayEntity.setPushTime(new Date());
        pmPayEntity.setActualPayTime(entity.getPaymentDate());
        pmPayEntity.setSupplyId(entity.getSupplierId());
        pmPayEntity.setPayeeId(entity.getPayeeId());
        if (entity.getPaymentContractFlag().equals(0)) {
            pmPayEntity.setContractId(entity.getContractId());
        } else {
            pmPayEntity.setContractId(-1L);
        }
        if (isRedRush) {
            pmPayEntity.setPayMnyActual(entity.getPayMny().negate());
            pmPayEntity.setSourceId("paymentSupplement-bpmback-" + entity.getId().toString() + "-ts-" + new Date().getTime());
        } else {
            pmPayEntity.setPayMnyActual(entity.getPayMny());
            pmPayEntity.setSourceId("paymentSupplement-approved-" + entity.getId().toString() + "-ts-" + new Date().getTime());
        }
        pmPayEntity.setSourceTypeCode("1");
        pmPayEntity.setId(IdWorker.getId());
        return pmPayEntity;
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    @Transactional(rollbackFor={Exception.class})
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        PaymentSupplementEntity entity = (PaymentSupplementEntity)((Object)this.paymentSupplementService.selectById(billId));
        PMPayEntity pmPayEntity = this.getWriteInfo(entity, false);
        this.logger.info("\u4ed8\u6b3e\u8865\u5f55\u5355-\u3010{}\u3011\u5ba1\u6279\u901a\u8fc7\u751f\u6210\u5bf9\u5e94\u4ed8\u6b3e\u6838\u9500\u5355-\u3010{}\u3011\u8fdb\u884c\u4ed8\u6b3e\u6838\u9500\u3002", (Object)JSONObject.toJSONString((Object)((Object)entity)), (Object)JSONObject.toJSONString((Object)((Object)pmPayEntity)));
        this.pMPayService.saveOrUpdate((Object)pmPayEntity, false);
        this.pMPayService.sendMessage((PMPayVO)BeanMapper.map((Object)((Object)pmPayEntity), PMPayVO.class));
        return CommonResponse.success((String)"\u5ba1\u6279\u56de\u8c03\u6210\u529f\uff01");
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    @Transactional(rollbackFor={Exception.class})
    public CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
        PaymentSupplementEntity entity = (PaymentSupplementEntity)((Object)this.paymentSupplementService.selectById(billId));
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"project_id", (Object)entity.getProjectId());
        query.eq((Object)"contract_id", (Object)entity.getContractId());
        query.eq((Object)"supplier_id", (Object)entity.getSupplierId());
        query.eq((Object)"payee_id", (Object)entity.getPayeeId());
        query.in((Object)"bill_state", Arrays.asList(BillStateEnum.UNCOMMITED_STATE.getBillStateCode(), BillStateEnum.UNAPPROVED.getBillStateCode(), BillStateEnum.SUSPEND.getBillStateCode()));
        List list = this.paymentSupplementService.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            this.logger.error("\u5355\u636e-[{}]\u5b58\u5728\u540c\u4e00\u7ef4\u5ea6\u672a\u751f\u6548\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u5f03\u5ba1\uff01");
            return CommonResponse.error((String)"\u5355\u636e\u5b58\u5728\u540c\u4e00\u7ef4\u5ea6\u672a\u751f\u6548\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u5f03\u5ba1\uff01");
        }
        if (entity.getBillState() == 3 || entity.getBillState() == 1) {
            PMPayEntity pmPayEntity = this.getWriteInfo(entity, true);
            this.logger.info("\u4ed8\u6b3e\u8865\u5f55\u5355-\u3010{}\u3011\u5ba1\u6279\u901a\u8fc7\u751f\u6210\u5bf9\u5e94\u4ed8\u6b3e\u6838\u9500\u5355-\u3010{}\u3011\u8fdb\u884c\u4ed8\u6b3e\u6838\u9500\u7ea2\u51b2\u3002", (Object)JSONObject.toJSONString((Object)((Object)entity)), (Object)JSONObject.toJSONString((Object)((Object)pmPayEntity)));
            this.pMPayService.saveOrUpdate((Object)pmPayEntity, false);
            this.pMPayService.sendMessage((PMPayVO)BeanMapper.map((Object)((Object)pmPayEntity), PMPayVO.class));
        }
        return CommonResponse.success((String)"\u5ba1\u6279\u56de\u8c03\u6210\u529f\uff01");
    }

    public CommonResponse<JSONArray> queryApproveUser(Long billId, String billTypeCode, String sign, Map<String, Object> other) {
        JSONArray arr = new JSONArray();
        this.logger.info("sign:{}", (Object)sign);
        if ("choseCostUser".equals(sign)) {
            PaymentSupplementEntity entity = (PaymentSupplementEntity)((Object)this.paymentSupplementService.selectById(billId));
            Long projectId = entity.getProjectId();
            JSONObject jsonObject = new JSONObject();
            CommonResponse commonResponse = this.projectPoolApi.queryProjectPoolById(projectId);
            if (!commonResponse.isSuccess()) {
                throw new BusinessException("\u67e5\u8be2\u9879\u76ee\u5931\u8d25!");
            }
            JSONArray array = (JSONArray)commonResponse.getData();
            List vos = JSONObject.parseArray((String)array.toJSONString(), ProjectPoolSetVO.class);
            this.logger.info("vos:{}", (Object)JSONObject.toJSONString((Object)vos));
            ProjectPoolSetVO vo = (ProjectPoolSetVO)vos.get(0);
            Long costAdapter = vo.getCostAdapter();
            String costAdapterName = vo.getCostAdapterName();
            this.logger.info("userId:{}", (Object)costAdapter);
            this.logger.info("userName:{}", (Object)costAdapterName);
            jsonObject.put("userId", (Object)costAdapter);
            jsonObject.put("userName", (Object)costAdapterName);
            arr.add((Object)jsonObject);
        }
        return CommonResponse.success((Object)arr);
    }
}

