package com.ejianc.business.financial.service.impl;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.financeintegration.PMPayApply.api.IPMYHSApi;
import com.ejianc.business.financeintegration.PMPayApply.vo.PMYHSVO;
import com.ejianc.business.financial.bean.StampDutyEntity;
import com.ejianc.business.financial.service.IStampDutyService;
import com.ejianc.business.financial.vo.StampDutyVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Service("stampDuty") 
public class StampDutyBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private IStampDutyService service;

	@Autowired
	private IPMYHSApi yhsApi;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		StampDutyEntity stampDutyEntity = service.selectById(billId);
		QueryParam param = new QueryParam();
		param.getParams().put("yearmonth", new Parameter(QueryParam.EQ, stampDutyEntity.getYearmonth()));
		param.getParams().put("billState", new Parameter(QueryParam.NOT_IN, Arrays.asList(1,3)));
		List<StampDutyEntity> stampDutyEntities = service.queryList(param);
		if (CollectionUtils.isEmpty(stampDutyEntities) ){
			param.getParams().get("billState").setType(QueryParam.IN);
			List<StampDutyEntity> stampDutys = service.queryList(param);
			ArrayList<PMYHSVO> pmyhsvos = new ArrayList<>();

			for (StampDutyEntity stampDuty : stampDutys) {
				PMYHSVO map = BeanMapper.map(stampDuty, PMYHSVO.class);
				map.setId(IdWorker.getId()+"");
				map.setPmBillId(stampDuty.getId()+"");
				pmyhsvos.add(map);
			}

			CommonResponse<PMYHSVO> pmyhsvoCommonResponse = yhsApi.listInsert(pmyhsvos);
			if (pmyhsvoCommonResponse.getCode() != 0){
				return CommonResponse.error(pmyhsvoCommonResponse.getMsg());
			}
		}

		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		StampDutyEntity stampDutyEntity = service.selectById(billId);
		QueryParam param = new QueryParam();
		param.getParams().put("yearmonth", new Parameter(QueryParam.EQ, stampDutyEntity.getYearmonth()));
		param.getParams().put("billState", new Parameter(QueryParam.NOT_IN, Arrays.asList(1,3)));
		List<StampDutyEntity> stampDutyEntities = service.queryList(param);
		if (CollectionUtils.isEmpty(stampDutyEntities) ){
			return CommonResponse.error("印花税数据已提交财务系统，无法撤回！");
		}

		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
