package com.ejianc.business.profinance.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.profinance.bean.SalaryEntity;
import com.ejianc.business.profinance.bean.SalaryPayApplyEntity;
import com.ejianc.business.profinance.service.ISalaryPayApplyService;
import com.ejianc.business.profinance.service.ISalaryService;
import com.ejianc.business.profinance.vo.ContractPaymentResultVO;
import com.ejianc.business.profinance.vo.PaymentApplyVO;
import com.ejianc.business.profinance.vo.SalaryVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

import static java.math.BigDecimal.ROUND_HALF_DOWN;

/**
 * PM支付主实体
 *
 * @author generator
 */
@RestController
@RequestMapping("/api/salaryApi/")
public class SalaryApi implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ISalaryService service;

    @Autowired
    private ISalaryPayApplyService salaryPayApplyService;

    @GetMapping(value = "salaryApplyInfoByContractId")
    public CommonResponse<ContractPaymentResultVO> querySalaryApplyInfoByContractId(@RequestParam Long contractId) {
        ContractPaymentResultVO resp = new ContractPaymentResultVO();
        StringBuilder sql = new StringBuilder();
        sql.append("id as id, bill_code as billCode, bill_state as billState, ")
                .append("org_id as orgId, org_code as orgCode, org_name as orgName, ")
                .append("parent_org_id as parentOrgId, parent_org_code as parentOrgCode, parent_org_name as parentOrgName, ")
                .append("contract_id as contractId, contract_name as contractName, contract_code as contractName, ")
                .append("contract_category_id as contractCategoryId, contract_category_name as contractCategoryName, ")
                .append("project_id as projectId, project_code as projectCode, project_name as projectName, ")
                .append("apply_date as applyDate, memo as memo, pay_reason as paymentReason, ")
                .append("apply_tax_mny as applyMny,apply_tax_mny as approvalMny, actual_paid_tax_mny as actualMny, 5 as paymentType, 1 as paymentContractFlag, apply_name as employeeName");
        QueryWrapper<SalaryPayApplyEntity> listQuery = new QueryWrapper<>();
        listQuery.select(sql.toString());
        listQuery.eq("contract_id", contractId);
        listQuery.in("bill_state", new Integer[]{
                BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
        listQuery.eq("is_repeat_bill", 0); //过滤掉重发单
//        listQuery.eq("pay_type", 1); //不要垫付的单子
        listQuery.in("pay_type", Arrays.asList("1","4"));

        listQuery.orderByDesc("pay_date", "create_time");
        List<PaymentApplyVO> salaryPayList = BeanMapper.mapList(salaryPayApplyService.listMaps(listQuery), PaymentApplyVO.class);


        QueryWrapper<SalaryPayApplyEntity> countQuery = new QueryWrapper<>();
        countQuery.select(sql.toString());
        countQuery.select("sum(apply_tax_mny) as totalApplyTaxMny, sum(apply_tax_mny) as totalApproveTaxMny, sum(ifnull(actual_paid_tax_mny,0)) as totalPaidTaxMny, contract_tax_mny as contractTaxMny, contract_id as contractId");
        countQuery.eq("contract_id", contractId);
        countQuery.in("bill_state", new Integer[]{
                BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
        countQuery.eq("is_repeat_bill", 0); //过滤掉重发单
//        countQuery.eq("pay_type", 1); //不要垫付的单子
        countQuery.in("pay_type", Arrays.asList("1","4"));
        Map<String, Object> countMap = salaryPayApplyService.getMap(countQuery);
        resp.setContractId(contractId);
        resp.setTotalActualMny(BigDecimal.ZERO);
        resp.setTotalApplyMny(BigDecimal.ZERO);
        resp.setTotalApprovalMny(BigDecimal.ZERO);
        resp.setPaymentRate(BigDecimal.ZERO);
        resp.setPaymentApplyList(salaryPayList);
        if(null != countMap) {
            if(null != countMap.get("totalApplyTaxMny")) {
                resp.setTotalApplyMny(new BigDecimal(countMap.get("totalApplyTaxMny").toString()));
            }
            if(null != countMap.get("totalApproveTaxMny")) {
                resp.setTotalApprovalMny(new BigDecimal(countMap.get("totalApproveTaxMny").toString()));
            }
            if(null != countMap.get("totalPaidTaxMny")) {
                resp.setTotalActualMny(new BigDecimal(countMap.get("totalPaidTaxMny").toString()));
            }
            if(null != countMap.get("contractTaxMny")) {
                resp.setContractTaxMny(new BigDecimal(countMap.get("contractTaxMny").toString()));
            }

            resp.setPaymentRate((resp.getTotalActualMny().divide(resp.getContractTaxMny(),8, ROUND_HALF_DOWN)).multiply(new BigDecimal(100)));
        }

        return CommonResponse.success(resp);
    }

    /**
     * 通过合同id、结算类型、日期查询相应的工人工资列表
     * @param contractId
     * @param settleType
     * @param settleDate
     * @return
     */
    @GetMapping("querySalaryList")
    CommonResponse<List<SalaryVO>> querySalaryList(@RequestParam(value = "contractId") Long contractId, @RequestParam(value = "settleType") Integer settleType, @RequestParam(value = "settleDate") String settleDate) {
        logger.info("查询工人工资单条件：contractId - ", contractId);
        QueryWrapper<SalaryEntity> listQuery = new QueryWrapper<>();
        listQuery.eq("contract_id", contractId);
        if (0 == settleType){
            //月度结算判断日期小于当前时间，且没有结算id
            listQuery.le("belong_month", settleDate);
            listQuery.isNull("settle_id");//没有结算id的
        }
        //取已生效的工人工资单
        listQuery.in("bill_state", Arrays.asList(
                BillStateEnum.COMMITED_STATE.getBillStateCode(),
                BillStateEnum.PASSED_STATE.getBillStateCode()));
        listQuery.orderByDesc("belong_month");
        List<SalaryEntity> salaryEntityList = service.list(listQuery);
        List<SalaryVO> salaryVOList = BeanMapper.mapList(salaryEntityList, SalaryVO.class);

        logger.info("查询工人工资单结果：{}", JSONObject.toJSONString(salaryVOList, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
        return CommonResponse.success("查询工人工资单单成功！", salaryVOList);
    }


    /**
     * 回写工人工资单的settleId
     * @param salaryIds
     * @param settleId
     * @return
     */
    @PostMapping("writeSalarySettleId")
    CommonResponse<String> writeSalarySettleId(@RequestParam(value = "salaryIds") List<Long> salaryIds, @RequestParam(value = "settleId", required = false) String settleId){
        logger.info("查询工人工资单列表条件：salaryIds - {}", JSONObject.toJSONString(salaryIds));
        logger.info("查询工人工资单列表条件：settleId - {}", settleId);
        QueryWrapper<SalaryEntity> listQuery = new QueryWrapper<>();
        listQuery.in("id", salaryIds);
        List<SalaryEntity> salaryEntityList = service.list(listQuery);
        if (CollectionUtils.isNotEmpty(salaryEntityList)){
            for (SalaryEntity salaryEntity : salaryEntityList) {
                if (StringUtils.isBlank(settleId)){
                    salaryEntity.setSettleId(null);
                }else {
                    salaryEntity.setSettleId(Long.valueOf(settleId));
                }
            }
        }
        service.saveOrUpdateBatch(salaryEntityList);
        return CommonResponse.success("回写工人工资单结算id成功，工人工资单条数：" + salaryEntityList.size() + "");
    }



    /**
     * 通过合同id相应的工人工资列表
     * @param contractId
     * @return
     */
    @GetMapping("querySalaryListByContract")
    CommonResponse<List<SalaryVO>> querySalaryListByContract(@RequestParam(value = "contractId") Long contractId) {
        logger.info("查询工人工资单条件：contractId - ", contractId);
        QueryWrapper<SalaryEntity> listQuery = new QueryWrapper<>();
        listQuery.eq("contract_id", contractId);
        listQuery.orderByDesc("belong_month");
        List<SalaryEntity> salaryEntityList = service.list(listQuery);
        List<SalaryVO> salaryVOList = BeanMapper.mapList(salaryEntityList, SalaryVO.class);

        logger.info("查询工人工资单结果：{}", JSONObject.toJSONString(salaryVOList, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
        return CommonResponse.success("查询工人工资单单成功！", salaryVOList);
    }

}