package com.ejianc.business.profinance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.contractbase.api.ITemplateCategoryApi;
import com.ejianc.business.contractbase.pool.enums.ContractFlagEnum;
import com.ejianc.business.contractbase.pool.enums.SettleSourceTypeEnum;
import com.ejianc.business.contractbase.pool.enums.SettleUltimateFlagEnum;
import com.ejianc.business.contractbase.pool.settlepool.api.ISettlePoolApi;
import com.ejianc.business.contractbase.pool.settlepool.vo.SettlePoolVO;
import com.ejianc.business.contractbase.vo.TemplateCategoryVO;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.process.enums.BillPushStatusEnum;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.procost.vo.CostDetailVO;
import com.ejianc.business.profinance.bean.ContractLawsuitEntity;
import com.ejianc.business.profinance.mapper.ContractLawsuitMapper;
import com.ejianc.business.profinance.service.IContractLawsuitService;
import com.ejianc.business.profinance.service.IContractLawsuitSubSettleService;
import com.ejianc.business.profinance.vo.ContractLawsuitVO;
import com.ejianc.business.settle.vo.SettleVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.*;

/**
 * 诉讼费结算实体
 * 
 * @author generator
 * 
 */
@Service("contractLawsuitService")
public class ContractLawsuitServiceImpl extends BaseServiceImpl<ContractLawsuitMapper, ContractLawsuitEntity> implements IContractLawsuitService{
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISettlePoolApi settlePoolApi;

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IContractLawsuitSubSettleService contractLawsuitSubSettleService;

    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private ITemplateCategoryApi templateCategoryApi;

    private static final String BILL_CODE = "CON_LASWUIT";//此处需要根据实际修改

    @Override
    public BigDecimal queryTotalLawsuitMny(Long contractId) {
        Map<String, BigDecimal> resp = new HashMap<>();
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contract_id",new Parameter(QueryParam.EQ,contractId));
        List<Integer> billStateList = new ArrayList<>();
        billStateList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billStateList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        queryParam.getParams().put("bill_state",new Parameter(QueryParam.IN,billStateList));
        QueryWrapper wrapper = changeToQueryWrapper(queryParam);
        wrapper.select("sum(lawsuit_work_mny) as lawsuitWorkMny");
        resp = super.getMap(wrapper);
        if (null == resp) {
            resp = new HashMap<>();
            resp.put("lawsuitWorkMny", BigDecimal.ZERO);

        }
        return resp.get("lawsuitWorkMny");
    }

    @Override
    public String pushLawsuitToPool(ContractLawsuitVO s) {
        SettlePoolVO spv = new SettlePoolVO();
        String pushResult = null;
        try {
            logger.info("结算单对象 -> 结算池对象自动转换开始");
            BeanConvertorUtil.convert(s, spv);
            logger.info("结算单对象 -> 结算池对象自动转换结束，下面开始手动转换");
            spv.setSourceType(SettleSourceTypeEnum.诉讼费结算.getCode());
            spv.setSettleProperty(0);// 属性类型：支出
            spv.setUltimateFlag(0);// 是否最终结算：否
            spv.setCurMny(s.getSettleMny());
            spv.setCurTax(BigDecimal.ZERO);
            spv.setCreateTime(s.getCreateTime());
            spv.setCreateUserCode(s.getCreateUserCode());
            spv.setBillCodeUrl("/ejc-profinance-frontend/#/lawsuitList/card?id="+s.getId());

            spv.setHandleType(0); //业务系统推送结算池
            spv.setContractFlag(ContractFlagEnum.有合同结算.getContractFlagCode());
            spv.setContractFlagName(ContractFlagEnum.有合同结算.getContractFlagCodeName());
            spv.setUltimateFlag(SettleUltimateFlagEnum.非最终结算.getCode());

            //查询合同分类
            CommonResponse<TemplateCategoryVO> categoryResp = templateCategoryApi.queryTmplCategoryById(s.getContractCategoryId());
            if(!categoryResp.isSuccess()) {
                return "推送失败，获取合同分类信息失败！";
            }
            spv.setContractType(categoryResp.getData().getCategoryProperty());
            spv.setContractTypeName(categoryResp.getData().getpName());

            logger.info("结算单对象:[{}] -> 结算池对象手动转换完成，下面开始:[{}]推送至结算池", JSONObject.toJSONString(s),JSONObject.toJSONString(spv));
            CommonResponse<SettlePoolVO> res = settlePoolApi.saveOrUpdateSettle(spv);
            if (res.isSuccess()) {
                this.executeUpdatePool(s.getId(), true);
                logger.info("结算单推送至结算池成功！结算单id-{}", s.getId());
            } else {
                this.executeUpdatePool(s.getId(), false);
                logger.error("结算单推送结算池失败！结算单id-{}，{}", s.getId(), JSONObject.toJSONString(res));
                pushResult = "结算单推送结算池失败";
            }
        }catch (Exception e) {
            logger.error("结算单推送结算池失败！结算单id-{}", s.getId(), e);
            pushResult = "结算单推送结算池失败";
        }

        return pushResult;
    }
    @Override
    public void executeUpdatePool(Long id, Boolean flag) {
        // 更新协同推送状态
        UpdateWrapper<ContractLawsuitEntity> updateWrapper = new UpdateWrapper<>();
        updateWrapper.eq("id", id);
        // 修改推送状态
        if (Boolean.TRUE.equals(flag)) {
            updateWrapper.set("push_pool_flag", BillPushStatusEnum.推送成功.getStatus());
        } else {
            updateWrapper.set("push_pool_flag", BillPushStatusEnum.未成功推送.getStatus());
        }
        super.update(updateWrapper);
    }


    // 从结算池中删除数据
    @Override
    public boolean delSettleFromPool(Long id) {
        SettlePoolVO spv = new SettlePoolVO();
        spv.setSourceId(id);

        CommonResponse<SettlePoolVO> res = settlePoolApi.deleteSettle(spv);
        if (res.isSuccess()) {
            logger.info("将结算单从结算池中删除成功！结算单id-{}", id);
            return true;
        }

        logger.error("将结算单从结算池中删除失败！结算单id-{}，{}", id, res.getMsg());
        return false;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ContractLawsuitVO saveContractLawsuitVO(ContractLawsuitVO saveOrUpdateVO) {
        ContractLawsuitEntity entity = BeanMapper.map(saveOrUpdateVO, ContractLawsuitEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            entity.setRelationFlag("0");
            entity.setProportionFlag("0");

        } else {
            //物理删除旧的合同结算信息
            contractLawsuitSubSettleService.deleteByLawsuitId(saveOrUpdateVO.getId());
        }
        super.saveOrUpdate(entity, false);
        ContractLawsuitVO vo = BeanMapper.map(entity, ContractLawsuitVO.class);
        return vo;
    }

    @Override
    public void costPush(ContractLawsuitEntity entity) {
        logger.info("开始costPush");
        String newRelationFlag = associatedFlag(entity);
        logger.info("newRelationFlag---{}",newRelationFlag);
        LambdaUpdateWrapper<ContractLawsuitEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.in(ContractLawsuitEntity::getId, entity.getId());
        updateWrapper.set(ContractLawsuitEntity::getRelationFlag, newRelationFlag);//(1:是，0：否)
        super.update(updateWrapper);
        String oldRelationFlag = entity.getRelationFlag();
        if ("1".equals(oldRelationFlag)) {
            if ("1".equals(newRelationFlag)) {
                saveCost(entity);
            }
            if (!"1".equals(newRelationFlag)) {
                //删除成本中心之前的数据
                logger.info("删除成本中心之前的数据-领料出库Id---{}",entity.getId());
                CommonResponse<String> commonResponse = costDetailApi.deleteSubject(entity.getId());
                logger.info("结果"+JSONObject.toJSONString(commonResponse));
                if(!commonResponse.isSuccess()){
                    throw new BusinessException(commonResponse.getMsg());
                }
            }
        }
        //之前未关联
        if ("0".equals(oldRelationFlag)) {
            if ("1".equals(newRelationFlag)) {
                //税率
                boolean b = saveCost(entity);
                if (!b){
                    throw new BusinessException("网络错误 推送实际成本失败");
                }
            }
        }
    }

    @Override
    public void costDeletePush(ContractLawsuitEntity entity) {
        logger.info("弃审推送成本---");
        logger.info("删除成本中心之前的数据-结算单Id---{}",entity.getId());
        CommonResponse<String> stringCommonResponse = costDetailApi.deleteSubject(entity.getId());
        logger.info("结果"+ JSONObject.toJSONString(stringCommonResponse));
        if(!stringCommonResponse.isSuccess()){
            throw new BusinessException(stringCommonResponse.getMsg());
        }
        //更新是否关联
        LambdaUpdateWrapper<ContractLawsuitEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.in(ContractLawsuitEntity::getId, entity.getId());
        updateWrapper.set(ContractLawsuitEntity::getRelationFlag, "0");//(1:是，0：否)
        super.update(updateWrapper);

    }

    @Override
    public CommonResponse<ContractLawsuitVO> pushCost(ContractLawsuitVO vo) {
        ContractLawsuitEntity entity = baseMapper.selectById(vo.getId());
        entity.setProjectWbsCode(vo.getProjectWbsCode());
        entity.setProjectWbsName(vo.getProjectWbsName());
        entity.setProjectWbsId(vo.getProjectWbsId());
        entity.setCostOfCourseCode(vo.getCostOfCourseCode());
        entity.setCostOfCourseName(vo.getCostOfCourseName());
        entity.setCostOfCourseId(vo.getCostOfCourseId());
        super.saveOrUpdate(entity, false);
        costPush(entity);
        return CommonResponse.success(BeanMapper.map(entity, ContractLawsuitVO.class));
    }

    private String associatedFlag(ContractLawsuitEntity entity){
        String newRelationFlag = "1";
        if (null==entity.getProjectWbsId()||null==entity.getCostOfCourseId()){
            newRelationFlag = "0";
        }
        return newRelationFlag;
    }


    private boolean saveCost(ContractLawsuitEntity entity) {
        logger.info("推送诉讼结算实体："+JSONObject.toJSONString(entity));
        List<CostDetailVO> costDetailVOList = new ArrayList<>();
        CostDetailVO costDetailVO = new CostDetailVO();
        costDetailVO.setSubjectId(entity.getCostOfCourseId());
        costDetailVO.setSubjectCode(entity.getCostOfCourseCode());
        costDetailVO.setSubjectName(entity.getCostOfCourseName());
        costDetailVO.setWbsId(entity.getProjectWbsId());
        costDetailVO.setWbsCode(entity.getProjectWbsCode());
        costDetailVO.setWbsName(entity.getProjectWbsName());
        costDetailVO.setSourceId(entity.getId());
        costDetailVO.setSourceDetailId(entity.getId());
        costDetailVO.setHappenTaxMny(entity.getOtherLawsuitMny());
        costDetailVO.setHappenMny(entity.getOtherLawsuitMny());
        costDetailVO.setSourceTabType("SET_LAWSUIT");
        costDetailVO.setSourceBillUrl("/ejc-profinance-frontend/#/lawsuitList/card?id="+entity.getId());//需要跳转路径与参数组成的全路径
        costDetailVO.setSourceBillCode(entity.getBillCode()); //填充自己的单据编号
        costDetailVO.setSourceBillName("诉讼费结算");//填充枚举里  自己的单据名称
        costDetailVO.setSourceType("LAWSUIT_SET");
        costDetailVO.setHappenDate(entity.getSettleDate());
        costDetailVO.setCreateUserName(entity.getCreateUserCode());
        costDetailVO.setProjectId(entity.getProjectId());
        costDetailVOList.add(costDetailVO);
        //成本中心
        if (CollectionUtils.isNotEmpty(costDetailVOList)) {
            logger.info("推送数据--------：{}",JSONObject.toJSONString(costDetailVOList));
            CommonResponse<String> stringCommonResponse = costDetailApi.saveSubject(costDetailVOList);
            logger.info("推送结果--------：{}",JSONObject.toJSONString(stringCommonResponse));
            if (!stringCommonResponse.isSuccess()) {
                logger.error("网络错误 推送实际成本失败 失败信息：{}",JSONObject.toJSONString(stringCommonResponse));
                throw new BusinessException(JSONObject.toJSONString(stringCommonResponse));
            }
        }
        return true;
    }
    }
