package com.ejianc.business.profinance.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.financeintegration.PMPayApply.api.IPMSalaryPayApplyApi;
import com.ejianc.business.financeintegration.PMPayApply.vo.PMSalaryPayApplyDetailVO;
import com.ejianc.business.financeintegration.PMPayApply.vo.PMSalaryPayApplyVO;
import com.ejianc.business.profinance.bean.SalaryPayApplyDetailEntity;
import com.ejianc.business.profinance.bean.SalaryPayApplyEntity;
import com.ejianc.business.profinance.bean.SalaryPayApplyRegisterEntity;
import com.ejianc.business.profinance.service.ISalaryPayApplyDetailService;
import com.ejianc.business.profinance.service.ISalaryPayApplyRegisterService;
import com.ejianc.business.profinance.service.ISalaryPayApplyService;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service("salaryPayApply")
public class SalaryPayApplyBpmServiceImpl implements ICommonBusinessService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ISalaryPayApplyService salaryPayApplyService;

    @Autowired
    private ISalaryPayApplyDetailService salaryPayApplyDetailService;

    @Autowired
    private IPMSalaryPayApplyApi pmSalaryPayApplyApi;

    @Autowired
    private ISalaryPayApplyRegisterService salaryPayApplyRegisterService;

    @Autowired
    private IProjectPoolApi projectPoolApi;


    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return bpmBackCheck(billId, state, billTypeCode);
    }

    ;

    /**
     * 有审批流的撤回后回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 审批节点审批中时节点审批前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    ;


    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {

        /**
         * 新增垫付逻辑，如果是垫付、劳务公司直发，则修改工资申请单的实付金额，支付状态、工人工资单的回写
         * 2025-08-13 新增甲方代发的类型和垫付逻辑保持一致
         *
         */
        SalaryPayApplyEntity sourceEntity = salaryPayApplyService.selectById(billId);
        if (sourceEntity.getPayType() != null &&
                (sourceEntity.getPayType() == 2 || sourceEntity.getPayType() == 3 || sourceEntity.getPayType() == 4)){
            salaryPayApplyService.handSalaryData(sourceEntity);
        }else {
        /*
        TODO 调用工人工资支付申请接口进行申请（此接口还未开发），然后将子表中的支付状态修改为待支付，
         后续需要开发一个MQ用于接受财务返回的支付结果
         根据支付结果更新工人工资支付申请子表对应工资清单数据的支付状态和支付日期，
         并将成功的工资清单记录新增到工资登记表中
         */
        /*
            1) 【工人工资支付申请】审批通过时，实时调用财务接口提供的中间表新增接口，在中间表中新增一条数据，数据的结构参见中间表，
            设置子表所有数据的初始“状态”为“待支付”；且【工人工资支付申请调整单】审批通过时，
            也是同样在中间表新增一条数据，相对于关联的【工人工资支付申请】，在财务中间表是一条新数据；
         */
            CommonResponse<PMSalaryPayApplyVO> res = salaryTakeEffect(billId);
            if (!res.isSuccess()) {
                logger.error("调用PM工资支付申请付款生效接口失败！message-{}", res.getMsg());
                return CommonResponse.error("调用PM工资支付申请付款生效接口失败");
            }
        }
        return CommonResponse.success("工资支付申请终审回调成功！");
    }

    private CommonResponse<PMSalaryPayApplyVO> salaryTakeEffect(Long id) {
        logger.info("调用PM工资支付申请的生效接口---ejc-profinance项目---SalaryPayApplyBpmServiceImpl类---salaryTakeEffect方法---begin，本付款申请ID-{}", id);
        SalaryPayApplyEntity sourceEntity = salaryPayApplyService.selectById(id);
        if (sourceEntity == null) {
            logger.error("根据本工资支付申请ID-{}，查询不到工资支付申请数据，无法调用PM工资支付申请生效接口", id);
            return CommonResponse.error("根据本工资支付申请ID-【" + id + "】查询不到工资支付申请数据，无法调用PM工资支付申请生效接口");
        }
        logger.info("根据本工资支付申请ID-{}，查询到的本工资支付申请数据-{}", id, JSONObject.toJSONString(sourceEntity, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
        PMSalaryPayApplyVO pmSalaryPayApplyVO = new PMSalaryPayApplyVO();

        pmSalaryPayApplyVO.setContractId(sourceEntity.getContractId().toString());
        pmSalaryPayApplyVO.setProjectId(sourceEntity.getProjectId().toString());
        pmSalaryPayApplyVO.setQuoteFlag("N");//初始引用状态 为未引用
        pmSalaryPayApplyVO.setSalaryPayApplyId(sourceEntity.getId().toString());
        pmSalaryPayApplyVO.setSupplierId(sourceEntity.getPaySupplierId().toString());
        //本次申请总金额
        pmSalaryPayApplyVO.setTotalApplyMny(sourceEntity.getApplyTaxMny());
        if (CollectionUtils.isNotEmpty(sourceEntity.getSalaryList())){
            //将工资支付申请子表身份证号相同的人员合成一条数据
            //1220要求不合并数据
            //Map<String, BigDecimal> salaryIdCardAndMnyMap = sourceEntity.getSalaryList().stream().collect(Collectors.groupingBy(SalaryPayApplyDetailEntity::getWorkerIdCard, Collectors.reducing(BigDecimal.ZERO, SalaryPayApplyDetailEntity::getWorkerApplyTaxMny, BigDecimal::add)));
            //Map<String, String> salaryIdCardAndPMIdMap = new HashMap<>();
            List<PMSalaryPayApplyDetailVO> pmSalaryPayApplyDetailList = new ArrayList<>();
            //if (null != salaryIdCardAndMnyMap){
                for (SalaryPayApplyDetailEntity detailEntity : sourceEntity.getSalaryList()) {
//                    if (salaryIdCardAndPMIdMap.containsKey(detailEntity.getWorkerIdCard())){
//                        detailEntity.setPmPayApplyDetailId(salaryIdCardAndPMIdMap.get(detailEntity.getWorkerIdCard()));
//                    }else {
                        //封装中间表子表数据
                        PMSalaryPayApplyDetailVO pmSalaryPayApplyDetailVO = new PMSalaryPayApplyDetailVO();
                        //新增id
                        pmSalaryPayApplyDetailVO.setId(String.valueOf(IdWorker.getId()));
                        pmSalaryPayApplyDetailVO.setPayState("0");
                        pmSalaryPayApplyDetailVO.setSalaryPayApplyId(detailEntity.getPid().toString());
                        pmSalaryPayApplyDetailVO.setWorkerAccountNum(detailEntity.getWorkerAccountNum());
                        //设置pm中间表子表申请金额（支付申请表里相同身份证的数据的申请金额总和）
                        //pmSalaryPayApplyDetailVO.setWorkerApplyTaxMny(salaryIdCardAndMnyMap.get(detailEntity.getWorkerIdCard()));
                        pmSalaryPayApplyDetailVO.setWorkerApplyTaxMny(detailEntity.getWorkerApplyTaxMny());

                        pmSalaryPayApplyDetailVO.setWorkerBankName(detailEntity.getWorkerBankName());
                        pmSalaryPayApplyDetailVO.setWorkerIdCard(detailEntity.getWorkerIdCard());
                        pmSalaryPayApplyDetailVO.setWorkerName(detailEntity.getWorkerName());
                        // 联行号、电话、性别 暂时没有该字段
                         pmSalaryPayApplyDetailVO.setInterBankNum(detailEntity.getWorkerInterBankNum());
                         //开户行省份
                         pmSalaryPayApplyDetailVO.setWorkerBankProvince(detailEntity.getWorkerBankProvince());
                        //pmSalaryPayApplyDetailVO.setWorkerPhone();
                        //pmSalaryPayApplyDetailVO.setWorkerSex();

                        //设置支付申请子表连接中间表子表的id
                        detailEntity.setPmPayApplyDetailId(pmSalaryPayApplyDetailVO.getId());
                        //salaryIdCardAndPMIdMap.put(pmSalaryPayApplyDetailVO.getWorkerIdCard(), pmSalaryPayApplyDetailVO.getId());
                        pmSalaryPayApplyDetailList.add(pmSalaryPayApplyDetailVO);
                   // }
                }
                //保存子表和中间表子表关联字段pmPayApplyDetailId
                salaryPayApplyDetailService.saveOrUpdateBatch(sourceEntity.getSalaryList());
            //}

            pmSalaryPayApplyVO.setDetailList(pmSalaryPayApplyDetailList);
        }

        logger.info("开始调用PM工资支付申请生效接口，接口参数VO-{}", JSONObject.toJSONString(pmSalaryPayApplyVO));
        CommonResponse<PMSalaryPayApplyVO> res = pmSalaryPayApplyApi.salaryTakeEffect(pmSalaryPayApplyVO);
        logger.info("调用PM工资支付申请的生效接口---ejc-profinance项目---SalaryPayApplyBpmServiceImpl类---salaryTakeEffect方法---end，接口返回结果-{}", JSONObject.toJSONString(res, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
        if (!res.isSuccess()){
            return  CommonResponse.error("付款申请推送中间表失败，失败原因：" + res.getMsg());
        }
        return res;
    }

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }


    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return bpmBackCheck(billId, state, billTypeCode);
    }

    private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
        // 查询当前申请单是否是当前所属合同下的申请单中的最新的一个，如果不是，不允许撤回
        SalaryPayApplyEntity salaryPayApplyEntity = salaryPayApplyService.selectById(billId);
        if (BillStateEnum.COMMITED_STATE.getBillStateCode().equals(salaryPayApplyEntity.getBillState()) || BillStateEnum.PASSED_STATE.getBillStateCode().equals(salaryPayApplyEntity.getBillState())){
            QueryWrapper<SalaryPayApplyEntity> salaryPayApplyEntityQueryWrapper = new QueryWrapper<>();
            salaryPayApplyEntityQueryWrapper
                    .eq("dr", 0)
                    .eq("tenant_id", InvocationInfoProxy.getTenantid())
                    .eq("contract_id", salaryPayApplyEntity.getContractId())
                    .orderByDesc("create_time")
                    .last("limit 1");
            List<SalaryPayApplyEntity> salaryPayApplyEntityList = salaryPayApplyService.list(salaryPayApplyEntityQueryWrapper);
            if (CollectionUtils.isNotEmpty(salaryPayApplyEntityList)) {
                SalaryPayApplyEntity lastSalaryPayEntity = salaryPayApplyEntityList.get(0);
                if (!billId.equals(lastSalaryPayEntity.getId())) {
                    // 当前申请单不是当前所属合同下最新的一个申请单，不允许撤回
                    return CommonResponse.error("当前申请单不是当前合同下最新的申请单，不允许弃审");
                }
            }

            //判断当前申请单是否在中间表中被引用，如果被引用，则不可撤回
            if (null != salaryPayApplyEntity){
                PMSalaryPayApplyVO pmSalaryPayApplyVO = new PMSalaryPayApplyVO();
                pmSalaryPayApplyVO.setSalaryPayApplyId(salaryPayApplyEntity.getId().toString());
                CommonResponse<PMSalaryPayApplyVO> res = pmSalaryPayApplyApi.salaryAbandonOrClose(pmSalaryPayApplyVO);
                logger.info("调用PM工资支付申请的弃审接口---ejc-profinance项目---SalaryPayApplyBpmServiceImpl类---bpmBackCheck方法---end，接口返回结果-{}", JSONObject.toJSONString(res, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
                if (!res.isSuccess()){
                    return CommonResponse.error("工资支付申请查询财务系统中间表失败，失败原因：" + res.getMsg());
                }else {
                    PMSalaryPayApplyVO resultVO = res.getData();
                    if (null != resultVO){
                        if ("Y".equals(resultVO.getQuoteFlag())){
                            return CommonResponse.error("该申请单已经被财务系统引用，不能撤回/弃审");
                        }else {
                            //将财务系统删除的数据进行记录
                            SalaryPayApplyRegisterEntity registerEntity = new SalaryPayApplyRegisterEntity();
                            registerEntity.setContractId(resultVO.getContractId());
                            registerEntity.setProjectId(resultVO.getProjectId());
                            registerEntity.setQuoteFlag(resultVO.getQuoteFlag());
                            registerEntity.setSupplierId(resultVO.getSupplierId());
                            registerEntity.setSalaryPayApplyId(resultVO.getSalaryPayApplyId());
                            registerEntity.setPmDataCreateTime(resultVO.getCreateTime());
                            registerEntity.setPmDataUpdateTime(resultVO.getUpdateTime());
                            registerEntity.setDeleteRegister(res.getMsg() + res.getData().toString());
                            salaryPayApplyRegisterService.saveOrUpdate(registerEntity);
                            logger.info("调用PM工资支付申请的弃审接口-记录中间表删除数据：registerEntity{}", JSONObject.toJSONString(res, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
                        }
                    }
                }
            }
        }
        // 垫付的不允许撤回， 因为已经修改工资支付、工资单、付款申请单、财务中间库数据
        if ((salaryPayApplyEntity.getBillState() == 1 || salaryPayApplyEntity.getBillState() == 3) && salaryPayApplyEntity.getPayType() != null && (salaryPayApplyEntity.getPayType() == 2 || salaryPayApplyEntity.getPayType() == 3)){
            return CommonResponse.error("支付类型为垫付的不允许撤回/弃审");
        }
        return CommonResponse.success();
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 审批--获取当前节点的审批人---从服务中选择
     *
     * @param billId 单据id
     * @param billTypeCode 单据类型编码
     * @param sign 节点标志
     * @return
     */
    @Override
    public CommonResponse<JSONArray> queryApproveUser(Long billId, String billTypeCode, String sign, Map<String, Object> other){
        JSONArray arr = new JSONArray();
        logger.info("sign:{}",sign);

        //根据标识判断是否（成本相关人员审批的）节点
        if ("choseCostUser".equals(sign)){
            //获取表单详情数据

            //根据项目id获取项目基本信息中的成本对接人信息
            SalaryPayApplyEntity entity = salaryPayApplyService.selectById(billId);
            Long projectId = entity.getProjectId();

            JSONObject jsonObject = new JSONObject();
            CommonResponse<JSONArray> commonResponse = projectPoolApi.queryProjectPoolById(projectId);


            if(!commonResponse.isSuccess()){
                throw new BusinessException("查询项目失败!");
            }
            JSONArray array = commonResponse.getData();
            List<ProjectPoolSetVO> vos = JSONObject.parseArray(array.toJSONString(), ProjectPoolSetVO.class);

            logger.info("vos:{}",JSONObject.toJSONString(vos));

            ProjectPoolSetVO vo = vos.get(0);
            Long costAdapter = vo.getCostAdapter();
            String costAdapterName = vo.getCostAdapterName();

            logger.info("userId:{}",costAdapter);
            logger.info("userName:{}",costAdapterName);


            jsonObject.put("userId",costAdapter);
            jsonObject.put("userName",costAdapterName);

            arr.add(jsonObject);

        }
        return CommonResponse.success(arr);
    }


}
