package com.ejianc.business.receipt.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 收款登记主实体
 * 
 * @author generator
 * 
 */
 @TableName("ejc_receipt_register")
public class ReceiptRegisterEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="create_user_id")
    private Long createUserId; // 创建者账号
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="bill_state")
    private Integer billState; // 单据状态 ：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    @TableField(value="org_id")
    private Long orgId; // 项目部id
    @TableField(value="org_code")
    private String orgCode; // 项目部编码
    @TableField(value="org_name")
    private String orgName; // 项目部名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 项目部所属组织id
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 项目部所属组织编码
    @TableField(value="parent_org_name")
    private String parentOrgName; // 项目部所属组织名称
    @TableField(value="contract_id")
    private Long contractId; // 合同id
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="contract_code")
    private String contractCode; // 合同编码
    @TableField(value="contract_category_id")
    private Long contractCategoryId; // 合同类别id
    @TableField(value="contract_category_code")
    private String contractCategoryCode; // 合同类别编码
    @TableField(value="contract_category_name")
    private String contractCategoryName; // 合同类别名称
    @TableField(value="supplement_flag")
    private Integer supplementFlag; // 是否主合同：0-主合同 1-补充协议
    @TableField(value="project_id")
    private Long projectId; // 项目Id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_code")
    private String projectCode; // 项目编号
    @TableField(value="customer_id")
    private Long customerId; // 甲方id
    @TableField(value="customer_name")
    private String customerName; // 甲方名称
    @TableField(value="contract_tax_mny")
    private BigDecimal contractTaxMny; // 合同金额
    @TableField(value="contract_mny")
    private BigDecimal contractMny; // 合同金额(无税)
    @TableField(value="receipt_date")
    private Date receiptDate; // 收款日期 根据当前日期时间默认，可修改 前端显示 年月日 后台保持要时分秒
    @TableField(value="employee_id")
    private Long employeeId; // 经办人id（申请人）
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称（申请人）
    @TableField(value="department_id")
    private Long departmentId; // 经办（申请人）部门id
    @TableField(value="department_name")
    private String departmentName; // 经办（申请人）部门名称
    @TableField(value="memo")
    private String memo; // 备注  非必填，0-500字
    @TableField(value="receipt_reason")
    private String receiptReason; // 收款款说明 非必填，0-300字
    @TableField(value="receipt_contract_flag")
    private Integer receiptContractFlag; // 收款类型 有无合同 0：有合同；1：无合同
    @TableField(value="account_num")
    private String accountNum; // 银行账号
    @TableField(value="account_name")
    private String accountName; // 账户名称
    @TableField(value="bank_account")
    private String bankAccount; // 开户行
    @TableField(value="account_id")
    private Long accountId; // 银行账户id
    @TableField(value="total_receipt_mny")
    private BigDecimal totalReceiptMny; // 已付款金额
    @TableField(value="settle_type_name")
    private String settleTypeName; // 结算方式
    @TableField(value="sum_received_mny")
    private BigDecimal sumReceivedMny; // 本次实收金额
    @TableField(value="clause_property_id")
    private Long clausePropertyId; // 款项属性id
    @TableField(value="clause_property_name")
    private String clausePropertyName; // 款项属性名称
    @TableField(value="settle_type_id")
    private Long settleTypeId; // 结算方式id
    @TableField(value="fee_id")
    private Long feeId; // 无合同费用类型id
    @TableField(value="fee_name")
    private String feeName; // 无合同费用类型名称
    @TableField(value="source_category_type")
    private String sourceCategoryType; // 合同大类
    @TableField(value="source_category_type_name")
    private String sourceCategoryTypeName; // 合同大类名称
    @TableField(value="source_flag")
    private Integer sourceFlag; // 来源标识
    @TableField(value="recipet_apply_id")
    private Long recipetApplyId; // 收款申请单号Id
    @TableField(value="recipet_apply_code")
    private String recipetApplyCode; // 收款申请单号Code
    @TableField(value="un_mny")
    private BigDecimal unMny; // 收款节点未核销
    

    public Long getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public Long getContractCategoryId() {
        return contractCategoryId;
    }

    public void setContractCategoryId(Long contractCategoryId) {
        this.contractCategoryId = contractCategoryId;
    }
    public String getContractCategoryCode() {
        return contractCategoryCode;
    }

    public void setContractCategoryCode(String contractCategoryCode) {
        this.contractCategoryCode = contractCategoryCode;
    }
    public String getContractCategoryName() {
        return contractCategoryName;
    }

    public void setContractCategoryName(String contractCategoryName) {
        this.contractCategoryName = contractCategoryName;
    }
    public Integer getSupplementFlag() {
        return supplementFlag;
    }

    public void setSupplementFlag(Integer supplementFlag) {
        this.supplementFlag = supplementFlag;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }
    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    public Date getReceiptDate() {
        return receiptDate;
    }

    public void setReceiptDate(Date receiptDate) {
        this.receiptDate = receiptDate;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getReceiptReason() {
        return receiptReason;
    }

    public void setReceiptReason(String receiptReason) {
        this.receiptReason = receiptReason;
    }
    public Integer getReceiptContractFlag() {
        return receiptContractFlag;
    }

    public void setReceiptContractFlag(Integer receiptContractFlag) {
        this.receiptContractFlag = receiptContractFlag;
    }
    public String getAccountNum() {
        return accountNum;
    }

    public void setAccountNum(String accountNum) {
        this.accountNum = accountNum;
    }
    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }
    public String getBankAccount() {
        return bankAccount;
    }

    public void setBankAccount(String bankAccount) {
        this.bankAccount = bankAccount;
    }
    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }
    public BigDecimal getTotalReceiptMny() {
        return totalReceiptMny;
    }

    public void setTotalReceiptMny(BigDecimal totalReceiptMny) {
        this.totalReceiptMny = totalReceiptMny;
    }
    public String getSettleTypeName() {
        return settleTypeName;
    }

    public void setSettleTypeName(String settleTypeName) {
        this.settleTypeName = settleTypeName;
    }
    public BigDecimal getSumReceivedMny() {
        return sumReceivedMny;
    }

    public void setSumReceivedMny(BigDecimal sumReceivedMny) {
        this.sumReceivedMny = sumReceivedMny;
    }
    public Long getClausePropertyId() {
        return clausePropertyId;
    }

    public void setClausePropertyId(Long clausePropertyId) {
        this.clausePropertyId = clausePropertyId;
    }
    public String getClausePropertyName() {
        return clausePropertyName;
    }

    public void setClausePropertyName(String clausePropertyName) {
        this.clausePropertyName = clausePropertyName;
    }
    public Long getSettleTypeId() {
        return settleTypeId;
    }

    public void setSettleTypeId(Long settleTypeId) {
        this.settleTypeId = settleTypeId;
    }
    public Long getFeeId() {
        return feeId;
    }

    public void setFeeId(Long feeId) {
        this.feeId = feeId;
    }
    public String getFeeName() {
        return feeName;
    }

    public void setFeeName(String feeName) {
        this.feeName = feeName;
    }

    public String getSourceCategoryType() {
        return sourceCategoryType;
    }

    public void setSourceCategoryType(String sourceCategoryType) {
        this.sourceCategoryType = sourceCategoryType;
    }

    public String getSourceCategoryTypeName() {
        return sourceCategoryTypeName;
    }

    public void setSourceCategoryTypeName(String sourceCategoryTypeName) {
        this.sourceCategoryTypeName = sourceCategoryTypeName;
    }

    public Integer getSourceFlag() {
        return sourceFlag;
    }

    public void setSourceFlag(Integer sourceFlag) {
        this.sourceFlag = sourceFlag;
    }

    public Long getRecipetApplyId() {
        return recipetApplyId;
    }

    public void setRecipetApplyId(Long recipetApplyId) {
        this.recipetApplyId = recipetApplyId;
    }

    public String getRecipetApplyCode() {
        return recipetApplyCode;
    }

    public void setRecipetApplyCode(String recipetApplyCode) {
        this.recipetApplyCode = recipetApplyCode;
    }

    public BigDecimal getUnMny() {
        return unMny;
    }

    public void setUnMny(BigDecimal unMny) {
        this.unMny = unMny;
    }
}
