package com.ejianc.business.receipt.service;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.receipt.bean.ReceiptRegisterEntity;
import com.ejianc.business.receipt.vo.ReceiptRegisterVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 收款登记主实体
 * 
 * @author generator
 * 
 */
public interface IReceiptRegisterService extends IBaseService<ReceiptRegisterEntity> {

    CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response);

    String saveImportExcel(HttpServletRequest request, List<ReceiptRegisterVO> importVOS);

    Map<String, BigDecimal> queryReceiptMny(Long contractId,Long projectId);

    String validateContract(Long contractId,Long id);

    BigDecimal getTotalColumnInfo(QueryParam param, boolean isEs);

    void autoPMReceipt();

    /**
     * 根据查询条件查询SumReceivedMny总和
     * @param param
     * @return
     */
    List<ReceiptRegisterVO> querySumReceivedMny(QueryParam param);

}
