/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.profinance.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.financeintegration.PMPayApply.api.IPMSalaryPayApplyApi;
import com.ejianc.business.financeintegration.PMPayApply.vo.PMSalaryPayApplyDetailVO;
import com.ejianc.business.financeintegration.PMPayApply.vo.PMSalaryPayApplyVO;
import com.ejianc.business.profinance.bean.SalaryPayApplyDetailEntity;
import com.ejianc.business.profinance.bean.SalaryPayApplyEntity;
import com.ejianc.business.profinance.bean.SalaryPayApplyRegisterEntity;
import com.ejianc.business.profinance.service.ISalaryPayApplyDetailService;
import com.ejianc.business.profinance.service.ISalaryPayApplyRegisterService;
import com.ejianc.business.profinance.service.ISalaryPayApplyService;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="salaryPayApply")
public class SalaryPayApplyBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISalaryPayApplyService salaryPayApplyService;
    @Autowired
    private ISalaryPayApplyDetailService salaryPayApplyDetailService;
    @Autowired
    private IPMSalaryPayApplyApi pmSalaryPayApplyApi;
    @Autowired
    private ISalaryPayApplyRegisterService salaryPayApplyRegisterService;
    @Autowired
    private IProjectPoolApi projectPoolApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        SalaryPayApplyEntity sourceEntity = (SalaryPayApplyEntity)((Object)this.salaryPayApplyService.selectById(billId));
        if (sourceEntity.getPayType() != null && (sourceEntity.getPayType() == 2 || sourceEntity.getPayType() == 3 || sourceEntity.getPayType() == 4)) {
            this.salaryPayApplyService.handSalaryData(sourceEntity);
        } else {
            CommonResponse<PMSalaryPayApplyVO> res = this.salaryTakeEffect(billId);
            if (!res.isSuccess()) {
                this.logger.error("\u8c03\u7528PM\u5de5\u8d44\u652f\u4ed8\u7533\u8bf7\u4ed8\u6b3e\u751f\u6548\u63a5\u53e3\u5931\u8d25\uff01message-{}", (Object)res.getMsg());
                return CommonResponse.error((String)"\u8c03\u7528PM\u5de5\u8d44\u652f\u4ed8\u7533\u8bf7\u4ed8\u6b3e\u751f\u6548\u63a5\u53e3\u5931\u8d25");
            }
        }
        return CommonResponse.success((String)"\u5de5\u8d44\u652f\u4ed8\u7533\u8bf7\u7ec8\u5ba1\u56de\u8c03\u6210\u529f\uff01");
    }

    private CommonResponse<PMSalaryPayApplyVO> salaryTakeEffect(Long id) {
        this.logger.info("\u8c03\u7528PM\u5de5\u8d44\u652f\u4ed8\u7533\u8bf7\u7684\u751f\u6548\u63a5\u53e3---ejc-profinance\u9879\u76ee---SalaryPayApplyBpmServiceImpl\u7c7b---salaryTakeEffect\u65b9\u6cd5---begin\uff0c\u672c\u4ed8\u6b3e\u7533\u8bf7ID-{}", (Object)id);
        SalaryPayApplyEntity sourceEntity = (SalaryPayApplyEntity)((Object)this.salaryPayApplyService.selectById(id));
        if (sourceEntity == null) {
            this.logger.error("\u6839\u636e\u672c\u5de5\u8d44\u652f\u4ed8\u7533\u8bf7ID-{}\uff0c\u67e5\u8be2\u4e0d\u5230\u5de5\u8d44\u652f\u4ed8\u7533\u8bf7\u6570\u636e\uff0c\u65e0\u6cd5\u8c03\u7528PM\u5de5\u8d44\u652f\u4ed8\u7533\u8bf7\u751f\u6548\u63a5\u53e3", (Object)id);
            return CommonResponse.error((String)("\u6839\u636e\u672c\u5de5\u8d44\u652f\u4ed8\u7533\u8bf7ID-\u3010" + id + "\u3011\u67e5\u8be2\u4e0d\u5230\u5de5\u8d44\u652f\u4ed8\u7533\u8bf7\u6570\u636e\uff0c\u65e0\u6cd5\u8c03\u7528PM\u5de5\u8d44\u652f\u4ed8\u7533\u8bf7\u751f\u6548\u63a5\u53e3"));
        }
        this.logger.info("\u6839\u636e\u672c\u5de5\u8d44\u652f\u4ed8\u7533\u8bf7ID-{}\uff0c\u67e5\u8be2\u5230\u7684\u672c\u5de5\u8d44\u652f\u4ed8\u7533\u8bf7\u6570\u636e-{}", (Object)id, (Object)JSONObject.toJSONString((Object)((Object)sourceEntity), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        PMSalaryPayApplyVO pmSalaryPayApplyVO = new PMSalaryPayApplyVO();
        pmSalaryPayApplyVO.setContractId(sourceEntity.getContractId().toString());
        pmSalaryPayApplyVO.setProjectId(sourceEntity.getProjectId().toString());
        pmSalaryPayApplyVO.setQuoteFlag("N");
        pmSalaryPayApplyVO.setSalaryPayApplyId(sourceEntity.getId().toString());
        pmSalaryPayApplyVO.setSupplierId(sourceEntity.getPaySupplierId().toString());
        pmSalaryPayApplyVO.setTotalApplyMny(sourceEntity.getApplyTaxMny());
        if (CollectionUtils.isNotEmpty(sourceEntity.getSalaryList())) {
            ArrayList<PMSalaryPayApplyDetailVO> pmSalaryPayApplyDetailList = new ArrayList<PMSalaryPayApplyDetailVO>();
            for (SalaryPayApplyDetailEntity detailEntity : sourceEntity.getSalaryList()) {
                PMSalaryPayApplyDetailVO pmSalaryPayApplyDetailVO = new PMSalaryPayApplyDetailVO();
                pmSalaryPayApplyDetailVO.setId(String.valueOf(IdWorker.getId()));
                pmSalaryPayApplyDetailVO.setPayState("0");
                pmSalaryPayApplyDetailVO.setSalaryPayApplyId(detailEntity.getPid().toString());
                pmSalaryPayApplyDetailVO.setWorkerAccountNum(detailEntity.getWorkerAccountNum());
                pmSalaryPayApplyDetailVO.setWorkerApplyTaxMny(detailEntity.getWorkerApplyTaxMny());
                pmSalaryPayApplyDetailVO.setWorkerBankName(detailEntity.getWorkerBankName());
                pmSalaryPayApplyDetailVO.setWorkerIdCard(detailEntity.getWorkerIdCard());
                pmSalaryPayApplyDetailVO.setWorkerName(detailEntity.getWorkerName());
                pmSalaryPayApplyDetailVO.setInterBankNum(detailEntity.getWorkerInterBankNum());
                pmSalaryPayApplyDetailVO.setWorkerBankProvince(detailEntity.getWorkerBankProvince());
                detailEntity.setPmPayApplyDetailId(pmSalaryPayApplyDetailVO.getId());
                pmSalaryPayApplyDetailList.add(pmSalaryPayApplyDetailVO);
            }
            this.salaryPayApplyDetailService.saveOrUpdateBatch(sourceEntity.getSalaryList());
            pmSalaryPayApplyVO.setDetailList(pmSalaryPayApplyDetailList);
        }
        this.logger.info("\u5f00\u59cb\u8c03\u7528PM\u5de5\u8d44\u652f\u4ed8\u7533\u8bf7\u751f\u6548\u63a5\u53e3\uff0c\u63a5\u53e3\u53c2\u6570VO-{}", (Object)JSONObject.toJSONString((Object)pmSalaryPayApplyVO));
        CommonResponse res = this.pmSalaryPayApplyApi.salaryTakeEffect(pmSalaryPayApplyVO);
        this.logger.info("\u8c03\u7528PM\u5de5\u8d44\u652f\u4ed8\u7533\u8bf7\u7684\u751f\u6548\u63a5\u53e3---ejc-profinance\u9879\u76ee---SalaryPayApplyBpmServiceImpl\u7c7b---salaryTakeEffect\u65b9\u6cd5---end\uff0c\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c-{}", (Object)JSONObject.toJSONString((Object)res, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        if (!res.isSuccess()) {
            return CommonResponse.error((String)("\u4ed8\u6b3e\u7533\u8bf7\u63a8\u9001\u4e2d\u95f4\u8868\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + res.getMsg()));
        }
        return res;
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
        SalaryPayApplyEntity salaryPayApplyEntity = (SalaryPayApplyEntity)((Object)this.salaryPayApplyService.selectById(billId));
        if (BillStateEnum.COMMITED_STATE.getBillStateCode().equals(salaryPayApplyEntity.getBillState()) || BillStateEnum.PASSED_STATE.getBillStateCode().equals(salaryPayApplyEntity.getBillState())) {
            SalaryPayApplyEntity lastSalaryPayEntity;
            QueryWrapper salaryPayApplyEntityQueryWrapper = new QueryWrapper();
            ((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)salaryPayApplyEntityQueryWrapper.eq((Object)"dr", (Object)0)).eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid())).eq((Object)"contract_id", (Object)salaryPayApplyEntity.getContractId())).orderByDesc((Object)"create_time")).last("limit 1");
            List salaryPayApplyEntityList = this.salaryPayApplyService.list((Wrapper)salaryPayApplyEntityQueryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)salaryPayApplyEntityList) && !billId.equals((lastSalaryPayEntity = (SalaryPayApplyEntity)((Object)salaryPayApplyEntityList.get(0))).getId())) {
                return CommonResponse.error((String)"\u5f53\u524d\u7533\u8bf7\u5355\u4e0d\u662f\u5f53\u524d\u5408\u540c\u4e0b\u6700\u65b0\u7684\u7533\u8bf7\u5355\uff0c\u4e0d\u5141\u8bb8\u5f03\u5ba1");
            }
            if (null != salaryPayApplyEntity) {
                PMSalaryPayApplyVO pmSalaryPayApplyVO = new PMSalaryPayApplyVO();
                pmSalaryPayApplyVO.setSalaryPayApplyId(salaryPayApplyEntity.getId().toString());
                CommonResponse res = this.pmSalaryPayApplyApi.salaryAbandonOrClose(pmSalaryPayApplyVO);
                this.logger.info("\u8c03\u7528PM\u5de5\u8d44\u652f\u4ed8\u7533\u8bf7\u7684\u5f03\u5ba1\u63a5\u53e3---ejc-profinance\u9879\u76ee---SalaryPayApplyBpmServiceImpl\u7c7b---bpmBackCheck\u65b9\u6cd5---end\uff0c\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c-{}", (Object)JSONObject.toJSONString((Object)res, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
                if (!res.isSuccess()) {
                    return CommonResponse.error((String)("\u5de5\u8d44\u652f\u4ed8\u7533\u8bf7\u67e5\u8be2\u8d22\u52a1\u7cfb\u7edf\u4e2d\u95f4\u8868\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + res.getMsg()));
                }
                PMSalaryPayApplyVO resultVO = (PMSalaryPayApplyVO)res.getData();
                if (null != resultVO) {
                    if ("Y".equals(resultVO.getQuoteFlag())) {
                        return CommonResponse.error((String)"\u8be5\u7533\u8bf7\u5355\u5df2\u7ecf\u88ab\u8d22\u52a1\u7cfb\u7edf\u5f15\u7528\uff0c\u4e0d\u80fd\u64a4\u56de/\u5f03\u5ba1");
                    }
                    SalaryPayApplyRegisterEntity registerEntity = new SalaryPayApplyRegisterEntity();
                    registerEntity.setContractId(resultVO.getContractId());
                    registerEntity.setProjectId(resultVO.getProjectId());
                    registerEntity.setQuoteFlag(resultVO.getQuoteFlag());
                    registerEntity.setSupplierId(resultVO.getSupplierId());
                    registerEntity.setSalaryPayApplyId(resultVO.getSalaryPayApplyId());
                    registerEntity.setPmDataCreateTime(resultVO.getCreateTime());
                    registerEntity.setPmDataUpdateTime(resultVO.getUpdateTime());
                    registerEntity.setDeleteRegister(res.getMsg() + ((PMSalaryPayApplyVO)res.getData()).toString());
                    this.salaryPayApplyRegisterService.saveOrUpdate((Object)registerEntity);
                    this.logger.info("\u8c03\u7528PM\u5de5\u8d44\u652f\u4ed8\u7533\u8bf7\u7684\u5f03\u5ba1\u63a5\u53e3-\u8bb0\u5f55\u4e2d\u95f4\u8868\u5220\u9664\u6570\u636e\uff1aregisterEntity{}", (Object)JSONObject.toJSONString((Object)res, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
                }
            }
        }
        if (!(salaryPayApplyEntity.getBillState() != 1 && salaryPayApplyEntity.getBillState() != 3 || salaryPayApplyEntity.getPayType() == null || salaryPayApplyEntity.getPayType() != 2 && salaryPayApplyEntity.getPayType() != 3)) {
            return CommonResponse.error((String)"\u652f\u4ed8\u7c7b\u578b\u4e3a\u57ab\u4ed8\u7684\u4e0d\u5141\u8bb8\u64a4\u56de/\u5f03\u5ba1");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<JSONArray> queryApproveUser(Long billId, String billTypeCode, String sign, Map<String, Object> other) {
        JSONArray arr = new JSONArray();
        this.logger.info("sign:{}", (Object)sign);
        if ("choseCostUser".equals(sign)) {
            SalaryPayApplyEntity entity = (SalaryPayApplyEntity)((Object)this.salaryPayApplyService.selectById(billId));
            Long projectId = entity.getProjectId();
            JSONObject jsonObject = new JSONObject();
            CommonResponse commonResponse = this.projectPoolApi.queryProjectPoolById(projectId);
            if (!commonResponse.isSuccess()) {
                throw new BusinessException("\u67e5\u8be2\u9879\u76ee\u5931\u8d25!");
            }
            JSONArray array = (JSONArray)commonResponse.getData();
            List vos = JSONObject.parseArray((String)array.toJSONString(), ProjectPoolSetVO.class);
            this.logger.info("vos:{}", (Object)JSONObject.toJSONString((Object)vos));
            ProjectPoolSetVO vo = (ProjectPoolSetVO)vos.get(0);
            Long costAdapter = vo.getCostAdapter();
            String costAdapterName = vo.getCostAdapterName();
            this.logger.info("userId:{}", (Object)costAdapter);
            this.logger.info("userName:{}", (Object)costAdapterName);
            jsonObject.put("userId", (Object)costAdapter);
            jsonObject.put("userName", (Object)costAdapterName);
            arr.add((Object)jsonObject);
        }
        return CommonResponse.success((Object)arr);
    }
}

