package com.ejianc.business.profinance.paysupplement.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 付款补录业务数据实体
 * 
 * @author generator
 * 
 */
 @TableName("ejc_payment_supplement")
public class PaymentSupplementEntity extends BaseEntity {
    private static final long serialVersionUID = -5513567365973454819L;

    @TableField(value="create_user_id")
    private Long createUserId; // 创建者账号
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="bill_state")
    private Integer billState; // 单据状态 ：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中，6-驳回到提交人
    @TableField(value="org_id")
    private Long orgId; // 项目部id
    @TableField(value="org_code")
    private String orgCode; // 项目部编码
    @TableField(value="org_name")
    private String orgName; // 项目部名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 项目部所属组织id
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 项目部所属组织编码
    @TableField(value="parent_org_name")
    private String parentOrgName; // 项目部上级组织名称
    @TableField(value="contract_id")
    private Long contractId; // 合同id
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="contract_code")
    private String contractCode; // 合同编码
    @TableField(value="contract_category_id")
    private Long contractCategoryId; // 合同类别id
    @TableField(value="contract_category_code")
    private String contractCategoryCode; // 合同类别编码
    @TableField(value="contract_category_name")
    private String contractCategoryName; // 合同类别名称
    @TableField(value="supplement_flag")
    private Integer supplementFlag; // 是否主合同：0-主合同 1-补充协议
    @TableField(value="project_id")
    private Long projectId; // 项目Id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_code")
    private String projectCode; // 项目编号
    @TableField(value="supplier_id")
    private Long supplierId; // 乙方id
    @TableField(value="supplier_name")
    private String supplierName; // 供应商名称
    @TableField(value="contract_tax_mny")
    private BigDecimal contractTaxMny; // 合同金额
    @TableField(value="contract_mny")
    private BigDecimal contractMny; // 合同金额(无税)
    @TableField(value="payment_date")
    private Date paymentDate; // 支付日期 根据当前日期时间默认，可修改 前端显示 年月日 后台保持要时分秒
    @TableField(value="employee_id")
    private Long employeeId; // 经办人id（申请人）
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称（申请人）
    @TableField(value="department_id")
    private Long departmentId; // 经办（申请人）部门id
    @TableField(value="department_name")
    private String departmentName; // 经办（申请人）部门名称
    @TableField(value="payment_contract_flag")
    private Integer paymentContractFlag; // 支出类型 有无合同 0：有合同；1：无合同
    @TableField(value="fee_type_id")
    private Long feeTypeId; // 无合同费用类型：0-正常付款，1-预付款，2-诉讼款,3:零星材料；4：临时机械
    @TableField(value="fee_type_name")
    private String feeTypeName; // 无合同费用类型名称
    @TableField(value="fee_type_code")
    private String feeTypeCode; // 无合同费用类型编码
    @TableField(value="personal_prepaid")
    private Integer personalPrepaid; // 是否个人垫付 0-否 1-是
    @TableField(value="payee_id")
    private Long payeeId; // 收款人
    @TableField(value="payee_name")
    private String payeeName; // 收款人名称
    @TableField(value="pay_mny")
    private BigDecimal payMny; // 本次付款金额
    @TableField(value="payable_mny")
    private BigDecimal payableMny; // 本次可支付金额
    @TableField(value="payment_reason")
    private String paymentReason; // 付款说明 非必填，0-300字
    @TableField(value="memo")
    private String memo; // 备注  非必填，0-500字
    @TableField(value="contract_link_url")
    private String contractLinkUrl; // 合同详情页面
    @TableField(value="source_category_type")
    private String sourceCategoryType; // 合同大类id
    @TableField(value="source_category_type_name")
    private String sourceCategoryTypeName; // 合同大类名称
    
    
    

    public Long getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public Long getContractCategoryId() {
        return contractCategoryId;
    }

    public void setContractCategoryId(Long contractCategoryId) {
        this.contractCategoryId = contractCategoryId;
    }
    public String getContractCategoryCode() {
        return contractCategoryCode;
    }

    public void setContractCategoryCode(String contractCategoryCode) {
        this.contractCategoryCode = contractCategoryCode;
    }
    public String getContractCategoryName() {
        return contractCategoryName;
    }

    public void setContractCategoryName(String contractCategoryName) {
        this.contractCategoryName = contractCategoryName;
    }
    public Integer getSupplementFlag() {
        return supplementFlag;
    }

    public void setSupplementFlag(Integer supplementFlag) {
        this.supplementFlag = supplementFlag;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    public Date getPaymentDate() {
        return paymentDate;
    }

    public void setPaymentDate(Date paymentDate) {
        this.paymentDate = paymentDate;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public Integer getPaymentContractFlag() {
        return paymentContractFlag;
    }

    public void setPaymentContractFlag(Integer paymentContractFlag) {
        this.paymentContractFlag = paymentContractFlag;
    }
    public Long getFeeTypeId() {
        return feeTypeId;
    }

    public void setFeeTypeId(Long feeTypeId) {
        this.feeTypeId = feeTypeId;
    }
    public String getFeeTypeName() {
        return feeTypeName;
    }

    public void setFeeTypeName(String feeTypeName) {
        this.feeTypeName = feeTypeName;
    }
    public String getFeeTypeCode() {
        return feeTypeCode;
    }

    public void setFeeTypeCode(String feeTypeCode) {
        this.feeTypeCode = feeTypeCode;
    }
    public Integer getPersonalPrepaid() {
        return personalPrepaid;
    }

    public void setPersonalPrepaid(Integer personalPrepaid) {
        this.personalPrepaid = personalPrepaid;
    }
    public Long getPayeeId() {
        return payeeId;
    }

    public void setPayeeId(Long payeeId) {
        this.payeeId = payeeId;
    }
    public String getPayeeName() {
        return payeeName;
    }

    public void setPayeeName(String payeeName) {
        this.payeeName = payeeName;
    }
    public BigDecimal getPayMny() {
        return payMny;
    }

    public void setPayMny(BigDecimal payMny) {
        this.payMny = payMny;
    }
    public BigDecimal getPayableMny() {
        return payableMny;
    }

    public void setPayableMny(BigDecimal payableMny) {
        this.payableMny = payableMny;
    }
    public String getPaymentReason() {
        return paymentReason;
    }

    public void setPaymentReason(String paymentReason) {
        this.paymentReason = paymentReason;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getContractLinkUrl() {
        return contractLinkUrl;
    }

    public void setContractLinkUrl(String contractLinkUrl) {
        this.contractLinkUrl = contractLinkUrl;
    }
    public String getSourceCategoryType() {
        return sourceCategoryType;
    }

    public void setSourceCategoryType(String sourceCategoryType) {
        this.sourceCategoryType = sourceCategoryType;
    }
    public String getSourceCategoryTypeName() {
        return sourceCategoryTypeName;
    }

    public void setSourceCategoryTypeName(String sourceCategoryTypeName) {
        this.sourceCategoryTypeName = sourceCategoryTypeName;
    }
    
}
