package com.ejianc.business.profinance.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.profinance.service.IGlodonProjectRelateDetailService;
import com.ejianc.business.profinance.utils.GlodonSalaryApiClient;
import com.ejianc.business.profinance.vo.GlodonProjectVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import io.swagger.models.auth.In;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.profinance.mapper.GlodonProjectRelateMapper;
import com.ejianc.business.profinance.bean.GlodonProjectRelateEntity;
import com.ejianc.business.profinance.service.IGlodonProjectRelateService;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 一建广联达项目对应实体
 *
 * @author generator
 */
@Service("glodonProjectRelateService")
public class GlodonProjectRelateServiceImpl extends BaseServiceImpl<GlodonProjectRelateMapper, GlodonProjectRelateEntity> implements IGlodonProjectRelateService {

    //广联达一键租户id
    private static final String GLODON_TENANT_ID = "1438833";
    //广联达一键组织id
    private static final String GLODON_ORG_ID = "1441301";
    //广联达项目列表
    private static final String PROJECT_LIST = "/admin/project/listByOrgId";

    @Autowired
    private IGlodonProjectRelateDetailService glodonProjectRelateDetailService;

    @Override
    public List<GlodonProjectRelateEntity> querySynchronizeFlagByProjectId(String projectId) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
        param.getParams().put("project_id", new Parameter(QueryParam.EQ, projectId));
        return super.queryList(param);
    }

    @Override
    public JSONObject getGlodonProjectList(Long projectId, Integer pageNumber, Integer pageSize, String searchText) {
        GlodonSalaryApiClient openApiTestClient = new GlodonSalaryApiClient();
        Map<String, Object> params = new HashMap<>();
        // TODO: 2022/4/18 广联达接口添加根据ids查询数据后添加ids参数进行查询
        params.put("tenantId", GLODON_TENANT_ID);
        params.put("orgId", GLODON_ORG_ID);

        String resultStr = openApiTestClient.sendGETRequest(PROJECT_LIST, params);

        System.out.println(resultStr);
        JSONObject resultObject = new JSONObject();
        if (StringUtils.isNotBlank(resultStr)) {
            resultObject = JSONObject.parseObject(resultStr);
        }
        JSONObject page = new JSONObject();
        if (resultObject != null) {
            //判断当前接口返回是否成功
            String success = resultObject.getString("success");
            if (StringUtils.isNotBlank(success) && success.equals("true")) {
                String data = resultObject.getString("data");
                if (StringUtils.isNotBlank(data)) {
                    List<GlodonProjectVO> glodonProjectVOList = JSONArray.parseArray(data, GlodonProjectVO.class);

                    String total = String.valueOf(glodonProjectVOList.size());
                    String current = String.valueOf(pageNumber);
                    String size = null != pageSize ? pageSize + "" : "10";
                    String pages = String.valueOf(glodonProjectVOList.size() > 0 ? Integer.valueOf((int) Math.ceil(glodonProjectVOList.size() * 1.0 / 10)) : 0);

                    List<Long> sourceProjectIds = new ArrayList<>();
                    if (CollectionUtils.isNotEmpty(glodonProjectVOList)) {
                        //如果有查询语
                        if (StringUtils.isNotBlank(searchText)){
                            //名字-VO map，通过名字获取相对应VO
                            Map<String, GlodonProjectVO> sourceProjectMap = glodonProjectVOList.stream().collect(Collectors.toMap(GlodonProjectVO::getName, Function.identity(), (key1, key2) -> key2));
                            if (null != sourceProjectMap){
                                List<GlodonProjectVO> glodonProjectSearchVOList = new ArrayList<>();
                                for (String key : sourceProjectMap.keySet()){
                                    if (key.contains(searchText)){
                                        glodonProjectSearchVOList.add(sourceProjectMap.get(key));
                                    }
                                }
                                //如果有附和条件的项目，则重置项目列表
                                if (glodonProjectSearchVOList.size() > 0){
                                    glodonProjectVOList = glodonProjectSearchVOList;
                                }
                            }
                        }
                        //重置项目数、总页数
                        total = String.valueOf(glodonProjectVOList.size());
                        pages = String.valueOf(glodonProjectVOList.size() > 0 ? Integer.valueOf((int) Math.ceil(glodonProjectVOList.size() * 1.0 / 10)) : 0);

                        //放置对应数项目
                        if (1 == Integer.valueOf(current)){
                            if (glodonProjectVOList.size() > 10){
                                glodonProjectVOList = glodonProjectVOList.subList(0, 10);
                            }else {
                                glodonProjectVOList = glodonProjectVOList.subList(0, glodonProjectVOList.size());
                            }
                        }else {
                            if ((pageNumber - 1) * 10 <= glodonProjectVOList.size()){
                                if (glodonProjectVOList.size() > pageNumber * 10){
                                    glodonProjectVOList = glodonProjectVOList.subList((pageNumber - 1) * 10 , pageNumber * 10);
                                }else {
                                    glodonProjectVOList = glodonProjectVOList.subList((pageNumber - 1) * 10 , glodonProjectVOList.size());
                                }
                            }else {
                                glodonProjectVOList = null;
                            }
                        }

                        if (null != glodonProjectVOList){
                            for (GlodonProjectVO glodonProjectVO : glodonProjectVOList) {
                                sourceProjectIds.add(glodonProjectVO.getId());
                            }
                            //查询广联达项目在项目库中的对照
                            sourceProjectIds = glodonProjectVOList.stream().map(GlodonProjectVO::getId).collect(Collectors.toList());
                            //查询非当前项目的广联达可用的项目对照
                            if (CollectionUtils.isNotEmpty(sourceProjectIds)){
                                QueryParam param = new QueryParam();
                                param.getParams().put("project_id", new Parameter(QueryParam.EQ, projectId));
                                List<GlodonProjectRelateEntity> relateEntityList = super.queryList(param);
                                if (CollectionUtils.isNotEmpty(relateEntityList) && null != relateEntityList.get(0)){
                                    List<Long> useGlodonProjectIds = glodonProjectRelateDetailService.selectUseGlodonProjectIds(sourceProjectIds, relateEntityList.get(0).getId());
                                    for (GlodonProjectVO glodonProjectVO : glodonProjectVOList) {
                                        if (CollectionUtils.isNotEmpty(useGlodonProjectIds) && useGlodonProjectIds.contains(glodonProjectVO.getId())) {
                                            glodonProjectVO.setIfChose("已选择");
                                        }
                                    }
                                }else {
                                    List<Long> useGlodonProjectIds = glodonProjectRelateDetailService.selectUseGlodonProjectIds(sourceProjectIds, null);
                                    for (GlodonProjectVO glodonProjectVO : glodonProjectVOList) {
                                        if (CollectionUtils.isNotEmpty(useGlodonProjectIds) && useGlodonProjectIds.contains(glodonProjectVO.getId())) {
                                            glodonProjectVO.setIfChose("已选择");
                                        }
                                    }
                                }
                            }
                        }
                    }
                    page.put("records", glodonProjectVOList);
                    page.put("total", total);
                    page.put("current", current);
                    page.put("size", size);
                    page.put("pages", pages);
                }
            }
        }
        return page;
    }
}
